/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.events;

import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.io.fBaseConnection;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.nirvana.base.events.nCachedChannelAttributes;
import com.pcbsys.nirvana.base.events.nPublished;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class nChannelIterate
extends nCachedChannelAttributes {
    public static final int sFirst = 0;
    public static final int sLast = 1;
    public static final int sNext = 2;
    public static final int sPrev = 3;
    public static final int sOpen = 5;
    public static final int sClose = 6;
    public static final int sAck = 7;
    public static final int sRollback = 8;
    protected boolean isAutoAck = true;
    private boolean isClientWindowSizeSet = false;
    protected int myCommand;
    private int maxUnackedEvents = -1;
    protected long myEID;
    protected long myTimeout;
    private long myAbsoluteTime;
    private long myNameId;
    protected long iteratorId;
    protected String iteratorIdString;
    private long[] ackEvents = null;
    protected fBaseConnection myCon;
    protected String mySelector;
    protected fFilter myFilter;
    protected List<nPublished> myEvents;
    protected nPublished myEvent;

    protected nChannelIterate() {
        super(89);
    }

    public nChannelIterate(long l, int n, long l2, long l3, long[] lArray) {
        this(l, 0L, 0L, n, null, l2, l3, true);
        this.ackEvents = lArray;
    }

    public nChannelIterate(long l, long l2, long l3, int n, String string, long l4, long l5, boolean bl) {
        super(89, l);
        this.myTimeout = l3;
        this.myEID = l2;
        this.myCommand = n;
        this.mySelector = string;
        this.myNameId = l4;
        this.iteratorId = l5;
        this.iteratorIdString = nChannelIterate.generateIteratorIdString(l5);
        this.isAutoAck = bl;
        this.ackEvents = null;
    }

    public static long generateIteratorUniqueId(long l, long l2) {
        return l + l2;
    }

    private static String generateIteratorIdString(long l) {
        return Long.toHexString(l >> 32 << 32) + "-" + (int)l;
    }

    public int getCommand() {
        return this.myCommand;
    }

    public nPublished getEvent() {
        return this.myEvent;
    }

    public long getIteratorId() {
        return this.iteratorId;
    }

    public String getIteratorIdAsString() {
        return this.iteratorIdString;
    }

    public long getTimeout() {
        return this.myTimeout;
    }

    public void setEID(long l) {
        this.myEID = l;
    }

    public long getEID() {
        return this.myEID;
    }

    public void setEvent(nPublished nPublished2) {
        this.myEvent = nPublished2;
    }

    public void setAbsoluteTime(long l) {
        this.myAbsoluteTime = l;
    }

    public long getAbsoluteTime() {
        return this.myAbsoluteTime;
    }

    public fBaseConnection getConnection() {
        return this.myCon;
    }

    public void setConnection(fBaseConnection fBaseConnection2) {
        this.myCon = fBaseConnection2;
    }

    public fFilter getFilter() {
        return this.myFilter;
    }

    public void setFilter(fFilter fFilter2) {
        this.myFilter = fFilter2;
    }

    public String getSelector() {
        return this.mySelector;
    }

    public long getNameId() {
        return this.myNameId;
    }

    public List<nPublished> getEvents() {
        return this.myEvents;
    }

    public void setEvents(List<nPublished> list) {
        this.myEvents = list;
    }

    public long[] getAckEvents() {
        return this.ackEvents;
    }

    public void setAckEvents(long[] lArray) {
        this.ackEvents = lArray;
    }

    public boolean isAutoAck() {
        return this.isAutoAck;
    }

    public void setAutoAck(boolean bl) {
        this.isAutoAck = bl;
    }

    public int getMaxUnackedEvents() {
        return this.maxUnackedEvents;
    }

    public void setMaxUnackedEvents(int n) {
        this.maxUnackedEvents = n;
        this.isClientWindowSizeSet = true;
    }

    public boolean isClientWindowSizeSet() {
        return this.isClientWindowSizeSet;
    }

    public boolean hasEvents() {
        return this.myEvents != null && !this.myEvents.isEmpty() || this.myEvent != null;
    }

    @Override
    public String getEventName() {
        return "Channel Iterate";
    }

    @Override
    protected void performRead(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        int n2;
        super.performRead(fEventInputStream2);
        this.myCommand = fEventInputStream2.readInt();
        this.myEID = fEventInputStream2.readLong();
        this.myTimeout = fEventInputStream2.readLong();
        this.mySelector = fEventInputStream2.readString();
        this.myNameId = fEventInputStream2.readLong();
        this.iteratorId = fEventInputStream2.readLong();
        this.iteratorIdString = nChannelIterate.generateIteratorIdString(this.iteratorId);
        byte by = fEventInputStream2.readByte();
        this.myEvent = (by & 1) != 0 ? (nPublished)fEventInputStream2.readEvent() : null;
        this.isAutoAck = (by & 2) == 0;
        boolean bl = this.isClientWindowSizeSet = (by & 4) != 0;
        if (this.isClientWindowSizeSet) {
            this.maxUnackedEvents = fEventInputStream2.readInt();
        }
        if ((n2 = fEventInputStream2.readInt()) != 0) {
            this.myEvents = new ArrayList<nPublished>();
            for (n = 0; n < n2; ++n) {
                nPublished nPublished2 = (nPublished)fEventInputStream2.readEvent();
                this.myEvents.add(nPublished2);
            }
        }
        if ((by & 8) != 0) {
            n = fEventInputStream2.readInt();
            this.ackEvents = new long[n];
            for (int i = 0; i < n; ++i) {
                this.ackEvents[i] = fEventInputStream2.readLong();
            }
        }
    }

    @Override
    protected void performWrite(fEventOutputStream fEventOutputStream2) throws IOException {
        super.performWrite(fEventOutputStream2);
        fEventOutputStream2.writeInt(this.myCommand);
        fEventOutputStream2.writeLong(this.myEID);
        fEventOutputStream2.writeLong(this.myTimeout);
        fEventOutputStream2.writeString(this.mySelector);
        fEventOutputStream2.writeLong(this.myNameId);
        fEventOutputStream2.writeLong(this.iteratorId);
        byte by = 0;
        if (this.myEvent != null) {
            by = 1;
        }
        if (!this.isAutoAck) {
            by = (byte)(by + 2);
        }
        if (this.isClientWindowSizeSet) {
            by = (byte)(by + 4);
        }
        if (this.ackEvents != null) {
            by = (byte)(by + 8);
        }
        fEventOutputStream2.writeByte(by);
        if (this.myEvent != null) {
            fEventOutputStream2.writeEvent(this.myEvent);
        }
        if (this.isClientWindowSizeSet) {
            fEventOutputStream2.writeInt(this.maxUnackedEvents);
        }
        if (this.myEvents != null) {
            fEventOutputStream2.writeInt(this.myEvents.size());
            for (nPublished nPublished2 : this.myEvents) {
                fEventOutputStream2.writeEvent(nPublished2);
            }
        } else {
            fEventOutputStream2.writeInt(0);
        }
        if (this.ackEvents != null) {
            fEventOutputStream2.writeInt(this.ackEvents.length);
            for (Object object : (Object)this.ackEvents) {
                fEventOutputStream2.writeLong((long)object);
            }
        }
    }

    @Override
    public fBaseEvent getClone() {
        try {
            nChannelIterate nChannelIterate2 = (nChannelIterate)this.clone();
            nChannelIterate2.myCommand = this.myCommand;
            nChannelIterate2.myEID = this.myEID;
            nChannelIterate2.myTimeout = this.myTimeout;
            nChannelIterate2.mySelector = this.mySelector;
            nChannelIterate2.myNameId = this.myNameId;
            nChannelIterate2.isClientWindowSizeSet = this.isClientWindowSizeSet;
            nChannelIterate2.maxUnackedEvents = this.maxUnackedEvents;
            if (this.myEvent != null) {
                nChannelIterate2.myEvent = (nPublished)this.myEvent.getClone();
            }
            return nChannelIterate2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

