/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.events;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nSynchronous;
import com.pcbsys.nirvana.base.nDataGroup;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class nDataGroupAdmin
extends nSynchronous {
    private static final String c_Interval = "i";
    private static final String c_Merge = "m";
    public static final int sAddGroup = 0;
    public static final int sDelGroup = 2;
    public static final int sGetDefault = 3;
    public static final int sAddGroups = 4;
    public static final int sGetAll = 5;
    public static final int sDelGroups = 6;
    public static final int sRecoverClient = 7;
    public static final int sAddStream = 10;
    public static final int sDelStream = 11;
    public static final int sAddPublishers = 21;
    public static final int sGetPublishers = 22;
    public static final int sDelPublishers = 23;
    public static final int sAddListener = 24;
    private int myCommand;
    private String myName;
    private String myGroup;
    private String[] myStreams;
    private nDataGroup myDataGroup;
    private Collection<nDataGroup> myGroups;
    private boolean registerListener;
    private boolean hasGroupRegistration;
    private boolean isSnoop = false;
    private boolean enableMulticast;
    private boolean deleteReplacedEvents;
    private int priority = 4;
    private fEventDictionary myConflationConfig;

    public nDataGroupAdmin() {
        super(92);
    }

    public nDataGroupAdmin(int n, boolean bl) {
        this();
        this.registerListener = bl;
        this.myCommand = n;
    }

    public nDataGroupAdmin(int n) {
        this();
        this.myCommand = n;
    }

    public nDataGroupAdmin(int n, String string) {
        this(n);
        this.myName = string;
    }

    public nDataGroupAdmin(int n, String[] stringArray) {
        this(n);
        this.myStreams = stringArray;
    }

    public nDataGroupAdmin(int n, String string, String string2) {
        this(n);
        this.myName = string2;
        this.myGroup = string;
    }

    public nDataGroupAdmin(int n, String string, String[] stringArray) {
        this(n);
        this.myStreams = stringArray;
        this.myGroup = string;
    }

    public int getCommand() {
        return this.myCommand;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    public void setGroups(Collection<nDataGroup> collection) {
        this.myGroups = collection;
    }

    public void setGroup(nDataGroup nDataGroup2) {
        this.myDataGroup = nDataGroup2;
    }

    public nDataGroup getGroup() {
        return this.myDataGroup;
    }

    public Collection<nDataGroup> getGroups() {
        return this.myGroups;
    }

    public String getGroupName() {
        return this.myGroup;
    }

    public boolean hasRegisterListener() {
        return this.registerListener;
    }

    public void setRegisterListener(boolean bl) {
        this.registerListener = bl;
    }

    public boolean isSnoopStream() {
        return this.isSnoop;
    }

    public void setSnoopStream(boolean bl) {
        this.isSnoop = bl;
    }

    public boolean isDeleteReplacedEvents() {
        return this.deleteReplacedEvents;
    }

    public void setDeleteReplacedEvents(boolean bl) {
        this.deleteReplacedEvents = bl;
    }

    public String[] getStreams() {
        return this.myStreams;
    }

    public void resetStreams() {
        this.myStreams = null;
    }

    public boolean hasConflation() {
        return this.myConflationConfig != null;
    }

    public void setConflationInterval(long l) {
        if (l <= 0L) {
            this.myConflationConfig = null;
        } else {
            if (this.myConflationConfig == null) {
                this.myConflationConfig = new fEventDictionary();
            }
            this.myConflationConfig.put(c_Interval, l);
        }
    }

    public boolean isEnableMulticast() {
        return this.enableMulticast;
    }

    public void setEnableMulticast(boolean bl) {
        this.enableMulticast = bl;
    }

    public boolean hasGroupRegistration() {
        return this.hasGroupRegistration;
    }

    public void setGroupRegistration(boolean bl) {
        this.hasGroupRegistration = bl;
    }

    @Override
    public nEvent getClone() {
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin();
        nDataGroupAdmin2.myCommand = this.myCommand;
        nDataGroupAdmin2.myConflationConfig = this.myConflationConfig;
        nDataGroupAdmin2.myDataGroup = this.myDataGroup;
        nDataGroupAdmin2.myGroup = this.myGroup;
        nDataGroupAdmin2.myId = this.myId;
        nDataGroupAdmin2.myName = this.myName;
        nDataGroupAdmin2.myStreams = this.myStreams;
        nDataGroupAdmin2.isSnoop = this.isSnoop;
        nDataGroupAdmin2.hasGroupRegistration = this.hasGroupRegistration;
        nDataGroupAdmin2.setRequestId(this.myUniqueRequestId);
        nDataGroupAdmin2.priority = this.priority;
        nDataGroupAdmin2.registerListener = this.registerListener;
        return nDataGroupAdmin2;
    }

    public long getConflationInterval() {
        if (this.myConflationConfig == null) {
            return -1L;
        }
        return this.myConflationConfig.getLong(c_Interval);
    }

    public void setConflationMerge(boolean bl) {
        if (this.myConflationConfig == null) {
            this.myConflationConfig = new fEventDictionary();
        }
        this.myConflationConfig.put(c_Merge, bl);
    }

    public boolean getConflationMerge() {
        if (this.myConflationConfig == null) {
            return false;
        }
        return this.myConflationConfig.getBoolean(c_Merge);
    }

    public void setPriority(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException(String.format("Group Priority must be between %d and %d", 0, 9));
        }
        this.priority = n;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getEventName() {
        return "Data Group Admin";
    }

    @Override
    protected void performWrite(fEventOutputStream fEventOutputStream2) throws IOException {
        super.performWrite(fEventOutputStream2);
        int n = 0;
        if (this.myName != null) {
            ++n;
        }
        if (this.myGroups != null) {
            n += 2;
        }
        if (this.myGroup != null) {
            n += 4;
        }
        if (this.registerListener) {
            n += 8;
        }
        if (this.myDataGroup != null) {
            n += 16;
        }
        if (this.myStreams != null) {
            n += 32;
        }
        if (this.myConflationConfig != null) {
            n += 64;
        }
        if (this.hasGroupRegistration) {
            n += 128;
        }
        if (this.isSnoop) {
            n += 256;
        }
        if (this.enableMulticast) {
            n += 512;
        }
        if (this.deleteReplacedEvents) {
            n += 1024;
        }
        fEventOutputStream2.writeInt(this.myCommand);
        fEventOutputStream2.writeInt(n += this.priority << 11);
        if (this.myName != null) {
            fEventOutputStream2.writeString(this.myName);
        }
        if (this.myGroups != null) {
            Iterator<nDataGroup> iterator = this.myGroups.iterator();
            fEventOutputStream2.writeInt(this.myGroups.size());
            while (iterator.hasNext()) {
                iterator.next().writeExternal(fEventOutputStream2);
            }
        }
        if (this.myGroup != null) {
            fEventOutputStream2.writeString(this.myGroup);
        }
        if (this.myDataGroup != null) {
            this.myDataGroup.writeExternal(fEventOutputStream2);
        }
        if (this.myStreams != null) {
            fEventOutputStream2.writeInt(this.myStreams.length);
            for (int i = 0; i < this.myStreams.length; ++i) {
                fEventOutputStream2.writeString(this.myStreams[i]);
            }
        }
        if (this.myConflationConfig != null) {
            this.myConflationConfig.writeExternal(fEventOutputStream2);
        }
    }

    @Override
    protected void performRead(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        int n2;
        super.performRead(fEventInputStream2);
        this.myCommand = fEventInputStream2.readInt();
        int n3 = fEventInputStream2.readInt();
        if ((n3 & 1) != 0) {
            this.myName = fEventInputStream2.readString();
        }
        if ((n3 & 2) != 0) {
            n2 = fEventInputStream2.readInt();
            this.myGroups = new LinkedList<nDataGroup>();
            for (n = 0; n < n2; ++n) {
                nDataGroup nDataGroup2 = new nDataGroup();
                nDataGroup2.readExternal(fEventInputStream2);
                this.myGroups.add(nDataGroup2);
            }
        }
        if ((n3 & 4) != 0) {
            this.myGroup = fEventInputStream2.readString();
        }
        boolean bl = this.registerListener = (n3 & 8) != 0;
        if ((n3 & 0x10) != 0) {
            this.myDataGroup = new nDataGroup();
            this.myDataGroup.readExternal(fEventInputStream2);
        }
        if ((n3 & 0x20) != 0) {
            n2 = fEventInputStream2.readInt();
            this.myStreams = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.myStreams[n] = fEventInputStream2.readString();
            }
        }
        if ((n3 & 0x40) != 0) {
            this.myConflationConfig = new fEventDictionary();
            this.myConflationConfig.readExternal(fEventInputStream2);
        }
        this.hasGroupRegistration = (n3 & 0x80) != 0;
        this.isSnoop = (n3 & 0x100) != 0;
        this.enableMulticast = (n3 & 0x200) != 0;
        this.deleteReplacedEvents = (n3 & 0x400) != 0;
        this.priority = n3 >> 11 & 0xF;
    }
}

