/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.events;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.events.nSource;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nRequestCallback;
import java.io.IOException;

public abstract class nEvent
implements fBaseEvent {
    private nRequestCallback myCallback;
    protected int myId;
    protected fEventDictionary myDictionary;
    private volatile boolean isDeleted;
    private byte[] myCache;
    private int myCacheCount;
    private boolean marked;
    private boolean sendReply = true;
    private boolean ignoreACL = false;
    private nSource mySource;
    private boolean producerEvent = false;

    public nEvent(int n) {
        this.myId = n;
    }

    public nRequestCallback getCallback() {
        return this.myCallback;
    }

    public void setCallback(nRequestCallback nRequestCallback2) {
        this.myCallback = nRequestCallback2;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean bl) {
        this.isDeleted = bl;
    }

    public boolean isProducerEvent() {
        return false;
    }

    @Override
    public boolean isFilterableEvent() {
        return this.isProducerEvent();
    }

    public nSource getEventSource() {
        return this.mySource;
    }

    public void setEventSource(nSource nSource2) {
        this.mySource = nSource2;
    }

    @Override
    public byte[] getData() {
        return null;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public long getHeapUsageEstimate() {
        return this.getSize();
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    @Override
    public fEventDictionary getDictionary() {
        return this.myDictionary;
    }

    @Override
    public fEventDictionary getHeaderDictionary() {
        return null;
    }

    @Override
    public int getId() {
        return this.myId;
    }

    public int getId(int n) {
        return this.myId;
    }

    public void setId(int n) {
        this.myId = n;
    }

    @Override
    public long getKey() {
        return 0L;
    }

    @Override
    public void setKey(long l) {
    }

    @Override
    public long getTTL() {
        return 0L;
    }

    public void setTTL(long l) {
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getIndentifier() {
        return null;
    }

    public void setReply(boolean bl) {
        this.sendReply = bl;
    }

    public boolean sendReply() {
        return this.sendReply;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.performRead(fEventInputStream2);
        int n = fEventInputStream2.readInt();
        if (n != 0) {
            int n2;
            if (n < 0) {
                n = n * -1 + 127;
            }
            StringBuilder stringBuilder = new StringBuilder("Stream corruption detected. Expected frame byte 0x00 received but received " + Integer.toHexString(n) + " while processing " + this.getClass().toString() + "\n");
            byte[] byArray = new byte[100];
            try {
                n2 = fEventInputStream2.read(byArray, 0, 100);
            }
            catch (Throwable throwable) {
                nConstants.logger.info(stringBuilder.toString());
                throw new IOException(stringBuilder.toString());
            }
            stringBuilder.append("*************************\n").append(fStringByteConverter.convertSafe(byArray, n2)).append("\n\nHEX\n");
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[i];
                if (n3 < 0) {
                    n3 = n3 * -1 + 127;
                }
                stringBuilder.append(", 0x").append(Integer.toHexString(n3));
            }
            stringBuilder.append("\n*************************");
            nConstants.logger.info(stringBuilder.toString());
            throw new IOException(stringBuilder.toString());
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        byte[] byArray = this.releaseCache();
        if (byArray != null && fEventOutputStream2.canCompressBinary()) {
            fEventOutputStream2.write(byArray);
        } else {
            this.performWrite(fEventOutputStream2);
            fEventOutputStream2.writeInt(0);
        }
    }

    public void setCache(byte[] byArray) {
        this.setCache(byArray, false);
    }

    public void setCache(byte[] byArray, boolean bl) {
        this.myCache = byArray;
        this.myCacheCount = bl ? Integer.MAX_VALUE : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateCache() {
        if (this.myCache == null || this.myCacheCount == Integer.MAX_VALUE) {
            return;
        }
        nEvent nEvent2 = this;
        synchronized (nEvent2) {
            ++this.myCacheCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] releaseCache() {
        if (this.myCache == null || this.myCacheCount == Integer.MAX_VALUE) {
            return this.myCache;
        }
        byte[] byArray = this.myCache;
        nEvent nEvent2 = this;
        synchronized (nEvent2) {
            --this.myCacheCount;
            if (this.myCacheCount == 0) {
                this.resetCache();
            }
        }
        return byArray;
    }

    @Override
    public fBaseEvent getClone() {
        try {
            return (fBaseEvent)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setDictionary(fEventDictionary fEventDictionary2) {
        this.myDictionary = fEventDictionary2;
    }

    @Override
    public void resetCache() {
        this.myCache = null;
        this.myCacheCount = 0;
    }

    int getCacheCount() {
        return this.myCacheCount;
    }

    @Override
    public void processLoopback() {
    }

    @Override
    public int getPriority() {
        return 4;
    }

    public void setIgnoreACL(boolean bl) {
        this.ignoreACL = bl;
    }

    public boolean getIgnoreACL() {
        return this.ignoreACL;
    }

    public nEvent getClientVersion() {
        return this;
    }

    public abstract String getEventName();

    protected abstract void performWrite(fEventOutputStream var1) throws IOException;

    protected abstract void performRead(fEventInputStream var1) throws IOException;

    protected boolean isSupported(int n) {
        return n >= 9;
    }
}

