/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base.json;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.base.fProtobufDictionary;
import com.pcbsys.foundation.base.fStringEntry;
import com.pcbsys.foundation.utils.Base64;
import com.pcbsys.foundation.utils.fAsciiByteArrayToPrimitiveType;
import com.pcbsys.foundation.utils.fAsciiEncoder;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fURLHelper;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nHeader;
import java.io.IOException;
import java.util.Arrays;

public final class JSONConverter {
    private static final byte[] jsonStart = "{".getBytes();
    private static final byte[] jsonEnd = "}".getBytes();
    private static final byte[] jsonComma = ",".getBytes();
    private static final byte[] jsonColon = ":".getBytes();
    private static final byte[] jsonQuote = "\"".getBytes();
    private static final byte[] jsonArrayStart = "[".getBytes();
    private static final byte[] jsonArrayEnd = "]".getBytes();
    private static final byte jsonCommaByte = 44;
    private static final byte jsonStartByte = 123;
    private static final byte jsonEndByte = 125;
    private static final byte jsonValueStartByte = 91;
    private static final byte jsonValueEndByte = 93;
    private static final byte jsonKeyStart = 34;
    private static final byte jsonKeyEnd = 34;
    private static final byte jsonStringStart = 34;
    private static final byte jsonStringEnd = 34;
    private static final byte jsonDashByte = 45;
    private static final byte jsonSpaceByte = 32;
    private static final byte jsonTabByte = 9;
    private static final byte jsonNewLineByte = 10;
    private static final byte jsonLineFeedByte = 13;
    private static final byte jsonEscapedCharacter = 92;
    private static final byte[] jsonCNAME = "\"CNAME\":\"".getBytes();
    private static final byte[] jsonDataGroup = ",\"dg\":\"1\"".getBytes();
    private static final byte[] jsonData = ",\"Data\":\"".getBytes();
    private static final byte[] jsonTag = ",\"Tag\":\"".getBytes();
    private static final byte[] jsonEID = ",\"EID\":".getBytes();
    private static final byte[] jsonHeader = ",\"h\":{".getBytes();
    private static final byte[] jsonDictionary = ",\"Dictionary\":".getBytes();
    private static final byte[] jsonAllowMergeHeader = "\"_allowMerging\":".getBytes();
    private static final byte[] jsonPubHostHeader = "\"pubHost\":\"".getBytes();
    private static final byte[] jsonPubNameHeader = "\"pubName\":\"".getBytes();
    private static final byte[] jsonSubHostHeader = "\"subHost\":\"".getBytes();
    private static final byte[] jsonSubIDHeader = "\"subID\":".getBytes();
    private static final byte[] jsonMessageTypeHeader = "\"messageType\":".getBytes();
    private static final byte[] jsonTimeStampHeader = "\"timeStamp\":".getBytes();
    private static final byte[] jsonIsDeltaHeader = "\"_isDelta\":".getBytes();
    private static final byte[] jsonIsRedeliveredHeader = "\"_isRedelivered\":".getBytes();
    private static final byte[] jsonIsRegisteredHeader = "\"isRegistered\":".getBytes();
    private static final byte[] jsonDeadEIDHeader = "\"deadEID\":".getBytes();
    private static final byte[] jsonDeadEventChannelHeader = "\"deadEventChannel\":\"".getBytes();
    private static final byte[] jsonJoinEIDHeader = "\"joinEID\":".getBytes();
    private static final byte[] jsonJoinChannelHeader = "\"joinChannel\":\"".getBytes();
    private static final byte[] jsonJoinRealmHeader = "\"joinRealm\":\"".getBytes();
    private static final byte[] jsonJoinPathHeader = "\"joinPath\":\"".getBytes();
    private static final byte[] jsonMessageIDHeader = "\"messageID\":\"".getBytes();
    private static final byte[] jsonCorrelationIDHeader = "\"correlationID\":\"".getBytes();
    private static final byte[] jsonTypeHeader = "\"type\":\"".getBytes();
    private static final byte[] jsonExpirationHeader = "\"expiration\":".getBytes();
    private static final byte[] jsonDestinationHeader = "\"destination\":\"".getBytes();
    private static final byte[] jsonDeliveryModeHeader = "\"deliveryMode\":".getBytes();
    private static final byte[] jsonPriorityHeader = "\"priority\":".getBytes();
    private static final byte[] jsonUserIDHeader = "\"userID\":\"".getBytes();
    private static final byte[] jsonAppIDHeader = "\"appID\":\"".getBytes();
    private static final byte[] jsonReplyToHeader = "\"replyTo\":\"".getBytes();
    private static final byte[] jsonReplyToType = "\"replyToType\":".getBytes();
    private static final byte[] jsonTrue = "true".getBytes();
    private static final byte[] jsonFalse = "false".getBytes();
    private static final byte jsonStringType = 48;
    private static final byte jsonLongType = 49;
    private static final byte jsonDoubleType = 50;
    private static final byte jsonBooleanType = 51;
    private static final byte jsonIntegerType = 52;
    private static final byte jsonFloatType = 53;
    private static final byte jsonCharType = 54;
    private static final byte jsonByteType = 55;
    private static final byte jsonShortType = 56;
    private static final byte jsonDictionaryType = 57;
    private static final byte jsonArrayType = 45;
    private static final byte[] dictionaryStringType = String.valueOf(0).getBytes();
    private static final byte[] dictionaryLongType = String.valueOf(1).getBytes();
    private static final byte[] dictionaryDoubleType = String.valueOf(2).getBytes();
    private static final byte[] dictionaryBooleanType = String.valueOf(3).getBytes();
    private static final byte[] dictionaryIntegerType = String.valueOf(4).getBytes();
    private static final byte[] dictionaryFloatType = String.valueOf(5).getBytes();
    private static final byte[] dictionaryCharType = String.valueOf(6).getBytes();
    private static final byte[] dictionaryByteType = String.valueOf(7).getBytes();
    private static final byte[] dictionaryShortType = String.valueOf(8).getBytes();
    private static final byte[] dictionaryDictionaryType = String.valueOf(9).getBytes();
    private static final byte[] dictionaryArrayType = String.valueOf(-1).getBytes();
    private static final int lSize = String.valueOf(Long.MIN_VALUE).length();
    private static final byte[] sTrue = JSONConverter.convertString("true");
    private static final byte[] sFalse = JSONConverter.convertString("false");

    public static byte[] toJSON(nPublished nPublished2, boolean bl, byte[] byArray, boolean bl2) {
        byte[] byArray2;
        byte[] byArray3;
        int n = 0;
        ++n;
        n += jsonQuote.length + jsonCNAME.length + byArray.length;
        byte[] byArray4 = bl2 ? JSONConverter.asciiEncode(nPublished2.getEID()) : JSONConverter.convertLongToArray(nPublished2.getEID());
        n += jsonEID.length + byArray4.length;
        if (bl) {
            n += jsonDataGroup.length;
        }
        byte[] byArray5 = null;
        if (nPublished2.getData() != null) {
            byArray5 = Base64.encodeBytes(nPublished2.getData());
            n = n + jsonData.length + jsonQuote.length + byArray5.length;
        }
        byte[] byArray6 = null;
        if (nPublished2.getTag() != null) {
            byArray6 = Base64.encodeBytes(nPublished2.getTag());
            n = n + jsonTag.length + jsonQuote.length + byArray6.length;
        }
        if ((byArray3 = JSONConverter.toJSON(nPublished2.getHeader(), bl2)) != null) {
            n += byArray3.length;
        }
        if ((byArray2 = JSONConverter.toJSON(nPublished2.getDictionary(), bl2)) != null) {
            n = n + jsonDictionary.length + byArray2.length;
        }
        byte[] byArray7 = new byte[++n];
        int n2 = 0;
        n2 = JSONConverter.copy(jsonStart, byArray7, n2);
        n2 = JSONConverter.copy(jsonCNAME, byArray7, n2);
        n2 = JSONConverter.copy(byArray, byArray7, n2);
        n2 = JSONConverter.copy(jsonQuote, byArray7, n2);
        if (bl) {
            n2 = JSONConverter.copy(jsonDataGroup, byArray7, n2);
        }
        n2 = JSONConverter.copy(jsonEID, byArray7, n2);
        n2 = JSONConverter.copy(byArray4, byArray7, n2);
        if (nPublished2.getData() != null) {
            n2 = JSONConverter.copy(jsonData, byArray7, n2);
            n2 = JSONConverter.copy(byArray5, byArray7, n2);
            n2 = JSONConverter.copy(jsonQuote, byArray7, n2);
        }
        if (nPublished2.getTag() != null) {
            n2 = JSONConverter.copy(jsonTag, byArray7, n2);
            n2 = JSONConverter.copy(byArray6, byArray7, n2);
            n2 = JSONConverter.copy(jsonQuote, byArray7, n2);
        }
        if (byArray2 != null) {
            n2 = JSONConverter.copy(jsonDictionary, byArray7, n2);
            n2 = JSONConverter.copy(byArray2, byArray7, n2);
        }
        if (byArray3 != null) {
            n2 = JSONConverter.copy(byArray3, byArray7, n2);
        }
        JSONConverter.copy(jsonEnd, byArray7, n2);
        return byArray7;
    }

    private static byte[] toJSON(nHeader nHeader2, boolean bl) {
        if (nHeader2 == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        n += jsonHeader.length;
        if (nHeader2.isAllowedMerge()) {
            n += jsonAllowMergeHeader.length + jsonTrue.length;
            ++n2;
        }
        if (nHeader2.getPubHost() != null) {
            n += jsonPubHostHeader.length + nHeader2.getPubHost().length + jsonQuote.length;
            ++n2;
        }
        if (nHeader2.getPubName() != null) {
            n += jsonPubNameHeader.length + nHeader2.getPubName().length + jsonQuote.length;
            ++n2;
        }
        if (nHeader2.getSubHost() != null) {
            n += jsonSubHostHeader.length + nHeader2.getSubHost().length + jsonQuote.length;
            ++n2;
        }
        byte[] byArray = null;
        if (nHeader2.getSubId() > 0) {
            byArray = fAsciiEncoder.encodeInt(nHeader2.getSubId());
            n += jsonSubIDHeader.length + byArray.length;
            ++n2;
        }
        byte[] byArray2 = null;
        if (nHeader2.getMessageType() != -1) {
            byArray2 = fAsciiEncoder.encodeInt(nHeader2.getMessageType());
            n += jsonMessageTypeHeader.length + byArray2.length;
            ++n2;
        }
        byte[] byArray3 = null;
        if (nHeader2.getTimestamp() > 0L) {
            byArray3 = bl ? JSONConverter.asciiEncode(nHeader2.getTimestamp()) : JSONConverter.convertLongToArray(nHeader2.getTimestamp());
            n += jsonTimeStampHeader.length + byArray3.length;
            ++n2;
        }
        if (nHeader2.isDelta()) {
            n += jsonIsDeltaHeader.length + jsonTrue.length;
            ++n2;
        }
        if (nHeader2.isRedelivered()) {
            n += jsonIsRedeliveredHeader.length + jsonTrue.length;
            ++n2;
        }
        if (nHeader2.isRegistered()) {
            n += jsonIsRegisteredHeader.length + jsonTrue.length;
            ++n2;
        }
        byte[] byArray4 = null;
        if (nHeader2.myDeadEID > 0L) {
            byArray4 = bl ? JSONConverter.asciiEncode(nHeader2.myDeadEID) : JSONConverter.convertLongToArray(nHeader2.myDeadEID);
            n += jsonDeadEIDHeader.length + byArray4.length;
            ++n2;
            if (nHeader2.myDeadEventChannel != null) {
                n = jsonDeadEventChannelHeader.length + nHeader2.myDeadEventChannel.length + jsonQuote.length;
                ++n2;
            }
        }
        byte[] byArray5 = null;
        if (nHeader2.myJoinEID > -1L) {
            byArray5 = bl ? JSONConverter.asciiEncode(nHeader2.myJoinEID) : JSONConverter.convertLongToArray(nHeader2.myJoinEID);
            n += jsonJoinEIDHeader.length + byArray5.length;
            ++n2;
            if (nHeader2.myJoinChannel != null) {
                n += jsonJoinChannelHeader.length + nHeader2.myJoinChannel.length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.myJoinRealm != null) {
                n += jsonJoinRealmHeader.length + nHeader2.myJoinRealm.length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.myJoinPath != null) {
                n += jsonJoinPathHeader.length + nHeader2.myJoinPath.length + jsonQuote.length;
                ++n2;
            }
        }
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        byte[] byArray9 = null;
        if (nHeader2.getMessageType() >= 0 && nHeader2.getMessageType() < 7) {
            if (nHeader2.getMessageId() != null) {
                n += jsonMessageIDHeader.length + nHeader2.getMessageId().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getCorrelationId() != null) {
                n += jsonCorrelationIDHeader.length + nHeader2.getCorrelationId().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getType() != null) {
                n += jsonTypeHeader.length + nHeader2.getType().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getExpiration() > 0L) {
                byArray6 = bl ? JSONConverter.asciiEncode(nHeader2.getExpiration()) : JSONConverter.convertLongToArray(nHeader2.getExpiration());
                n += jsonExpirationHeader.length + byArray6.length;
                ++n2;
            }
            if (nHeader2.getDestination() != null) {
                n += jsonDestinationHeader.length + nHeader2.getDestination().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getDeliveryMode() > 0) {
                byArray7 = fAsciiEncoder.encodeInt(nHeader2.getDeliveryMode());
                n += jsonDeliveryModeHeader.length + byArray7.length;
                ++n2;
            }
            if (nHeader2.getPriority() > 0) {
                byArray8 = fAsciiEncoder.encodeInt(nHeader2.getPriority());
                n += jsonPriorityHeader.length + byArray8.length;
                ++n2;
            }
            if (nHeader2.getUserId() != null) {
                n += jsonUserIDHeader.length + nHeader2.getUserId().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getApplicationId() != null) {
                n += jsonAppIDHeader.length + nHeader2.getApplicationId().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getReplyToName() != null) {
                n += jsonReplyToHeader.length + nHeader2.getReplyToName().length + jsonQuote.length;
                ++n2;
            }
            if (nHeader2.getReplyType() > 0) {
                byArray9 = fAsciiEncoder.encodeInt(nHeader2.getReplyType());
                n += jsonReplyToType.length + byArray9.length;
                ++n2;
            }
        }
        int n3 = ++n + (n2 == 0 ? 0 : n2 - 1);
        byte[] byArray10 = new byte[n3];
        int n4 = 0;
        n4 = JSONConverter.copy(jsonHeader, byArray10, n4);
        if (nHeader2.isAllowedMerge()) {
            n4 = JSONConverter.copy(jsonAllowMergeHeader, byArray10, n4);
            n4 = JSONConverter.copy(jsonTrue, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getPubHost() != null) {
            n4 = JSONConverter.copy(jsonPubHostHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getPubHost(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getPubName() != null) {
            n4 = JSONConverter.copy(jsonPubNameHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getPubName(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getSubHost() != null) {
            n4 = JSONConverter.copy(jsonSubHostHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getSubHost(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray != null) {
            n4 = JSONConverter.copy(jsonSubIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray2 != null) {
            n4 = JSONConverter.copy(jsonMessageTypeHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray2, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray3 != null) {
            n4 = JSONConverter.copy(jsonTimeStampHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray3, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.isDelta()) {
            n4 = JSONConverter.copy(jsonIsDeltaHeader, byArray10, n4);
            n4 = JSONConverter.copy(jsonTrue, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.isRedelivered()) {
            n4 = JSONConverter.copy(jsonIsRedeliveredHeader, byArray10, n4);
            n4 = JSONConverter.copy(jsonTrue, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.isRegistered()) {
            n4 = JSONConverter.copy(jsonIsRegisteredHeader, byArray10, n4);
            n4 = JSONConverter.copy(jsonTrue, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray4 != null) {
            n4 = JSONConverter.copy(jsonDeadEIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray4, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
            if (nHeader2.myDeadEventChannel != null) {
                n4 = JSONConverter.copy(jsonDeadEventChannelHeader, byArray10, n4);
                n4 = JSONConverter.copy(nHeader2.myDeadEventChannel, byArray10, n4);
                n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
                if (--n2 > 0) {
                    n4 = JSONConverter.copy(jsonComma, byArray10, n4);
                }
            }
        }
        if (byArray5 != null) {
            n4 = JSONConverter.copy(jsonJoinEIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray5, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
            if (nHeader2.myJoinChannel != null) {
                n4 = JSONConverter.copy(jsonJoinChannelHeader, byArray10, n4);
                n4 = JSONConverter.copy(nHeader2.myJoinChannel, byArray10, n4);
                n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
                if (--n2 > 0) {
                    n4 = JSONConverter.copy(jsonComma, byArray10, n4);
                }
            }
            if (nHeader2.myJoinRealm != null) {
                n4 = JSONConverter.copy(jsonJoinRealmHeader, byArray10, n4);
                n4 = JSONConverter.copy(nHeader2.myJoinRealm, byArray10, n4);
                n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
                if (--n2 > 0) {
                    n4 = JSONConverter.copy(jsonComma, byArray10, n4);
                }
            }
            if (nHeader2.myJoinPath != null) {
                n4 = JSONConverter.copy(jsonJoinPathHeader, byArray10, n4);
                n4 = JSONConverter.copy(nHeader2.myJoinPath, byArray10, n4);
                n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
                if (--n2 > 0) {
                    n4 = JSONConverter.copy(jsonComma, byArray10, n4);
                }
            }
        }
        if (byArray7 != null) {
            n4 = JSONConverter.copy(jsonDeliveryModeHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray7, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getMessageType() == -1 || nHeader2.getMessageType() > 6) {
            JSONConverter.copy(jsonEnd, byArray10, n4);
            return byArray10;
        }
        if (nHeader2.getMessageId() != null) {
            n4 = JSONConverter.copy(jsonMessageIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getMessageId(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getCorrelationId() != null) {
            n4 = JSONConverter.copy(jsonCorrelationIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getCorrelationId(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getType() != null) {
            n4 = JSONConverter.copy(jsonTypeHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getType(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray6 != null) {
            n4 = JSONConverter.copy(jsonExpirationHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray6, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getDestination() != null) {
            n4 = JSONConverter.copy(jsonDestinationHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getDestination(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray8 != null) {
            n4 = JSONConverter.copy(jsonPriorityHeader, byArray10, n4);
            n4 = JSONConverter.copy(byArray8, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getUserId() != null) {
            n4 = JSONConverter.copy(jsonUserIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getUserId(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getApplicationId() != null) {
            n4 = JSONConverter.copy(jsonAppIDHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getApplicationId(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (nHeader2.getReplyToName() != null) {
            n4 = JSONConverter.copy(jsonReplyToHeader, byArray10, n4);
            n4 = JSONConverter.copy(nHeader2.getReplyToName(), byArray10, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray10, n4);
            if (--n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray10, n4);
            }
        }
        if (byArray9 != null) {
            n4 = JSONConverter.copy(jsonReplyToType, byArray10, n4);
            n4 = JSONConverter.copy(byArray9, byArray10, n4);
        }
        JSONConverter.copy(jsonEnd, byArray10, n4);
        return byArray10;
    }

    public static byte[] toJSON(fEventDictionary fEventDictionary2, boolean bl) {
        if (fEventDictionary2 == null || fEventDictionary2 instanceof fProtobufDictionary) {
            return null;
        }
        int n = jsonStart.length + jsonEnd.length;
        byte[][] byArrayArray = new byte[fEventDictionary2.getSize()][];
        int n2 = 0;
        for (fStringEntry fStringEntry2 : fEventDictionary2.getKeySet()) {
            byte[] object = JSONConverter.getEntryBytes(fStringEntry2, fEventDictionary2, bl);
            int n3 = jsonQuote.length * 2 + fStringEntry2.getBytes().length + jsonColon.length + object.length;
            if (n2 > 0) {
                n3 += jsonComma.length;
            }
            byte[] byArray = new byte[n3];
            int n4 = 0;
            if (n2 > 0) {
                n4 = JSONConverter.copy(jsonComma, byArray, n4);
            }
            n4 = JSONConverter.copy(jsonQuote, byArray, n4);
            n4 = JSONConverter.copy(fStringEntry2.getBytes(), byArray, n4);
            n4 = JSONConverter.copy(jsonQuote, byArray, n4);
            n4 = JSONConverter.copy(jsonColon, byArray, n4);
            JSONConverter.copy(object, byArray, n4);
            byArrayArray[n2] = byArray;
            n += n3;
            ++n2;
        }
        Object object = new byte[n];
        int n5 = JSONConverter.copy(jsonStart, (byte[])object, 0);
        for (byte[] byArray : byArrayArray) {
            n5 = JSONConverter.copy(byArray, (byte[])object, n5);
        }
        JSONConverter.copy(jsonEnd, (byte[])object, n5);
        return object;
    }

    private static int copy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    private static byte[] getEntryBytes(fStringEntry fStringEntry2, fEventDictionary fEventDictionary2, boolean bl) {
        Object object = fEventDictionary2.getNative(fStringEntry2);
        if (object == null) {
            object = "";
        }
        if (object instanceof fStringEntry || object instanceof String) {
            byte[] byArray = object instanceof String ? fURLHelper.escapeJSON(fStringByteConverter.convert((String)object)) : fURLHelper.escapeJSON(((fStringEntry)object).getBytes());
            return JSONConverter.createDictionaryEntryString(byArray, dictionaryStringType);
        }
        if (object instanceof Long) {
            byte[] byArray = bl ? JSONConverter.asciiEncode((Long)object) : JSONConverter.convertLongToArray((Long)object);
            return JSONConverter.createDictionaryEntry(byArray, dictionaryLongType);
        }
        if (object instanceof Double) {
            byte[] byArray = fAsciiEncoder.encodeDouble((Double)object);
            return JSONConverter.createDictionaryEntry(byArray, dictionaryDoubleType);
        }
        if (object instanceof Boolean) {
            byte[] byArray = (Boolean)object != false ? jsonTrue : jsonFalse;
            return JSONConverter.createDictionaryEntry(byArray, dictionaryBooleanType);
        }
        if (object instanceof Byte) {
            return JSONConverter.createDictionaryEntry(fAsciiEncoder.encodeInt(((Byte)object).byteValue()), dictionaryByteType);
        }
        if (object instanceof Integer) {
            byte[] byArray = fAsciiEncoder.encodeInt((Integer)object);
            return JSONConverter.createDictionaryEntry(byArray, dictionaryIntegerType);
        }
        if (object instanceof Float) {
            byte[] byArray = fAsciiEncoder.encodeFloat(((Float)object).floatValue());
            return JSONConverter.createDictionaryEntry(byArray, dictionaryFloatType);
        }
        if (object instanceof Character) {
            byte[] byArray = fURLHelper.escapeJSON(((Character)object).charValue());
            return JSONConverter.createDictionaryEntryString(byArray, dictionaryCharType);
        }
        if (object instanceof Short) {
            byte[] byArray = fAsciiEncoder.encodeInt(((Short)object).shortValue());
            return JSONConverter.createDictionaryEntry(byArray, dictionaryShortType);
        }
        if (object instanceof fEventDictionary) {
            byte[] byArray = JSONConverter.toJSON((fEventDictionary)object, bl);
            return JSONConverter.createDictionaryEntry(byArray, dictionaryDictionaryType);
        }
        return JSONConverter.convertArray(object, bl);
    }

    private static byte[] convertArray(Object object, boolean bl) {
        int n;
        Object[] objectArray;
        Object object2 = null;
        int n2 = jsonArrayStart.length * 2 + jsonArrayEnd.length * 2 + jsonComma.length * 2 + dictionaryArrayType.length;
        int n3 = 0;
        boolean bl2 = false;
        byte[] byArray = null;
        if (object instanceof String[]) {
            bl2 = true;
            byArray = dictionaryStringType;
            objectArray = (String[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fURLHelper.escapeJSON(fStringByteConverter.convert(objectArray[n]));
                n2 += object2[n].length + jsonQuote.length * 2;
            }
        } else if (object instanceof int[] || object instanceof Integer[]) {
            byArray = dictionaryIntegerType;
            objectArray = (int[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fAsciiEncoder.encodeInt((int)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof long[] || object instanceof Long[]) {
            byArray = dictionaryLongType;
            objectArray = (long[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            if (bl) {
                for (n = 0; n < objectArray.length; ++n) {
                    object2[n] = JSONConverter.asciiEncode((long)objectArray[n]);
                    n2 += object2[n].length;
                }
            } else {
                for (n = 0; n < objectArray.length; ++n) {
                    object2[n] = JSONConverter.convertLongToArray((long)objectArray[n]);
                    n2 += object2[n].length;
                }
            }
        } else if (object instanceof double[] || object instanceof Double[]) {
            byArray = dictionaryDoubleType;
            objectArray = (double[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fAsciiEncoder.encodeDouble((double)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof boolean[] || object instanceof Boolean[]) {
            objectArray = (boolean[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = JSONConverter.asciiEncode((boolean)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof float[] || object instanceof Float[]) {
            byArray = dictionaryFloatType;
            objectArray = (float[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fAsciiEncoder.encodeFloat((float)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof char[] || object instanceof Character[]) {
            bl2 = true;
            byArray = dictionaryCharType;
            objectArray = (char[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fURLHelper.escapeJSON((char)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof byte[] || object instanceof Byte[]) {
            byArray = dictionaryByteType;
            objectArray = (byte[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fAsciiEncoder.encodeInt(0xFF & objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof short[] || object instanceof Short[]) {
            byArray = dictionaryShortType;
            objectArray = (short[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = fAsciiEncoder.encodeInt((int)objectArray[n]);
                n2 += object2[n].length;
            }
        } else if (object instanceof fEventDictionary[]) {
            byArray = dictionaryDictionaryType;
            objectArray = (fEventDictionary[])object;
            object2 = new byte[objectArray.length][];
            n2 += objectArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                object2[n] = JSONConverter.toJSON((fEventDictionary)((Object)objectArray[n]), bl);
                n2 += object2[n].length;
            }
        }
        byte[] byArray2 = new byte[n2 += byArray.length];
        n3 = JSONConverter.copy(jsonArrayStart, byArray2, n3);
        n3 = JSONConverter.copy(dictionaryArrayType, byArray2, n3);
        n3 = JSONConverter.copy(jsonComma, byArray2, n3);
        n3 = JSONConverter.copy(byArray, byArray2, n3);
        n3 = JSONConverter.copy(jsonComma, byArray2, n3);
        n3 = JSONConverter.copy(jsonArrayStart, byArray2, n3);
        int n4 = object2 == null ? 0 : ((byte[][])object2).length;
        for (n = 0; n < n4; ++n) {
            if (n > 0) {
                n3 = JSONConverter.copy(jsonComma, byArray2, n3);
            }
            if (bl2) {
                n3 = JSONConverter.copy(jsonQuote, byArray2, n3);
                n3 = JSONConverter.copy(object2[n], byArray2, n3);
                n3 = JSONConverter.copy(jsonQuote, byArray2, n3);
                continue;
            }
            n3 = JSONConverter.copy(object2[n], byArray2, n3);
        }
        n3 = JSONConverter.copy(jsonArrayEnd, byArray2, n3);
        JSONConverter.copy(jsonArrayEnd, byArray2, n3);
        return byArray2;
    }

    private static byte[] createDictionaryEntry(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[jsonArrayStart.length + byArray.length + jsonComma.length + byArray2.length + jsonArrayEnd.length];
        int n = 0;
        n = JSONConverter.copy(jsonArrayStart, byArray3, n);
        n = JSONConverter.copy(byArray2, byArray3, n);
        n = JSONConverter.copy(jsonComma, byArray3, n);
        n = JSONConverter.copy(byArray, byArray3, n);
        JSONConverter.copy(jsonArrayEnd, byArray3, n);
        return byArray3;
    }

    private static byte[] createDictionaryEntryString(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[jsonArrayStart.length + byArray.length + jsonComma.length + byArray2.length + jsonArrayEnd.length + jsonQuote.length * 2];
        int n = 0;
        n = JSONConverter.copy(jsonArrayStart, byArray3, n);
        n = JSONConverter.copy(byArray2, byArray3, n);
        n = JSONConverter.copy(jsonComma, byArray3, n);
        n = JSONConverter.copy(jsonQuote, byArray3, n);
        n = JSONConverter.copy(byArray, byArray3, n);
        n = JSONConverter.copy(jsonQuote, byArray3, n);
        JSONConverter.copy(jsonArrayEnd, byArray3, n);
        return byArray3;
    }

    public static fEventDictionary toDictionary(byte[] byArray, int n) throws IOException {
        fEventDictionary fEventDictionary2 = new fEventDictionary();
        JSONConverter.toDictionary(fEventDictionary2, byArray, 0, byArray.length, n);
        return fEventDictionary2;
    }

    private static int findNextComma(byte[] byArray, int n, int n2) {
        while (n < n2 && byArray[n] != 44) {
            ++n;
        }
        return n;
    }

    private static int findNext(byte[] byArray, int n, int n2, byte by) {
        boolean bl = false;
        while (n < n2) {
            if (byArray[n] == by && !bl) {
                return n;
            }
            bl = byArray[n] == 92 && !bl;
            ++n;
        }
        return -1;
    }

    private static int nextValue(byte[] byArray, int n, int n2) {
        while (n < n2) {
            if (byArray[n] != 32 && byArray[n] != 9 && byArray[n] != 10 && byArray[n] != 13) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static fEventDictionary jsonToDictionary(byte[] byArray, int n) throws IOException {
        fEventDictionary fEventDictionary2 = new fEventDictionary();
        JSONConverter.jsonToDictionary(fEventDictionary2, byArray, 0, byArray.length, n);
        return fEventDictionary2;
    }

    private static int jsonToDictionary(fEventDictionary fEventDictionary2, byte[] byArray, int n, int n2, int n3) throws IOException {
        n = JSONConverter.findNext(byArray, n, n2, (byte)123);
        block13: while (n < n2 && (n = JSONConverter.findNext(byArray, n, n2, (byte)34)) != -1) {
            int n4 = n + 1;
            int n5 = JSONConverter.findNext(byArray, n4, n2, (byte)34);
            byte[] byArray2 = new byte[n5 - n4];
            System.arraycopy(byArray, n4, byArray2, 0, byArray2.length);
            n = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n5, n2, (byte)91) + 1, n2);
            switch (byArray[n]) {
                case 48: {
                    int n6 = JSONConverter.findNext(byArray, n, n2, (byte)34) + 1;
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)34);
                    byte[] byArray3 = new byte[n7 - n6];
                    System.arraycopy(byArray, n6, byArray3, 0, byArray3.length);
                    fEventDictionary2.put(byArray2, byArray3);
                    n = JSONConverter.findNext(byArray, n7, n2, (byte)93) + 1;
                    continue block13;
                }
                case 49: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    long l = fAsciiByteArrayToPrimitiveType.convertToLong(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, l);
                    n = n7 + 1;
                    continue block13;
                }
                case 50: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    double d = fAsciiByteArrayToPrimitiveType.convertToDouble(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, (Object)d);
                    n = n7 + 1;
                    continue block13;
                }
                case 51: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    boolean bl = byArray[n6] != 102 && byArray[n6] != 70;
                    fEventDictionary2.put(byArray2, bl);
                    n = n7 + 1;
                    continue block13;
                }
                case 52: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    int n8 = fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, n8);
                    n = n7 + 1;
                    continue block13;
                }
                case 53: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    float f = fAsciiByteArrayToPrimitiveType.convertToFloat(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, f);
                    n = n7 + 1;
                    continue block13;
                }
                case 54: {
                    int n6 = JSONConverter.findNext(byArray, n, n2, (byte)34) + 1;
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)34);
                    char c = fStringByteConverter.convert(byArray, n6);
                    fEventDictionary2.put(byArray2, c);
                    n = n7 + 1;
                    continue block13;
                }
                case 55: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    byte by = (byte)fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, by);
                    n = n7 + 1;
                    continue block13;
                }
                case 56: {
                    int n6 = JSONConverter.nextValue(byArray, JSONConverter.findNext(byArray, n, n2, (byte)44) + 1, n2);
                    int n7 = JSONConverter.findNext(byArray, n6, n2, (byte)93);
                    short s = (short)fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n6, n7 - n6);
                    fEventDictionary2.put(byArray2, (int)s);
                    n = n7 + 1;
                    continue block13;
                }
                case 57: {
                    throw new IllegalArgumentException("Converting a JSON String containing a nested dictionary is currently not supported");
                }
                case 45: {
                    int n7;
                    int n6 = byArray[n += 3];
                    if (n6 == 55) {
                        n7 = JSONConverter.findNextComma(byArray, n += 2, n2);
                        int n9 = fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n, n7 - n);
                        int n10 = 0;
                        int n11 = JSONConverter.findNext(byArray, n, n2, (byte)93);
                        int n12 = JSONConverter.findNext(byArray, n, n2, (byte)91);
                        String string = new String(Arrays.copyOfRange(byArray, n12 + 1, n11));
                        byte[] byArray4 = new byte[string.split(",").length];
                        while (n10 < byArray4.length) {
                            byArray4[n10++] = (byte)fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n, n7 - n);
                            n = n7 + 1;
                            n7 = JSONConverter.findNextComma(byArray, n, n2);
                        }
                        n7 = n11;
                        fEventDictionary2.put(fStringByteConverter.convert(byArray2), byArray4);
                        n = n7 + 1;
                        continue block13;
                    }
                    throw new IllegalArgumentException("Converting a JSON String containing a array is currently not supported");
                }
            }
            throw new IOException("Failed to parse correctly");
        }
        return n;
    }

    private static int toDictionary(fEventDictionary fEventDictionary2, byte[] byArray, int n, int n2, int n3) throws IOException {
        block13: while (n < n2) {
            int n4 = JSONConverter.findNextComma(byArray, n + 1, n2);
            int n5 = fURLHelper.decodeURLRewrite(byArray, n, n4) + n;
            byte[] byArray2 = new byte[n5 - n];
            System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
            n = n4 + 1;
            switch (byArray[n]) {
                case 48: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    if (n - n4 > n3) {
                        throw new IOException("Incoming dictionary too large");
                    }
                    int n6 = fURLHelper.decodeURLRewrite(byArray, n, n4) + n;
                    byte[] byArray3 = new byte[n6 - n];
                    System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
                    fEventDictionary2.put(byArray2, byArray3);
                    n = n4 + 1;
                    continue block13;
                }
                case 49: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, fAsciiByteArrayToPrimitiveType.convertToLong(byArray, n, n4 - n));
                    n = n4 + 1;
                    continue block13;
                }
                case 50: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, (Object)fAsciiByteArrayToPrimitiveType.convertToDouble(byArray, n, n4 - n));
                    n = n4 + 1;
                    continue block13;
                }
                case 51: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    if (byArray[n] == 102 || byArray[n] == 70) {
                        fEventDictionary2.put(byArray2, false);
                    } else {
                        fEventDictionary2.put(byArray2, true);
                    }
                    n = n4 + 1;
                    continue block13;
                }
                case 52: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n, n4 - n));
                    n = n4 + 1;
                    continue block13;
                }
                case 53: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, fAsciiByteArrayToPrimitiveType.convertToFloat(byArray, n, n4 - n));
                    n = n4 + 1;
                    continue block13;
                }
                case 54: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fURLHelper.decodeURLRewrite(byArray, n, n4);
                    fEventDictionary2.put(byArray2, fStringByteConverter.convert(byArray, n));
                    n = n4 + 1;
                    continue block13;
                }
                case 55: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, (byte)fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n, n4 - n));
                    n4 = JSONConverter.findNextComma(byArray, n4, n2);
                    n = n4 + 1;
                    continue block13;
                }
                case 56: {
                    n4 = JSONConverter.findNextComma(byArray, n += 2, n2);
                    fEventDictionary2.put(byArray2, (int)((short)fAsciiByteArrayToPrimitiveType.convertToInt(byArray, n, n4 - n)));
                    n = n4 + 1;
                    continue block13;
                }
                case 57: {
                    n += 2;
                    fEventDictionary fEventDictionary3 = new fEventDictionary();
                    n = JSONConverter.toDictionary(fEventDictionary3, byArray, n, n2, n3);
                    fEventDictionary2.put(byArray2, (Object)fEventDictionary3);
                    continue block13;
                }
                case 45: {
                    n = JSONConverter.extractArray(fEventDictionary2, byArray2, byArray, n + 3, n2, n3);
                    continue block13;
                }
            }
            ++n;
        }
        return n;
    }

    private static int extractArray(fEventDictionary fEventDictionary2, byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws IOException {
        byte by = byArray2[n];
        int n4 = JSONConverter.findNextComma(byArray2, n += 2, n2);
        int n5 = fAsciiByteArrayToPrimitiveType.convertToInt(byArray2, n, n4 - n);
        n = n4 + 1;
        int n6 = 0;
        switch (by) {
            case 48: {
                String[] stringArray = new String[n5];
                while (n6 < stringArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    if (n4 - n > n3) {
                        throw new IOException("Incoming dictionary too large");
                    }
                    int n7 = fURLHelper.decodeURLRewrite(byArray2, n, n4) + n;
                    stringArray[n6++] = fStringByteConverter.convert(byArray2, n, n7 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)stringArray);
                break;
            }
            case 49: {
                long[] lArray = new long[n5];
                while (n6 < lArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    lArray[n6++] = fAsciiByteArrayToPrimitiveType.convertToLong(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)lArray);
                break;
            }
            case 50: {
                double[] dArray = new double[n5];
                while (n6 < dArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    dArray[n6++] = fAsciiByteArrayToPrimitiveType.convertToDouble(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)dArray);
                break;
            }
            case 51: {
                boolean[] blArray = new boolean[n5];
                while (n6 < blArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    blArray[n6++] = byArray2[n] != 102 && byArray2[n] != 70;
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)blArray);
                break;
            }
            case 52: {
                int[] nArray = new int[n5];
                n = n4 + 1;
                while (n6 < nArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    nArray[n6++] = fAsciiByteArrayToPrimitiveType.convertToInt(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)nArray);
                break;
            }
            case 53: {
                float[] fArray = new float[n5];
                while (n6 < fArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    fArray[n6++] = fAsciiByteArrayToPrimitiveType.convertToFloat(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)fArray);
                break;
            }
            case 54: {
                char[] cArray = new char[n5];
                while (n6 < cArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    fURLHelper.decodeURLRewrite(byArray2, n, n4);
                    cArray[n6++] = fStringByteConverter.convert(byArray2, n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)cArray);
                break;
            }
            case 55: {
                byte[] byArray3 = new byte[n5];
                while (n6 < byArray3.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    byArray3[n6++] = (byte)fAsciiByteArrayToPrimitiveType.convertToInt(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(fStringByteConverter.convert(byArray), byArray3);
                n = n4 + 1;
                break;
            }
            case 56: {
                short[] sArray = new short[n5];
                while (n6 < sArray.length) {
                    n4 = JSONConverter.findNextComma(byArray2, n, n2);
                    sArray[n6++] = (short)fAsciiByteArrayToPrimitiveType.convertToInt(byArray2, n, n4 - n);
                    n = n4 + 1;
                }
                fEventDictionary2.put(byArray, (Object)sArray);
                break;
            }
            case 57: {
                fEventDictionary[] fEventDictionaryArray = new fEventDictionary[n5];
                while (n6 < fEventDictionaryArray.length) {
                    fEventDictionary fEventDictionary3 = new fEventDictionary();
                    n = JSONConverter.toDictionary(fEventDictionary3, byArray2, n, n2, n3);
                    fEventDictionaryArray[n6++] = fEventDictionary3;
                }
                fEventDictionary2.put(byArray, (Object)fEventDictionaryArray);
                break;
            }
        }
        return n;
    }

    private static byte[] convertLongToArray(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = Math.abs(l);
        }
        long l2 = l >> 32;
        long l3 = 0xFFFFFFFFL & l;
        if (bl) {
            l2 |= 0x80000000L;
        }
        byte[] byArray = JSONConverter.asciiEncode(l2);
        byte[] byArray2 = JSONConverter.asciiEncode(l3);
        int n = byArray.length + byArray2.length + jsonArrayStart.length + jsonArrayEnd.length + 1;
        byte[] byArray3 = new byte[n];
        byArray3[0] = jsonArrayStart[0];
        int n2 = 1;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = 44;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        byArray3[n2 += byArray2.length] = jsonArrayEnd[0];
        return byArray3;
    }

    private JSONConverter() {
    }

    public static byte[] asciiEncode(long l) {
        byte[] byArray = new byte[lSize];
        int n = fAsciiEncoder.encodeLong(l, byArray);
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        return byArray2;
    }

    public static byte[] convertString(String string) {
        return fStringByteConverter.convert(string);
    }

    public static byte[] asciiEncode(boolean bl) {
        return bl ? sTrue : sFalse;
    }
}

