/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.filters.MessageFilter;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

public abstract class nBaseMultiplexer {
    protected int purgeListeners = 0;

    public abstract void addSubscriber(nEventListener var1, String var2, long var3) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nSelectorParserException, nSecurityException, nChannelAlreadySubscribedException, nChannelNotFoundException;

    public abstract boolean deleteSubscriber(nEventListener var1) throws nSelectorParserException, nSecurityException, nRequestTimedOutException, nSessionPausedException, nChannelAlreadySubscribedException, nSessionNotConnectedException, nChannelNotFoundException, nUnexpectedResponseException;

    public abstract void rebuildArray();

    public abstract void purge(long var1, long var3, String var5);

    public boolean requestPurge() {
        return this.purgeListeners > 0;
    }

    public static class SubscriberInfo
    implements fTask {
        private nEventListener myListener;
        private String myFilter;
        private long myStartEid;
        private fFilter mySelector;
        private final Queue<nConsumeEvent> myQueue = new Queue(100);
        private boolean Queued = false;
        private boolean isClosed = false;

        public SubscriberInfo(nEventListener nEventListener2, String string, long l) throws nSelectorParserException {
            this.myListener = nEventListener2;
            this.myStartEid = l;
            this.myFilter = string;
            if (string != null) {
                try {
                    MessageFilter messageFilter = new MessageFilter(string);
                    this.mySelector = messageFilter.createFilter();
                }
                catch (Throwable throwable) {
                    throw new nSelectorParserException(throwable.getMessage());
                }
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public fFilter getSelector() {
            return this.mySelector;
        }

        public String getFilter() {
            return this.myFilter;
        }

        public long getStartEID() {
            return this.myStartEid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processEvent(nConsumeEvent nConsumeEvent2, nThreadManager nThreadManager2) {
            Queue<nConsumeEvent> queue = this.myQueue;
            synchronized (queue) {
                this.myQueue.put(nConsumeEvent2);
                if (!this.Queued) {
                    this.Queued = true;
                    if (!nThreadManager2.addTask(this)) {
                        this.execute();
                    }
                }
            }
        }

        public void close() {
            this.isClosed = true;
            while (this.size() != 0) {
                this.myQueue.pop();
            }
        }

        public int size() {
            return this.myQueue.size();
        }

        public nEventListener getListener() {
            return this.myListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void execute() {
            while (this.myQueue.size() != 0) {
                nConsumeEvent nConsumeEvent2;
                Queue<nConsumeEvent> queue = this.myQueue;
                synchronized (queue) {
                    nConsumeEvent2 = this.myQueue.pop();
                }
                try {
                    if (nConsumeEvent2 == null || this.isClosed) continue;
                    this.myListener.go(nConsumeEvent2);
                }
                catch (Exception exception) {
                    nConstants.logger.info("Exception : " + exception.getMessage() + " " + exception.getClass().getName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean reQueue() {
            Queue<nConsumeEvent> queue = this.myQueue;
            synchronized (queue) {
                if (this.isClosed) {
                    return false;
                }
                this.Queued = this.myQueue.size() != 0;
                return this.Queued;
            }
        }
    }
}

