/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.io.fByteArrayInputStream;
import com.pcbsys.foundation.io.fByteArrayOutputStream;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fGenerateUniqueId;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.nChannelPublishKey;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nIllegalArgumentException;
import com.pcbsys.nirvana.base.nRealm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class nChannelAttributes
extends fBaseTransportObject
implements SortedObject {
    public static final String sMergeClassname = "MergeClassName";
    public static final String sSyncOnWrite = "SyncOnWrite";
    public static final String sSyncBatchSize = "SyncBatchSize";
    public static final String sSyncTime = "SyncTime";
    public static final String sHonorCapacity = "HonourCapacity";
    public static final String sPerformMaint = "PerformMaint";
    public static final String sStampDictionary = "StampDictionary";
    public static final String sEnableCaching = "EnableCaching";
    @Deprecated
    public static final String sEnableStoreBuffering = "EnableStoreBuffering";
    @Deprecated
    public static final String sStoreBufferSize = "StoreBufferSize";
    public static final String sCacheOnReload = "CacheOnReload";
    public static final String sFanoutArchiveTarget = "FanoutArchiveTarget";
    public static final String sResourcePriority = "Priority";
    public static final String sEnableMulticast = "EnableMulticast";
    public static final String sProtobufDescriptors = "protobufDescriptors";
    public static final String sProtobufDescriptor = "protobufDescriptor";
    public static final String sProtobufDescriptorNames = "protobufDescriptorNames";
    public static final String sProtobufDescriptorName = "protobufDescriptorName";
    public static final String sProtobufType = "protobufType";
    public static final String sMultiFileEventsPerSpindle = "multiFileEventsPerSpindle";
    private static final String sIgnoreClusterFlagIssues = "sIgnoreClusterFlagIssues";
    protected int MAXEVENTS = 0;
    protected long TTL = 0L;
    protected int type = 1;
    protected String name;
    protected byte[] nameBytes;
    protected nRealm realm;
    protected Vector realmPath;
    protected long uniqueId = -1L;
    protected int myChannelMode = 100;
    protected nChannelPublishKey[] myKeys = null;
    protected boolean isClusterWide = false;
    protected long myDeadEventStoreId = -1L;
    protected boolean useJMSEngine = false;
    protected boolean eventUpdateEngine = false;
    protected fEventDictionary myMetaDictionary;
    protected boolean isDurable = true;
    protected boolean isAutoDelete = false;

    public nChannelAttributes() {
        this.MAXEVENTS = nConstants.DEFAULT_STORE_CAPACITY;
        this.TTL = nConstants.DEFAULT_STORE_TTL;
    }

    public nChannelAttributes(nChannelAttributes nChannelAttributes2) {
        this.MAXEVENTS = nChannelAttributes2.MAXEVENTS;
        this.TTL = nChannelAttributes2.TTL;
        this.type = nChannelAttributes2.type;
        this.name = nChannelAttributes2.name;
        this.nameBytes = nChannelAttributes2.nameBytes;
        this.realm = nChannelAttributes2.realm;
        this.realmPath = nChannelAttributes2.realmPath;
        this.uniqueId = nChannelAttributes2.getUniqueId();
        this.myChannelMode = nChannelAttributes2.myChannelMode;
        this.myKeys = nChannelAttributes2.myKeys;
        this.isClusterWide = nChannelAttributes2.isClusterWide;
        this.myDeadEventStoreId = nChannelAttributes2.myDeadEventStoreId;
        this.useJMSEngine = nChannelAttributes2.useJMSEngine;
        this.eventUpdateEngine = nChannelAttributes2.eventUpdateEngine;
        this.myMetaDictionary = nChannelAttributes2.myMetaDictionary;
        this.isAutoDelete = nChannelAttributes2.isAutoDelete;
        this.isDurable = nChannelAttributes2.isDurable;
    }

    public nChannelAttributes(String string, int n, long l, int n2) throws nIllegalArgumentException {
        this.setName(string);
        this.setTTL(l);
        this.setMaxEvents(n);
        this.setType(n2);
    }

    public nChannelAttributes(String string, int n, long l, int n2, nRealm nRealm2) throws nIllegalArgumentException {
        this.setName(string);
        this.setTTL(l);
        this.setMaxEvents(n);
        this.setType(n2);
        this.setRealm(nRealm2);
    }

    public byte[][] getProtobufDescriptors() throws nIllegalArgumentException {
        try {
            byte[] byArray = this.getMetaData().getByteArray(sProtobufDescriptors);
            if (byArray != null && byArray.length != 0) {
                fByteArrayInputStream fByteArrayInputStream2 = new fByteArrayInputStream(byArray);
                fEventInputStream fEventInputStream2 = new fEventInputStream((InputStream)fByteArrayInputStream2, byArray.length);
                int n = fEventInputStream2.readInt();
                byte[][] byArray2 = new byte[n][0];
                for (int i = 0; i < n; ++i) {
                    byArray2[i] = fEventInputStream2.readByteArray();
                }
                return byArray2;
            }
            return null;
        }
        catch (Exception exception) {
            nConstants.logger.error("Exception in nChannelAttributes.getProtobufDescriptors() ", exception);
            throw new nIllegalArgumentException("Descriptor could not be read." + exception);
        }
    }

    public void setProtobufDescriptors(byte[][] object) throws nIllegalArgumentException {
        if (object == null) {
            object = new byte[0][];
        }
        fByteArrayOutputStream fByteArrayOutputStream2 = new fByteArrayOutputStream();
        try {
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fByteArrayOutputStream2);
            int n = ((byte[][])object).length;
            fEventOutputStream2.writeInt(n);
            for (int i = 0; i < ((byte[][])object).length; ++i) {
                fEventOutputStream2.writeByteArray(object[i]);
            }
            this.getMetaData().put(sProtobufDescriptors, fByteArrayOutputStream2.toByteArray());
        }
        catch (IOException iOException) {
            throw new nIllegalArgumentException("Descriptor could not be written.");
        }
    }

    @Deprecated
    public void setProtobufDescriptor(byte[] byArray) {
        if (byArray == null) {
            this.getMetaData().remove(sProtobufDescriptor);
        } else {
            this.getMetaData().put(sProtobufDescriptor, byArray);
        }
    }

    public byte[] getProtobufDescriptor() {
        return (byte[])this.getMetaData().get(sProtobufDescriptor);
    }

    public void setProtobufDescriptorNames(String[] stringArray) {
        this.getMetaData().put(sProtobufDescriptorNames, stringArray);
    }

    public void setProtobufDescriptorName(String string) {
        this.getMetaData().put(sProtobufDescriptorName, string);
    }

    public String[] getProtobufDescriptorNames() {
        return this.getMetaData().getStringArray(sProtobufDescriptorNames);
    }

    public String getProtobufDescriptorName() {
        return this.getMetaData().getString(sProtobufDescriptorName);
    }

    public void setProtobufType(String string) {
        this.getMetaData().put(sProtobufType, string);
    }

    public String getProtobufType() {
        return (String)this.getMetaData().get(sProtobufType);
    }

    public void setDeadEventHandler(long l) {
        this.myDeadEventStoreId = l;
    }

    public long getDeadEventHandler() {
        return this.myDeadEventStoreId;
    }

    public void setClusterWide(boolean bl) {
        this.isClusterWide = bl;
    }

    public boolean isClusterWide() {
        return this.isClusterWide;
    }

    public void setPublishKeys(nChannelPublishKey[] nChannelPublishKeyArray) {
        this.myKeys = nChannelPublishKeyArray;
    }

    public nChannelPublishKey[] getPublishKeys() {
        return this.myKeys;
    }

    public void setMaxEvents(int n) throws nIllegalArgumentException {
        if (n < 0) {
            throw new nIllegalArgumentException("nChannelAttributes: Illegal MaxEvents Value" + n);
        }
        this.MAXEVENTS = n;
    }

    public int getMaxEvents() {
        return this.MAXEVENTS;
    }

    public boolean isExternal() {
        return this.realm != null;
    }

    public void setTTL(long l) throws nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("nChannelAttributes: Illegal TTL Value");
        }
        this.TTL = l;
    }

    public long getTTL() {
        return this.TTL;
    }

    public void setUniqueId(long l) {
        this.uniqueId = l;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setRealm(nRealm nRealm2) {
        this.realm = nRealm2;
    }

    public nRealm getRealm() {
        return this.realm;
    }

    public void setName(String string) throws nIllegalArgumentException {
        try {
            this.name = nConstants.validate(string);
            this.nameBytes = fStringByteConverter.convert(this.name);
        }
        catch (Exception exception) {
            throw new nIllegalArgumentException("nChannelAttributes: Invalid name specified");
        }
    }

    @Deprecated
    public String getFullName() throws IllegalStateException {
        if (this.name == null) {
            throw new IllegalStateException("nChannelAttributes: name not set");
        }
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int n) throws nIllegalArgumentException {
        if (n != 1 && n != 2 && n != 3) {
            throw new nIllegalArgumentException("nChannelAttributes: Illegal Channel Type !" + n);
        }
        this.type = n;
    }

    public void setChannelMode(int n) throws nIllegalArgumentException {
        if (n != 100 && n != 101) {
            throw new nIllegalArgumentException("nChannelAttributes: Illegal Channel Mode!" + n);
        }
        this.myChannelMode = n;
    }

    public int getChannelMode() {
        return this.myChannelMode;
    }

    public int getType() {
        return this.type;
    }

    public boolean isEventUpdateEngine() {
        return this.eventUpdateEngine;
    }

    public void setEventUpdateEngine(boolean bl) {
        this.eventUpdateEngine = bl;
    }

    public boolean isUseJMSEngine() {
        return this.useJMSEngine;
    }

    public void setUseJMSEngine(boolean bl) {
        this.useJMSEngine = bl;
    }

    public fEventDictionary getMetaData() {
        if (this.myMetaDictionary == null) {
            this.myMetaDictionary = new fEventDictionary();
        }
        return this.myMetaDictionary;
    }

    public void setMetaData(fEventDictionary fEventDictionary2) {
        this.myMetaDictionary = fEventDictionary2;
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    public void setDurable(boolean bl) {
        this.isDurable = bl;
    }

    public boolean isAutoDelete() {
        return this.isAutoDelete;
    }

    public void setAutoDelete(boolean bl) {
        this.isAutoDelete = bl;
    }

    public void setIgnoreClusterFlagProblems() {
        this.myMetaDictionary.put(sIgnoreClusterFlagIssues, true);
    }

    public boolean isIgnoreClusterFlagProblems() {
        return this.getMetaData().getBoolean(sIgnoreClusterFlagIssues);
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        int n2;
        this.myChannelMode = fEventInputStream2.readInt();
        this.MAXEVENTS = fEventInputStream2.readInt();
        this.type = fEventInputStream2.readInt();
        this.uniqueId = fEventInputStream2.readLong();
        this.TTL = fEventInputStream2.readLong();
        this.nameBytes = fEventInputStream2.readByteArray();
        this.name = fStringByteConverter.convert(this.nameBytes);
        if (fEventInputStream2.readBoolean()) {
            this.realm = new nRealm();
            this.realm.readExternal(fEventInputStream2);
        }
        if ((n2 = fEventInputStream2.readInt()) != 0) {
            this.myKeys = new nChannelPublishKey[n2];
            for (n = 0; n < n2; ++n) {
                try {
                    this.myKeys[n] = new nChannelPublishKey(fEventInputStream2.readString(), fEventInputStream2.readInt());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.isClusterWide = ((n = fEventInputStream2.readByte()) & 1) != 0;
        this.useJMSEngine = (n & 2) != 0;
        this.eventUpdateEngine = (n & 8) != 0;
        this.isDurable = (n & 0x10) == 0;
        this.isAutoDelete = (n & 0x20) != 0;
        this.myDeadEventStoreId = fEventInputStream2.readLong();
        if ((n & 4) != 0) {
            byte[] byArray = fEventInputStream2.readByteArray();
            this.unpack(byArray);
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeInt(this.myChannelMode);
        fEventOutputStream2.writeInt(this.MAXEVENTS);
        fEventOutputStream2.writeInt(this.type);
        fEventOutputStream2.writeLong(this.uniqueId);
        fEventOutputStream2.writeLong(this.TTL);
        fEventOutputStream2.writeByteArray(this.nameBytes);
        boolean bl = this.realm != null;
        fEventOutputStream2.writeBoolean(bl);
        if (bl) {
            this.realm.writeExternal(fEventOutputStream2);
        }
        if (this.myKeys != null) {
            fEventOutputStream2.writeInt(this.myKeys.length);
            for (int i = 0; i < this.myKeys.length; ++i) {
                fEventOutputStream2.writeString(this.myKeys[i].getName());
                fEventOutputStream2.writeInt(this.myKeys[i].getDepth());
            }
        } else {
            fEventOutputStream2.writeInt(0);
        }
        byte[] byArray = this.pack();
        byte by = 0;
        if (this.isClusterWide) {
            by = (byte)(by + 1);
        }
        if (this.useJMSEngine) {
            by = (byte)(by + 2);
        }
        if (this.eventUpdateEngine) {
            by = (byte)(by + 8);
        }
        if (byArray != null) {
            by = (byte)(by + 4);
        }
        if (!this.isDurable) {
            by = (byte)(by + 16);
        }
        if (this.isAutoDelete) {
            by = (byte)(by + 32);
        }
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeLong(this.myDeadEventStoreId);
        if (byArray != null) {
            fEventOutputStream2.writeByteArray(byArray);
        }
    }

    public int getSize() {
        int n = 4;
        n += 4;
        n += 4;
        n += 8;
        n += 8;
        ++n;
        n += 4 + this.nameBytes.length;
        ++n;
        if (this.realm != null) {
            // empty if block
        }
        return n;
    }

    public String toString() {
        if (this.name == null) {
            return "";
        }
        String string = "Channel Name = " + this.name + "\n";
        string = string + " realm = " + this.realm + "\n";
        string = string + " ttl = " + this.TTL + "\n";
        string = string + " max events " + this.MAXEVENTS + "\n";
        string = string + " type = ";
        string = this.type == 1 ? string + "NORMAL\n" : (this.type == 2 ? string + "PERSISTENT\n" : (this.type == 3 ? string + "MIXED\n" : string + "UNKNOWN\n"));
        if (this.getMetaData() != null && this.getMetaData().getInt(sMultiFileEventsPerSpindle) > 0) {
            string = string + "Spindle Size : " + this.getMetaData().getInt(sMultiFileEventsPerSpindle) + "\n";
        }
        string = this.getChannelMode() == 101 ? string + "is a Queue \n" : string + "is a Channel \n";
        string = this.isExternal() ? string + "Is External" : string + "Is Not External";
        string = string + "Unique Id = " + this.getUniqueId();
        return string;
    }

    public boolean isMatch(Object object) {
        return this.compare(object) == 0L;
    }

    @Deprecated
    public boolean equals(Object object) {
        return this.isMatch(object);
    }

    public int hashCode() {
        return (int)this.uniqueId;
    }

    @Override
    public boolean lessThan(Object object) {
        return this.compare(object) < 0L;
    }

    public boolean isAutoMaintain() {
        boolean bl = false;
        if (this.type == 3 || this.type == 2) {
            bl = this.myMetaDictionary.getBoolean(sPerformMaint);
        }
        return bl;
    }

    private long compare(Object object) {
        if (object instanceof Long) {
            return this.uniqueId - (Long)object;
        }
        if (object instanceof nChannelAttributes) {
            nChannelAttributes nChannelAttributes2 = (nChannelAttributes)object;
            return this.uniqueId - nChannelAttributes2.uniqueId;
        }
        return 1L;
    }

    @Override
    public boolean equals(long l) {
        return this.uniqueId == l;
    }

    @Override
    public boolean lessThan(long l) {
        return this.uniqueId < l;
    }

    public void regenerateUniqueId() {
        nChannelAttributes nChannelAttributes2 = new nChannelAttributes(this);
        nChannelAttributes2.setUniqueId(-1L);
        nChannelAttributes2.setUseJMSEngine(false);
        nChannelAttributes2.setEventUpdateEngine(false);
        nChannelAttributes2.setMetaData(null);
        long l = fGenerateUniqueId.generate(nChannelAttributes2);
        this.setUniqueId(l);
    }

    protected byte[] pack() {
        if (this.myMetaDictionary != null && this.myMetaDictionary.getSize() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                fEventOutputStream fEventOutputStream2 = new fEventOutputStream((OutputStream)byteArrayOutputStream, true);
                this.myMetaDictionary.writeExternal(fEventOutputStream2);
                fEventOutputStream2.flush();
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void unpack(byte[] byArray) {
        this.myMetaDictionary = new fEventDictionary();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            fEventInputStream fEventInputStream2 = new fEventInputStream((InputStream)byteArrayInputStream, 100000000, true);
            this.myMetaDictionary.readExternal(fEventInputStream2);
            fEventInputStream2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

