/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.logger.storelogger.StoreLoggerImpl;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.KnownClientStoresCache;
import com.pcbsys.nirvana.base.events.nConnectionSubscribe;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nFlowControl;
import com.pcbsys.nirvana.base.events.nUserSubscribe;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;

public abstract class nChannelQueue {
    private static final String CLASS_NAME = nChannelQueue.class.getSimpleName();
    protected final nChannelAttributes nca;
    private final Reconnect reconTask = new Reconnect();
    protected int myWindowSize = -1;
    protected long myLastEID = -1L;
    protected long myLastAck = -1L;
    protected boolean myMaintainPriority = false;
    protected boolean myIsInfiniteWindow = false;
    protected boolean myAutoAck = false;
    protected boolean isSharedNamedObject = false;
    protected boolean requestPurge = false;
    protected String mySelector;
    protected nDurable myDurable;
    private boolean hasFlowOff = false;
    private nEvent flowOn = null;
    private nEvent flowOff = null;
    private final StoreLogger storeTraceLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected nChannelQueue(nChannelAttributes nChannelAttributes2) throws nIllegalArgumentException {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Invalid Channel Attributes : null");
        }
        this.nca = nChannelAttributes2;
        this.storeTraceLogger = new StoreLoggerImpl(this.nca.getName(), ClientEventTraceLoggerContext.getInstance());
        if (!nConstants.isSystemStore(nChannelAttributes2)) {
            KnownClientStoresCache knownClientStoresCache = KnownClientStoresCache.getInstance();
            synchronized (knownClientStoresCache) {
                KnownClientStoresCache.getInstance().addStore(this);
            }
        }
    }

    public StoreLogger getTraceLogger() {
        return this.storeTraceLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopFlow() {
        try {
            nChannelQueue nChannelQueue2 = this;
            synchronized (nChannelQueue2) {
                if (!this.hasFlowOff) {
                    this.hasFlowOff = true;
                    if (this.flowOff == null) {
                        this.flowOff = new nFlowControl(this.nca.getUniqueId(), 0);
                    }
                    this.writeEvent(this.flowOff);
                }
            }
        }
        catch (Exception exception) {
            nConstants.logger.error("nChannelQueue error :" + exception.toString());
        }
    }

    public long lastReceivedEID() {
        return this.myLastEID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFlow() {
        try {
            nChannelQueue nChannelQueue2 = this;
            synchronized (nChannelQueue2) {
                if (this.hasFlowOff) {
                    this.hasFlowOff = false;
                    if (this.flowOn == null) {
                        this.flowOn = new nFlowControl(this.nca.getUniqueId(), 1);
                    }
                    this.writeEvent(this.flowOn);
                }
            }
        }
        catch (Exception exception) {
            nConstants.logger.error("nChannelQueue error :" + exception.toString());
        }
    }

    protected void reconnectSub() {
        nConstants.logger.info("Resubscribing to " + this.nca.getName());
        fThreadScheduler.getInstance().addTask(this.reconTask, 0L);
    }

    public boolean isAutoAck() {
        return this.myAutoAck;
    }

    public long getDurableId() {
        return this.myDurable == null ? -1L : this.myDurable.getID();
    }

    protected void reconnectListeners() throws Exception {
        nConnectionSubscribe nConnectionSubscribe2 = new nConnectionSubscribe(this.nca, true);
        this.writeEvent(nConnectionSubscribe2);
    }

    protected abstract nEvent writeEvent(nEvent var1, long var2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException;

    protected abstract nEvent writeEvent(nEvent var1) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException;

    protected abstract nChannelAttributes getBaseChannelAttributes();

    protected class Reconnect
    extends fScheduledTask {
        private int maxAttempts = 120;
        private int attempts = 0;

        protected Reconnect() {
        }

        @Override
        public long reSchedule() {
            return -1L;
        }

        public void reset() {
            this.attempts = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            try {
                Reconnect reconnect = this;
                synchronized (reconnect) {
                    nEvent nEvent2;
                    nUserSubscribe nUserSubscribe2;
                    if (nChannelQueue.this.nca.getChannelMode() == 101) {
                        nUserSubscribe2 = new nUserSubscribe(nChannelQueue.this.nca, nChannelQueue.this.myLastEID, nChannelQueue.this.mySelector, nChannelQueue.this.getDurableId(), 0L, false, nChannelQueue.this.myIsInfiniteWindow);
                        nUserSubscribe2.setMaintainPriority(nChannelQueue.this.myMaintainPriority);
                    } else {
                        long l = nChannelQueue.this.myLastEID;
                        if (nChannelQueue.this.isSharedNamedObject) {
                            l = nChannelQueue.this.myWindowSize;
                        } else if (nChannelQueue.this.myDurable != null) {
                            l = nChannelQueue.this.myLastAck;
                        } else if (nChannelQueue.this.myLastEID >= 0L) {
                            ++l;
                        }
                        nUserSubscribe2 = new nUserSubscribe(nChannelQueue.this.nca, l, nChannelQueue.this.mySelector, nChannelQueue.this.getDurableId(), 0L, nChannelQueue.this.requestPurge, nChannelQueue.this.myIsInfiniteWindow);
                        nUserSubscribe2.setReconnect(true);
                    }
                    if (nChannelQueue.this.storeTraceLogger.isInfoEnabled()) {
                        nChannelQueue.this.storeTraceLogger.info("Attempting resubscribe on reconnect. EID=" + nUserSubscribe2.getEID() + ", selector=" + nUserSubscribe2.getSelector() + ", nameId=" + nUserSubscribe2.getNameId() + ", isInfiniteWindow=" + nUserSubscribe2.isInfiniteWindow() + ", requestId=" + nUserSubscribe2.getRequestId(), CLASS_NAME);
                    }
                    if (!((nEvent2 = nChannelQueue.this.writeEvent(nUserSubscribe2)) instanceof nUserSubscribe || nEvent2 instanceof nExceptionEvent && ((nExceptionEvent)nEvent2).getExceptionId() == 6)) {
                        if (((nChannelQueue)nChannelQueue.this).reconTask.attempts < ((nChannelQueue)nChannelQueue.this).reconTask.maxAttempts) {
                            nConstants.logger.warn("Unable to resubscribe to " + nChannelQueue.this.nca.getName() + " retrying.");
                            fThreadScheduler.getInstance().addTask(nChannelQueue.this.reconTask, 1000L);
                        } else {
                            nConstants.logger.warn("Unable to resubscribe to " + nChannelQueue.this.nca.getName() + " giving up as max retries reached");
                        }
                    } else {
                        nConstants.logger.debug("Resubscribed to " + nChannelQueue.this.nca.getName());
                        nChannelQueue.this.reconTask.reset();
                    }
                }
                ++this.attempts;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

