/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fPrioritized;
import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.collections.fQueue;
import com.pcbsys.foundation.collections.multiq.fPriorityQueueFactory;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.events.nConnectionUpdate;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nPurge;
import com.pcbsys.nirvana.base.nBaseMultiplexer;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nConsumeEvent;
import com.pcbsys.nirvana.base.nRegisteredEventManager;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelConnectionListener;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nChannelWatcher;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nMessageValidator;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSignedEventListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class nClientChannelList
implements SortedObject {
    private static final String CLASS_NAME = nClientChannelList.class.getSimpleName();
    private final nThreadManager myThreadManager;
    private final fQueue<fPrioritized> myEventQueue;
    private final nChannelImpl myBaseImpl;
    private final boolean isQueue;
    private final nRegisteredEventManager myRegisteredEventMgr;
    private final nPushTask myTask;
    private final CopyOnWriteArrayList<nChannelConnectionListener> myConListeners;
    private nEventListener channelSub = null;
    private nMessageValidator messageValidator = null;
    private boolean isQueued = false;
    private boolean isSubscribed = false;
    private boolean isDeleted = false;

    public nClientChannelList(nChannelImpl nChannelImpl2, nThreadManager nThreadManager2) {
        this.myThreadManager = nThreadManager2;
        this.myBaseImpl = nChannelImpl2;
        this.myEventQueue = fPriorityQueueFactory.createPriorityQueue();
        this.myConListeners = new CopyOnWriteArrayList();
        this.isQueue = this.myBaseImpl.getBaseChannelAttributes().getChannelMode() == 101;
        nRegisteredEventManager nRegisteredEventManager2 = null;
        if (this.myBaseImpl.getBaseChannelAttributes().isEventUpdateEngine() && this.myBaseImpl.getBaseChannelAttributes().getPublishKeys() != null && this.myBaseImpl.getBaseChannelAttributes().getPublishKeys().length == 1) {
            nRegisteredEventManager2 = new nRegisteredEventManager(this.myBaseImpl.getBaseChannelAttributes().getPublishKeys()[0].getName());
        }
        this.myRegisteredEventMgr = nRegisteredEventManager2;
        this.myTask = new nPushTask(this);
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public boolean hasSubscribers() {
        return this.channelSub != null;
    }

    public nChannelAttributes getAttributes() {
        return this.myBaseImpl.getBaseChannelAttributes();
    }

    public String getName() {
        return this.myBaseImpl.getBaseChannelAttributes().getName();
    }

    public int getQueueSize() {
        return this.myEventQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected() {
        fQueue<fPrioritized> fQueue2 = this.myEventQueue;
        synchronized (fQueue2) {
            Queue queue = new Queue();
            while (this.myEventQueue.size() != 0) {
                fPrioritized fPrioritized2 = this.myEventQueue.pop();
                if (!(fPrioritized2 instanceof WrappedConsumeEvent)) continue;
                com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2 = ((WrappedConsumeEvent)fPrioritized2).event;
            }
            while (queue.size() != 0) {
                this.myEventQueue.put((fPrioritized)queue.pop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        fQueue<fPrioritized> fQueue2 = this.myEventQueue;
        synchronized (fQueue2) {
            Queue<fPrioritized> queue = new Queue<fPrioritized>();
            while (this.myEventQueue.size() != 0) {
                fPrioritized fPrioritized2 = this.myEventQueue.pop();
                if (!(fPrioritized2 instanceof WrappedConsumeEvent)) continue;
                queue.put(fPrioritized2);
                com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2 = ((WrappedConsumeEvent)fPrioritized2).event;
            }
            while (queue.size() != 0) {
                this.myEventQueue.put((fPrioritized)queue.pop());
            }
        }
        try {
            if (this.isSubscribed && this.hasSubscribers()) {
                this.myBaseImpl.reconnectSub();
            }
            if (this.hasListeners()) {
                this.myBaseImpl.reconnectListeners();
            }
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            nConstants.logger.error("Failed to reconnect listeners - " + nSessionNotConnectedException2);
            nConstants.logger.debug(nSessionNotConnectedException2);
        }
        catch (Exception exception) {
            nConstants.logger.error(exception);
        }
    }

    public boolean hasListeners() {
        return !this.myConListeners.isEmpty();
    }

    public boolean containsListener(nChannelConnectionListener nChannelConnectionListener2) {
        return this.myConListeners.contains(nChannelConnectionListener2);
    }

    public void addConnectionListener(nChannelConnectionListener nChannelConnectionListener2) {
        this.myConListeners.add(nChannelConnectionListener2);
    }

    public void delConnectionListener(nChannelConnectionListener nChannelConnectionListener2) {
        this.myConListeners.remove(nChannelConnectionListener2);
    }

    public void delAllConnectionListener() {
        this.myConListeners.clear();
    }

    private void callbackListeners(nConnectionUpdate nConnectionUpdate2) {
        if (this.myConListeners.size() != 0) {
            String[] stringArray = new String[]{};
            if (nConnectionUpdate2.getState() == 0) {
                fSubject fSubject2 = nConnectionUpdate2.getSubject();
                stringArray = new String[fSubject2.getPrincipals().size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = ((fPrincipal)fSubject2.getPrincipals().elementAt(i)).toString();
                }
            }
            for (nChannelConnectionListener nChannelConnectionListener2 : this.myConListeners) {
                if (nConnectionUpdate2.getState() == 0) {
                    nChannelConnectionListener2.newConnection(nConnectionUpdate2.getConnectionId(), stringArray, nConnectionUpdate2.getSelector(), nConnectionUpdate2.getProtocol(), nConnectionUpdate2.getName(), nConnectionUpdate2.getJavaVersion(), nConnectionUpdate2.getOSVersion(), nConnectionUpdate2.getOSName(), nConnectionUpdate2.getBuildName(), nConnectionUpdate2.getBuildDate(), nConnectionUpdate2.isMulticastEnabled(), nConnectionUpdate2.requirePriorityConnection());
                    continue;
                }
                nChannelConnectionListener2.delConnection(nConnectionUpdate2.getConnectionId());
            }
        }
    }

    public void push(nConnectionUpdate nConnectionUpdate2) {
        this.addToQueue(nConnectionUpdate2);
    }

    public void push(nPurge nPurge2) {
        if (!this.isSubscribed) {
            return;
        }
        this.addToQueue(nPurge2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(fPrioritized fPrioritized2) {
        fQueue<fPrioritized> fQueue2 = this.myEventQueue;
        synchronized (fQueue2) {
            this.myEventQueue.put(fPrioritized2);
            if (!this.isQueued) {
                this.isQueued = true;
                if (!this.myThreadManager.addTask(this.myTask)) {
                    this.myTask.execute();
                }
            }
        }
    }

    public void push(nPublished nPublished2) {
        com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2 = this.myBaseImpl.convertPublishedToConsumeEvent(nPublished2);
        if (this.myBaseImpl.getTraceLogger().isTraceEnabled()) {
            this.myBaseImpl.getTraceLogger().trace("Publishing response to client. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
        }
        this.push(nConsumeEvent2, nPublished2.getSignature());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2, byte[] byArray) {
        if (!this.isSubscribed) {
            if (this.myBaseImpl.getTraceLogger().isTraceEnabled()) {
                this.myBaseImpl.getTraceLogger().trace("Received event w/o subscription. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
            }
            return;
        }
        if (this.myBaseImpl.getTraceLogger().isTraceEnabled()) {
            this.myBaseImpl.getTraceLogger().trace("Received event on client. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
        }
        ((nConsumeEvent)nConsumeEvent2).setChannel(this.myBaseImpl);
        ((nConsumeEvent)nConsumeEvent2).setDurable(this.myBaseImpl.myDurable);
        if (this.channelSub instanceof nBaseMultiplexer) {
            long l = nConsumeEvent2.getEventID();
            this.pushCallback(nConsumeEvent2, byArray);
            if (!this.isQueue) {
                this.myBaseImpl.myLastEID = l;
            }
            if (this.isSubscribed && this.myBaseImpl.isAutoAck()) {
                try {
                    nConsumeEvent2.ack();
                }
                catch (Exception exception) {}
            }
        } else if (byArray != null) {
            nEventSignaturePair nEventSignaturePair2 = new nEventSignaturePair();
            nEventSignaturePair2.event = nConsumeEvent2;
            nEventSignaturePair2.signature = byArray;
            this.addToQueue(nEventSignaturePair2);
        } else {
            this.checkPriority(nConsumeEvent2);
            this.addToQueue(new WrappedConsumeEvent(nConsumeEvent2));
        }
        nClientChannelList nClientChannelList2 = this;
        synchronized (nClientChannelList2) {
            if (this.myEventQueue.size() == nConstants.getSubHighWater()) {
                this.myBaseImpl.stopFlow();
            }
        }
    }

    private void pushPurgeCallback(nPurge nPurge2) {
        try {
            if (this.channelSub instanceof nBaseMultiplexer && ((nBaseMultiplexer)((Object)this.channelSub)).requestPurge()) {
                ((nBaseMultiplexer)((Object)this.channelSub)).purge(nPurge2.getStartEID(), nPurge2.getEndEID(), nPurge2.getSelector());
            } else if (this.channelSub instanceof nChannelWatcher) {
                ((nChannelWatcher)this.channelSub).purge(nPurge2.getStartEID(), nPurge2.getEndEID(), nPurge2.getSelector());
            } else if (this.myRegisteredEventMgr != null) {
                this.myRegisteredEventMgr.purge(nPurge2);
            }
        }
        catch (Exception exception) {
            nConstants.logger.fatal(exception);
        }
    }

    private void pushCallback(com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2, byte[] byArray) {
        block18: {
            try {
                com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent3 = null;
                if (this.myRegisteredEventMgr != null) {
                    nConsumeEvent3 = this.myRegisteredEventMgr.update(nConsumeEvent2);
                }
                if (byArray == null || this.messageValidator == null) {
                    try {
                        if (this.channelSub != null) {
                            if (this.myBaseImpl.getTraceLogger().isInfoEnabled()) {
                                this.myBaseImpl.getTraceLogger().info("Received event for asynchronous subscriber. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
                            }
                            this.channelSub.go(nConsumeEvent2);
                        } else if (this.myBaseImpl.getTraceLogger().isWarnEnabled()) {
                            this.myBaseImpl.getTraceLogger().warn("Processing event will be dropped as no subscriber set. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {}
                    break block18;
                }
                if (nConsumeEvent3 != null) {
                    nConsumeEvent2 = nConsumeEvent3;
                }
                if (this.channelSub instanceof nSignedEventListener) {
                    try {
                        Object object = nConsumeEvent2.validate(this.messageValidator);
                        ((nSignedEventListener)this.channelSub).go(nConsumeEvent2, object);
                    }
                    catch (Exception exception) {
                        ((nSignedEventListener)this.channelSub).error(nConsumeEvent2, nConsumeEvent2.getSignature(), exception);
                    }
                } else {
                    this.channelSub.go(nConsumeEvent2);
                }
            }
            catch (Throwable throwable) {
                nConstants.logger.fatal(throwable);
            }
        }
        try {
            if (this.myBaseImpl.isAutoAck() && nConsumeEvent2.getEventID() != -2L) {
                nConsumeEvent2.ack();
            }
        }
        catch (Exception exception) {
            nConstants.logger.fatal(exception);
        }
    }

    public boolean isSubscribed() {
        return this.isSubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteSub() {
        if (!this.isSubscribed) {
            return false;
        }
        fQueue<fPrioritized> fQueue2 = this.myEventQueue;
        synchronized (fQueue2) {
            this.channelSub = null;
            this.isSubscribed = false;
            while (this.myEventQueue.size() != 0) {
                fPrioritized fPrioritized2 = this.myEventQueue.pop();
                if (fPrioritized2 instanceof nConsumeEvent) {
                    nConsumeEvent nConsumeEvent2 = (nConsumeEvent)((Object)fPrioritized2);
                    continue;
                }
                if (!(fPrioritized2 instanceof nConnectionUpdate)) continue;
                this.callbackListeners((nConnectionUpdate)fPrioritized2);
            }
        }
        if (this.isSubscribed) {
            this.myBaseImpl.myAutoAck = false;
        }
        return true;
    }

    public synchronized void addSub(nEventListener nEventListener2, nMessageValidator nMessageValidator2) throws nChannelAlreadySubscribedException {
        if (this.channelSub != null) {
            throw new nChannelAlreadySubscribedException();
        }
        this.channelSub = nEventListener2;
        this.messageValidator = nMessageValidator2;
        this.myBaseImpl.myAutoAck = false;
        this.startSubscribers();
    }

    public synchronized void startSubscribers() {
        this.isSubscribed = true;
    }

    public boolean equals(Object object) {
        return this.isMatch(object);
    }

    public int hashCode() {
        return this.myBaseImpl.getBaseChannelAttributes().hashCode();
    }

    public boolean isMatch(Object object) {
        return this.myBaseImpl.getBaseChannelAttributes().isMatch(object);
    }

    @Override
    public boolean lessThan(Object object) {
        return this.myBaseImpl.getBaseChannelAttributes().lessThan(object);
    }

    @Override
    public boolean equals(long l) {
        return this.myBaseImpl.getBaseChannelAttributes().equals(l);
    }

    @Override
    public boolean lessThan(long l) {
        return this.myBaseImpl.getBaseChannelAttributes().lessThan(l);
    }

    public nEventListener getSubscriber() {
        return this.channelSub;
    }

    public nThreadManager getThreadManager() {
        return this.myThreadManager;
    }

    public void setDeleted() {
        this.isDeleted = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    private void checkPriority(com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2) {
        byte by;
        if (nConsumeEvent2.hasAttributes() && ((by = nConsumeEvent2.getAttributes().getPriority()) < 0 || by > 9)) {
            byte by2 = 4;
            if (this.myBaseImpl.getBaseChannelAttributes().getMetaData().containsKey("Priority")) {
                by2 = (byte)this.myBaseImpl.getBaseChannelAttributes().getMetaData().getInt("Priority");
            }
            nConsumeEvent2.getAttributes().setPriority(by2);
        }
    }

    private static final class WrappedConsumeEvent
    implements fPrioritized {
        private final com.pcbsys.nirvana.client.nConsumeEvent event;

        WrappedConsumeEvent(com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2) {
            this.event = nConsumeEvent2;
        }

        @Override
        public final int getPriority() {
            return this.event.getAttributes().getPriority();
        }
    }

    private static class nPushTask
    implements fTask {
        final nClientChannelList myChannel;
        private boolean isClosed = false;

        nPushTask(nClientChannelList nClientChannelList2) {
            this.myChannel = nClientChannelList2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean reQueue() {
            fQueue fQueue2 = this.myChannel.myEventQueue;
            synchronized (fQueue2) {
                if (this.isClosed) {
                    return false;
                }
                this.myChannel.isQueued = this.myChannel.myEventQueue.size() != 0;
                return this.myChannel.isQueued;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Object object) {
            if (object instanceof nConnectionUpdate) {
                this.myChannel.callbackListeners((nConnectionUpdate)object);
                return;
            }
            com.pcbsys.nirvana.client.nConsumeEvent nConsumeEvent2 = null;
            byte[] byArray = null;
            if (object instanceof WrappedConsumeEvent) {
                nConsumeEvent2 = ((WrappedConsumeEvent)object).event;
            } else if (object instanceof nEventSignaturePair) {
                nEventSignaturePair nEventSignaturePair2 = (nEventSignaturePair)object;
                nConsumeEvent2 = nEventSignaturePair2.event;
                byArray = nEventSignaturePair2.signature;
            } else if (object instanceof nPurge) {
                this.myChannel.pushPurgeCallback((nPurge)object);
            }
            if (nConsumeEvent2 != null) {
                this.myChannel.checkPriority(nConsumeEvent2);
                try {
                    this.myChannel.pushCallback(nConsumeEvent2, byArray);
                }
                catch (Throwable throwable) {
                    nConstants.logger.log(throwable);
                }
                long l = nConsumeEvent2.getEventID();
                if (!this.myChannel.isQueue && this.myChannel.isSubscribed) {
                    ((nClientChannelList)this.myChannel).myBaseImpl.myLastEID = l;
                }
                nClientChannelList nClientChannelList2 = this.myChannel;
                synchronized (nClientChannelList2) {
                    if (this.myChannel.myEventQueue.size() == nConstants.getSubLowWater()) {
                        this.myChannel.myBaseImpl.startFlow();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void execute() {
            Object var1_1 = null;
            boolean bl = true;
            while (bl && !this.isClosed) {
                fQueue fQueue2 = this.myChannel.myEventQueue;
                synchronized (fQueue2) {
                    if (this.myChannel.myEventQueue.size() != 0) {
                        var1_1 = this.myChannel.myEventQueue.pop();
                    } else {
                        bl = false;
                    }
                }
                if (var1_1 != null) {
                    this.handleEvent(var1_1);
                } else {
                    bl = false;
                }
                var1_1 = null;
            }
        }

        public void close() {
            this.isClosed = true;
        }
    }

    private static class nEventSignaturePair
    implements fPrioritized {
        public com.pcbsys.nirvana.client.nConsumeEvent event;
        public byte[] signature;

        private nEventSignaturePair() {
        }

        @Override
        public int getPriority() {
            return this.event.getAttributes().getPriority();
        }
    }
}

