/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.io.fConnection;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.logger.fLogging;
import com.pcbsys.foundation.logger.fLoggingFactory;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.nirvana.base.nChannelAttributes;
import java.io.File;

public class nConstants {
    public static final fLogging logger = fLoggingFactory.getLogger(nConstants.class.getPackage().getName());
    public static final String sharedQueueFolder = "namedsubqueues";
    public static final String sIllegalDeadEventHandler = "Cannot mix clustered and non clustered resources for Dead Event Handlers";
    public static final String sIllegalDeadEventHandlerNonExistant = "Could not find dead event handler store that was provided";
    public static final long EXCLUSIVE_SESSION_CHECK = -2L;
    public static final String sRealmSpecific = "/RealmSpecific";
    public static final String sMyStatusChannelName = "/RealmSpecific/NirvanaStatusChannel";
    public static final String sMyTXChannelName = "/RealmSpecific/NirvanaTxChannel";
    public static final String sMyTXClusterChannelName = "/RealmSpecific/NirvanaTxClusterChannel";
    public static final String sDefContextChannelName = "/naming/defaultContext";
    public static final String lockFileName = "RealmServer.lck";
    public static final int DEFAULT_SERVER_WINDOW_SIZE = -1;
    public static final int INFINITE_WINDOW = 0;
    public static final int CHAN_RELIABLE = 1;
    public static final int CHAN_PERSISTENT = 2;
    public static final int CHAN_MIXED = 3;
    public static final int CHAN_SIMPLE = 4;
    public static final int CHAN_TRANSIENT = 5;
    public static final int CHAN_OFF_HEAP = 7;
    public static final int CHAN_PAGED = 8;
    public static final int TRANSIENT_LIKE_TTL = 1;
    public static final String[] CHAN_TYPES = new String[]{"N/A", "Reliable", "Persistent", "Mixed"};
    public static final int CHAN_MODE_NORMAL = 100;
    public static final int CHAN_MODE_QUEUE = 101;
    public static final int DICTIONARY_STAMPING_ENABLED = 1;
    public static final int DICTIONARY_STAMPING_DISABLED = -1;
    public static final int DICTIONARY_STAMPING_DEFAULT = 0;
    public static int DEFAULT_STORE_TTL = 0;
    public static int DEFAULT_STORE_CAPACITY = 0;
    public static final int SERVER_DEFAULT_STORE_EVENTS_PER_SPINDLE = 0;
    public static final boolean SERVER_DEFAULT_STORE_CAPACITY_HONORING = false;
    public static final boolean SERVER_DEFAULT_STORE_AUTO_MAINTANANCE = false;
    public static final int INITIAL_EID = -1;
    public static final int DEFAULT_STORE_PRIVILEGES = -1;
    public static final byte JMS_BASE_MESSAGE_TYPE = 0;
    public static final byte JMS_MAP_MESSAGE_TYPE = 1;
    public static final byte JMS_BYTES_MESSAGE_TYPE = 2;
    public static final byte JMS_OBJECT_MESSAGE_TYPE = 3;
    public static final byte JMS_STREAM_MESSAGE_TYPE = 4;
    public static final byte JMS_TEXT_MESSAGE_TYPE = 5;
    private static long EVENTWAIT = 60000L;
    private static long TXPUBWAIT = 20000L;
    private static long SLEEP = 50L;
    public static final int WAIT_UNTIL_RESPONSE_IS_RECEIVED = -1;
    private static int sMySubLowWater = 1000;
    private static int sMySubHighWater = 3000;
    private static boolean sReconnectAfterAccessRevoked = true;
    private static boolean sReconnectImmediately = false;
    private static long sReconnectInterval = 2000L;
    public static final boolean debug = false;
    static final String ClientAppIDSessionNameSeparator = "~#~";
    public static final boolean sNamedPriorityDebug = fEnvironment.isDebugEnabled("NamedPriority");
    public static final long UNUSED = -1L;

    public static String[] splitClientAppIDAndSessionName(String string) {
        String[] stringArray = string.split(ClientAppIDSessionNameSeparator, 2);
        if (stringArray.length <= 1) {
            return new String[]{"", string};
        }
        return stringArray;
    }

    public static String joinClientAppIDAndSessName(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            return string2;
        }
        return string + ClientAppIDSessionNameSeparator + string2;
    }

    public static long getSLEEP() {
        return SLEEP;
    }

    public static void setSLEEP(long l) {
        SLEEP = l;
    }

    public static long getTXPUBWAIT() {
        return TXPUBWAIT;
    }

    public static void setTXPUBWAIT(long l) {
        TXPUBWAIT = l;
    }

    public static long getEVENTWAIT() {
        return EVENTWAIT;
    }

    public static void setEVENTWAIT(long l) {
        EVENTWAIT = l;
    }

    public static long getReconnectInterval() {
        return sReconnectInterval;
    }

    public static void setReconnectInterval(long l) {
        sReconnectInterval = l;
    }

    public static boolean getReconnectImmediately() {
        return sReconnectImmediately;
    }

    public static void setReconnectImmediately(boolean bl) {
        sReconnectImmediately = bl;
    }

    public static long getKeepAliveInterval() {
        return fConnection.getKeepAlive();
    }

    public static void setKeepAliveInterval(long l) {
        fConnection.setKeepAlive(l);
    }

    public static int getSubLowWater() {
        return sMySubLowWater;
    }

    public static void setSubLowWater(int n) {
        sMySubLowWater = n;
    }

    public static int getConnectionQueueHighWater() {
        return fConnectionSettings.getHWMark();
    }

    public static void setConnectionQueueHighWater(int n) {
        fConnectionSettings.setHWMark(n);
    }

    public static int getConnectionQueueLowWater() {
        return fConnectionSettings.getLWMark();
    }

    public static void setConnectionQueueLowWater(int n) {
        fConnectionSettings.setLWMark(n);
    }

    public static int getConnectionBlockWeighting() {
        return fConnectionSettings.getBlockWeighting();
    }

    public static void setConnectionBlockWeighting(int n) {
        fConnectionSettings.setBlockWeighting(n);
    }

    public static int getSubHighWater() {
        return sMySubHighWater;
    }

    public static void setSubHighWater(int n) {
        sMySubHighWater = n;
    }

    public static void setBlockLimit(int n) {
        fConnectionSettings.setBlockLimit(n);
    }

    public static void setAccessWaitLimit(int n) {
        fConnectionSettings.setAccessWaitLimit(n);
    }

    public static void setPushWaitLimit(int n) {
        fConnectionSettings.setPushWaitLimit(n);
    }

    public static int getPushWaitLimit() {
        return fConnectionSettings.getPushWaitLimit();
    }

    public static int getAccessWaitLimit() {
        return fConnectionSettings.getAccessWaitLimit();
    }

    public static int getBlockLimit() {
        return fConnectionSettings.getBlockLimit();
    }

    public static String validate(String string) throws Exception {
        if (string.contains("\\")) {
            string = string.replace('\\', '/');
        }
        if (string.contains("::")) {
            string = string.replaceAll("::", "/");
        }
        if (string.contains("//")) {
            string = string.replace("//", "/");
        }
        nConstants.checkName(string);
        int n = string.indexOf("/", 1);
        if (n != -1 && string.charAt(0) != '/') {
            string = "/" + string;
        }
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        while (string.indexOf("//") != -1) {
            string = string.substring(0, string.indexOf("//")) + string.substring(string.indexOf("//") + 1);
        }
        if (string.length() > 0 && string.charAt(0) == '/' && string.length() > 1 && string.indexOf("/", 1) == -1) {
            string = string.substring(1);
        }
        return string;
    }

    public static String validateMountPoint(String string) throws Exception {
        if (string.indexOf(32) != -1 || string.indexOf(32) != -1) {
            throw new Exception("Illegal name");
        }
        int n = (string = nConstants.checkName(string.replace('\\', '/'))).indexOf("/", 1);
        if (n != -1 && string.charAt(0) != '/') {
            string = "/" + string;
        }
        if (string.charAt(string.length() - 1) == '/') {
            string = string.substring(0, string.length() - 1);
        }
        while (string.indexOf("//") != -1) {
            string = string.substring(0, string.indexOf("//")) + string.substring(string.indexOf("//") + 1);
        }
        return string;
    }

    private static String checkName(String string) throws Exception {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                throw new Exception("Illegal name : Illegal charater at pos : " + i);
            }
            if (Character.isIdentifierIgnorable(c)) {
                throw new Exception("Illegal name : Illegal charater at pos : " + i);
            }
            if (!Character.isDefined(c)) {
                throw new Exception("Illegal name : Illegal charater at pos : " + i);
            }
            if (Character.isISOControl(c)) {
                throw new Exception("Illegal name : Illegal charater at pos : " + i);
            }
            if (Character.isSpaceChar(c)) {
                throw new Exception("Illegal name : Illegal charater at pos : " + i);
            }
            if (Character.isLetterOrDigit(c) || c == '/' || c == '-' || c == '_' || c == '#') continue;
            throw new Exception("Illegal name : Illegal charater at pos : " + i);
        }
        return string;
    }

    public static boolean isSystemStore(nChannelAttributes nChannelAttributes2) {
        int n = nChannelAttributes2.getName().indexOf(sRealmSpecific.substring(1));
        return n != -1;
    }

    public static boolean isSystemStore(String string) {
        int n = string.indexOf(sRealmSpecific.substring(1));
        return n != -1;
    }

    public static boolean doReconnectAfterACLRevoked() {
        return sReconnectAfterAccessRevoked;
    }

    public static void setReconnectAfterACLRevoked(boolean bl) {
        sReconnectAfterAccessRevoked = bl;
    }

    public static int getInitialConnectionTimeout() {
        return fConnectionSettings.getSocketConnectTimeout();
    }

    public static void setInitialConnectionTimeout(int n) {
        fConnectionSettings.setSocketConnectTimeout(n);
    }

    public static void setPermittedKeepAlivesMissed(int n) {
        fConnectionSettings.sPermittedMissedKeepAlives = n;
    }

    public static File getNewLockFileRef(String string) {
        return new File(string + File.separator + lockFileName);
    }
}

