/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.xmlHelper;
import com.pcbsys.nirvana.base.AckRollbackHelper;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nHeader;
import com.pcbsys.nirvana.base.nIllegalArgumentException;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nQueueReader;
import com.pcbsys.nirvana.client.nQueueTransactionReader;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import org.w3c.dom.Document;

public class nConsumeEvent {
    private static final String CLASS_NAME = nConsumeEvent.class.getSimpleName();
    private static final String sMatrixTag = "com.pcbsys.matrix.conduits.tag";
    private nHeader myHeader = null;
    private long eventID;
    private String eventTag = null;
    private byte[] eventTagBytes = null;
    private byte[] eventData = null;
    private Document dom = null;
    private nEventProperties myProperties = null;
    private boolean isDom = false;
    private long myTTL = 0L;
    private boolean myPersist = true;
    private boolean hasAcked = false;
    private byte[] mySignature = null;
    private boolean isTransient = false;
    private boolean hasCheckedForTag = false;
    private nUnAckedEventManager myUnackedEventManager = null;
    private boolean multicastDelivered;
    private nDurable myDurable = null;
    private boolean isEndOfChannel = true;
    private nChannelImpl myChannel = null;
    private nQueueReader reader;
    private final AckRollbackHelper.HelperAttributes helperAttributes = new AckRollbackHelper.HelperAttributes();
    private final AckRollbackHelper ackRollbackHelper = new AckRollbackHelper();

    public nConsumeEvent(byte[] byArray, byte[] byArray2) {
        this.eventTagBytes = byArray;
        this.eventData = byArray2;
    }

    public nConsumeEvent(String string, byte[] byArray) {
        this(string, byArray, false);
    }

    public nConsumeEvent(String string, byte[] byArray, boolean bl) {
        this.eventTag = string;
        this.eventData = byArray;
        this.isDom = bl;
    }

    public nConsumeEvent(String string, nEventProperties nEventProperties2, byte[] byArray) {
        this.eventTag = string;
        this.eventData = byArray;
        this.myProperties = nEventProperties2;
    }

    public nConsumeEvent(String string, Document document) {
        this.eventTag = string;
        this.dom = document;
        this.isDom = true;
    }

    public nConsumeEvent(nEventProperties nEventProperties2, Document document) {
        this.myProperties = nEventProperties2;
        this.dom = document;
        this.isDom = true;
    }

    public void setHeader(nHeader nHeader2) {
        this.myHeader = nHeader2;
    }

    public nHeader getHeader() {
        return this.myHeader;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public boolean isDom() {
        return this.isDom;
    }

    public nEventProperties getProperties() {
        return this.myProperties;
    }

    public void setProperties(nEventProperties nEventProperties2) {
        this.myProperties = nEventProperties2;
    }

    public Document getDocument() {
        return this.dom;
    }

    public long getEventID() {
        return this.eventID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEventTag() {
        if (this.hasCheckedForTag || this.eventTag != null) {
            return this.eventTag;
        }
        if (this.eventTagBytes != null) {
            this.eventTag = fStringByteConverter.convert(this.eventTagBytes);
            this.hasCheckedForTag = true;
            return this.eventTag;
        }
        nConsumeEvent nConsumeEvent2 = this;
        synchronized (nConsumeEvent2) {
            if (this.getProperties() != null && this.getProperties().getString(sMatrixTag) != null && this.eventTagBytes == null) {
                this.eventTag = this.getProperties().getString(sMatrixTag);
            }
            this.hasCheckedForTag = true;
        }
        return this.eventTag;
    }

    public byte[] getEventData() {
        return this.eventData;
    }

    public long getTTL() {
        return this.myTTL;
    }

    public void setTTL(long l) {
        this.myTTL = l;
    }

    public boolean isPersistant() {
        return this.myPersist;
    }

    public void setPersistant(boolean bl) {
        this.myPersist = bl;
    }

    public void ack(boolean bl, boolean bl2) throws Exception {
        this.ack(0L, bl, bl2);
    }

    public void ack(boolean bl) throws Exception {
        this.ack(0L, bl, true);
    }

    public void ack(long l, boolean bl, boolean bl2) throws Exception {
        if (this.myChannel != null && this.myChannel.getTraceLogger().isTraceEnabled()) {
            this.myChannel.getTraceLogger().trace("nConsumeEvent ack invoked. timeout=" + l + ", isSynchronous=" + bl + ", ackPrevious=" + bl2 + ", nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(this) + "}", CLASS_NAME);
        }
        this.doCommitOrRollback(true, l, bl, bl2);
    }

    public void ack(long l) throws Exception {
        this.ack(l, true, true);
    }

    public void rollback(boolean bl) throws Exception {
        this.rollback(0L, bl, false);
    }

    public void rollback(boolean bl, boolean bl2) throws Exception {
        this.rollback(0L, bl, bl2);
    }

    public void rollback(long l, boolean bl, boolean bl2) throws Exception {
        if (this.myChannel != null && this.myChannel.getTraceLogger().isTraceEnabled()) {
            this.myChannel.getTraceLogger().trace("nConsumeEvent rollback invoked. timeout=" + l + ", isSynchronous=" + bl + ", individualRollback=" + bl2 + ", thisEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(this) + "}", CLASS_NAME);
        }
        this.doCommitOrRollback(false, l, bl, !bl2);
    }

    private long[] getUnAckedEvents(long l, boolean bl) {
        if (this.myUnackedEventManager != null) {
            return this.myUnackedEventManager.getEIDs(l, bl);
        }
        return new long[]{l};
    }

    private void commitAckedEvents(long[] lArray) {
        if (this.myUnackedEventManager != null) {
            this.myUnackedEventManager.commit(lArray);
        }
    }

    private long[] getEventsToRollback(long l, boolean bl) {
        if (this.myUnackedEventManager != null) {
            return this.myUnackedEventManager.getEIDsToRollback(l, bl);
        }
        return new long[]{l};
    }

    private void commitRollBackEvents(long[] lArray) {
        if (this.myUnackedEventManager != null) {
            for (long l : lArray) {
                this.myUnackedEventManager.rollback(l, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommitOrRollback(boolean bl, long l, boolean bl2, boolean bl3) throws nIllegalArgumentException, com.pcbsys.nirvana.client.nIllegalArgumentException, nIllegalStateException, nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        if (this.myChannel == null) {
            return;
        }
        if (this.myChannel.isQueue()) {
            if (this.reader instanceof nQueueTransactionReader) {
                nQueueTransactionReader nQueueTransactionReader2 = (nQueueTransactionReader)((Object)this.reader);
                if (bl) {
                    nQueueTransactionReader2.commit(this.getEventID(), bl3);
                } else {
                    nQueueTransactionReader2.rollback(this.getEventID(), !bl3);
                }
            }
            return;
        }
        if (this.myDurable == null) {
            return;
        }
        boolean bl4 = false;
        long l2 = 0L;
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        if (l == 0L) {
            l = 1L;
        }
        this.helperAttributes.setSynchronous(bl2);
        while (!bl4 && l2 < l) {
            Object object;
            try {
                boolean bl5 = this.myUnackedEventManager != null || this.myUnackedEventManager == null && !bl3;
                this.helperAttributes.setIndividual(bl5);
                if (bl) {
                    if (!this.hasAcked) {
                        object = this.getUnAckedEvents(this.eventID, bl3);
                        if (((Object)object).length == 0) {
                            throw new nIllegalArgumentException("Invalid EID or EID already acked");
                        }
                        this.ackRollbackHelper.sendChannelAck((long[])object, this.helperAttributes);
                        this.hasAcked = true;
                    }
                } else {
                    object = this.getEventsToRollback(this.eventID, bl3);
                    if (((Object)object).length == 0) {
                        throw new nIllegalArgumentException("Invalid EID or EID already rolled back");
                    }
                    this.ackRollbackHelper.sendChannelRollback((long[])object, this.helperAttributes);
                    this.hasAcked = true;
                }
                bl4 = true;
            }
            catch (nRequestTimedOutException | nSessionPausedException nBaseClientException2) {
                if (l == 1L) {
                    throw nBaseClientException2;
                }
                object = this;
                synchronized (object) {
                    try {
                        this.wait(nConstants.getPushWaitLimit());
                        l2 += (long)nConstants.getPushWaitLimit();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (!bl4 && l2 >= l) {
            if (bl) {
                throw new nRequestTimedOutException("Failed to commit eid " + this.eventID + " before timeout " + l);
            }
            throw new nRequestTimedOutException("Failed to rollback eid " + this.eventID + " before timeout " + l);
        }
    }

    public byte[] getSignature() {
        return this.mySignature;
    }

    public boolean isEndOfChannel() {
        return this.isEndOfChannel;
    }

    protected nChannelImpl getChannel() {
        return this.myChannel;
    }

    protected void setChannel(nChannelImpl nChannelImpl2) {
        this.myChannel = nChannelImpl2;
        this.helperAttributes.setChannel(nChannelImpl2);
    }

    protected void setDurable(nDurable nDurable2) {
        this.myDurable = nDurable2;
        this.helperAttributes.setDurable(nDurable2);
    }

    protected void setQueueReader(nQueueReader nQueueReader2) {
        this.reader = nQueueReader2;
    }

    protected long getNamedId() {
        return this.myDurable == null ? -1L : this.myDurable.getID();
    }

    protected void setEndOfChannel(boolean bl) {
        this.isEndOfChannel = bl;
    }

    public void setEventID(long l) {
        this.eventID = l;
    }

    protected void encodeDOM(xmlHelper xmlHelper2) {
        if (!this.isDom() || this.dom == null) {
            return;
        }
        xmlHelper2.setDoc(this.dom);
        this.eventData = xmlHelper2.encode();
        this.dom = null;
    }

    public void setSignature(byte[] byArray) {
        this.mySignature = byArray;
    }

    protected void setUnAckedEventManager(nUnAckedEventManager nUnAckedEventManager2) {
        this.myUnackedEventManager = nUnAckedEventManager2;
        this.helperAttributes.setUnAckedEventManager(nUnAckedEventManager2);
    }

    public boolean isMulticastDelivered() {
        return this.multicastDelivered;
    }

    public void multicastDelivered(boolean bl) {
        this.multicastDelivered = bl;
    }
}

