/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fPrioritized;
import com.pcbsys.foundation.io.fBaseConnection;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fAclEntry;
import com.pcbsys.foundation.security.fAclList;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nStreamStatusUpdate;
import com.pcbsys.nirvana.base.nChannelList;
import com.pcbsys.nirvana.base.nConflation;
import com.pcbsys.nirvana.base.nConnectionArray;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nDataGroupStatus;
import com.pcbsys.nirvana.base.nDataStream;
import com.pcbsys.nirvana.base.nDataStreamArray;
import com.pcbsys.nirvana.base.nMappedStream;
import com.pcbsys.nirvana.base.nMulticastStateListener;
import com.pcbsys.nirvana.base.nSecurityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;

public final class nDataGroup
extends nDataStream
implements fPrioritized {
    private static final transient AtomicLong sAliasCounter = new AtomicLong(0L);
    private static final long sPublishPrivilege = 1L;
    private static final long sOwnerPrivilege = 2L;
    public static final int sConflation = 0;
    public static final int sSnapshot = 1;
    private final transient byte[] myAlias = fStringByteConverter.convert("g" + sAliasCounter.incrementAndGet());
    private fAclList myAcl;
    private final nDataGroupStatus myStatus;
    private final nDataStreamArray myLocalCollectionMap = new nDataStreamArray();
    private final nDataStreamArray myFlatStreamOnlyMap = new nDataStreamArray();
    private final nDataStreamArray mySnoopMap = new nDataStreamArray();
    private final nDataStreamArray myParent = new nDataStreamArray();
    private final nConnectionArray myRegisteredListeners = new nConnectionArray(null, false);
    private final nConnectionArray myStreamDeletedListeners = new nConnectionArray(null, false);
    private boolean isGlobal = false;
    private boolean enableMulticast;
    private boolean mergeEvents;
    private boolean deleteExpiredEvents;
    private boolean isHidden;
    private long myConflationInterval = 0L;
    private long myID = -1L;
    private nPublished[] mySnapshotEvents;
    private nConflation myFanoutObject;
    private nMulticastStateListener myStateListener;
    private int myPriority = 0;

    public nDataGroup() {
        this.myAcl = new fAclList();
        this.myStatus = new nDataGroupStatus(this);
    }

    public nDataGroup(boolean bl) {
        this();
        this.myLocalCollectionMap.setName("default-Local");
        this.myFlatStreamOnlyMap.setName("default-Flat");
        this.mySnoopMap.setName("default-Snoop");
        this.myParent.setName("default-Parent");
        this.isGlobal = bl;
        if (this.isGlobal) {
            this.myID = 0L;
        }
    }

    public nDataGroup(String string, String string2) {
        this();
        this.myName = string;
        this.myLocalCollectionMap.setName(this.myName + "-Local");
        this.myFlatStreamOnlyMap.setName(this.myName + "-Flat");
        this.mySnoopMap.setName(this.myName + "-Snoop");
        this.myParent.setName(this.myName + "-Parent");
        this.mySubject = string2;
        this.isGlobal = string.equals("*");
        if (this.isGlobal) {
            this.myID = 0L;
        } else {
            CRC32 cRC32 = new CRC32();
            cRC32.update(fStringByteConverter.convert(string));
            this.myID = cRC32.getValue();
            if (this.myStatus != null) {
                this.myStatus.setUniqueID(this.myID);
            }
        }
    }

    public synchronized nDataGroup getClone() {
        return this;
    }

    @Override
    public void close() {
        if (this.myStateListener != null) {
            this.myStateListener.resourceDeleted();
        }
        this.myLocalCollectionMap.clear();
        this.mySnoopMap.clear();
        this.myAcl.clear();
        this.myRegisteredListeners.clear();
        super.close();
        this.myFlatStreamOnlyMap.clear();
        if (this.mySnapshotEvents != null) {
            this.mySnapshotEvents[0] = null;
            this.mySnapshotEvents[1] = null;
        }
    }

    public int compareTo(nDataGroup nDataGroup2) {
        if (this.myName.compareTo(nDataGroup2.getName()) != 0 || this.myConflationInterval != nDataGroup2.myConflationInterval || this.enableMulticast != nDataGroup2.enableMulticast || this.deleteExpiredEvents != nDataGroup2.deleteExpiredEvents || this.mergeEvents != nDataGroup2.mergeEvents || this.isGlobal != nDataGroup2.isGlobal) {
            return 1;
        }
        return 0;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public byte[] getAlias() {
        return this.myAlias;
    }

    public void setParent(nDataGroup nDataGroup2) {
        this.myParent.add(nDataGroup2);
    }

    public void removeParent(nDataGroup nDataGroup2) {
        this.myParent.remove(nDataGroup2.getName());
    }

    public nDataStream[] getParent() {
        return this.myParent.getArray();
    }

    public nConflation getConflationEngine() {
        return this.myFanoutObject;
    }

    public void setConflationEngine(nConflation nConflation2) {
        this.myFanoutObject = nConflation2;
    }

    public long getID() {
        return this.myID;
    }

    public void setLastEid(long l) {
        this.myStatus.setLastEid(l);
    }

    public void updateACL(nDataGroup nDataGroup2) {
        this.myAcl = nDataGroup2.myAcl.getClone();
    }

    public boolean isEnableMulticast() {
        return this.enableMulticast;
    }

    public void setEnableMulticast(boolean bl) {
        this.enableMulticast = bl;
    }

    public boolean isDeleteExpiredEvents() {
        return this.deleteExpiredEvents;
    }

    public void setDeleteExpiredEvents(boolean bl) {
        this.deleteExpiredEvents = bl;
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    public void setPriority(int n) {
        this.myPriority = n;
    }

    public long getConflationInterval() {
        return this.myConflationInterval;
    }

    public void setConflationInterval(long l) {
        this.myConflationInterval = l;
    }

    public boolean isMergeEvents() {
        return this.mergeEvents;
    }

    public void setMergeEvents(boolean bl) {
        this.mergeEvents = bl;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public final nDataGroupStatus getStatus(boolean bl) {
        if (this.myStatus.hasChanged() || bl) {
            return this.myStatus;
        }
        return null;
    }

    public void incrementStreamCount() {
        this.myStatus.incrementConnectionCount();
    }

    public void decrementStreamCount() {
        this.myStatus.setChanged(true);
    }

    public final void incrementPublishedCount(int n) {
        nChannelList.incrementTotalEventsPublished(n);
        this.myStatus.incrementPublishCount(n);
    }

    public final void incrementSubscribedCount(int n) {
        this.myStatus.incrementSubscribedCount(n);
    }

    public int totalChildren() {
        int n = this.myLocalCollectionMap.size();
        Iterator<nDataStream> iterator = this.myLocalCollectionMap.iterator();
        while (iterator.hasNext()) {
            nDataStream nDataStream2 = iterator.next();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            if (!(nDataStream2 instanceof nDataGroup)) continue;
            n += ((nDataGroup)nDataStream2).totalChildren();
        }
        return n;
    }

    public int children() {
        return this.myLocalCollectionMap.size();
    }

    public int getTotalStreams() {
        return this.myLocalCollectionMap.size() + this.mySnoopMap.size();
    }

    public void registerStateListener(nMulticastStateListener nMulticastStateListener2) {
        this.myStateListener = nMulticastStateListener2;
    }

    public void addListener(fBaseConnection fBaseConnection2) {
        if (nConstants.logger.isTraceEnabled()) {
            nConstants.logger.trace("DataGroup> Adding con " + fBaseConnection2.getID() + " to myRegisteredListeners for data group : " + this.getName());
        }
        this.myRegisteredListeners.put(fBaseConnection2);
    }

    public void addStreamDeletedListener(fBaseConnection fBaseConnection2) {
        if (nConstants.logger.isTraceEnabled()) {
            nConstants.logger.trace("DataGroup> Adding con " + fBaseConnection2.getID() + " to myStreamDeletedListeners for data group : " + this.getName());
        }
        this.myStreamDeletedListeners.put(fBaseConnection2);
    }

    public void delListener(fBaseConnection fBaseConnection2) {
        if (this.myRegisteredListeners.size() > 0 && this.myRegisteredListeners.contains(fBaseConnection2)) {
            if (nConstants.logger.isTraceEnabled()) {
                nConstants.logger.trace("DataGroup> Removing con " + fBaseConnection2.getID() + " from myRegisteredListeners for data group : " + this.getName());
            }
            this.myRegisteredListeners.remove(fBaseConnection2);
        }
        if (this.myStreamDeletedListeners.size() > 0 && this.myStreamDeletedListeners.contains(fBaseConnection2)) {
            if (nConstants.logger.isTraceEnabled()) {
                nConstants.logger.trace("DataGroup> Removing con " + fBaseConnection2.getID() + " from myStreamDeletedListeners for data group : " + this.getName());
            }
            this.myStreamDeletedListeners.remove(fBaseConnection2);
        }
    }

    public fBaseConnection[] getListeners() {
        return this.myRegisteredListeners.getArray();
    }

    public boolean containsListener(String string) {
        return this.myRegisteredListeners != null && this.myRegisteredListeners.contains(string);
    }

    public void removeStreamDeletedListener(fBaseConnection fBaseConnection2) {
        this.myStreamDeletedListeners.remove(fBaseConnection2);
    }

    public nPublished getSnapshotEvent(int n) {
        if (this.mySnapshotEvents != null && n < this.mySnapshotEvents.length) {
            return this.mySnapshotEvents[n];
        }
        return null;
    }

    public synchronized void replaceSnapshotEvent(int n, nPublished nPublished2) {
        if (this.mySnapshotEvents == null) {
            this.mySnapshotEvents = new nPublished[2];
        }
        if (n < this.mySnapshotEvents.length) {
            this.mySnapshotEvents[n] = nPublished2;
            if (this.mySnapshotEvents[n].getChannelAttributesId() <= 0L) {
                this.mySnapshotEvents[n].setChannelAttributesId(this.getID());
                this.mySnapshotEvents[n].setResourceAlias(this.getAlias());
            }
        }
    }

    public synchronized boolean hasEvents() {
        nMappedStream[] nMappedStreamArray;
        if (this.mySnapshotEvents != null && (this.mySnapshotEvents[0] != null || this.mySnapshotEvents[1] != null)) {
            return true;
        }
        for (nMappedStream nMappedStream2 : nMappedStreamArray = this.myParent.getArray()) {
            nDataStream nDataStream2 = nMappedStream2.getStream();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            if (!((nDataGroup)nDataStream2).hasEvents()) continue;
            return true;
        }
        return false;
    }

    public synchronized nPublished[] getEvents() {
        nMappedStream[] nMappedStreamArray;
        ArrayList<nPublished> arrayList = new ArrayList<nPublished>();
        nMappedStream[] nMappedStreamArray2 = nMappedStreamArray = this.myParent.getArray();
        int n = nMappedStreamArray2.length;
        for (int i = 0; i < n; ++i) {
            nMappedStream nMappedStream2 = nMappedStreamArray2[i];
            nDataStream nDataStream2 = nMappedStream2.getStream();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            nPublished[] nPublishedArray = ((nDataGroup)nDataStream2).getEvents();
            Collections.addAll(arrayList, nPublishedArray);
        }
        if (this.mySnapshotEvents != null) {
            boolean bl = this.mySnapshotEvents[0] != null;
            int n2 = n = this.mySnapshotEvents[1] != null ? 1 : 0;
            if (bl) {
                nPublished nPublished2 = this.mySnapshotEvents[0];
                nPublished2.setId(10);
                arrayList.add(nPublished2);
            }
            if (n != 0) {
                nPublished nPublished3 = this.mySnapshotEvents[1];
                nPublished3.setId(10);
                arrayList.add(nPublished3);
            }
        }
        return arrayList.toArray(new nPublished[arrayList.size()]);
    }

    protected void addToParent(nDataStream nDataStream2) {
        nMappedStream[] nMappedStreamArray;
        nDataStream nDataStream3 = nDataStream2;
        if (nDataStream2 instanceof nMappedStream) {
            nDataStream3 = ((nMappedStream)nDataStream2).getStream();
        }
        if (nDataStream3 instanceof nDataGroup) {
            this.myFlatStreamOnlyMap.add(((nDataGroup)nDataStream3).getAllStreams());
        } else {
            this.myFlatStreamOnlyMap.add(nDataStream2);
        }
        for (nMappedStream nMappedStream2 : nMappedStreamArray = this.myParent.getArray()) {
            ((nDataGroup)nMappedStream2.getStream()).addToParent(nDataStream2);
        }
    }

    private boolean isParentOf(nDataGroup nDataGroup2) {
        Iterator<nDataStream> iterator = nDataGroup2.myParent.iterator();
        while (iterator.hasNext()) {
            nDataGroup nDataGroup3;
            nDataStream nDataStream2 = iterator.next();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            if (!(nDataGroup3 = (nDataGroup)nDataStream2).equals(this) && !this.isParentOf(nDataGroup3)) continue;
            return true;
        }
        return false;
    }

    protected void removeFromParent(nDataStream nDataStream2) {
        nMappedStream[] nMappedStreamArray;
        this.myFlatStreamOnlyMap.remove(nDataStream2.getName());
        for (nMappedStream nMappedStream2 : nMappedStreamArray = this.myParent.getArray()) {
            ((nDataGroup)nMappedStream2.getStream()).removeFromParent(nDataStream2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addStream(nDataStream nDataStream2) throws Exception {
        nMappedStream[] nMappedStreamArray;
        if (nDataStream2 == this) {
            throw new nSecurityException("Can not add data group to itself");
        }
        nDataStream nDataStream3 = nDataStream2;
        if (nDataStream2 instanceof nMappedStream) {
            nDataStream3 = ((nMappedStream)nDataStream2).getStream();
        }
        if (nDataStream3 instanceof nDataGroup) {
            void nDataStream5;
            nDataStream[] nDataStreamArray2;
            nMappedStreamArray = (nMappedStream[])nDataStream3;
            if (nMappedStreamArray.isParentOf(this)) {
                throw new nSecurityException("Cannot add a parent data group to a child data group");
            }
            nDataStream[] nDataStreamArray3 = nDataStreamArray2 = nMappedStreamArray.getAllStreams();
            int n = nDataStreamArray3.length;
            boolean i = false;
            while (nDataStream5 < n) {
                nDataStream nDataStream4 = nDataStreamArray3[nDataStream5];
                if (nDataStream4 instanceof nDataGroup) {
                    this.addStream(nDataStream4);
                } else {
                    this.myFlatStreamOnlyMap.add(nDataStream4);
                }
                ++nDataStream5;
            }
            nMappedStreamArray.setParent(this);
        } else {
            this.myFlatStreamOnlyMap.add(nDataStream2);
        }
        if (nDataStream2.getName().length() > 0 && nDataStream2.getSubject().length() > 0 && this.myLocalCollectionMap.add(nDataStream2)) {
            nDataStream2.incrementUsage();
            this.incrementUsage();
            if (this.myStateListener != null) {
                this.myStateListener.addClient(nDataStream2, nDataStream2.getUserObject());
            }
            nMappedStreamArray = this.myParent.getArray();
            for (nDataStream nDataStream5 : nMappedStreamArray) {
                ((nDataGroup)((nMappedStream)nDataStream5).getStream()).addToParent(nDataStream2);
            }
        }
    }

    public void addSnoopStream(nDataStream nDataStream2) throws Exception {
        if (nDataStream2 == this) {
            throw new nSecurityException("Can not add data group to itself");
        }
        nDataStream nDataStream3 = nDataStream2;
        if (nDataStream2 instanceof nMappedStream) {
            nDataStream3 = ((nMappedStream)nDataStream2).getStream();
        }
        if (nDataStream3 instanceof nDataGroup && ((nDataGroup)nDataStream3).mySnoopMap.contains(this.getName())) {
            throw new nSecurityException("Cannot add a parent data group to a child data group");
        }
        if (this.mySnoopMap.add(nDataStream2)) {
            this.myFlatStreamOnlyMap.add(nDataStream2);
            nDataStream2.incrementUsage();
            this.incrementUsage();
            if (this.myStateListener != null) {
                this.myStateListener.addClient(nDataStream2, nDataStream2.getUserObject());
            }
        }
    }

    public nDataStream delStream(String string) {
        nDataStream nDataStream2 = this.myLocalCollectionMap.remove(string);
        nDataStream nDataStream3 = this.myFlatStreamOnlyMap.remove(string);
        if (nDataStream2 == null) {
            nDataStream2 = nDataStream3;
        }
        if (nDataStream2 != null) {
            nMappedStream[] nMappedStreamArray;
            nDataStream nDataStream4 = nDataStream2;
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream4 = ((nMappedStream)nDataStream2).getStream();
            }
            if (nDataStream4 instanceof nDataGroup) {
                this.myFlatStreamOnlyMap.del(((nDataGroup)nDataStream4).getAllStreams());
                ((nDataGroup)nDataStream4).removeParent(this);
            }
            for (nMappedStream nMappedStream2 : nMappedStreamArray = this.myParent.getArray()) {
                ((nDataGroup)nMappedStream2.getStream()).removeFromParent(nDataStream2);
            }
            this.decrementUsage();
            nDataStream2.decrementUsage();
            if (this.myStateListener != null) {
                this.myStateListener.delClient(nDataStream2.getUserObject());
            }
        }
        return nDataStream2;
    }

    public nDataStream delSnoopStream(String string) {
        nDataStream nDataStream2 = this.mySnoopMap.remove(string);
        if (nDataStream2 != null && this.myFlatStreamOnlyMap.del(nDataStream2)) {
            nDataStream2.decrementUsage();
            this.decrementUsage();
        }
        return nDataStream2;
    }

    public void streamDeleted(nStreamStatusUpdate nStreamStatusUpdate2) {
        fBaseConnection[] fBaseConnectionArray;
        for (fBaseConnection fBaseConnection2 : fBaseConnectionArray = this.myStreamDeletedListeners.getArray()) {
            try {
                if (fBaseConnection2 == null) continue;
                if (fBaseConnection2.isAlive()) {
                    fBaseConnection2.write(nStreamStatusUpdate2);
                    continue;
                }
                this.myStreamDeletedListeners.remove(fBaseConnection2);
            }
            catch (Exception exception) {
                nConstants.logger.warn(exception);
            }
        }
    }

    public void replaceDataGroupStructure(nDataGroup nDataGroup2) {
        if (this.myLocalCollectionMap.remove(nDataGroup2.getName()) != null) {
            this.myLocalCollectionMap.add(nDataGroup2);
        }
        if (this.myParent.contains(nDataGroup2.getName())) {
            this.myParent.remove(nDataGroup2.getName());
            this.myParent.add(nDataGroup2);
        }
        if (this.mySnoopMap.contains(nDataGroup2.getName())) {
            this.mySnoopMap.remove(nDataGroup2.getName());
            this.mySnoopMap.add(nDataGroup2);
        }
    }

    public void replaceStream(nDataStream nDataStream2) {
        if (this.myLocalCollectionMap.remove(nDataStream2.getName()) != null) {
            this.myLocalCollectionMap.add(nDataStream2);
        }
        if (this.myFlatStreamOnlyMap.remove(nDataStream2.getName()) != null) {
            this.myFlatStreamOnlyMap.add(nDataStream2);
        }
    }

    public boolean containsPublisher(fSubject fSubject2) {
        return this.contains(fSubject2, 1L);
    }

    public boolean containsOwner(fSubject fSubject2) {
        return this.contains(fSubject2, 2L);
    }

    public void addPublisher(fSubject fSubject2) throws Exception {
        this.addPrivilige(fSubject2, 1L);
    }

    public void addOwner(fSubject fSubject2) throws Exception {
        this.addPrivilige(fSubject2, 2L);
    }

    public fSubject delPublisher(String string) {
        return this.delPrivilige(new fSubject(string), 1L);
    }

    private boolean contains(fSubject fSubject2, long l) {
        fAclEntry fAclEntry2 = this.myAcl.find(fSubject2);
        if (fAclEntry2 == null) {
            fAclEntry2 = this.myAcl.lookup(fSubject2);
        }
        return fAclEntry2 != null && (fAclEntry2.getPriv() & l) != 0L;
    }

    private synchronized fSubject addPrivilige(fSubject fSubject2, long l) {
        fAclEntry fAclEntry2 = this.myAcl.get(fSubject2);
        if (fAclEntry2 == null) {
            fAclEntry2 = new fAclEntry(fSubject2, l);
            this.myAcl.add(fAclEntry2);
        } else if ((fAclEntry2.getPriv() & l) == 0L) {
            fAclEntry2.setPriv(fAclEntry2.getPriv() + l);
        }
        return fAclEntry2.getSubject();
    }

    private synchronized fSubject delPrivilige(fSubject fSubject2, long l) {
        fAclEntry fAclEntry2 = this.myAcl.get(fSubject2);
        if (fAclEntry2 != null) {
            if ((fAclEntry2.getPriv() & l) != 0L) {
                fAclEntry2.setPriv(fAclEntry2.getPriv() - l);
            }
            if (fAclEntry2.getPriv() == 0L) {
                this.myAcl.remove(fAclEntry2);
            }
            return fAclEntry2.getSubject();
        }
        return null;
    }

    public nDataStream get(String string) {
        return this.myLocalCollectionMap.find(string);
    }

    public nDataStream getSnoop(String string) {
        return this.mySnoopMap.find(string);
    }

    public Iterator<nDataStream> values() {
        return this.myLocalCollectionMap.iterator();
    }

    public Iterator<nDataStream> snoopValues() {
        return this.mySnoopMap.iterator();
    }

    public nDataStream[] getAllStreams() {
        return this.myFlatStreamOnlyMap.getArray();
    }

    public int getAllStreamsLength() {
        return this.myFlatStreamOnlyMap.size();
    }

    public nDataStream[] getStreams() {
        return this.myLocalCollectionMap.getArray();
    }

    public void writeStructureExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        super.writeExternal(fEventOutputStream2);
        fEventOutputStream2.writeLong(this.myID);
        ArrayList<nDataGroup> arrayList = new ArrayList<nDataGroup>();
        nMappedStream[] nMappedStreamArray = this.myLocalCollectionMap.getArray();
        for (nMappedStream nMappedStream2 : nMappedStreamArray) {
            if (!(nMappedStream2.getStream() instanceof nDataGroup)) continue;
            arrayList.add((nDataGroup)nMappedStream2.getStream());
        }
        fEventOutputStream2.writeInt(arrayList.size());
        for (nDataGroup nDataGroup2 : arrayList) {
            nDataGroup2.writeStructureExternal(fEventOutputStream2);
        }
        long l = 0L;
        if (this.mergeEvents) {
            l = 1L;
        }
        if (this.enableMulticast) {
            l += 2L;
        }
        if (this.deleteExpiredEvents) {
            l += 4L;
        }
        if (this.isHidden) {
            l += 8L;
        }
        fEventOutputStream2.writeLong(l += (long)(this.myPriority << 4));
        fEventOutputStream2.writeLong(this.myConflationInterval);
        this.myAcl.writeExternal(fEventOutputStream2);
    }

    public void readStructureExternal(fEventInputStream fEventInputStream2) throws IOException {
        super.readExternal(fEventInputStream2);
        this.myID = fEventInputStream2.readLong();
        if (this.myStatus != null) {
            this.myStatus.setUniqueID(this.myID);
        }
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            nDataGroup nDataGroup2 = new nDataGroup();
            nDataGroup2.readStructureExternal(fEventInputStream2);
            try {
                this.addStream(nDataGroup2);
                continue;
            }
            catch (Exception exception) {
                nConstants.logger.warn(exception);
            }
        }
        long l = fEventInputStream2.readLong();
        this.mergeEvents = (l & 1L) != 0L;
        this.enableMulticast = (l & 2L) != 0L;
        this.deleteExpiredEvents = (l & 4L) != 0L;
        this.isHidden = (l & 8L) != 0L;
        this.myPriority = (int)(l >> 4 & 0xFL);
        if (this.myPriority == 0) {
            this.myPriority = 4;
        }
        this.myConflationInterval = fEventInputStream2.readLong();
        this.myAcl.readExternal(fEventInputStream2);
        if (this.isGlobal) {
            this.myID = 0L;
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        super.writeExternal(fEventOutputStream2);
        fEventOutputStream2.writeLong(this.myID);
        fEventOutputStream2.writeInt(this.myLocalCollectionMap.size() + this.mySnoopMap.size());
        this.myLocalCollectionMap.writeExternal(fEventOutputStream2);
        this.mySnoopMap.writeExternal(fEventOutputStream2);
        byte by = 0;
        if (this.mergeEvents) {
            by = 1;
        }
        if (this.enableMulticast) {
            by = (byte)(by + 2);
        }
        if (this.deleteExpiredEvents) {
            by = (byte)(by + 4);
        }
        if (this.isHidden) {
            by = (byte)(by + 8);
        }
        by = (byte)(by + (this.myPriority << 4));
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeLong(this.myConflationInterval);
        this.myAcl.writeExternal(fEventOutputStream2);
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        super.readExternal(fEventInputStream2);
        this.myID = fEventInputStream2.readLong();
        if (this.myStatus != null) {
            this.myStatus.setUniqueID(this.myID);
        }
        int n2 = fEventInputStream2.readInt();
        for (n = 0; n < n2; ++n) {
            boolean bl = fEventInputStream2.readBoolean();
            nDataStream nDataStream2 = bl ? new nDataGroup() : new nDataStream();
            nDataStream2.readExternal(fEventInputStream2);
            try {
                if (nDataStream2.isSnoop() || nDataStream2.isAdmin()) {
                    this.addSnoopStream(nDataStream2);
                    continue;
                }
                this.addStream(nDataStream2);
                continue;
            }
            catch (Exception exception) {
                nConstants.logger.warn(exception);
            }
        }
        n = fEventInputStream2.readByte();
        this.mergeEvents = (n & 1) != 0;
        this.enableMulticast = (n & 2) != 0;
        this.deleteExpiredEvents = (n & 4) != 0;
        this.isHidden = (n & 8) != 0;
        this.myConflationInterval = fEventInputStream2.readLong();
        this.myPriority = n >>> 4 & 0xF;
        this.myAcl.readExternal(fEventInputStream2);
        if (this.isGlobal) {
            this.myID = 0L;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.dump(stringBuffer);
        return stringBuffer.toString();
    }

    private void dump(StringBuffer stringBuffer) {
        this.dump(stringBuffer, this.getName());
    }

    private void dump(StringBuffer stringBuffer, String string) {
        nDataStream nDataStream2;
        Iterator<nDataStream> iterator = this.myLocalCollectionMap.iterator();
        while (iterator.hasNext()) {
            nDataStream2 = iterator.next();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            if (nDataStream2 instanceof nDataGroup) {
                stringBuffer.append(string).append(".").append(nDataStream2.getName()).append("\n");
                ((nDataGroup)nDataStream2).dump(stringBuffer, string + "." + nDataStream2.getName());
                continue;
            }
            stringBuffer.append(string).append(".").append(nDataStream2.getName()).append("\n");
        }
        iterator = this.mySnoopMap.iterator();
        while (iterator.hasNext()) {
            nDataStream2 = iterator.next();
            if (nDataStream2 instanceof nMappedStream) {
                nDataStream2 = ((nMappedStream)nDataStream2).getStream();
            }
            if (nDataStream2 instanceof nDataGroup) {
                stringBuffer.append(string).append(".").append(nDataStream2.getName()).append("\n");
                ((nDataGroup)nDataStream2).dump(stringBuffer, string + "." + nDataStream2.getName());
                continue;
            }
            stringBuffer.append(string).append(".").append(nDataStream2.getName()).append("\n");
        }
    }
}

