/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.collections.Queue;
import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nMulticastEventCallback;
import com.pcbsys.nirvana.base.nThreadManager;

public class nDataGroupEventPump
implements fTask {
    private static int sMaxQueueSize = nConstants.getConnectionQueueHighWater();
    private final nThreadManager myThreadManager;
    private final Queue<nEvent> myQueue;
    private final nMulticastEventCallback myCallback;
    private boolean queued;
    private boolean blocked;
    private boolean pause;
    private boolean isClosed;

    public nDataGroupEventPump(nThreadManager nThreadManager2, nMulticastEventCallback nMulticastEventCallback2) {
        this.myThreadManager = nThreadManager2;
        this.myCallback = nMulticastEventCallback2;
        this.myQueue = new Queue();
        this.queued = false;
        this.pause = false;
        this.blocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            this.isClosed = true;
            while (this.myQueue.size() > 0) {
                this.myQueue.pop();
            }
        }
    }

    public int size() {
        return this.myQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(nEvent nEvent2) {
        boolean bl;
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            if (this.isClosed) {
                return;
            }
            this.myQueue.put(nEvent2);
            if (!this.queued && !this.pause) {
                this.queued = this.myThreadManager.addTask(this);
            }
            bl = this.queued;
        }
        if (!this.pause && !bl) {
            this.execute();
        } else if (this.myQueue.size() > sMaxQueueSize) {
            queue = this.myQueue;
            synchronized (queue) {
                while (this.myQueue.size() > sMaxQueueSize) {
                    this.blocked = true;
                    try {
                        this.myQueue.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.blocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute() {
        nEvent nEvent2;
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            if (this.isClosed) {
                return;
            }
            nEvent2 = this.myQueue.pop();
        }
        if (nEvent2 != null) {
            this.myCallback.execute(nEvent2);
        }
        if (this.myQueue.size() < sMaxQueueSize / 2 && this.blocked) {
            queue = this.myQueue;
            synchronized (queue) {
                this.myQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reQueue() {
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            if (this.isClosed) {
                return false;
            }
            this.queued = this.myQueue.size() != 0 && !this.pause;
            return this.queued;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        boolean bl;
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            this.pause = false;
            if (this.isClosed) {
                return;
            }
            if (!this.queued && this.myQueue.size() != 0) {
                this.queued = this.myThreadManager.addTask(this);
            }
            bl = this.queued;
        }
        if (!bl) {
            this.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Queue<nEvent> queue = this.myQueue;
        synchronized (queue) {
            this.pause = true;
        }
    }

    public boolean isPaused() {
        return this.pause;
    }
}

