/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nSecurity;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannelAlreadyExistsException;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nDuplicateJoinException;
import com.pcbsys.nirvana.client.nExceededLimitException;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nNameAlreadyBoundException;
import com.pcbsys.nirvana.client.nNameDoesNotExistException;
import com.pcbsys.nirvana.client.nNameSpaceConflictException;
import com.pcbsys.nirvana.client.nPublishPausedException;
import com.pcbsys.nirvana.client.nRealmAlreadyBoundException;
import com.pcbsys.nirvana.client.nRealmInUseException;
import com.pcbsys.nirvana.client.nRealmNotFoundException;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nTransactionNoSuchTXIDException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import com.pcbsys.nirvana.client.nUnknownRemoteRealmException;
import com.pcbsys.nirvana.client.nUserNotSubscribedException;
import com.pcbsys.nirvana.client.nWindowSizeExceededException;

public class nExceptionEventProcessor {
    public static void checkCommonExceptions(nEvent nEvent2) throws nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nChannelNotFoundException, nSecurityException {
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        nExceptionEventProcessor.checkSessionPausedException(nEvent2);
        nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
        nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
    }

    public static void checkSecurityException(nEvent nEvent2) throws nSecurityException {
        if (nEvent2 != null) {
            nExceptionEvent nExceptionEvent2;
            if (nEvent2.getId() == 40) {
                nExceptionEventProcessor.checkIfExceptionIsCommitOrRollBackOfEvents(nEvent2);
            } else if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 25) {
                throw new nSecurityException(nExceptionEvent2.getMessage());
            }
        }
        nExceptionEventProcessor.checkPermissionsException(nEvent2);
        nExceptionEventProcessor.checkClusterNotReady(nEvent2);
    }

    public static void checkIfExceptionIsCommitOrRollBackOfEvents(nEvent nEvent2) throws nSecurityException {
        if (((nSecurity)nEvent2).getMessage().contains("Need to commit/rollback outstanding events ID") || ((nSecurity)nEvent2).getMessage().contains("Need to acknowledge/rollback outstanding events ID")) {
            throw new nWindowSizeExceededException(((nSecurity)nEvent2).getMessage());
        }
        throw new nSecurityException(((nSecurity)nEvent2).getMessage());
    }

    public static void checkUnexpectedExceptionEvent(nEvent nEvent2, String string) throws nUnexpectedResponseException {
        if (nEvent2 != null) {
            if (nEvent2.getId() == 75) {
                nBaseClientException nBaseClientException2 = nExceptionFactory.getException(((nExceptionEvent)nEvent2).getExceptionId(), ((nExceptionEvent)nEvent2).getMessage());
                throw new nUnexpectedResponseException(string, nBaseClientException2);
            }
            throw new nUnexpectedResponseException(string);
        }
    }

    public static void checkUnexpectedExceptionEventAppendOrtoString(nEvent nEvent2, String string) throws nUnexpectedResponseException {
        if (nEvent2 != null && nEvent2.getId() == 75) {
            nBaseClientException nBaseClientException2 = nExceptionFactory.getException(((nExceptionEvent)nEvent2).getExceptionId(), ((nExceptionEvent)nEvent2).getMessage());
            throw new nUnexpectedResponseException(string + nBaseClientException2.getMessage(), nBaseClientException2);
        }
        throw new nUnexpectedResponseException(string + (nEvent2 != null ? nEvent2.toString() : ""));
    }

    public static void checkChannelNotFound(nEvent nEvent2) throws nChannelNotFoundException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && (nEvent2.getId() == 75 || nEvent2.getId() == 114) && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 0) {
            throw new nChannelNotFoundException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkUnknownRemoteRealm(nEvent nEvent2) throws nUnknownRemoteRealmException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 1) {
            throw new nUnknownRemoteRealmException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkChannelAlreadyExists(nEvent nEvent2) throws nChannelAlreadyExistsException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 2) {
            throw new nChannelAlreadyExistsException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkRealmAlreadyBound(nEvent nEvent2) throws nRealmAlreadyBoundException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 3) {
            throw new nRealmAlreadyBoundException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkRealmUnreachable(nEvent nEvent2) throws nRealmUnreachableException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 4) {
            throw new nRealmUnreachableException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkRealmNotFound(nEvent nEvent2) throws nRealmNotFoundException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 5) {
            throw new nRealmNotFoundException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkChannelAlreadySubscribed(nEvent nEvent2) throws nChannelAlreadySubscribedException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 6) {
            throw new nChannelAlreadySubscribedException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkSelectorParser(nEvent nEvent2) throws nSelectorParserException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 7) {
            throw new nSelectorParserException(nExceptionEvent2.getMessage());
        }
    }

    static void checkUserNotSubscribed(nEvent nEvent2) throws nUserNotSubscribedException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 8) {
            throw new nUserNotSubscribedException(nExceptionEvent2.getMessage());
        }
    }

    static void checkExceededLimit(nEvent nEvent2) throws nExceededLimitException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 9) {
            throw new nExceededLimitException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkTransactionNoSuchTXID(nEvent nEvent2) throws nTransactionNoSuchTXIDException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 10) {
            throw new nTransactionNoSuchTXIDException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkNameSpaceConflictThrowIllegal(nEvent nEvent2) throws nIllegalArgumentException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 11) {
            nNameSpaceConflictException nNameSpaceConflictException2 = new nNameSpaceConflictException(nExceptionEvent2.getMessage());
            throw new nIllegalArgumentException(nNameSpaceConflictException2.toString(), nNameSpaceConflictException2);
        }
    }

    public static void checkNameSpaceConflict(nEvent nEvent2) throws nNameSpaceConflictException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 11) {
            throw new nNameSpaceConflictException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkDuplicateJoin(nEvent nEvent2) throws nDuplicateJoinException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 12) {
            throw new nDuplicateJoinException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkNameAlreadyBound(nEvent nEvent2) throws nNameAlreadyBoundException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 13) {
            throw new nNameAlreadyBoundException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkNameDoesNotExist(nEvent nEvent2) throws nNameDoesNotExistException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 14) {
            throw new nNameDoesNotExistException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkRealmInUse(nEvent nEvent2) throws nRealmInUseException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 16) {
            throw new nRealmInUseException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkIllegalArgument(nEvent nEvent2) throws nIllegalArgumentException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 22) {
            throw new nIllegalArgumentException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkPublishPausedException(nEvent nEvent2) throws nPublishPausedException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 39) {
            throw new nPublishPausedException(nExceptionEvent2.getMessage());
        }
    }

    private static void checkClusterNotReady(nEvent nEvent2) throws nSecurityException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 17) {
            throw new nSecurityException(nExceptionFactory.getErrorMessage(17, nExceptionEvent2.getMessage()));
        }
    }

    private static void checkPermissionsException(nEvent nEvent2) throws nSecurityException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2 != null && nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 37) {
            throw new nSecurityException(nExceptionFactory.getErrorMessage(37, nExceptionEvent2.getMessage()));
        }
    }

    public static void checkSessionPausedException(nEvent nEvent2) throws nSessionPausedException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 23) {
            throw new nSessionPausedException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkRequestTimeoutException(nEvent nEvent2) throws nRequestTimedOutException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 27) {
            throw new nRequestTimedOutException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkSessionNotConnectedException(nEvent nEvent2) throws nSessionNotConnectedException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 24) {
            throw new nSessionNotConnectedException(nExceptionEvent2.getMessage());
        }
    }

    public static void checkIllegalStateException(nEvent nEvent2) throws nIllegalStateException {
        nExceptionEvent nExceptionEvent2;
        if (nEvent2.getId() == 75 && (nExceptionEvent2 = (nExceptionEvent)nEvent2).getExceptionId() == 29) {
            throw new nIllegalStateException(nExceptionEvent2.getMessage());
        }
    }
}

