/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.base.fMissingKeyHandler;
import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.base.nConstants;
import java.io.IOException;
import java.util.LinkedHashMap;

public class nHeader
implements fExternalable,
fMissingKeyHandler,
Cloneable {
    public static final byte GoogleProtocolBufferType = 6;
    public static final byte AMQPMessageType = 7;
    public static final int SIZE_ESTIMATE = 144;
    public static String[] sMessageTypes = new String[]{"Base", "Map", "Bytes", "Object", "Stream", "Text", "Protobuf", "AMQP"};
    private static LinkedHashMap<String, nHeaderItem> myTranslationMap = nHeader.setupMapping();
    private static Vector myKeys;
    protected byte myReplyType;
    protected byte myDeliveryMode;
    protected byte myPriority = (byte)15;
    private transient boolean isReadOnly;
    protected byte myMessageType = (byte)-1;
    public long myTimestamp;
    public long myExpiration;
    public byte[] myCorrelationId;
    public byte[] myMessageId;
    public byte[] myType;
    public byte[] myDestination;
    public byte[] myApplicationId;
    public byte[] myUserId;
    public byte[] myReplyToName;
    public byte[] myPubName;
    public byte[] myPubHost;
    public byte[] mySubName;
    public byte[] mySubHost;
    public int mySubId;
    public byte[] myJoinChannel;
    public byte[] myJoinRealm;
    public byte[] myJoinPath;
    public long myJoinEID = -1L;
    public byte[] myDeadEventChannel;
    public long myDeadEID;
    public boolean redelivered;
    public int redeliveredCount;
    public long myTTL;
    private boolean hasOriginalTransactionEID = false;
    private fEventDictionary myDefaultDictionary;
    private boolean allowMerge;
    private boolean isRegistered = false;
    private boolean isExtendedTypes = false;
    private boolean isSubNameArray = false;
    private boolean writeSubNameArray = true;
    private boolean isDelta = false;
    private boolean isCompressed = false;

    public nHeader getClone() {
        try {
            nHeader nHeader2 = (nHeader)this.clone();
            nHeader2.isReadOnly = false;
            nHeader2.myMessageType = this.myMessageType;
            if (this.myMessageId != null) {
                nHeader2.myMessageId = (byte[])this.myMessageId.clone();
            }
            if (this.myReplyToName != null) {
                nHeader2.myReplyToName = (byte[])this.myReplyToName.clone();
            }
            nHeader2.isCompressed = this.isCompressed;
            nHeader2.writeSubNameArray = true;
            return nHeader2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.myCorrelationId != null) {
            stringBuilder.append("CorrelationID: ").append(fStringByteConverter.convert(this.myCorrelationId)).append(' ');
        }
        if (this.myMessageId != null) {
            stringBuilder.append("myMessageId: ").append(fStringByteConverter.convert(this.myMessageId)).append(' ');
        }
        if (this.myType != null) {
            stringBuilder.append("myType: ").append(fStringByteConverter.convert(this.myType)).append(' ');
        }
        if (this.myDestination != null) {
            stringBuilder.append("myDestination: ").append(fStringByteConverter.convert(this.myDestination)).append(' ');
        }
        if (this.myApplicationId != null) {
            stringBuilder.append("myApplicationId: ").append(fStringByteConverter.convert(this.myApplicationId)).append(' ');
        }
        if (this.myUserId != null) {
            stringBuilder.append("myUserId: ").append(fStringByteConverter.convert(this.myUserId)).append(' ');
        }
        if (this.myReplyToName != null) {
            stringBuilder.append("myReplyToName: ").append(fStringByteConverter.convert(this.myReplyToName)).append(' ');
        }
        if (this.myPubName != null) {
            stringBuilder.append("myPubName: ").append(fStringByteConverter.convert(this.myPubName)).append(' ');
        }
        if (this.myPubHost != null) {
            stringBuilder.append("myPubHost: ").append(fStringByteConverter.convert(this.myPubHost)).append(' ');
        }
        if (this.mySubName != null) {
            stringBuilder.append("mySubName: ").append(fStringByteConverter.convert(this.mySubName)).append(' ');
        }
        if (this.mySubHost != null) {
            stringBuilder.append("mySubHost: ").append(fStringByteConverter.convert(this.mySubHost)).append(' ');
        }
        if (this.myJoinChannel != null) {
            stringBuilder.append("myJoinChannel: ").append(fStringByteConverter.convert(this.myJoinChannel)).append(' ');
        }
        if (this.myJoinRealm != null) {
            stringBuilder.append("myJoinRealm: ").append(fStringByteConverter.convert(this.myJoinRealm)).append(' ');
        }
        if (this.myJoinPath != null) {
            stringBuilder.append("myJoinPath: ").append(fStringByteConverter.convert(this.myJoinPath)).append(' ');
        }
        if (this.myJoinEID != -1L) {
            stringBuilder.append("myJoinEID: ").append(this.myJoinEID).append(" ");
        }
        if (this.myDeadEventChannel != null) {
            stringBuilder.append("myDeadEventChannel: ").append(fStringByteConverter.convert(this.myDeadEventChannel));
        }
        return stringBuilder.toString();
    }

    public long getOriginalTransactionEID() {
        if (this.hasOriginalTransactionEID) {
            return this.myDeadEID;
        }
        return -1L;
    }

    public void setOriginalTransactionEID(long l) {
        this.hasOriginalTransactionEID = true;
        this.myDeadEID = l;
    }

    @Deprecated
    public boolean isImmediate() {
        return false;
    }

    @Deprecated
    public void setImmediate(boolean bl) {
    }

    public static Vector getKeys() {
        return myKeys;
    }

    public boolean isAllowedMerge() {
        return this.allowMerge;
    }

    public void setAllowMerge(boolean bl) {
        this.allowMerge = bl;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean bl) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.isRegistered = bl;
    }

    public byte getMessageType() {
        if (this.isExtendedTypes) {
            return (byte)(this.myMessageType + 6);
        }
        return this.myMessageType;
    }

    public void setMessageType(byte by) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myMessageType = by;
        if (by > 6) {
            this.isExtendedTypes = true;
            this.myMessageType = (byte)(this.myMessageType - 6);
        }
    }

    public int getSubId() {
        return this.mySubId;
    }

    public void setSubId(int n) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.mySubId = n;
    }

    public byte[] getSubHost() {
        return this.mySubHost;
    }

    public void setSubHost(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.mySubHost = byArray;
    }

    public byte[] getSubName() {
        return this.mySubName;
    }

    public boolean isSubNameArray() {
        return this.isSubNameArray;
    }

    public byte[][] getSubNames() {
        int n = 0;
        int n2 = this.ToShort(new byte[]{this.mySubName[n], this.mySubName[n + 1]});
        byte[][] byArrayArray = new byte[n2][];
        n += 2;
        for (int i = 0; i < n2; ++i) {
            short s = this.ToShort(new byte[]{this.mySubName[n], this.mySubName[n + 1]});
            byArrayArray[i] = new byte[s];
            System.arraycopy(this.mySubName, n += 2, byArrayArray[i], 0, s);
            n += byArrayArray[i].length;
        }
        return byArrayArray;
    }

    public void setSubName(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.mySubName = byArray;
        this.writeSubNameArray = true;
    }

    private short ToShort(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length != 2) {
            return 0;
        }
        return (short)((short)byArray[0] & 0xFF | ((short)byArray[1] & 0xFF) << 8);
    }

    private byte[] ToByte(short s) {
        return new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
    }

    public void setSubNames(String[] stringArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.isSubNameArray = true;
        byte[][] byArrayArray = new byte[stringArray.length][];
        short[] sArray = new short[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray = fStringByteConverter.convert(stringArray[i].toLowerCase());
            sArray[i] = (short)byArray.length;
            byte[] byArray2 = this.ToByte(sArray[i]);
            byArrayArray[i] = new byte[byArray.length + 2];
            System.arraycopy(byArray2, 0, byArrayArray[i], 0, 2);
            System.arraycopy(byArray, 0, byArrayArray[i], 2, byArray.length);
            n += byArrayArray[i].length;
        }
        this.mySubName = new byte[n + 2];
        byte[] byArray = this.ToByte((short)stringArray.length);
        int n2 = 2;
        for (int i = 0; i < stringArray.length; ++i) {
            System.arraycopy(byArrayArray[i], 0, this.mySubName, n2, byArrayArray[i].length);
            n2 += byArrayArray[i].length;
        }
        System.arraycopy(byArray, 0, this.mySubName, 0, 2);
        this.writeSubNameArray = true;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public void setTimestamp(long l) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myTimestamp = l;
    }

    public long getTTL() {
        return this.myTTL;
    }

    public void setTTL(long l) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myTTL = l;
    }

    public long getExpiration() {
        return this.myExpiration;
    }

    public void setExpiration(long l) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myExpiration = l;
    }

    public byte getReplyType() {
        return this.myReplyType;
    }

    public void setReplyType(byte by) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        if (by > 4 || by < 0) {
            by = 0;
        }
        this.myReplyType = by;
    }

    public byte getDeliveryMode() {
        return this.myDeliveryMode;
    }

    public void setDeliveryMode(byte by) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        if (by != 1 && by != 2) {
            by = 1;
        }
        this.myDeliveryMode = by;
    }

    public byte getPriority() {
        return this.myPriority;
    }

    public void setPriority(byte by) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        if (by < 0 || by > 9) {
            by = (byte)4;
        }
        this.myPriority = by;
    }

    public byte[] getUserId() {
        return this.myUserId;
    }

    public void setUserId(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myUserId = byArray;
    }

    public byte[] getApplicationId() {
        return this.myApplicationId;
    }

    public void setApplicationId(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myApplicationId = byArray;
    }

    public byte[] getDestination() {
        return this.myDestination;
    }

    public void setDestination(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myDestination = byArray;
    }

    public byte[] getType() {
        return this.myType;
    }

    public void setType(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myType = byArray;
    }

    public byte[] getMessageId() {
        return this.myMessageId;
    }

    public void setMessageId(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myMessageId = byArray;
    }

    public byte[] getCorrelationId() {
        return this.myCorrelationId;
    }

    public void setCorrelationId(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myCorrelationId = byArray;
    }

    public byte[] getReplyToName() {
        return this.myReplyToName;
    }

    public void setReplyToName(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myReplyToName = byArray;
    }

    public byte[] getPubHost() {
        return this.myPubHost;
    }

    public void setPubHost(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myPubHost = byArray;
    }

    public byte[] getPubName() {
        return this.myPubName;
    }

    public void setPubName(byte[] byArray) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myPubName = byArray;
    }

    public int getRedeliveredCount() {
        return this.redeliveredCount;
    }

    public void setRedeliveredCount(int n) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.redeliveredCount = n;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public void setRedelivered(boolean bl) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.redelivered = bl;
    }

    public void setDelta(boolean bl) {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.isDelta = bl;
    }

    public boolean isDelta() {
        return this.isDelta;
    }

    public fEventDictionary getDictionary() {
        if (this.myDefaultDictionary == null) {
            this.myDefaultDictionary = new fEventDictionary();
            this.myDefaultDictionary.setMissingKeyHandler(this);
        }
        return this.myDefaultDictionary;
    }

    public void reset() {
        if (this.isReadOnly) {
            nConstants.logger.log("Error: Header Read Only flag set");
            if (fRuntime.sThrowErrorOnReadOnly) {
                throw new Error("Read Only flag set");
            }
        }
        this.myTimestamp = 0L;
        this.myCorrelationId = null;
        this.myMessageId = null;
        this.myType = null;
        this.myDestination = null;
        this.myApplicationId = null;
        this.myUserId = null;
        this.myPubName = null;
        this.myPubHost = null;
        this.myDefaultDictionary = null;
    }

    private static byte getByteValueForHeader(Object object) {
        if (object instanceof Integer) {
            return (byte)((Integer)object).intValue();
        }
        return (Byte)object;
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        byte by = this.myReplyType;
        by = (byte)(by + ((this.myDeliveryMode - 1 & 1) << 3));
        by = (byte)(by + ((this.myPriority & 0xF) << 4));
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeLong(this.myTimestamp);
        fEventOutputStream2.writeLong(this.myExpiration);
        long l = 0L;
        if (this.myCorrelationId != null) {
            l |= 1L;
        }
        if (this.myMessageId != null) {
            l |= 2L;
        }
        if (this.myType != null) {
            l |= 4L;
        }
        if (this.myDestination != null) {
            l |= 8L;
        }
        if (this.myApplicationId != null) {
            l |= 0x10L;
        }
        if (this.myUserId != null) {
            l |= 0x20L;
        }
        if (this.myReplyToName != null) {
            l |= 0x40L;
        }
        if (this.myPubHost != null) {
            l |= 0x80L;
        }
        if (this.myPubName != null) {
            l |= 0x100L;
        }
        if (this.redelivered) {
            l |= 0x200L;
        }
        if (this.mySubHost != null) {
            l |= 0x400L;
        }
        if (this.mySubName != null && this.writeSubNameArray) {
            l |= 0x800L;
        }
        if (this.myJoinChannel != null) {
            l |= 0x1000L;
        }
        if (this.myJoinRealm != null) {
            l |= 0x2000L;
        }
        if (this.myJoinPath != null) {
            l |= 0x4000L;
        }
        if (this.myDeadEventChannel != null) {
            l |= 0x8000L;
        }
        if (this.myJoinEID != -1L) {
            l |= 0x10000L;
        }
        if (this.myDeadEID != 0L) {
            l |= 0x20000L;
        }
        if (this.isRegistered) {
            l |= 0x40000L;
        }
        if (this.isSubNameArray) {
            l |= 0x100000L;
        }
        if (this.isDelta) {
            l |= 0x200000L;
        }
        if (this.isCompressed) {
            l |= 0x400000L;
        }
        if (this.hasOriginalTransactionEID) {
            l |= 0x800000L;
        }
        if (this.isExtendedTypes) {
            l |= 0x2000000L;
        }
        l += (long)((this.myMessageType & 7) << 26);
        if (this.allowMerge) {
            l |= 0x40000000L;
        }
        if (this.mySubId != 0) {
            long l2 = this.mySubId;
            l += l2 << 32;
        }
        fEventOutputStream2.writeLong(l);
        fEventOutputStream2.writeShort((short)this.redeliveredCount);
        if (this.myCorrelationId != null) {
            fEventOutputStream2.writeByteArray(this.myCorrelationId);
        }
        if (this.myMessageId != null) {
            fEventOutputStream2.writeByteArray(this.myMessageId);
        }
        if (this.myType != null) {
            fEventOutputStream2.writeByteArray(this.myType);
        }
        if (this.myDestination != null) {
            fEventOutputStream2.writeByteArray(this.myDestination);
        }
        if (this.myApplicationId != null) {
            fEventOutputStream2.writeByteArray(this.myApplicationId);
        }
        if (this.myUserId != null) {
            fEventOutputStream2.writeByteArray(this.myUserId);
        }
        if (this.myReplyToName != null) {
            fEventOutputStream2.writeByteArray(this.myReplyToName);
        }
        if (this.myPubHost != null) {
            fEventOutputStream2.writeByteArray(this.myPubHost);
        }
        if (this.myPubName != null) {
            fEventOutputStream2.writeByteArray(this.myPubName);
        }
        if (this.mySubHost != null) {
            fEventOutputStream2.writeByteArray(this.mySubHost);
        }
        if (this.mySubName != null && this.writeSubNameArray) {
            fEventOutputStream2.writeByteArray(this.mySubName);
        }
        if (this.myJoinChannel != null) {
            fEventOutputStream2.writeByteArray(this.myJoinChannel);
        }
        if (this.myJoinRealm != null) {
            fEventOutputStream2.writeByteArray(this.myJoinRealm);
        }
        if (this.myJoinPath != null) {
            fEventOutputStream2.writeByteArray(this.myJoinPath);
        }
        if (this.myDeadEventChannel != null) {
            fEventOutputStream2.writeByteArray(this.myDeadEventChannel);
        }
        if (this.myJoinEID != -1L) {
            fEventOutputStream2.writeLong(this.myJoinEID);
        }
        if (this.myDeadEID != 0L) {
            fEventOutputStream2.writeLong(this.myDeadEID);
        }
    }

    @Deprecated
    public void writeToClient(fEventOutputStream fEventOutputStream2) throws IOException {
        byte by = this.myReplyType;
        by = (byte)(by + ((this.myDeliveryMode - 1 & 1) << 3));
        by = (byte)(by + ((this.myPriority & 0xF) << 4));
        fEventOutputStream2.writeByte(by);
        fEventOutputStream2.writeLong(this.myTimestamp);
        fEventOutputStream2.writeLong(this.myExpiration);
        long l = 0L;
        if (this.myCorrelationId != null) {
            l |= 1L;
        }
        if (this.myMessageId != null) {
            l |= 2L;
        }
        if (this.myType != null) {
            l |= 4L;
        }
        if (this.myDestination != null) {
            l |= 8L;
        }
        if (this.myApplicationId != null) {
            l |= 0x10L;
        }
        if (this.myUserId != null) {
            l |= 0x20L;
        }
        if (this.myReplyToName != null) {
            l |= 0x40L;
        }
        if (this.myPubHost != null) {
            l |= 0x80L;
        }
        if (this.myPubName != null) {
            l |= 0x100L;
        }
        if (this.redelivered) {
            l |= 0x200L;
        }
        if (this.mySubHost != null) {
            l |= 0x400L;
        }
        if (this.myJoinChannel != null) {
            l |= 0x1000L;
        }
        if (this.myJoinRealm != null) {
            l |= 0x2000L;
        }
        if (this.myJoinPath != null) {
            l |= 0x4000L;
        }
        if (this.myDeadEventChannel != null) {
            l |= 0x8000L;
        }
        if (this.myJoinEID != -1L) {
            l |= 0x10000L;
        }
        if (this.myDeadEID != 0L) {
            l |= 0x20000L;
        }
        if (this.isRegistered) {
            l |= 0x40000L;
        }
        if (this.isSubNameArray) {
            l |= 0x100000L;
        }
        if (this.isDelta) {
            l |= 0x200000L;
        }
        if (this.isCompressed) {
            l |= 0x400000L;
        }
        if (this.hasOriginalTransactionEID) {
            l |= 0x800000L;
        }
        if (this.isExtendedTypes) {
            l |= 0x2000000L;
        }
        l += (long)((this.myMessageType & 7) << 26);
        if (this.allowMerge) {
            l |= 0x40000000L;
        }
        if (this.mySubId != 0) {
            long l2 = this.mySubId;
            l += l2 << 32;
        }
        fEventOutputStream2.writeLong(l);
        fEventOutputStream2.writeShort((short)this.redeliveredCount);
        if (this.myCorrelationId != null) {
            fEventOutputStream2.writeByteArray(this.myCorrelationId);
        }
        if (this.myMessageId != null) {
            fEventOutputStream2.writeByteArray(this.myMessageId);
        }
        if (this.myType != null) {
            fEventOutputStream2.writeByteArray(this.myType);
        }
        if (this.myDestination != null) {
            fEventOutputStream2.writeByteArray(this.myDestination);
        }
        if (this.myApplicationId != null) {
            fEventOutputStream2.writeByteArray(this.myApplicationId);
        }
        if (this.myUserId != null) {
            fEventOutputStream2.writeByteArray(this.myUserId);
        }
        if (this.myReplyToName != null) {
            fEventOutputStream2.writeByteArray(this.myReplyToName);
        }
        if (this.myPubHost != null) {
            fEventOutputStream2.writeByteArray(this.myPubHost);
        }
        if (this.myPubName != null) {
            fEventOutputStream2.writeByteArray(this.myPubName);
        }
        if (this.mySubHost != null) {
            fEventOutputStream2.writeByteArray(this.mySubHost);
        }
        if (this.myJoinChannel != null) {
            fEventOutputStream2.writeByteArray(this.myJoinChannel);
        }
        if (this.myJoinRealm != null) {
            fEventOutputStream2.writeByteArray(this.myJoinRealm);
        }
        if (this.myJoinPath != null) {
            fEventOutputStream2.writeByteArray(this.myJoinPath);
        }
        if (this.myDeadEventChannel != null) {
            fEventOutputStream2.writeByteArray(this.myDeadEventChannel);
        }
        if (this.myJoinEID != -1L) {
            fEventOutputStream2.writeLong(this.myJoinEID);
        }
        if (this.myDeadEID != 0L) {
            fEventOutputStream2.writeLong(this.myDeadEID);
        }
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        byte by = fEventInputStream2.readByte();
        this.myReplyType = (byte)(by & 7);
        this.myDeliveryMode = (byte)((by >> 3 & 1) + 1);
        this.myPriority = (byte)(by >> 4 & 0xF);
        this.myTimestamp = fEventInputStream2.readLong();
        this.myExpiration = fEventInputStream2.readLong();
        long l = fEventInputStream2.readLong();
        this.redeliveredCount = fEventInputStream2.readShort();
        if ((l & 1L) != 0L) {
            this.myCorrelationId = fEventInputStream2.readByteArray();
        }
        if ((l & 2L) != 0L) {
            this.myMessageId = fEventInputStream2.readByteArray();
        }
        if ((l & 4L) != 0L) {
            this.myType = fEventInputStream2.readByteArray();
        }
        if ((l & 8L) != 0L) {
            this.myDestination = fEventInputStream2.readByteArray();
        }
        if ((l & 0x10L) != 0L) {
            this.myApplicationId = fEventInputStream2.readByteArray();
        }
        if ((l & 0x20L) != 0L) {
            this.myUserId = fEventInputStream2.readByteArray();
        }
        if ((l & 0x40L) != 0L) {
            this.myReplyToName = fEventInputStream2.readByteArray();
        }
        if ((l & 0x80L) != 0L) {
            this.myPubHost = fEventInputStream2.readByteArray();
        }
        if ((l & 0x100L) != 0L) {
            this.myPubName = fEventInputStream2.readByteArray();
        }
        boolean bl = this.redelivered = (l & 0x200L) != 0L;
        if ((l & 0x400L) != 0L) {
            this.mySubHost = fEventInputStream2.readByteArray();
        }
        if ((l & 0x800L) != 0L) {
            this.mySubName = fEventInputStream2.readByteArray();
        }
        if ((l & 0x1000L) != 0L) {
            this.myJoinChannel = fEventInputStream2.readByteArray();
        }
        if ((l & 0x2000L) != 0L) {
            this.myJoinRealm = fEventInputStream2.readByteArray();
        }
        if ((l & 0x4000L) != 0L) {
            this.myJoinPath = fEventInputStream2.readByteArray();
        }
        if ((l & 0x8000L) != 0L) {
            this.myDeadEventChannel = fEventInputStream2.readByteArray();
        }
        if ((l & 0x10000L) != 0L) {
            this.myJoinEID = fEventInputStream2.readLong();
        }
        if ((l & 0x20000L) != 0L) {
            this.myDeadEID = fEventInputStream2.readLong();
        }
        this.isRegistered = (l & 0x40000L) != 0L;
        this.isSubNameArray = (l & 0x100000L) != 0L;
        this.isDelta = (l & 0x200000L) != 0L;
        this.isCompressed = (l & 0x400000L) != 0L;
        this.hasOriginalTransactionEID = (l & 0x800000L) != 0L;
        this.isExtendedTypes = (l & 0x2000000L) != 0L;
        this.myMessageType = (byte)(l >> 26 & 7L);
        if (this.myMessageType == 7) {
            this.myMessageType = (byte)-1;
        }
        this.allowMerge = (l & 0x40000000L) != 0L;
        this.mySubId = (int)(l >> 32);
    }

    @Override
    public Object getObjectFromString(String string) {
        nHeaderItem nHeaderItem2 = myTranslationMap.get(string);
        if (nHeaderItem2 != null) {
            return nHeaderItem2.getValue(this);
        }
        return null;
    }

    public void convertToDictionary(fEventDictionary fEventDictionary2) {
        for (nHeaderItem nHeaderItem2 : myTranslationMap.values()) {
            if (nHeaderItem2 == null) continue;
            nHeaderItem2.addToDictionary(this, fEventDictionary2);
        }
    }

    public boolean convertFromDictionary(fEventDictionary fEventDictionary2) {
        boolean bl = false;
        for (nHeaderItem nHeaderItem2 : myTranslationMap.values()) {
            if (nHeaderItem2 == null || !nHeaderItem2.getFromDictionary(this, fEventDictionary2)) continue;
            fEventDictionary2.remove(nHeaderItem2.getName());
            bl = true;
        }
        return bl;
    }

    @Override
    public Object getObjectFromBytes(byte[] byArray) {
        return this.getObjectFromString(fStringByteConverter.convert(byArray));
    }

    @Override
    public Vector getObjectKeys() {
        return myKeys;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setCompressed(boolean bl) {
        this.isCompressed = bl;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    private static LinkedHashMap<String, nHeaderItem> setupMapping() {
        LinkedHashMap<String, nHeaderItem> linkedHashMap = new LinkedHashMap<String, nHeaderItem>();
        myKeys = new Vector();
        nHeaderItem nHeaderItem2 = new nHeaderItem("nrvpub.time"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myTimestamp != 0L) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myTimestamp);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myTimestamp = (Long)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myTimestamp != 0L) {
                    return nHeader2.myTimestamp;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvpub.host"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myPubHost != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myPubHost);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myPubHost = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myPubHost != null) {
                    return fStringByteConverter.convert(nHeader2.myPubHost);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvpub.name"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myPubName != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myPubName);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myPubName = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myPubName != null) {
                    return fStringByteConverter.convert(nHeader2.myPubName);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvpub.redelivery"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.redeliveredCount != 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.redeliveredCount);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.redeliveredCount = (Integer)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.redeliveredCount != 0) {
                    return (long)nHeader2.redeliveredCount;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvsub.host"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.mySubHost != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.mySubHost);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.mySubHost = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.mySubHost != null) {
                    return fStringByteConverter.convert(nHeader2.mySubHost);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvsub.name"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.mySubName != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.mySubName);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.mySubName = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.mySubName != null) {
                    return fStringByteConverter.convert(nHeader2.mySubName);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvsub.id"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.mySubId != 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.mySubId);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.mySubId = (Integer)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.mySubId != 0) {
                    return nHeader2.mySubId;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvdead.orig.chan"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myDeadEventChannel != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myDeadEventChannel);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myDeadEventChannel = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myDeadEventChannel != null) {
                    return fStringByteConverter.convert(nHeader2.myDeadEventChannel);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvdead.orig.eid"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myDeadEID != 0L) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myDeadEID);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myDeadEID = (Long)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myDeadEID != 0L) {
                    return nHeader2.myDeadEID;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvjoin.orig.chan"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myJoinChannel != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myJoinChannel);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myJoinChannel = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myJoinChannel != null) {
                    return fStringByteConverter.convert(nHeader2.myJoinChannel);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvjoin.orig.realm"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myJoinRealm != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myJoinRealm);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myJoinRealm = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myJoinRealm != null) {
                    return fStringByteConverter.convert(nHeader2.myJoinRealm);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvjoin.path"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myJoinPath != null) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myJoinPath);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myJoinPath = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myJoinPath != null) {
                    return fStringByteConverter.convert(nHeader2.myJoinPath);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("nrvjoin.orig.eid"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myJoinEID != -1L) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myJoinEID);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myJoinEID = (Long)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myJoinEID != -1L) {
                    return nHeader2.myJoinEID;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSMessageID"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myMessageId != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myMessageId));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myMessageId = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myMessageId != null) {
                    return fStringByteConverter.convert(nHeader2.myMessageId);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSCorrelationID"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myCorrelationId != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myCorrelationId));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myCorrelationId = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myCorrelationId != null) {
                    return fStringByteConverter.convert(nHeader2.myCorrelationId);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSReplyTo"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myReplyToName != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myReplyToName));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myReplyToName = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myReplyToName != null) {
                    return fStringByteConverter.convert(nHeader2.myReplyToName);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSType"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myType != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myType));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myType = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myType != null) {
                    return fStringByteConverter.convert(nHeader2.myType);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSXUserID"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myUserId != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myUserId));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myUserId = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myUserId != null) {
                    return fStringByteConverter.convert(nHeader2.myUserId);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSXAppID"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myApplicationId != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myApplicationId));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myApplicationId = (byte[])object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myApplicationId != null) {
                    return fStringByteConverter.convert(nHeader2.myApplicationId);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSExpiration"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myExpiration != 0L) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myExpiration);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myExpiration = (Long)object;
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myExpiration != 0L) {
                    return nHeader2.myExpiration;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSDeliveryMode"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myDeliveryMode != 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myDeliveryMode);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    if (object instanceof String) {
                        nHeader2.myDeliveryMode = ((String)object).equalsIgnoreCase("PERSISTENT") ? (byte)2 : (byte)1;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myDeliveryMode != 0) {
                    if (nHeader2.myDeliveryMode == 2) {
                        return "PERSISTENT";
                    }
                    return "NON_PERSISTENT";
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSDestination"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myDestination != null) {
                    fEventDictionary2.put(this.myDictionaryName, fStringByteConverter.convert(nHeader2.myDestination));
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    if (object instanceof String) {
                        nHeader2.myDestination = fStringByteConverter.convert((String)object);
                    } else if (object instanceof byte[]) {
                        nHeader2.myDestination = (byte[])object;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myDestination != null) {
                    return fStringByteConverter.convert(nHeader2.myDestination);
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSPriority"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myPriority != 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myPriority);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myPriority = nHeader.getByteValueForHeader(object);
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myPriority != 0) {
                    return nHeader2.myPriority;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSReplyToType"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myReplyType != 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myReplyType);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myReplyType = nHeader.getByteValueForHeader(object);
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myReplyType != 0) {
                    return (int)nHeader2.myReplyType;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        nHeaderItem2 = new nHeaderItem("JMSMsgType"){

            @Override
            public void addToDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                if (nHeader2.myMessageType > 0) {
                    fEventDictionary2.put(this.myDictionaryName, nHeader2.myMessageType);
                }
            }

            @Override
            public boolean getFromDictionary(nHeader nHeader2, fEventDictionary fEventDictionary2) {
                Object object = fEventDictionary2.getRaw(this.myDictionaryName);
                if (object != null) {
                    nHeader2.myMessageType = nHeader.getByteValueForHeader(object);
                    return true;
                }
                return false;
            }

            @Override
            public Object getValue(nHeader nHeader2) {
                if (nHeader2.myMessageType > 0) {
                    return (int)nHeader2.myMessageType;
                }
                return null;
            }
        };
        linkedHashMap.put(nHeaderItem2.getName(), nHeaderItem2);
        return linkedHashMap;
    }

    protected static abstract class nHeaderItem {
        protected String myDictionaryName;

        public nHeaderItem(String string) {
            this.myDictionaryName = string;
            myKeys.add(string);
        }

        public String getName() {
            return this.myDictionaryName;
        }

        public abstract Object getValue(nHeader var1);

        public abstract void addToDictionary(nHeader var1, fEventDictionary var2);

        public abstract boolean getFromDictionary(nHeader var1, fEventDictionary var2);
    }
}

