/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nMulticastInSyncCallback;
import java.util.LinkedList;

public class nMulticastStreamTransitionManager {
    private final String myName;
    private final long myResourceID;
    private final LinkedList<nPublished> myUnprocessed = new LinkedList();
    private final nMulticastInSyncCallback mySyncCallback;
    private long myTCPID;
    private long myMulticastId;
    private long TCPEventTime;
    private boolean inSync;

    public nMulticastStreamTransitionManager(long l, String string, nMulticastInSyncCallback nMulticastInSyncCallback2) {
        this.mySyncCallback = nMulticastInSyncCallback2;
        this.myResourceID = l;
        this.myTCPID = -1L;
        this.myMulticastId = -1L;
        this.myName = string;
        this.inSync = false;
    }

    public String getName() {
        return this.myName;
    }

    public int size() {
        return this.myUnprocessed.size();
    }

    public void setInsync() {
        if (!this.inSync && this.myTCPID == -1L || this.myTCPID + 1L == this.myMulticastId) {
            this.inSync = true;
            this.TCPEventTime = fTimer.currentTimeMillis();
            while (this.myUnprocessed.size() != 0) {
                this.mySyncCallback.processEvent(this.myUnprocessed.removeFirst());
            }
        }
    }

    public boolean inSync() {
        if (this.inSync) {
            while (this.myUnprocessed.size() != 0) {
                this.mySyncCallback.processEvent(this.myUnprocessed.removeFirst());
            }
        }
        return this.inSync;
    }

    public nPublished getNext() {
        return this.myUnprocessed.removeFirst();
    }

    public boolean process(nPublished nPublished2) {
        if (!this.inSync) {
            if (!nPublished2.isMulticastDelivered()) {
                if (this.myTCPID == -1L) {
                    this.myTCPID = nPublished2.getEID();
                    this.alignUndeliveredQueue();
                } else {
                    this.myTCPID = nPublished2.getEID();
                }
                if (this.myMulticastId != -1L && nPublished2.getEID() == this.myMulticastId) {
                    this.inSync = true;
                    this.TCPEventTime = fTimer.currentTimeMillis();
                    this.alignUndeliveredQueue();
                }
                return true;
            }
            if (this.myTCPID != -1L && (this.myTCPID == nPublished2.getEID() || this.myTCPID + 1L == nPublished2.getEID())) {
                this.inSync = true;
                this.TCPEventTime = fTimer.currentTimeMillis();
                this.alignUndeliveredQueue();
                this.myMulticastId = nPublished2.getEID();
                if (this.myTCPID + 1L == nPublished2.getEID()) {
                    return true;
                }
            } else if (nPublished2.getEID() > this.myTCPID) {
                if (this.myMulticastId == -1L && this.myUnprocessed.size() == 0) {
                    this.myMulticastId = nPublished2.getEID();
                }
                this.myUnprocessed.addLast(nPublished2);
            }
            return false;
        }
        if (nPublished2.isMulticastDelivered()) {
            if (nPublished2.getEID() > this.myMulticastId && this.myUnprocessed.size() == 0) {
                this.myMulticastId = nPublished2.getEID();
                return true;
            }
            if (nPublished2.getEID() > this.myMulticastId) {
                this.myUnprocessed.addLast(nPublished2);
            }
        } else {
            this.TCPEventTime = fTimer.currentTimeMillis();
        }
        return false;
    }

    private void alignUndeliveredQueue() {
        while (this.myUnprocessed.size() > 0 && this.myUnprocessed.getFirst().getEID() <= this.myTCPID) {
            this.myUnprocessed.removeFirst();
        }
        if (this.myUnprocessed.size() > 0) {
            this.myMulticastId = this.myUnprocessed.getFirst().getEID();
        }
    }

    public long lastTCPEventIn() {
        return this.TCPEventTime;
    }

    public long getResourceID() {
        return this.myResourceID;
    }
}

