/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.collections.SortedObject;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.base.nIllegalArgumentException;
import java.io.IOException;

public class nRealm
implements fExternalable,
SortedObject {
    protected Vector<fConnectionDetails> myConnections = new Vector();
    protected String name;
    protected String myMountPoint;
    protected transient fConnectionDetails myConnectionDetails;
    protected byte[] myPublicKey;

    public nRealm() {
    }

    public nRealm(String string, String[] stringArray) throws fException {
        try {
            this.setName(string);
            this.myMountPoint = null;
            this.setConnections(stringArray);
        }
        catch (Exception exception) {
            throw new fException(exception.getMessage());
        }
    }

    public void setConnections(String[] stringArray) {
        this.myConnections.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            try {
                fConnectionDetails fConnectionDetails2 = new fConnectionDetails(string);
                this.myConnections.addElement(fConnectionDetails2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public nRealm(String string, Vector vector) throws fException {
        this.myConnections = vector;
        try {
            this.setName(string);
            this.myMountPoint = null;
        }
        catch (Exception exception) {
            throw new fException(exception.getMessage());
        }
    }

    public String getHostVal() {
        fConnectionDetails fConnectionDetails2 = (fConnectionDetails)this.myConnections.elementAt(0);
        return fConnectionDetails2.getHost();
    }

    public int getHTTPPortVal() {
        for (int i = 0; i < this.myConnections.size(); ++i) {
            fConnectionDetails fConnectionDetails2 = (fConnectionDetails)this.myConnections.elementAt(i);
            if (fConnectionDetails2.getType() != 1 && fConnectionDetails2.getType() != 3) continue;
            return fConnectionDetails2.getPort();
        }
        return 0;
    }

    public int getPortVal() {
        for (int i = 0; i < this.myConnections.size(); ++i) {
            fConnectionDetails fConnectionDetails2 = (fConnectionDetails)this.myConnections.elementAt(i);
            if (fConnectionDetails2.getType() != 0 && fConnectionDetails2.getType() != 2) continue;
            return fConnectionDetails2.getPort();
        }
        return 0;
    }

    public Vector<fConnectionDetails> getConnections() {
        return this.myConnections;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) throws Exception {
        this.name = nConstants.validate(string);
    }

    public String getMountPoint() {
        return this.myMountPoint;
    }

    public byte[] getPublicKey() {
        return this.myPublicKey;
    }

    public void setPublicKey(byte[] byArray) {
        this.myPublicKey = byArray;
    }

    public void setMountPoint(String string) throws nIllegalArgumentException {
        if (string != null && string.length() == 0) {
            this.myMountPoint = null;
            return;
        }
        try {
            this.myMountPoint = nConstants.validateMountPoint("/" + string);
        }
        catch (Throwable throwable) {
            throw new nIllegalArgumentException(throwable.getMessage());
        }
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.name = fEventInputStream2.readString();
        if (fEventInputStream2.readBoolean()) {
            this.myMountPoint = fEventInputStream2.readString();
        }
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fConnectionDetails fConnectionDetails2 = new fConnectionDetails();
            fConnectionDetails2.readExternal(fEventInputStream2);
            this.myConnections.addElement(fConnectionDetails2);
        }
        this.myPublicKey = (byte[])(fEventInputStream2.readBoolean() ? fEventInputStream2.readByteArray() : null);
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeString(this.name);
        if (this.myMountPoint == null) {
            fEventOutputStream2.writeBoolean(false);
        } else {
            fEventOutputStream2.writeBoolean(true);
            fEventOutputStream2.writeString(this.myMountPoint);
        }
        fEventOutputStream2.writeInt(this.myConnections.size());
        for (int i = 0; i < this.myConnections.size(); ++i) {
            this.myConnectionDetails = (fConnectionDetails)this.myConnections.elementAt(i);
            this.myConnectionDetails.writeExternal(fEventOutputStream2);
        }
        if (this.myPublicKey != null) {
            fEventOutputStream2.writeBoolean(true);
            fEventOutputStream2.writeByteArray(this.myPublicKey);
        } else {
            fEventOutputStream2.writeBoolean(false);
        }
    }

    @Override
    public boolean lessThan(Object object) {
        return this.compare(object) < 0;
    }

    @Deprecated
    public boolean equals(Object object) {
        return this.compare(object) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private int compare(Object object) {
        if (object instanceof nRealm) {
            nRealm nRealm2 = (nRealm)object;
            return nRealm2.name.compareTo(this.name);
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.compareTo(this.name);
        }
        return 1;
    }

    @Override
    public boolean equals(long l) {
        return false;
    }

    @Override
    public boolean lessThan(long l) {
        return false;
    }
}

