/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nSynchronous;
import com.pcbsys.nirvana.base.events.nSynchronousCallbackWrapper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class nRequestResponseContainer {
    private final int requestIdentifier;
    private final nSynchronous myReq;
    private final Thread myThread;
    private final long waitLength;
    private final long startTime;
    private final boolean waitForResponse;
    private final CountDownLatch countDownLatch;
    private nEvent myResponse;
    private boolean isComplete = false;
    private boolean clear = false;
    private boolean wasPaused = false;
    private long executionTime;

    public nRequestResponseContainer(nSynchronous nSynchronous2, long l) {
        this.myReq = nSynchronous2;
        this.requestIdentifier = this.myReq.getRequestId();
        this.myThread = Thread.currentThread();
        if (nSynchronous2 instanceof nSynchronousCallbackWrapper) {
            this.waitForResponse = false;
            this.waitLength = -1L;
            this.startTime = -1L;
            this.countDownLatch = null;
        } else {
            this.waitForResponse = true;
            if (l <= -1L) {
                l = Long.MAX_VALUE;
            }
            this.waitLength = l;
            this.startTime = fTimer.getTicks();
            this.countDownLatch = new CountDownLatch(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        nRequestResponseContainer nRequestResponseContainer2 = this;
        synchronized (nRequestResponseContainer2) {
            this.isComplete = true;
            this.clear = true;
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        this.executeCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(nEvent nEvent2) {
        nRequestResponseContainer nRequestResponseContainer2 = this;
        synchronized (nRequestResponseContainer2) {
            this.isComplete = true;
            this.myResponse = nEvent2;
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        this.executeCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paused() {
        nRequestResponseContainer nRequestResponseContainer2 = this;
        synchronized (nRequestResponseContainer2) {
            this.wasPaused = true;
            this.isComplete = true;
            this.clear = true;
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
        this.executeCallback();
    }

    public boolean waitForComplete() {
        if (!this.waitForResponse) {
            return false;
        }
        long l = this.waitLength + this.startTime;
        while (true) {
            try {
                this.countDownLatch.await(this.waitLength, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                if (l > fTimer.getTicks()) continue;
            }
            break;
        }
        this.executionTime = fTimer.getTicks() - this.startTime;
        return true;
    }

    public long responseTime() {
        return this.executionTime;
    }

    private void executeCallback() {
        if (this.myReq.getCallback() != null) {
            this.myReq.getCallback().response(this.myReq, this.myResponse);
        }
    }

    public nSynchronous getRequest() {
        return this.myReq;
    }

    public nEvent getResponse() {
        return this.myResponse;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean wasPaused() {
        return this.wasPaused;
    }

    public int getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public boolean isClear() {
        return this.clear;
    }

    public Thread getThread() {
        return this.myThread;
    }
}

