/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.util.StringTokenizer;

public final class nRuntime
extends fRuntime {
    public static String sCoName = nRuntime.getCompanyIdName();
    public static final String sServerName = "Universal Messaging";
    public static final String sAdminName = "Enterprise Manager";
    public static final String sAdminJMSName = "JMS Enterprise Manager";
    public static final String sAdminViewerName = "Enterprise Viewer";
    public static String sReleaseDetails = "10.5.0.9.134924";
    public static final String sBuildNumber = "Build 134924";
    public static final String additionalBuildInfo = "10.5.0.x Fix None";
    private static final String sDefaultBuildStamp = "12-Feb-1964";
    public static final String sBuildDate = "July 21 2020";
    public static final boolean sDevelopersBuild = "July 21 2020".equals("12-Feb-1964");
    public static final String sInterRealmProtocolVersion = "1";
    public static final boolean sSupportAMQP = !nRuntime.isServer() || nRuntime.getValueAsBoolean("AMQP");
    public static final boolean sSupportMQTT = !nRuntime.isServer() || nRuntime.getValueAsBoolean("MQTT");
    public static final boolean sSupportSTOMP = false;
    public static final boolean sSupportXMPP = false;
    public static final boolean sSupportServerExtension = false;
    public static final long sBuildMode = 0L;
    public static final long sMaxNoOfChannels = !nRuntime.isServer() ? -1L : nRuntime.getValueAsLong("MaxResources");
    public static final long sMaxNoOfConnections = -1L;
    public static final boolean sSupportMixedChannels = !nRuntime.isServer() || nRuntime.getValueAsBoolean("MixedChannels");
    public static final boolean sSupportReliableChannels = !nRuntime.isServer() || nRuntime.getValueAsBoolean("ReliableChannels");
    public static final boolean sSupportPersistantChannels = !nRuntime.isServer() || nRuntime.getValueAsBoolean("PersistentChannels");
    public static final boolean sSupportPlugins = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Plugins");
    public static final boolean sSupportZones = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Zones");
    public static final boolean sSupportJoins = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Joins");
    public static final boolean sSupportPublishKeys = !nRuntime.isServer() || nRuntime.getValueAsBoolean("PublishKeys");
    public static final boolean sEnhancedAdminFunction = !nRuntime.isServer() || nRuntime.getValueAsBoolean("EnhancedAdmin");
    public static final boolean sEnableClustering = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Clustering");
    public static final boolean sEnableScheduling = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Scheduling");
    public static final boolean sEnableCompression = true;
    public static final boolean sEnableJMX = false;
    public static final boolean sSupportSnoop = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Snoop");
    public static final boolean sEnablePolicyServer = !nRuntime.isServer() || nRuntime.getValueAsBoolean("PolicyServer");
    public static final boolean sEnableClusterSites = !nRuntime.isServer() || nRuntime.getValueAsBoolean("ClusterSites");
    public static boolean sEnableThreadPooling = true;
    public static final boolean sEnableNIODrivers = true;
    public static final boolean sEnableHTTP_1_1 = true;
    public static final boolean sEnableWebSockets = !nRuntime.isServer() || nRuntime.getValueAsBoolean("WebSockets");
    public static final boolean sEnableThrottlingOnMemoryThreshold = true;
    public static final boolean sEnableNativeComet = !nRuntime.isServer() || nRuntime.getValueAsBoolean("NativeComet");
    public static final boolean sSyncWrites = false;
    static final int sHighWaterMark = 3000;
    static final int sLowWaterMark = 1000;
    public static final int sStoreCapacity = 0;
    public static final int sStoreTTL = 0;
    public static final boolean sSupportQueuePriority = !nRuntime.isServer() || nRuntime.getValueAsBoolean("QueuePriority");
    public static final boolean sSupportClusterEnginePipelining = !nRuntime.isServer() || nRuntime.getValueAsBoolean("ClusterEnginePipelining");
    public static final boolean sEnableMulticast = !nRuntime.isServer() || nRuntime.getValueAsBoolean("Multicast");
    public static final boolean sEnableMessagingPriority = !nRuntime.isServer() || nRuntime.getValueAsBoolean("MessagingPriority");
    public static final boolean sEnableHTTP = !nRuntime.isServer() || nRuntime.getValueAsBoolean("HTTPSupport");
    public static final boolean sEnableSHM = !nRuntime.isServer() || nRuntime.getValueAsBoolean("SharedMemory");
    public static final boolean sSupportJMSClients = !nRuntime.isServer() || nRuntime.getValueAsBoolean("JMSClients");
    public static final boolean sSupportWebClients = !nRuntime.isServer() || nRuntime.getValueAsBoolean("WebClients");
    public static final boolean sSupportMobileClients = !nRuntime.isServer() || nRuntime.getValueAsBoolean("MobileClients");
    public static final boolean sSupportEnterpriseClients = !nRuntime.isServer() || nRuntime.getValueAsBoolean("EnterpriseClients");
    public static final boolean sEnableDataGroups = !nRuntime.isServer() || nRuntime.getValueAsBoolean("DataGroups");
    public static final boolean sEnableRDMA = !nRuntime.isServer() || nRuntime.getValueAsBoolean("RDMA");
    public static final boolean sEnforceReadOnly = Boolean.parseBoolean(fSystemConfiguration.getProperty("ThrowErrorOnReadOnly", "false"));
    private static final boolean[] FunctionMask = nRuntime.setupMask();

    private static boolean getValueAsBoolean(String string) {
        try {
            return nRuntime.getLicenseManager().getValueAsBoolean(string);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static long getValueAsLong(String string) {
        try {
            return nRuntime.getLicenseManager().getValueAsLong(string);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static String getCompanyIdName() {
        if (isServer) {
            return nRuntime.getLicenseManager().getCompanyId();
        }
        return "";
    }

    public static boolean[] getFunctionMask() {
        return FunctionMask;
    }

    private static boolean[] setupMask() {
        fConnectionSettings.setHWMark(3000);
        fConnectionSettings.setLWMark(1000);
        boolean[] blArray = new boolean[116];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        blArray[25] = sSupportJoins;
        blArray[26] = sSupportJoins;
        blArray[27] = sSupportJoins;
        blArray[29] = sSupportJoins;
        blArray[30] = sSupportZones;
        blArray[31] = sSupportZones;
        blArray[83] = sSupportPlugins;
        blArray[102] = sEnableClustering;
        blArray[103] = sEnableScheduling;
        fRuntime.sCoName = sCoName;
        return blArray;
    }

    public static String asString() {
        StringBuffer stringBuffer = new StringBuffer("Nirvana Runtime:\n");
        stringBuffer.append(sCoName).append(" : ").append(sServerName).append(" : Build Number : ").append(sBuildNumber).append(" built on ").append(sBuildDate).append("\n");
        stringBuffer.append("\n");
        nRuntime.helper(stringBuffer, "# Channels  :", sMaxNoOfChannels);
        stringBuffer.append("\n");
        nRuntime.helper(stringBuffer, "Mixed       :", sSupportMixedChannels);
        nRuntime.helper(stringBuffer, "Reliable    :", sSupportReliableChannels);
        nRuntime.helper(stringBuffer, "Persistent  :", sSupportPersistantChannels);
        stringBuffer.append("\n");
        nRuntime.helper(stringBuffer, "Plugins     :", sSupportPlugins);
        nRuntime.helper(stringBuffer, "Federated   :", sSupportZones);
        nRuntime.helper(stringBuffer, "Joins       :", sSupportJoins);
        nRuntime.helper(stringBuffer, "Publish_Keys:", sSupportPublishKeys);
        nRuntime.helper(stringBuffer, "Clustering  :", sEnableClustering);
        nRuntime.helper(stringBuffer, "Sites       :", sEnableClusterSites);
        nRuntime.helper(stringBuffer, "Scheduling  :", sEnableScheduling);
        nRuntime.helper(stringBuffer, "Snoop       :", sSupportSnoop);
        nRuntime.helper(stringBuffer, "Policies    :", sEnablePolicyServer);
        nRuntime.helper(stringBuffer, "WebSockets  :", sEnableWebSockets);
        nRuntime.helper(stringBuffer, "NativeComet :", sEnableNativeComet);
        stringBuffer.append("\n");
        nRuntime.helper(stringBuffer, "Multicast   :", sEnableMulticast);
        nRuntime.helper(stringBuffer, "SHM         :", sEnableSHM);
        nRuntime.helper(stringBuffer, "RDMA        :", sEnableRDMA);
        nRuntime.helper(stringBuffer, "AMQP        :", sSupportAMQP);
        nRuntime.helper(stringBuffer, "MQTT        :", sSupportMQTT);
        return stringBuffer.toString();
    }

    private static void helper(StringBuffer stringBuffer, String string, boolean bl) {
        stringBuffer.append(string).append(bl).append("\n");
    }

    private static void helper(StringBuffer stringBuffer, String string, long l) {
        stringBuffer.append(string).append(l).append("\n");
    }

    public static boolean acceptClientVersion(String string, boolean bl) {
        if (sReleaseDetails.equals("10.5.0.9.134924")) {
            return true;
        }
        if (sReleaseDetails.trim().length() > 0 && string.trim().length() > 0) {
            if (sReleaseDetails.equals(string)) {
                return true;
            }
            float f = nRuntime.convertToVersion(sReleaseDetails);
            float f2 = nRuntime.convertToVersion(string);
            if (!bl) {
                return f <= f2 && f != 0.0f && f2 != 0.0f;
            }
            return f == f2 && f != 0.0f;
        }
        return false;
    }

    private static float convertToVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".");
        float f = 0.0f;
        if (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextElement().toString();
            if (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextElement().toString();
                f = Integer.parseInt(string2);
                f += (float)Integer.parseInt(string3) / 100.0f;
            }
        }
        return f;
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Universal Build Information:\n");
        stringBuffer.append("\tBuild Identifier:").append(sBuildNumber).append("\n");
        stringBuffer.append("\t Build Date :").append(sBuildDate).append("\n");
        System.out.println(stringBuffer.toString());
    }

    static {
        fEnvironment.setIsDeveloperBuild(sDevelopersBuild);
    }
}

