/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.nirvana.base.nIllegalArgumentException;

public class nStorePermission {
    private static final String INVALID_FIELD_MESSAGE_FORMAT = "Invalid %s, must be non-empty.";
    private static final String PERMISSION_FORMAT = "%s@%s:%d";
    private static final String SUBJECT_FORMAT = "%s@%s";
    private static final String GROUP = "group";
    private static final String USER = "user";
    private static final String HOST = "host";
    private static final String SUBJECT = "subject";
    private String user;
    private String host;
    private boolean isGroup;
    private long permissionMask;

    public nStorePermission(String string, String string2, long l) throws nIllegalArgumentException {
        this.validateMask(l);
        this.validateUserHost(string, string2);
        this.user = string.toLowerCase();
        this.host = string2.toLowerCase();
        this.permissionMask = l;
    }

    public nStorePermission(String string, long l, boolean bl) throws nIllegalArgumentException {
        this(string, l, bl, true);
    }

    public nStorePermission(String string, long l, boolean bl, boolean bl2) throws nIllegalArgumentException {
        if (bl2) {
            this.validateMask(l);
        }
        if (bl) {
            if (bl2) {
                this.validateNonEmpty(string, GROUP);
            }
            this.user = string;
        } else {
            String[] stringArray;
            if (bl2) {
                this.validateSubjectFormat(string);
            }
            if ((stringArray = string.split("@")).length != 2 && bl2) {
                throw new nIllegalArgumentException("Illegal subject. User or host component is missing. Must be user@host.");
            }
            if (bl2) {
                this.validateUserHost(stringArray[0], stringArray[1]);
            }
            this.user = stringArray[0].toLowerCase();
            this.host = stringArray[1].toLowerCase();
        }
        this.isGroup = bl;
        this.permissionMask = l;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public String getSubject() {
        return this.isGroup ? this.user : String.format(SUBJECT_FORMAT, this.user, this.host);
    }

    public String getName() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public long getPermissions() {
        return this.permissionMask;
    }

    public boolean canManage() {
        return this.checkBit(0) && this.checkBit(1);
    }

    public boolean canPurge() {
        return this.checkBit(7);
    }

    public boolean canGetLastEventId() {
        return this.checkBit(9);
    }

    public boolean canWrite() {
        return this.checkBit(5);
    }

    public boolean canRead() {
        return this.checkBit(6);
    }

    public boolean canPop() {
        return this.checkBit(10);
    }

    public boolean canUseNamedSubscription() {
        return this.checkBit(11);
    }

    public boolean hasFullPrivileges() {
        return this.checkBit(3);
    }

    public String toString() {
        return String.format(PERMISSION_FORMAT, this.user, this.host, this.permissionMask);
    }

    private void validateSubjectFormat(String string) throws nIllegalArgumentException {
        this.validateNonEmpty(string, SUBJECT);
        if (!string.contains("@")) {
            throw new nIllegalArgumentException("Malformed subject. Must be user@host.");
        }
    }

    private boolean checkBit(int n) {
        return (this.permissionMask & (long)(1 << n)) != 0L;
    }

    private void validateUserHost(String string, String string2) throws nIllegalArgumentException {
        this.validateNonEmpty(string, USER);
        this.validateNonEmpty(string2, HOST);
    }

    private void validateNonEmpty(String string, String string2) throws nIllegalArgumentException {
        if (string == null || string.trim().isEmpty()) {
            throw new nIllegalArgumentException(String.format(INVALID_FIELD_MESSAGE_FORMAT, string2));
        }
    }

    private void validateMask(long l) throws nIllegalArgumentException {
        if (l <= 0L) {
            throw new nIllegalArgumentException("Provide a valid privilege mask. The mask must be a positive number.");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        nStorePermission nStorePermission2 = (nStorePermission)object;
        if (this.permissionMask != nStorePermission2.permissionMask) {
            return false;
        }
        if (this.user != null ? !this.user.equals(nStorePermission2.user) : nStorePermission2.user != null) {
            return false;
        }
        return this.host != null ? this.host.equals(nStorePermission2.host) : nStorePermission2.host == null;
    }

    public int hashCode() {
        int n = this.user != null ? this.user.hashCode() : 0;
        n = 31 * n + (this.host != null ? this.host.hashCode() : 0);
        n = 31 * n + (int)(this.permissionMask ^ this.permissionMask >>> 32);
        return n;
    }
}

