/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.nirvana.base.nBaseMultiplexer;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nChannelWatcher;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class nSubscriberMultiplexer
extends nBaseMultiplexer
implements nEventListener {
    private static final String CLASS_NAME = nSubscriberMultiplexer.class.getSimpleName();
    private final nThreadManager myThreadManager;
    private final LinkedHashMap<nEventListener, nBaseMultiplexer.SubscriberInfo> myList;
    private final nChannelImpl myChannelList;
    private boolean hasSubscribed;
    private String myCurrentFilter;
    private nBaseMultiplexer.SubscriberInfo[] myListeners;

    public nSubscriberMultiplexer(nChannelImpl nChannelImpl2, nThreadManager nThreadManager2) {
        this.myChannelList = nChannelImpl2;
        this.hasSubscribed = false;
        this.myList = new LinkedHashMap();
        this.myCurrentFilter = null;
        this.myThreadManager = nThreadManager2;
    }

    @Override
    public void addSubscriber(nEventListener nEventListener2, String string, long l) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nSelectorParserException, nSecurityException, nChannelAlreadySubscribedException, nChannelNotFoundException {
        boolean bl = false;
        if (this.myChannelList.getTraceLogger().isTraceEnabled()) {
            this.myChannelList.getTraceLogger().trace("Creating multiplexed subscription. filter=" + string + ", startEid=" + l + ", currentSubscriptionSize=" + this.myList.size(), CLASS_NAME);
        }
        if (nEventListener2 instanceof nChannelWatcher) {
            if (!this.requestPurge()) {
                bl = true;
            }
            ++this.purgeListeners;
        }
        for (nEventListener nEventListener3 : this.myList.keySet()) {
            if (!nEventListener3.equals(nEventListener2)) continue;
            this.myList.remove(nEventListener3);
            break;
        }
        if (this.myList.size() == 0) {
            this.hasSubscribed = false;
        }
        nBaseMultiplexer.SubscriberInfo subscriberInfo = new nBaseMultiplexer.SubscriberInfo(nEventListener2, string, l);
        this.myList.put(subscriberInfo.getListener(), subscriberInfo);
        this.scanForChanges(subscriberInfo, bl);
    }

    @Override
    public synchronized boolean deleteSubscriber(nEventListener nEventListener2) throws nSelectorParserException, nSecurityException, nRequestTimedOutException, nSessionPausedException, nChannelAlreadySubscribedException, nSessionNotConnectedException, nChannelNotFoundException, nUnexpectedResponseException {
        nBaseMultiplexer.SubscriberInfo subscriberInfo = (nBaseMultiplexer.SubscriberInfo)this.myList.remove(nEventListener2);
        boolean bl = false;
        if (this.myChannelList.getTraceLogger().isTraceEnabled()) {
            this.myChannelList.getTraceLogger().trace("Deleting multiplexed subscription. currentSubscriptionSize=" + this.myList.size(), CLASS_NAME);
        }
        if (subscriberInfo != null) {
            if (nEventListener2 instanceof nChannelWatcher) {
                --this.purgeListeners;
                bl = !this.requestPurge();
            }
            subscriberInfo.close();
            this.scanForChanges(subscriberInfo, bl);
        }
        return subscriberInfo != null;
    }

    private synchronized void scanForChanges(nBaseMultiplexer.SubscriberInfo subscriberInfo, boolean bl) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nSelectorParserException, nSecurityException, nChannelAlreadySubscribedException, nChannelNotFoundException {
        if (this.hasSubscribed) {
            if (this.myList.size() == 0) {
                this.myChannelList.removeSubscriber();
                this.hasSubscribed = false;
                this.myListeners = null;
            } else {
                boolean bl2 = false;
                String string = null;
                for (nBaseMultiplexer.SubscriberInfo subscriberInfo2 : this.myList.values()) {
                    if (subscriberInfo2.getFilter() == null) {
                        bl2 = true;
                        continue;
                    }
                    if (string == null) {
                        string = subscriberInfo2.getFilter();
                        continue;
                    }
                    string = string + " OR " + subscriberInfo2.getFilter();
                }
                if (bl2) {
                    if (this.myCurrentFilter != null || bl) {
                        this.rebuildArray();
                        this.myCurrentFilter = null;
                        this.myChannelList.resetSubscriber(this, null, -9L);
                    } else if (this.myList.size() > this.myListeners.length) {
                        this.rebuildArray();
                    }
                } else if (!this.myCurrentFilter.equalsIgnoreCase(string) || bl) {
                    this.rebuildArray();
                    this.myCurrentFilter = string;
                    this.myChannelList.resetSubscriber(this, this.myCurrentFilter, -9L);
                }
            }
        } else {
            this.rebuildArray();
            this.hasSubscribed = true;
            this.myCurrentFilter = subscriberInfo.getFilter();
            if (this.myChannelList.isSubscribed()) {
                this.myChannelList.removeSubscriber();
            }
            this.myChannelList.addSubscriber(this, subscriberInfo.getFilter(), subscriberInfo.getStartEID());
        }
    }

    @Override
    public void rebuildArray() {
        if (this.myList.size() == 0) {
            this.myListeners = null;
        } else {
            this.myListeners = new nBaseMultiplexer.SubscriberInfo[this.myList.size()];
            int n = 0;
            Iterator<nBaseMultiplexer.SubscriberInfo> iterator = this.myList.values().iterator();
            while (iterator.hasNext()) {
                nBaseMultiplexer.SubscriberInfo subscriberInfo;
                this.myListeners[n] = subscriberInfo = iterator.next();
                ++n;
            }
        }
    }

    @Override
    public void purge(long l, long l2, String string) {
        nBaseMultiplexer.SubscriberInfo[] subscriberInfoArray = this.myListeners;
        if (subscriberInfoArray == null) {
            return;
        }
        for (nBaseMultiplexer.SubscriberInfo subscriberInfo : subscriberInfoArray) {
            if (!(subscriberInfo.getListener() instanceof nChannelWatcher)) continue;
            ((nChannelWatcher)subscriberInfo.getListener()).purge(l, l2, string);
        }
    }

    @Override
    public void go(nConsumeEvent nConsumeEvent2) {
        nBaseMultiplexer.SubscriberInfo[] subscriberInfoArray = this.myListeners;
        if (subscriberInfoArray == null) {
            return;
        }
        for (nBaseMultiplexer.SubscriberInfo subscriberInfo : subscriberInfoArray) {
            boolean bl = true;
            if (subscriberInfo.getSelector() != null && subscriberInfoArray.length > 1 && nConsumeEvent2.getProperties() != null) {
                bl = subscriberInfo.getSelector().isMatch(this.myChannelList.getBaseDictionary(nConsumeEvent2.getProperties()));
            }
            if (!bl || subscriberInfo.isClosed()) continue;
            subscriberInfo.processEvent(nConsumeEvent2, this.myThreadManager);
        }
    }
}

