/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.base;

import com.pcbsys.foundation.threads.fTask;
import com.pcbsys.foundation.threads.fThreadPool;

public class nThreadManager {
    private final String myUniqueSessionID;
    private fThreadPool myThreadPool;
    private int myThreadPoolSize;
    private volatile boolean hasThreadPool;
    private boolean isThreadPoolEnabled;
    private volatile boolean isClosed;

    public nThreadManager(String string) {
        this.myUniqueSessionID = string;
        this.myThreadPoolSize = 4;
        this.hasThreadPool = false;
        this.isThreadPoolEnabled = true;
        this.isClosed = false;
    }

    public void initialise() {
        if (this.isThreadPoolEnabled) {
            this.createThreadPool();
        }
    }

    private synchronized void createThreadPool() {
        if (!this.isClosed && !this.hasThreadPool) {
            this.myThreadPool = new fThreadPool("UM-Event-Processing-Pool: " + this.myUniqueSessionID, 1, this.myThreadPoolSize);
            this.hasThreadPool = true;
        }
    }

    private synchronized void closeThreadPool() {
        if (this.hasThreadPool) {
            this.hasThreadPool = false;
            this.myThreadPool.close();
            this.myThreadPool = null;
        }
        this.isClosed = true;
    }

    public void enableThreading(boolean bl) {
        this.isThreadPoolEnabled = bl;
        if (!bl) {
            this.closeThreadPool();
        } else {
            this.createThreadPool();
        }
    }

    public void enableThreading() {
        if (this.myThreadPool == null) {
            this.createThreadPool();
        }
    }

    public void setThreadPoolSize(int n) {
        if (n < 1) {
            n = 2;
        }
        if (this.myThreadPool != null) {
            this.myThreadPool.setMaxSize(n);
        }
        this.myThreadPoolSize = n;
    }

    public int getThreadPoolSize() {
        return this.myThreadPoolSize;
    }

    public void close() {
        this.closeThreadPool();
    }

    public synchronized boolean addTask(fTask fTask2) {
        if (!this.hasThreadPool) {
            return false;
        }
        this.myThreadPool.addTask(fTask2);
        return true;
    }

    public void setMinimumPoolSize(int n) {
        this.myThreadPool.setMinimumSize(n);
    }
}

