/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.nirvana.client.nSessionAttributes;
import com.pcbsys.nirvana.client.nSessionFactory;
import java.util.ArrayList;
import java.util.List;

class SessionAttributes
implements com.pcbsys.nirvana.base.clientimpl.SessionAttributes {
    private final List<List<fConnectionDetails>> connectionDetails;
    private final String[] enabledCiphers;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String certificateAlias;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String sslProtocol;
    private final String sessionNameIdentifier;
    private final long reconnectInterval;
    private final long initialConnectionRetryCount;
    private final boolean isRequestPriorityConnection;
    private final boolean isFollowTheMaster;
    private final boolean isDisableReconnect;
    private final boolean isRequestUnthrottledConnection;
    private final boolean isAdviseAsynchronousEventListenersOfStoreDelete;
    private final boolean isReconnectImmediately;
    private final boolean isHorizontalScalabilitySession;
    private boolean isDisconnectOnClusterFailure;
    private boolean isSessionThreadsDaemon;
    private String clientAppID;

    SessionAttributes(nSessionAttributes nSessionAttributes2) {
        this.enabledCiphers = nSessionAttributes2.getEnabledCiphers();
        this.keyStorePath = nSessionAttributes2.getKeyStorePath();
        this.keyStorePassword = nSessionAttributes2.getKeyStorePass();
        this.certificateAlias = nSessionAttributes2.getKeyStoreCert();
        this.trustStorePath = nSessionAttributes2.getTrustStorePath();
        this.trustStorePassword = nSessionAttributes2.getTrustStorePass();
        this.sslProtocol = nSessionAttributes2.getSSLProtocol();
        this.reconnectInterval = nSessionAttributes2.getReconnectInterval();
        this.initialConnectionRetryCount = nSessionAttributes2.getInitialConnectionRetryCount();
        this.isRequestPriorityConnection = nSessionAttributes2.isRequestPriorityConnection();
        this.isFollowTheMaster = nSessionAttributes2.isFollowTheMaster();
        this.isDisconnectOnClusterFailure = nSessionAttributes2.isDisconnectOnClusterFailure();
        this.isDisableReconnect = nSessionAttributes2.isDisableReconnect();
        this.isRequestUnthrottledConnection = nSessionAttributes2.isRequestUnthrottledConnection();
        this.isSessionThreadsDaemon = nSessionAttributes2.isSessionThreadsDaemon();
        this.isAdviseAsynchronousEventListenersOfStoreDelete = nSessionAttributes2.isAdviseAsynchronousEventListenersOfStoreDelete();
        this.isReconnectImmediately = nSessionAttributes2.getReconnectImmediately();
        this.connectionDetails = new ArrayList<List<fConnectionDetails>>();
        this.fillConnectionDetails(nSessionAttributes2.getConnections());
        this.isHorizontalScalabilitySession = this.connectionDetails.size() > 1;
        String string = nSessionAttributes2.getName();
        if (string == null || string.trim().isEmpty()) {
            string = this.isHorizontalScalabilitySession ? "UM Horizontal Scalability Session" : "UM Session";
        }
        this.sessionNameIdentifier = string;
        this.clientAppID = nSessionFactory.getSAGAppID();
    }

    private void fillConnectionDetails(List<List<fConnectionDetails>> list) {
        for (List<fConnectionDetails> list2 : list) {
            this.connectionDetails.add(new ArrayList<fConnectionDetails>(list2));
        }
    }

    @Override
    public List<List<fConnectionDetails>> getConnectionDetails() {
        return this.connectionDetails;
    }

    @Override
    public boolean isSSLConfigured() {
        return this.getTrustStorePath() != null || this.getTrustStorePassword() != null || this.getKeyStorePath() != null || this.getKeyStorePassword() != null || this.getCertificateAlias() != null || this.getEnabledCiphers() != null || this.getSslProtocol() != null;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    @Override
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public String getSslProtocol() {
        return this.sslProtocol;
    }

    @Override
    public String getSessionName() {
        return this.sessionNameIdentifier;
    }

    @Override
    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    @Override
    public long getInitialConnectionRetryCount() {
        return this.initialConnectionRetryCount;
    }

    @Override
    public boolean isHorizontalScalabilitySession() {
        return this.isHorizontalScalabilitySession;
    }

    @Override
    @Deprecated
    public boolean isRequestPriorityConnection() {
        return this.isRequestPriorityConnection;
    }

    @Override
    public boolean isFollowTheMaster() {
        return this.isFollowTheMaster;
    }

    @Override
    public boolean isDisconnectOnClusterFailure() {
        return this.isDisconnectOnClusterFailure;
    }

    @Override
    public void isDisconnectOnClusterFailure(boolean bl) {
        this.isDisconnectOnClusterFailure = bl;
    }

    @Override
    public boolean isDisableReconnect() {
        return this.isDisableReconnect;
    }

    @Override
    public boolean isRequestUnthrottledConnection() {
        return this.isRequestUnthrottledConnection;
    }

    @Override
    public boolean isSessionThreadsDaemon() {
        return this.isSessionThreadsDaemon;
    }

    @Override
    public void isSessionThreadsDaemon(boolean bl) {
        this.isSessionThreadsDaemon = bl;
    }

    @Override
    public boolean isAdviseAsynchronousEventListenersOfStoreDelete() {
        return this.isAdviseAsynchronousEventListenersOfStoreDelete;
    }

    @Override
    public boolean isReconnectImmediately() {
        return this.isReconnectImmediately;
    }

    public String toString() {
        return "nSessionAttributes:conns=" + this.connectionDetails.size() + "/" + this.connectionDetails;
    }

    @Override
    public String getClientAppID() {
        return this.clientAppID;
    }
}

