/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.utils.xmlHelper;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.events.nChangeAttributes;
import com.pcbsys.nirvana.client.nChannelAttributes;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

public abstract class nAbstractChannel {
    protected static final String sQueueObsoleteMessage = "This queue object is obsolete please perform a findQueue and discard this object";
    protected static final String sChannelObsoleteMessage = "This channel object is obsolete please perform a findChannel and discard this object";
    private final nChannelImpl myChannel;
    private final boolean isQueue;
    private final nSession mySession;
    private final ClientConnectionManager myConnectionManager;
    xmlHelper pubHelper = null;

    protected nAbstractChannel(nChannelImpl nChannelImpl2, boolean bl, nSession nSession2, ClientConnectionManager clientConnectionManager) {
        this.myChannel = nChannelImpl2;
        this.isQueue = bl;
        this.mySession = nSession2;
        this.myConnectionManager = clientConnectionManager;
    }

    protected nAbstractChannel(nAbstractChannel nAbstractChannel2) {
        this(nAbstractChannel2.myChannel, nAbstractChannel2.isQueue(), nAbstractChannel2.getSession(), nAbstractChannel2.myConnectionManager);
    }

    public nSession getSession() {
        return this.mySession;
    }

    public int getQueueSize() {
        if (this.myChannel != null && this.myChannel.getChannelList() != null) {
            return this.myChannel.getChannelList().getQueueSize();
        }
        return 0;
    }

    public void updateProtobufDefinitions(byte[][] byArray) throws nIllegalArgumentException, nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        com.pcbsys.nirvana.base.nChannelAttributes nChannelAttributes2;
        if (this.isStoreObjectInvalid()) {
            if (this.isQueue) {
                throw new nIllegalArgumentException(sQueueObsoleteMessage);
            }
            throw new nIllegalArgumentException(sChannelObsoleteMessage);
        }
        try {
            nChannelAttributes2 = new com.pcbsys.nirvana.base.nChannelAttributes(this.getBaseAttributes());
            nChannelAttributes2.setProtobufDescriptors(byArray);
        }
        catch (com.pcbsys.nirvana.base.nIllegalArgumentException nIllegalArgumentException2) {
            throw new nIllegalArgumentException(nIllegalArgumentException2.getMessage());
        }
        nChangeAttributes nChangeAttributes2 = new nChangeAttributes(this.getBaseAttributes(), nChannelAttributes2);
        this.myChannel.writeEvent(nChangeAttributes2);
        this.myChannel.getBaseChannelAttributes().setMetaData(nChannelAttributes2.getMetaData());
    }

    protected nChannelImpl getBaseChannel() {
        return this.myChannel;
    }

    protected boolean isQueue() {
        return this.isQueue;
    }

    protected ClientConnectionManager getConnectionManager() {
        return this.myConnectionManager;
    }

    public boolean isStoreObjectInvalid() {
        return this.myChannel.getChannelList().isDeleted();
    }

    public nChannelAttributes getStoreAttributes() {
        return new nChannelAttributes(this.getBaseAttributes());
    }

    protected nChannelImpl getChannel() {
        return this.myChannel;
    }

    protected com.pcbsys.nirvana.base.nChannelAttributes getBaseAttributes() {
        return this.myChannel.getBaseChannelAttributes();
    }

    public void purgeEvent(long l) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l, null, true, false);
    }

    public void purgeEvents(long l, long l2) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        if (l > l2) {
            throw new nIllegalArgumentException("StartEID must be equal or less then EndEID");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l2, null, true, false);
    }

    public void purgeEvents(long l, long l2, String string) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        if (l > l2) {
            throw new nIllegalArgumentException("StartEID must be equal or less then EndEID");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Selector must be a valid String");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l2, string, true, false);
    }

    public void purgeEventAsync(long l) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l, null, false, false);
    }

    public void purgeEventsAsync(long l, long l2) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        if (l > l2) {
            throw new nIllegalArgumentException("StartEID must be equal or less then EndEID");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l2, null, false, false);
    }

    public void purgeEventsAsync(long l, long l2, String string) throws nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (l < 0L) {
            throw new nIllegalArgumentException("EID must be equal or greater then 0");
        }
        if (l > l2) {
            throw new nIllegalArgumentException("StartEID must be equal or less then EndEID");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Selector must be a valid String");
        }
        this.checkIllegalState();
        this.getBaseChannel().purgeEvents(l, l2, string, false, false);
    }

    public void purge() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.checkIllegalStateUnexpected();
        this.getBaseChannel().purgeEvents(0L, this.getBaseChannel().getLastEID(), null, true, false);
    }

    public void purge(String string) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.checkIllegalStateUnexpected();
        this.getBaseChannel().purgeEvents(0L, this.getBaseChannel().getLastEID(), string, true, false);
    }

    public void purgeEventsAsync() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.checkIllegalStateUnexpected();
        this.getBaseChannel().purgeEvents(0L, this.getBaseChannel().getLastEID(), null, false, false);
    }

    public void purgeEventsAsync(String string) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.checkIllegalStateUnexpected();
        this.getBaseChannel().purgeEvents(0L, this.getBaseChannel().getLastEID(), string, false, false);
    }

    protected void checkIllegalState() throws nIllegalArgumentException {
        if (this.isStoreObjectInvalid()) {
            throw this.createObsoleteException();
        }
    }

    protected abstract nIllegalArgumentException createObsoleteException();

    protected void checkIllegalStateUnexpected() throws nUnexpectedResponseException {
        if (this.isStoreObjectInvalid()) {
            nUnexpectedResponseException nUnexpectedResponseException2 = new nUnexpectedResponseException();
            nUnexpectedResponseException2.initCause(this.createObsoleteException());
            throw nUnexpectedResponseException2;
        }
    }

    public StoreLogger getTraceLogger() {
        return this.myChannel.getTraceLogger();
    }
}

