/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nMessageSigner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.zip.CRC32;

public class nCertificateSigner
implements nMessageSigner {
    private static final String defaultAlgorithm = "SHA1withRSA";
    private Signature mySignature;
    private byte[] crcKey;
    private PrivateKey myPrivateKey;

    public static String getDefaultAlgorithm() {
        return defaultAlgorithm;
    }

    public nCertificateSigner(X509Certificate x509Certificate, PrivateKey privateKey) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException {
        this(x509Certificate, privateKey, defaultAlgorithm);
    }

    public nCertificateSigner(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException {
        if (x509Certificate == null) {
            throw new nIllegalArgumentException("Supplied certificate can not be null");
        }
        if (privateKey == null) {
            throw new nIllegalArgumentException("Supplied Private Key can not be null");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Supplied Algorithm can not be null");
        }
        this.initialise(x509Certificate, privateKey, string);
    }

    public nCertificateSigner(KeyStore keyStore, String string, String string2) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, UnrecoverableKeyException {
        this(keyStore, string, string2, defaultAlgorithm);
    }

    public nCertificateSigner(KeyStore keyStore, String string, String string2, String string3) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, UnrecoverableKeyException {
        if (keyStore == null) {
            throw new nIllegalArgumentException("Supplied KeyStore can not be null");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Supplied alias can not be null");
        }
        if (string2 == null) {
            throw new nIllegalArgumentException("Supplied privKeyPassword can not be null");
        }
        if (string3 == null) {
            throw new nIllegalArgumentException("Supplied algorithm can not be null");
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        if (x509Certificate == null) {
            throw new nIllegalArgumentException("Supplied alias can not be found in keystore");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, string2.toCharArray());
        if (privateKey == null) {
            throw new nIllegalArgumentException("Supplied password can not get private key");
        }
        this.initialise(x509Certificate, privateKey, string3);
    }

    public nCertificateSigner(String string, String string2, String string3, String string4) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException {
        this(string, string2, string3, string4, defaultAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nCertificateSigner(String string, String string2, String string3, String string4, String string5) throws nIllegalArgumentException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException, FileNotFoundException, CertificateException, IOException, UnrecoverableKeyException {
        if (string == null) {
            throw new nIllegalArgumentException("Supplied keystoreName can not be null");
        }
        if (string2 == null) {
            throw new nIllegalArgumentException("Supplied keyStorePasswd can not be null");
        }
        if (string3 == null) {
            throw new nIllegalArgumentException("Supplied alias can not be null");
        }
        if (string4 == null) {
            throw new nIllegalArgumentException("Supplied privKeyPassword can not be null");
        }
        if (string5 == null) {
            throw new nIllegalArgumentException("Supplied algorithm can not be null");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new nIllegalArgumentException("Supplied keystoreName does not exist:" + string);
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, string2.toCharArray());
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string3);
        if (x509Certificate == null) {
            throw new nIllegalArgumentException("Supplied alias can not be found in keystore");
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string3, string4.toCharArray());
        if (privateKey == null) {
            throw new nIllegalArgumentException("Supplied password can not get private key");
        }
        this.initialise(x509Certificate, privateKey, string5);
    }

    @Override
    public Provider getProvider() {
        return this.mySignature.getProvider();
    }

    @Override
    public void update(byte[] byArray) throws Exception {
        this.mySignature.update(byArray);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] byArray = this.mySignature.sign();
        byte[] byArray2 = new byte[byArray.length + 4];
        System.arraycopy(this.crcKey, 0, byArray2, 0, 4);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        this.mySignature.initSign(this.myPrivateKey);
        return byArray2;
    }

    private void initialise(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, InvalidKeyException, nIllegalArgumentException {
        x509Certificate.checkValidity();
        CRC32 cRC32 = new CRC32();
        cRC32.update(x509Certificate.getSignature());
        cRC32.update(x509Certificate.getSerialNumber().toByteArray());
        int n = (int)cRC32.getValue();
        this.crcKey = new byte[4];
        int n2 = 24;
        for (int i = 0; i < 4; ++i) {
            this.crcKey[i] = (byte)(n >> n2 & 0xFF);
            n2 -= 8;
        }
        this.mySignature = Signature.getInstance(string);
        if (this.mySignature == null) {
            throw new nIllegalArgumentException("Signature class for " + string + " not found");
        }
        this.myPrivateKey = privateKey;
        this.mySignature.initSign(privateKey);
    }
}

