/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nMessageValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.CRC32;

public class nCertificateValidator
implements nMessageValidator {
    private static final String defaultAlgorithm = "SHA1withRSA";
    private LinkedHashMap<Long, nSignatureStore> mySignatures = new LinkedHashMap();
    private nSignatureStore active = null;

    public static String getDefaultAlgorithm() {
        return defaultAlgorithm;
    }

    public nCertificateValidator(X509Certificate[] x509CertificateArray) throws nIllegalArgumentException, NoSuchAlgorithmException, InvalidKeyException {
        this(x509CertificateArray, defaultAlgorithm);
    }

    public nCertificateValidator(X509Certificate[] x509CertificateArray, String string) throws nIllegalArgumentException, NoSuchAlgorithmException, InvalidKeyException {
        if (x509CertificateArray == null) {
            throw new nIllegalArgumentException("Supplied certificates can not be null");
        }
        if (x509CertificateArray.length == 0) {
            throw new nIllegalArgumentException("Must supply at least one certificate");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Signature algorithm can not be null");
        }
        for (X509Certificate x509Certificate : x509CertificateArray) {
            if (x509Certificate == null) {
                throw new nIllegalArgumentException("Can not have NULL X509Certificate");
            }
            this.loadCertificate(x509Certificate, string);
        }
    }

    public nCertificateValidator(KeyStore keyStore) throws nIllegalArgumentException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException {
        this(keyStore, defaultAlgorithm);
    }

    public nCertificateValidator(KeyStore keyStore, String string) throws nIllegalArgumentException, NoSuchAlgorithmException, InvalidKeyException, KeyStoreException {
        if (keyStore == null) {
            throw new nIllegalArgumentException("Supplied keystore can not be null");
        }
        if (string == null) {
            throw new nIllegalArgumentException("Signature algorithm can not be null");
        }
        this.loadKeystore(keyStore, string);
    }

    public nCertificateValidator(String string, String string2) throws nIllegalArgumentException, KeyStoreException, FileNotFoundException, CertificateException, NoSuchAlgorithmException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        this(string, string2, defaultAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nCertificateValidator(String string, String string2, String string3) throws nIllegalArgumentException, KeyStoreException, FileNotFoundException, CertificateException, NoSuchAlgorithmException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        if (string == null) {
            throw new nIllegalArgumentException("Supplied keystoreName can not be null");
        }
        if (string2 == null) {
            throw new nIllegalArgumentException("Supplied keyStorePasswd can not be null");
        }
        if (string3 == null) {
            throw new nIllegalArgumentException("Signature algorithm can not be null");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("Suppplied KeyStore filename does not exist:" + string);
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, string2.toCharArray());
        }
        this.loadKeystore(keyStore, string3);
    }

    public Certificate[] getLoadedCertificates() {
        Certificate[] certificateArray = new Certificate[this.mySignatures.size()];
        Iterator<nSignatureStore> iterator = this.mySignatures.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            certificateArray[n] = iterator.next().myCert;
            ++n;
        }
        return certificateArray;
    }

    @Override
    public Provider getProvider() {
        return this.mySignatures.entrySet().iterator().next().getValue().mySignature.getProvider();
    }

    @Override
    public void start(byte[] byArray) {
        long l = this.getCRCKey(byArray);
        this.active = this.mySignatures.get(l);
    }

    @Override
    public void stop() {
        this.active = null;
    }

    @Override
    public void update(byte[] byArray) throws Exception {
        if (this.active != null) {
            this.active.mySignature.update(byArray);
        }
    }

    @Override
    public Object check(byte[] byArray) throws Exception {
        if (this.active == null) {
            throw new Exception("Unable to locate signing certificate to validate");
        }
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        boolean bl = this.active.mySignature.verify(byArray2);
        if (!bl) {
            throw new Exception("Signatures do not match");
        }
        this.active.mySignature.initVerify(this.active.myCert.getPublicKey());
        return this.active.myCert;
    }

    private void loadCertificate(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, InvalidKeyException {
        CRC32 cRC32 = new CRC32();
        cRC32.update(x509Certificate.getSignature());
        cRC32.update(x509Certificate.getSerialNumber().toByteArray());
        int n = (int)cRC32.getValue();
        Signature signature = Signature.getInstance(string);
        PublicKey publicKey = x509Certificate.getPublicKey();
        signature.initVerify(publicKey);
        nSignatureStore nSignatureStore2 = new nSignatureStore(x509Certificate, signature, n);
        try {
            this.mySignatures.put(nSignatureStore2.myKey, nSignatureStore2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getCRCKey(byte[] byArray) {
        int n = 24;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 = (byArray[i] & 0xFF) << n | n2;
            n -= 8;
        }
        return n2;
    }

    private void loadKeystore(KeyStore keyStore, String string) throws KeyStoreException, NoSuchAlgorithmException, InvalidKeyException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            this.loadCertificate((X509Certificate)keyStore.getCertificate(enumeration.nextElement().toString()), string);
        }
    }

    private static class nSignatureStore {
        Certificate myCert;
        Signature mySignature;
        long myKey;

        nSignatureStore(Certificate certificate, Signature signature, long l) {
            this.mySignature = signature;
            this.myKey = l;
            this.myCert = certificate;
        }
    }
}

