/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.events.nAckEvent;
import com.pcbsys.nirvana.base.events.nConnectionSubscribe;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nGetLastEID;
import com.pcbsys.nirvana.base.events.nGetLastStoredEID;
import com.pcbsys.nirvana.base.events.nManageNamedSub;
import com.pcbsys.nirvana.base.events.nPeekQueue;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nPurge;
import com.pcbsys.nirvana.base.events.nQueueTransactionStatus;
import com.pcbsys.nirvana.base.events.nRemoveSub;
import com.pcbsys.nirvana.base.events.nUserSubscribe;
import com.pcbsys.nirvana.base.nBaseNamedObject;
import com.pcbsys.nirvana.base.nChannelAttributes;
import com.pcbsys.nirvana.base.nChannelQueue;
import com.pcbsys.nirvana.base.nClientChannelList;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.base.nSubscriberMultiplexer;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nChannelConnectionListener;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nChannelWatcher;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nDurableAttributes;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nMaxBufferSizeExceededException;
import com.pcbsys.nirvana.client.nMessageSigner;
import com.pcbsys.nirvana.client.nMessageValidator;
import com.pcbsys.nirvana.client.nNameAlreadyBoundException;
import com.pcbsys.nirvana.client.nNameDoesNotExistException;
import com.pcbsys.nirvana.client.nPublishPausedException;
import com.pcbsys.nirvana.client.nQueuePeekContext;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

public class nChannelImpl
extends nChannelQueue {
    private static final String CLASS_NAME = nChannelImpl.class.getSimpleName();
    private final nClientChannelList myChannelList;
    private final ClientConnectionManager myConnectionManager;
    private nUnAckedEventManager unAckedEventManager;
    private nDurable myNamedObject;
    private nAbstractChannel publicStore;

    protected nChannelImpl(nChannelAttributes nChannelAttributes2, nThreadManager nThreadManager2, ClientConnectionManager clientConnectionManager) throws nIllegalArgumentException {
        super(nChannelAttributes2);
        this.myConnectionManager = clientConnectionManager;
        this.myChannelList = new nClientChannelList(this, nThreadManager2);
        this.myWindowSize = nConstants.getMaxUnackedEvents();
    }

    @Override
    protected nEvent writeEvent(nEvent nEvent2, long l) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        return this.myConnectionManager.getEventProcessor().writeEvent(nEvent2, l);
    }

    @Override
    public nEvent writeEvent(nEvent nEvent2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        return this.myConnectionManager.getEventProcessor().writeEvent(nEvent2);
    }

    @Override
    public nChannelAttributes getBaseChannelAttributes() {
        return this.nca;
    }

    protected long getLastEID() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nGetLastEID nGetLastEID2 = new nGetLastEID(this.nca);
        nEvent nEvent2 = this.writeEvent(nGetLastEID2);
        if (nEvent2 instanceof nGetLastEID) {
            nGetLastEID nGetLastEID3 = (nGetLastEID)nEvent2;
            return nGetLastEID3.getEID();
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "getLastEID");
    }

    protected long getLastStoredEID() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nGetLastStoredEID nGetLastStoredEID2 = new nGetLastStoredEID(this.nca);
        nEvent nEvent2 = this.writeEvent(nGetLastStoredEID2);
        if (nEvent2 instanceof nGetLastStoredEID) {
            nGetLastStoredEID nGetLastStoredEID3 = (nGetLastStoredEID)nEvent2;
            return nGetLastStoredEID3.getEID();
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "getLastStoredEID");
    }

    public void delNamedObject(nDurable nDurable2) throws nSecurityException, nChannelNotFoundException, nNameDoesNotExistException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        this.validateNamedObjectOrigin(nDurable2);
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.nca, 1, null);
        if (this.getTraceLogger().isInfoEnabled()) {
            this.getTraceLogger().info("Deleting durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
        }
        nManageNamedSub2.setNameId(nDurable2.getID());
        nEvent nEvent2 = this.writeEvent(nManageNamedSub2);
        if (nEvent2 instanceof nManageNamedSub) {
            if (this.getTraceLogger().isTraceEnabled()) {
                this.getTraceLogger().trace("Successful deletion of durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            return;
        }
        try {
            nExceptionEventProcessor.checkCommonExceptions(nEvent2);
            nExceptionEventProcessor.checkNameDoesNotExist(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "delNamedObject");
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Failed to delete durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            throw exception;
        }
    }

    public void unbindNamedObject(nDurable nDurable2) throws nChannelNotFoundException, nNameDoesNotExistException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (this.getTraceLogger().isInfoEnabled()) {
            this.getTraceLogger().info("Unbinding durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
        }
        this.validateNamedObjectOrigin(nDurable2);
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.nca, 3, null);
        nManageNamedSub2.setNameId(nDurable2.getID());
        nEvent nEvent2 = this.writeEvent(nManageNamedSub2);
        if (nEvent2 instanceof nManageNamedSub) {
            if (this.getTraceLogger().isTraceEnabled()) {
                this.getTraceLogger().trace("Successful unbind of durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            return;
        }
        try {
            nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
            nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
            nExceptionEventProcessor.checkSessionPausedException(nEvent2);
            nExceptionEventProcessor.checkChannelNotFound(nEvent2);
            nExceptionEventProcessor.checkNameDoesNotExist(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "unbindNamedObject");
        }
        catch (Exception exception) {
            this.getTraceLogger().warn("Failed to unbind durable. " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            throw exception;
        }
    }

    protected nDurable createDurable(nDurableAttributes nDurableAttributes2) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nNameAlreadyBoundException, nSelectorParserException {
        return this.createDurable(nDurableAttributes2, false);
    }

    public nDurable createDurable(nDurableAttributes nDurableAttributes2, boolean bl) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nNameAlreadyBoundException, nSelectorParserException {
        nEvent nEvent2;
        if (nDurableAttributes2.isClustered() && !this.myChannelList.getAttributes().isClusterWide()) {
            throw new nUnexpectedResponseException("Channel is not cluster wide, yet the named object is request as being cluster wide");
        }
        byte by = 0;
        if (bl) {
            by = 4;
        }
        if (this.getTraceLogger().isInfoEnabled()) {
            this.getTraceLogger().info("Creating durable. " + ClientEventTraceLoggerContext.addDurAttributesInfo(nDurableAttributes2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
        }
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.nca, by, nDurableAttributes2.getName(), nDurableAttributes2.isPersistent(), nDurableAttributes2.isClustered(), nDurableAttributes2.getStartEID(), nDurableAttributes2.getType() == nDurableAttributes.nDurableType.Shared, nDurableAttributes2.getType() == nDurableAttributes.nDurableType.Serial);
        if ((nDurableAttributes2.getType() == nDurableAttributes.nDurableType.Shared || nDurableAttributes2.getType() == nDurableAttributes.nDurableType.Serial) && nDurableAttributes2.getSelector() != null) {
            nManageNamedSub2.setSelector(nDurableAttributes2.getSelector());
        }
        if ((nEvent2 = this.writeEvent(nManageNamedSub2)) instanceof nManageNamedSub) {
            if (this.getTraceLogger().isTraceEnabled()) {
                this.getTraceLogger().trace("Successful creation of durable. " + ClientEventTraceLoggerContext.addDurAttributesInfo(nDurableAttributes2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            nManageNamedSub nManageNamedSub3 = (nManageNamedSub)nEvent2;
            return this.myConnectionManager.getDurableManagerHelper().convert((nChannel)this.publicStore, nManageNamedSub3.getObject());
        }
        try {
            nExceptionEventProcessor.checkCommonExceptions(nEvent2);
            nExceptionEventProcessor.checkNameAlreadyBound(nEvent2);
            nExceptionEventProcessor.checkSelectorParser(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "createNamedObject");
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Failed to create durable. " + ClientEventTraceLoggerContext.addDurAttributesInfo(nDurableAttributes2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()) + ", reason=" + exception.getMessage(), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    public nDurable getNamedObject(String string) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nNameDoesNotExistException {
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.nca, 2, string);
        nEvent nEvent2 = this.writeEvent(nManageNamedSub2);
        if (nEvent2 instanceof nManageNamedSub) {
            nManageNamedSub nManageNamedSub3 = (nManageNamedSub)nEvent2;
            nBaseNamedObject[] nBaseNamedObjectArray = nManageNamedSub3.getList();
            if (nBaseNamedObjectArray != null && nBaseNamedObjectArray.length > 0) {
                nBaseNamedObject nBaseNamedObject2 = nBaseNamedObjectArray[0];
                return this.myConnectionManager.getDurableManagerHelper().convert((nChannel)this.publicStore, nBaseNamedObject2);
            }
            return null;
        }
        nExceptionEventProcessor.checkCommonExceptions(nEvent2);
        nExceptionEventProcessor.checkNameDoesNotExist(nEvent2);
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "getNamedObject");
    }

    protected nDurable[] getNamedObject() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.nca, 2, null);
        nEvent nEvent2 = this.writeEvent(nManageNamedSub2);
        if (nEvent2 instanceof nManageNamedSub) {
            nManageNamedSub nManageNamedSub3 = (nManageNamedSub)nEvent2;
            nBaseNamedObject[] nBaseNamedObjectArray = nManageNamedSub3.getList();
            if (nBaseNamedObjectArray == null) {
                nBaseNamedObjectArray = new nBaseNamedObject[]{};
            }
            nDurable[] nDurableArray = new nDurable[nBaseNamedObjectArray.length];
            for (int i = 0; i < nBaseNamedObjectArray.length; ++i) {
                nBaseNamedObject nBaseNamedObject2 = nBaseNamedObjectArray[i];
                nDurableArray[i] = this.myConnectionManager.getDurableManagerHelper().convert((nChannel)this.publicStore, nBaseNamedObject2);
            }
            return nDurableArray;
        }
        nExceptionEventProcessor.checkCommonExceptions(nEvent2);
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "getNamedObject");
    }

    protected nPeekQueue peekQueue(nQueuePeekContext nQueuePeekContext2, int n) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        nPeekQueue nPeekQueue2 = new nPeekQueue(this.nca, nQueuePeekContext2.getIndex(), nQueuePeekContext2.getWindowSize(), nQueuePeekContext2.hasMore(), nQueuePeekContext2.getSelector(), n);
        nEvent nEvent2 = this.writeEvent(nPeekQueue2);
        if (nEvent2 instanceof nPeekQueue) {
            return (nPeekQueue)nEvent2;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        try {
            nExceptionEventProcessor.checkSelectorParser(nEvent2);
        }
        catch (nSelectorParserException nSelectorParserException2) {
            throw new nIllegalArgumentException("Invalid selector provided", nSelectorParserException2);
        }
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "peekQueue");
    }

    protected int getEventCount() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nGetLastEID nGetLastEID2 = new nGetLastEID(this.nca);
        nEvent nEvent2 = this.writeEvent(nGetLastEID2);
        if (nEvent2 instanceof nGetLastEID) {
            nGetLastEID nGetLastEID3 = (nGetLastEID)nEvent2;
            return nGetLastEID3.getEventCount();
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        throw nChannelImpl.handleUnexpectedResponse(nEvent2, "getEventCount");
    }

    protected void purgeEvents(long l, long l2, String string, boolean bl, boolean bl2) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nPurge nPurge2 = new nPurge(this.nca, l, l2, string, bl2);
        nPurge2.setSyncFlag(bl);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Client requested purge. " + ClientEventTraceLoggerContext.addPurgeInfo(nPurge2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.writeEvent(nPurge2);
        if (!bl) {
            if (this.getTraceLogger().isTraceEnabled()) {
                this.getTraceLogger().trace("Purge request sent. " + ClientEventTraceLoggerContext.addPurgeInfo(nPurge2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            return;
        }
        if (nEvent2 instanceof nPurge) {
            if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Purge request successful. " + ClientEventTraceLoggerContext.addPurgeInfo(nPurge2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
            }
            return;
        }
        try {
            nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
            nExceptionEventProcessor.checkSecurityException(nEvent2);
            nExceptionEventProcessor.checkChannelNotFound(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "purgeEvents");
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Purge request failed. " + ClientEventTraceLoggerContext.addPurgeInfo(nPurge2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()) + ", reason=" + exception.getMessage(), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    protected void publish(nConsumeEvent nConsumeEvent2, nMessageSigner nMessageSigner2) throws nSessionNotConnectedException, nSessionPausedException, nSecurityException, nMaxBufferSizeExceededException, nPublishPausedException {
        block3: {
            nPublished nPublished2 = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEvent2, nMessageSigner2, this.nca.getUniqueId(), this.myConnectionManager);
            try {
                if (this.publicStore.getTraceLogger().isInfoEnabled()) {
                    this.publicStore.getTraceLogger().info("Sending publish request. nPublished={" + ClientEventTraceLoggerContext.addPubEventTraceInfo(nPublished2) + "}, conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                this.writeEvent(nPublished2);
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                if (!this.publicStore.getTraceLogger().isWarnEnabled()) break block3;
                this.publicStore.getTraceLogger().warn("Publish request timed out. nConsumeEvent={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}, conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
        }
    }

    public void addSubscriber(nEventListener nEventListener2, String string, long l) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException, nUnexpectedResponseException, nSelectorParserException {
        this.addSubscriber(nEventListener2, string, l, null, false);
    }

    public void resetSubscriber(nEventListener nEventListener2, String string, long l) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException, nUnexpectedResponseException, nSelectorParserException {
        this.addSubscriber(nEventListener2, string, l, null, true);
    }

    protected void addSubscriber(nEventListener nEventListener2, String string, long l, nMessageValidator nMessageValidator2, boolean bl) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSelectorParserException {
        this.addSubscriber(nEventListener2, string, l, nMessageValidator2, bl, false, false);
    }

    public void addSubscriber(nEventListener nEventListener2, String string, long l, nMessageValidator nMessageValidator2, boolean bl, boolean bl2, boolean bl3) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSelectorParserException {
        nEvent nEvent2;
        String string2;
        if (!bl) {
            this.myChannelList.addSub(nEventListener2, nMessageValidator2);
        }
        this.setupListener(nEventListener2);
        nUserSubscribe nUserSubscribe2 = new nUserSubscribe(this.nca, l, string, -1L, -1L, this.requestPurge, bl3);
        nUserSubscribe2.setMaintainPriority(bl2);
        try {
            if (this.getTraceLogger().isTraceEnabled()) {
                string2 = "Adding asynchronous subscriber. isInfiniteWindow=" + bl3 + ", windowSize=" + l + ", selector=" + string + ", maintainPriority=" + bl2 + ", eid=" + l + ", messagingValidator=" + (nMessageValidator2 == null ? "No" : "Yes, requestId=" + nUserSubscribe2.getRequestId()) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager());
                this.getTraceLogger().trace(string2, CLASS_NAME);
            }
            nEvent2 = this.writeEvent(nUserSubscribe2);
        }
        catch (nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
            this.myChannelList.deleteSub();
            throw nBaseClientException2;
        }
        catch (nRequestTimedOutException nRequestTimedOutException2) {
            try {
                this.removeSubscriber(false);
            }
            catch (Exception exception) {
                nConstants.logger.warn("Timed out while subscribing to channel " + this.nca.getName() + " and subscription cleanup failed: " + exception.getMessage(), exception);
            }
            this.myChannelList.deleteSub();
            throw nRequestTimedOutException2;
        }
        if (nEvent2 instanceof nUserSubscribe) {
            if (this.getTraceLogger().isInfoEnabled()) {
                string2 = "Successful addition of asynchronous subscriber. requestId=" + nUserSubscribe2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager());
                this.getTraceLogger().info(string2, CLASS_NAME);
            }
            this.myLastEID = l;
            this.mySelector = string;
            this.myMaintainPriority = bl2;
            this.myIsInfiniteWindow = bl3;
            return;
        }
        this.myChannelList.deleteSub();
        try {
            nExceptionEventProcessor.checkCommonExceptions(nEvent2);
            nExceptionEventProcessor.checkChannelAlreadySubscribed(nEvent2);
            nExceptionEventProcessor.checkSelectorParser(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "addSubscriber");
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Failed to add asynchronous subscriber. requestId=" + nUserSubscribe2.getRequestId() + ", reason=" + exception.getMessage(), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    public void setupSubscription(nEventListener nEventListener2) throws nChannelAlreadySubscribedException {
        this.myChannelList.addSub(nEventListener2, null);
        this.myLastEID = 0L;
        this.mySelector = null;
        this.setupListener(nEventListener2);
    }

    private void setupListener(nEventListener nEventListener2) {
        this.requestPurge = false;
        if (nEventListener2 instanceof nSubscriberMultiplexer) {
            this.requestPurge = ((nSubscriberMultiplexer)nEventListener2).requestPurge();
        } else if (nEventListener2 instanceof nChannelWatcher) {
            this.requestPurge = true;
        } else if (this.nca.getPublishKeys() != null && this.nca.getPublishKeys().length > 0) {
            this.requestPurge = true;
        }
    }

    void reSubscribe(String string, long l) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSelectorParserException {
        nEventListener nEventListener2 = this.myChannelList.getSubscriber();
        this.removeSubscriber(true);
        if (string == null) {
            string = this.mySelector;
        }
        this.addSubscriber(nEventListener2, string, l);
    }

    void reSubscribe(nDurable nDurable2, String string) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSelectorParserException, nNameAlreadyBoundException, nNameDoesNotExistException, nIllegalArgumentException {
        nEventListener nEventListener2 = this.myChannelList.getSubscriber();
        int n = this.myWindowSize;
        boolean bl = this.isAutoAck();
        this.removeSubscriber(true);
        this.addSubscriber(nEventListener2, nDurable2, string, null, bl, n);
    }

    public void addSubscriber(nEventListener nEventListener2, nDurable nDurable2, String string, nMessageValidator nMessageValidator2, boolean bl, int n) throws nSecurityException, nChannelNotFoundException, nChannelAlreadySubscribedException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSelectorParserException, nNameAlreadyBoundException, nNameDoesNotExistException, nIllegalArgumentException {
        nEvent nEvent2;
        this.myWindowSize = n;
        this.validateNamedObjectOrigin(nDurable2);
        this.unAckedEventManager = new nUnAckedEventManager();
        nEventListener2 = nDurable2.wrapEventListener(nEventListener2, this.unAckedEventManager);
        nDurable2.registerUnackedEventManager(this.unAckedEventManager);
        this.myChannelList.addSub(nEventListener2, nMessageValidator2);
        this.setupListener(nEventListener2);
        this.myAutoAck = bl;
        this.myDurable = nDurable2;
        this.myNamedObject = nDurable2;
        if (nDurable2.isShared() || nDurable2.isSerial()) {
            this.isSharedNamedObject = true;
            this.myWindowSize = n;
        }
        nUserSubscribe nUserSubscribe2 = new nUserSubscribe(this.nca, n, string, nDurable2.getID(), this.myConnectionManager.getServerProvidedSessionID(), this.requestPurge, false);
        try {
            if (this.getTraceLogger().isTraceEnabled()) {
                String string2 = "Adding durable asynchronous subscriber. windowSize=" + n + ", selector=" + string + ", autoAck=" + bl + ", " + ClientEventTraceLoggerContext.addDurableInfo(nDurable2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager());
                this.getTraceLogger().trace(string2, CLASS_NAME);
            }
            nEvent2 = this.writeEvent(nUserSubscribe2);
        }
        catch (nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Session is not connected/paused failed to add durable asynchronous subscriber. requestId=" + nUserSubscribe2.getRequestId() + ", reason=" + nBaseClientException2.getMessage(), CLASS_NAME, nBaseClientException2);
            }
            this.tidyUpConnections();
            throw nBaseClientException2;
        }
        catch (nRequestTimedOutException nRequestTimedOutException2) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Timed out while adding asynchronous subscriber. requestId=" + nUserSubscribe2.getRequestId() + ", reason=" + nRequestTimedOutException2.getMessage(), CLASS_NAME, nRequestTimedOutException2);
            }
            try {
                this.removeSubscriber(false);
            }
            catch (Exception exception) {
                nConstants.logger.warn("Timed out while subscribing to channel " + this.nca.getName() + " and subscription cleanup failed: " + exception.getMessage(), exception);
            }
            this.tidyUpConnections();
            throw nRequestTimedOutException2;
        }
        if (nEvent2 instanceof nUserSubscribe) {
            this.mySelector = string;
            if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Asynchronous durable subscriber successfully added.", CLASS_NAME);
            }
            return;
        }
        this.tidyUpConnections();
        try {
            nExceptionEventProcessor.checkCommonExceptions(nEvent2);
            nExceptionEventProcessor.checkChannelAlreadySubscribed(nEvent2);
            nExceptionEventProcessor.checkSelectorParser(nEvent2);
            nExceptionEventProcessor.checkNameDoesNotExist(nEvent2);
            nExceptionEventProcessor.checkNameAlreadyBound(nEvent2);
            throw nChannelImpl.handleUnexpectedResponse(nEvent2, "addSubscriber");
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Failed to add asynchronous subscriber. requestId=" + nUserSubscribe2.getRequestId() + ", reason=" + exception.getMessage(), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    private void tidyUpConnections() {
        this.myChannelList.deleteSub();
        this.myAutoAck = false;
        this.myWindowSize = -1;
        this.myDurable = null;
    }

    public boolean isSubscribed() {
        return this.myChannelList.isSubscribed();
    }

    public void startSubscribers() {
        this.myChannelList.startSubscribers();
    }

    public void setPublicStore(nAbstractChannel nAbstractChannel2) {
        this.publicStore = nAbstractChannel2;
    }

    public void removeSubscriber() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.removeSubscriber(false);
    }

    public void removeSubscriber(boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        nRemoveSub nRemoveSub2 = new nRemoveSub(this.nca.getUniqueId(), this.getDurableId());
        nRemoveSub2.setSynchronous(bl);
        nEvent nEvent2 = this.writeEvent(nRemoveSub2);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Removing asynchronous subscriber. requestId=" + nRemoveSub2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager()), CLASS_NAME);
        }
        if (nEvent2 != null && nEvent2.getId() != 17) {
            nExceptionEventProcessor.checkSessionPausedException(nEvent2);
            nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
            nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
        }
        if (this.getTraceLogger().isInfoEnabled()) {
            String string = "Successful removal of asynchronous subscriber. requestId=" + nRemoveSub2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.getConnectionManager());
            this.getTraceLogger().info(string, CLASS_NAME);
        }
        this.tidyUpConnections();
        if (this.myNamedObject != null) {
            this.myNamedObject.unregisterUnackedEventManager(this.unAckedEventManager);
        }
    }

    protected String getName() {
        return this.nca.getName();
    }

    protected void addConnectionListener(nChannelConnectionListener nChannelConnectionListener2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        this.addConnectionListener(nChannelConnectionListener2, false);
    }

    protected void addConnectionListener(nChannelConnectionListener nChannelConnectionListener2, boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException, nIllegalArgumentException {
        if (nChannelConnectionListener2 != null) {
            if (this.myChannelList.containsListener(nChannelConnectionListener2)) {
                throw new nIllegalArgumentException("A Connection Listener is already bound");
            }
            this.myChannelList.addConnectionListener(nChannelConnectionListener2);
            nConnectionSubscribe nConnectionSubscribe2 = new nConnectionSubscribe(this.nca, true);
            nConnectionSubscribe2.setSynchronous(bl);
            nEvent nEvent2 = this.writeEvent(nConnectionSubscribe2);
            nExceptionEventProcessor.checkIllegalArgument(nEvent2);
            if (nEvent2 != null) {
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "Was not expecting any response to this request");
            }
        }
    }

    protected void removeConnectionListener(nChannelConnectionListener nChannelConnectionListener2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.myChannelList.delConnectionListener(nChannelConnectionListener2);
        if (!this.myChannelList.hasListeners()) {
            this.removeAllConnectionListener();
        }
    }

    protected void removeAllConnectionListener() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        this.myChannelList.delAllConnectionListener();
        nConnectionSubscribe nConnectionSubscribe2 = new nConnectionSubscribe(this.nca, false);
        this.writeEvent(nConnectionSubscribe2);
    }

    public nClientChannelList getChannelList() {
        return this.myChannelList;
    }

    protected int getType() {
        return this.nca.getType();
    }

    public void commitAllEventsUpToAndIncluding(long l, long l2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        nEvent nEvent2;
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalStateException("This queue object is obsolete please perform a findQueue and discard this object");
        }
        nQueueTransactionStatus nQueueTransactionStatus2 = nQueueTransactionStatus.createCommitEvent(this.nca, l, l2);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Committing all events up to including " + ClientEventTraceLoggerContext.eidFormat(l2) + ", readerUniqueId=" + l + ", requestId=" + nQueueTransactionStatus2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if ((nEvent2 = this.writeEvent(nQueueTransactionStatus2)) != null) {
            if (nEvent2.getId() != 90) {
                try {
                    nExceptionEventProcessor.checkIllegalStateException(nEvent2);
                    nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
                    nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
                    nExceptionEventProcessor.checkSessionPausedException(nEvent2);
                }
                catch (Exception exception) {
                    if (this.getTraceLogger().isWarnEnabled()) {
                        this.getTraceLogger().warn("Commit all events up to " + ClientEventTraceLoggerContext.eidFormat(l2) + " has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
                    }
                    throw exception;
                }
            } else if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Commit succeeded for all events up to " + ClientEventTraceLoggerContext.eidFormat(l2) + ". " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
        }
    }

    public void commitOnlyTheseEvents(long l, long[] lArray) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        nEvent nEvent2;
        if (lArray.length == 0) {
            return;
        }
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalStateException("This queue object is obsolete please perform a findQueue and discard this object");
        }
        nQueueTransactionStatus nQueueTransactionStatus2 = nQueueTransactionStatus.createCommitEvent(this.nca, l, lArray);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Committing only these events. readerUniqueId=" + l + ", requestId=" + nQueueTransactionStatus2.getRequestId() + ", " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if ((nEvent2 = this.writeEvent(nQueueTransactionStatus2)) != null) {
            if (nEvent2.getId() != 90) {
                try {
                    nExceptionEventProcessor.checkIllegalStateException(nEvent2);
                    nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
                    nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
                    nExceptionEventProcessor.checkSessionPausedException(nEvent2);
                }
                catch (Exception exception) {
                    if (this.getTraceLogger().isWarnEnabled()) {
                        this.getTraceLogger().warn("Commit specific events has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
                    }
                    throw exception;
                }
            } else if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Commit succeeded. " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
        }
    }

    public void rollbackAllEventsUpToAndIncluding(long l, long l2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        nEvent nEvent2;
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalStateException("This queue object is obsolete please perform a findQueue and discard this object");
        }
        nQueueTransactionStatus nQueueTransactionStatus2 = nQueueTransactionStatus.createRollbackEvent(this.nca, l, l2);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Rollback all events up to including " + ClientEventTraceLoggerContext.eidFormat(l2) + ", readerUniqueId=" + l + ", requestId=" + nQueueTransactionStatus2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if ((nEvent2 = this.writeEvent(nQueueTransactionStatus2)) != null) {
            if (nEvent2.getId() != 90) {
                try {
                    nExceptionEventProcessor.checkIllegalStateException(nEvent2);
                    nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
                    nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
                    nExceptionEventProcessor.checkSessionPausedException(nEvent2);
                }
                catch (Exception exception) {
                    if (this.getTraceLogger().isWarnEnabled()) {
                        this.getTraceLogger().warn("Rollback all events up to EID= " + l2 + " has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
                    }
                    throw exception;
                }
            } else if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Rollback succeeded for all events up to. " + ClientEventTraceLoggerContext.eidFormat(l2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
        }
    }

    public void rollbackOnlyTheseEvents(long l, long[] lArray) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        nEvent nEvent2;
        if (lArray.length == 0) {
            return;
        }
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalStateException("This queue object is obsolete please perform a findQueue and discard this object");
        }
        nQueueTransactionStatus nQueueTransactionStatus2 = nQueueTransactionStatus.createRollbackEvent(this.nca, l, lArray);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Rollback only these events. readerUniqueId=" + l + ", requestId=" + nQueueTransactionStatus2.getRequestId() + ", " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if ((nEvent2 = this.writeEvent(nQueueTransactionStatus2)) != null) {
            if (nEvent2.getId() != 90) {
                try {
                    nExceptionEventProcessor.checkIllegalStateException(nEvent2);
                    nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
                    nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
                    nExceptionEventProcessor.checkSessionPausedException(nEvent2);
                }
                catch (Exception exception) {
                    if (this.getTraceLogger().isWarnEnabled()) {
                        this.getTraceLogger().warn("Rollback specific events has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
                    }
                    throw exception;
                }
            } else if (this.getTraceLogger().isInfoEnabled()) {
                this.getTraceLogger().info("Rollback succeeded." + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
        }
    }

    public void sendNamedAck(long[] lArray, long l, boolean bl, boolean bl2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalArgumentException {
        nEvent nEvent2;
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalArgumentException("This channel object is obsolete please perform a findChannel and discard this object");
        }
        nAckEvent nAckEvent2 = new nAckEvent(this.nca, -1L, l, lArray, bl2, true);
        nAckEvent2.setSynchronous(bl);
        if (this.getTraceLogger().isTraceEnabled()) {
            this.getTraceLogger().trace("Sending named ack. nameId=" + l + ", isSynchronous=" + bl + ", isAckIndividual=" + bl2 + ", requestId=" + nAckEvent2.getRequestId() + ", " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if ((nEvent2 = this.writeEvent(nAckEvent2)) instanceof nExceptionEvent) {
            nExceptionEvent nExceptionEvent2 = (nExceptionEvent)nEvent2;
            nConstants.logger.fatal(nExceptionFactory.getException(nExceptionEvent2.getExceptionId(), nExceptionEvent2.getMessage()));
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Named ack has failed. reason=" + nExceptionEvent2.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, nExceptionFactory.getException(nExceptionEvent2.getExceptionId(), nExceptionEvent2.getMessage()));
            }
            return;
        }
        try {
            nExceptionEventProcessor.checkSessionPausedException(nAckEvent2);
            nExceptionEventProcessor.checkRequestTimeoutException(nAckEvent2);
            nExceptionEventProcessor.checkSessionNotConnectedException(nAckEvent2);
            nExceptionEventProcessor.checkIllegalArgument(nAckEvent2);
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Named ack has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
            }
            throw exception;
        }
        if (this.getTraceLogger().isInfoEnabled()) {
            this.getTraceLogger().info("Named ack succeeded. " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        if (lArray.length > 0) {
            this.myLastAck = lArray[lArray.length - 1];
        }
    }

    public void sendNamedRollback(long[] lArray, long l, boolean bl, boolean bl2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalArgumentException {
        if (this.myChannelList.isDeleted()) {
            throw new nIllegalArgumentException("This channel object is obsolete please perform a findChannel and discard this object");
        }
        nAckEvent nAckEvent2 = new nAckEvent(this.nca, -1L, l, lArray, bl2, false);
        nAckEvent2.setSynchronous(bl);
        if (this.getTraceLogger().isInfoEnabled()) {
            this.getTraceLogger().info("Sending named rollback. nameId=" + l + ", isSynchronous=" + bl + ", isIndividual=" + bl2 + ",requestId=" + nAckEvent2.getRequestId() + ", " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        try {
            this.writeEvent(nAckEvent2);
        }
        catch (Exception exception) {
            if (this.getTraceLogger().isWarnEnabled()) {
                this.getTraceLogger().warn("Named rollback has failed. reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    static nUnexpectedResponseException handleUnexpectedResponse(nEvent nEvent2, String string) {
        if (nEvent2 != null) {
            if (nEvent2 instanceof nExceptionEvent) {
                return new nUnexpectedResponseException(string + " " + nEvent2.getClass().getName() + " [" + ((nExceptionEvent)nEvent2).getExceptionId() + "]: " + ((nExceptionEvent)nEvent2).getMessage());
            }
            return new nUnexpectedResponseException(string + " " + nEvent2.getClass().getName() + " " + nEvent2.toString());
        }
        return new nUnexpectedResponseException(string);
    }

    public nConsumeEvent convertPublishedToConsumeEvent(nPublished nPublished2) {
        return nConsumeEventConverter.nPublishedTonConsumeEvent(nPublished2);
    }

    public fEventDictionary getBaseDictionary(nEventProperties nEventProperties2) {
        return nEventProperties2.getBaseDictionary();
    }

    public boolean isQueue() {
        return this.myChannelList.isQueue();
    }

    private void validateNamedObjectOrigin(nDurable nDurable2) throws nIllegalArgumentException {
        if (!nDurable2.getChannel().equals(this)) {
            throw new nIllegalArgumentException("This named object is not valid for use with this channel object");
        }
    }

    ClientConnectionManager getConnectionManager() {
        return this.myConnectionManager;
    }
}

