/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.nChannelIteratorManager;
import com.pcbsys.nirvana.base.events.nAckEvent;
import com.pcbsys.nirvana.base.events.nChannelIterate;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nRuntime;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.RequestTimeoutHelper;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nRealmNotFoundException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSelectorParserException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class nChannelIterator {
    private static final String CLASS_NAME = nChannelIterator.class.getSimpleName();
    public static final int INFINITE_WINDOW = 0;
    public static final int INFINITE_WINDOW_NEW_DURABLE = Integer.MAX_VALUE;
    protected static final int SERVER_PROVIDED_WINDOW = -1;
    private static final AtomicLong sUniqueId = new AtomicLong(0L);
    protected final long myUniqueId;
    private final long myStartEID;
    protected final long myNamedId;
    private final int maxUnackedEvents;
    protected final boolean autoAck;
    protected final String mySelector;
    protected final nChannel myChannel;
    protected final long myChannelUniqueIdentifier;
    protected final nDurable myNamedObject;
    protected final nUnAckedEventManager myUnackedEventManager;
    private final nChannelIteratorManager myChannelIteratorManager;
    protected final List<nPublished> myWindow = new ArrayList<nPublished>();
    protected boolean firstReq = true;
    protected boolean isClosed = false;
    protected long currentIdx;

    protected nChannelIterator(nChannel nChannel2, long l, String string, nDurable nDurable2, boolean bl, int n) {
        if (nDurable2 != null) {
            this.myUnackedEventManager = new nUnAckedEventManager();
            nDurable2.registerUnackedEventManager(this.myUnackedEventManager);
        } else {
            this.myUnackedEventManager = null;
        }
        this.myStartEID = l;
        this.myChannel = nChannel2;
        this.myChannelUniqueIdentifier = this.myChannel.getBaseAttributes().getUniqueId();
        this.currentIdx = l - 1L;
        this.mySelector = string;
        this.autoAck = bl;
        this.myUniqueId = nChannelIterate.generateIteratorUniqueId(this.myChannel.getConnectionManager().getServerProvidedSessionID(), sUniqueId.incrementAndGet());
        this.myNamedObject = nDurable2;
        this.myNamedId = nDurable2 != null ? nDurable2.getID() : -1L;
        this.maxUnackedEvents = n;
        this.myChannelIteratorManager = this.myChannel.getConnectionManager().getChannelIteratorManager();
        this.myChannelIteratorManager.put(this);
        nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, this.myStartEID, 0L, 5, this.mySelector, this.myNamedId, this.myUniqueId, this.autoAck);
        nChannelIterate2.setMaxUnackedEvents(n);
        if (nChannel2.getTraceLogger().isInfoEnabled()) {
            nChannel2.getTraceLogger().info("Creating an iterator. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        try {
            this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
        }
        catch (nRequestTimedOutException | nSessionNotConnectedException | nSessionPausedException nBaseClientException2) {
            // empty catch block
        }
    }

    public boolean hasEventsCached() {
        if (!this.myWindow.isEmpty()) {
            return true;
        }
        return this.myChannelIteratorManager.hasMessagesWaiting(this.myChannelUniqueIdentifier, this.myUniqueId);
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (!this.myChannel.isStoreObjectInvalid()) {
            nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, 0L, 0L, 6, null, this.myNamedId, this.myUniqueId, this.autoAck);
            if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                this.myChannel.getTraceLogger().info("Closing iterator. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()) + ", unackedEvents={" + ClientEventTraceLoggerContext.addPubEventsInfo(this.myWindow) + "}", CLASS_NAME);
            }
            try {
                this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myWindow.clear();
        this.myChannelIteratorManager.remove(this);
        if (this.myNamedObject != null) {
            this.myNamedObject.unregisterUnackedEventManager(this.myUnackedEventManager);
        }
    }

    protected void reconnect() {
        nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, this.currentIdx, 0L, 5, this.mySelector, this.myNamedId, this.myUniqueId, this.autoAck);
        this.handleWindowSize(nChannelIterate2);
        try {
            nChannelIterate2.setSynchronous(false);
            if (this.myChannel.getTraceLogger().isTraceEnabled()) {
                this.myChannel.getTraceLogger().trace("Reconnecting iterator. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ack(long l) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        this.ack(l, false, true);
    }

    public synchronized void ack(long l, boolean bl, boolean bl2) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        this.checkIllegalState();
        if (this.autoAck) {
            return;
        }
        if (this.myNamedObject != null) {
            long[] lArray;
            if (this.myUnackedEventManager != null) {
                lArray = this.myUnackedEventManager.getEIDs(l, bl2);
            } else {
                long[] lArray2 = new long[1];
                lArray = lArray2;
                lArray2[0] = l;
            }
            long[] lArray3 = lArray;
            if (this.myChannel.getTraceLogger().isTraceEnabled()) {
                this.myChannel.getTraceLogger().trace("Iterator channel named ack invoked. EID=" + l + ", isIndividualAck=" + bl + ", ackPrevious=" + bl2 + ", iteratorId=" + this.myUniqueId + ClientEventTraceLoggerContext.addDurableInfo(this.myNamedObject), CLASS_NAME);
            }
            try {
                this.myChannel.getChannel().sendNamedAck(lArray3, this.myNamedId, true, bl);
            }
            catch (nIllegalArgumentException nIllegalArgumentException2) {
                throw new nUnexpectedResponseException("This channel object is obsolete please perform a findChannel and discard this object", nIllegalArgumentException2);
            }
            if (this.myUnackedEventManager != null) {
                this.myUnackedEventManager.commit(lArray3);
            }
        } else {
            nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, l, 0L, 7, this.mySelector, this.myNamedId, this.myUniqueId, false);
            if (this.myChannel.getTraceLogger().isTraceEnabled()) {
                this.myChannel.getTraceLogger().trace("Iterator channel ack invoked. EID=" + l + ", isIndividualAck=" + bl + ", ackPrevious=" + bl2 + ", iteratorId=" + this.myUniqueId + ", requestId=" + nChannelIterate2.getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
            try {
                this.handleResponse(nEvent2);
            }
            catch (Exception exception) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Iterator channel ack has failed. reason=" + exception.getMessage(), CLASS_NAME, exception);
                }
                throw exception;
            }
        }
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public synchronized void rollback() throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nRealmNotFoundException, nSecurityException, nUnexpectedResponseException, nChannelNotFoundException, nSelectorParserException {
        this.rollback(Long.MAX_VALUE);
    }

    public synchronized void rollback(long l) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nRealmNotFoundException, nSecurityException, nUnexpectedResponseException, nChannelNotFoundException, nSelectorParserException {
        if (this.myChannel.isStoreObjectInvalid() || this.myNamedObject == null || !this.myNamedObject.isShared() && !this.myNamedObject.isSerial()) {
            return;
        }
        long[] lArray = this.myUnackedEventManager.getEIDs(l, true);
        if (lArray.length == 0) {
            return;
        }
        nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, 8, this.myNamedObject.getID(), this.myUniqueId, lArray);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Channel iterator rollback invoked. iteratorId=" + this.myUniqueId + ", nameId=" + this.myNamedObject.getID() + ", requestId=" + nChannelIterate2.getRequestId() + ", " + ClientEventTraceLoggerContext.eidFormat(lArray) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
        try {
            this.handleResponse(nEvent2);
        }
        catch (Exception exception) {
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Channel iterator rollback failed. reason=" + exception.getMessage(), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    public synchronized nConsumeEvent getFirst() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        return this.processRequest(0, this.myStartEID);
    }

    public synchronized nConsumeEvent getLast() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        return this.processRequest(1, this.myStartEID);
    }

    public synchronized nConsumeEvent getPrev() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        if (this.firstReq) {
            ++this.currentIdx;
        }
        return this.processRequest(3, this.currentIdx);
    }

    private nConsumeEvent processRequest(int n, long l) throws nUnexpectedResponseException, nRealmNotFoundException, nSecurityException, nChannelNotFoundException, nSelectorParserException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        if (this.firstReq) {
            this.firstReq = false;
        }
        this.checkIllegalState();
        this.myWindow.clear();
        nChannelIterate nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, l, 0L, n, this.mySelector, this.myNamedId, this.myUniqueId, this.autoAck);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Channel iterator sending request to server. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nChannelIterate2);
        this.handleResponse(nEvent2);
        return this.getPublishedEvent();
    }

    public nConsumeEvent getNext() throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        try {
            return this.getNext(-1L);
        }
        catch (nRequestTimedOutException nRequestTimedOutException2) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nConsumeEvent getNext(long l) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nRealmNotFoundException, nUnexpectedResponseException, nSelectorParserException {
        nChannelIterate nChannelIterate2;
        this.checkIllegalState();
        if (this.myChannel.getTraceLogger().isTraceEnabled()) {
            this.myChannel.getTraceLogger().trace("Channel iterator getNext invoked. iteratorId=" + nChannelIterate.generateIteratorUniqueId(this.myChannel.getConnectionManager().getServerProvidedSessionID(), this.myUniqueId) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nChannelIterator nChannelIterator2 = this;
        synchronized (nChannelIterator2) {
            nConsumeEvent nConsumeEvent2;
            if (this.firstReq) {
                this.firstReq = false;
            }
            if ((nConsumeEvent2 = this.getPublishedEvent()) != null) {
                if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                    this.myChannel.getTraceLogger().info("Iterator retrieved event from client window. iteratorId=" + nChannelIterate.generateIteratorUniqueId(this.myChannel.getConnectionManager().getServerProvidedSessionID(), this.myUniqueId) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()) + ", event=" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2), CLASS_NAME);
                }
                return nConsumeEvent2;
            }
            nChannelIterate2 = new nChannelIterate(this.myChannelUniqueIdentifier, this.currentIdx, l, 2, this.mySelector, this.myNamedId, this.myUniqueId, this.autoAck);
            this.handleWindowSize(nChannelIterate2);
        }
        long l2 = fTimer.getTicks();
        nEvent nEvent2 = null;
        try {
            if (this.myChannel.getTraceLogger().isTraceEnabled()) {
                this.myChannel.getTraceLogger().trace("Iterator requesting new event from server. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            nEvent2 = this.myChannel.getBaseChannel().writeEvent(nChannelIterate2, RequestTimeoutHelper.getResetTimeout(l));
            if (fTimer.getTicks() - l2 > RequestTimeoutHelper.getDelayTimeout(l)) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Channel iterate event is delayed. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()) + ", elapsedTime=" + (fTimer.getTicks() - l2), CLASS_NAME);
                }
                nConstants.logger.fatal("Channel Iterator> Channel iterate event with ID " + nChannelIterate2.getRequestId() + " is delayed for channel " + this.myChannel.getName() + ", session ID " + Long.toHexString(this.myChannel.getConnectionManager().getServerProvidedSessionID()) + ", connection " + this.myChannel.getConnectionManager().getLocalHostAndPort() + ", elapsed time ms " + (fTimer.getTicks() - l2));
            }
        }
        catch (nRequestTimedOutException nRequestTimedOutException2) {
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Resetting client connection because channel iterate timed out. " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME, nRequestTimedOutException2);
            }
            nConstants.logger.fatal("Channel Iterator> Resetting client connection because request with ID " + nChannelIterate2.getRequestId() + " timed out for channel " + this.myChannel.getName() + ", session ID " + Long.toHexString(this.myChannel.getConnectionManager().getServerProvidedSessionID()) + ", connection " + this.myChannel.getConnectionManager().getLocalHostAndPort());
            this.myChannel.getConnectionManager().resetConnection();
        }
        nChannelIterator nChannelIterator3 = this;
        synchronized (nChannelIterator3) {
            this.handleResponse(nEvent2);
            nConsumeEvent nConsumeEvent3 = this.getPublishedEvent();
            if (nConsumeEvent3 != null) {
                if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                    this.myChannel.getTraceLogger().info("Returning nConsumeEvent to client. event={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent3) + "}" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
                }
                return nConsumeEvent3;
            }
            if (l <= 0L) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Timed out on getNext request . {" + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
                }
                return null;
            }
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Channel iterate time out exceeded. {" + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            throw new nRequestTimedOutException("Time out exceeded : " + l);
        }
    }

    protected void handleWindowSize(nChannelIterate nChannelIterate2) {
        boolean bl;
        boolean bl2 = bl = this.myNamedObject != null && (this.myNamedObject.isShared() || this.myNamedObject.isSerial()) && this.maxUnackedEvents != -1;
        if (bl) {
            nChannelIterate2.setMaxUnackedEvents(this.maxUnackedEvents);
        }
    }

    protected void handleResponse(nEvent nEvent2) throws nSecurityException, nUnexpectedResponseException, nSelectorParserException, nRealmNotFoundException, nChannelNotFoundException, nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException {
        if (nEvent2 == null) {
            return;
        }
        if (this.isClosed) {
            try {
                nPublished nPublished2 = null;
                if (nEvent2 instanceof nChannelIterate) {
                    nPublished2 = ((nChannelIterate)nEvent2).getEvent();
                } else if (nEvent2 instanceof nPopQueue) {
                    nPublished2 = ((nPopQueue)nEvent2).getEvent();
                }
                if (nPublished2 != null && nPublished2.getEID() != -1L) {
                    this.rollback(nPublished2.getEID());
                }
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                nConstants.logger.warn("Iterator closed, request timed out when trying to rollback events.");
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            }
            catch (nSessionPausedException nSessionPausedException2) {
                nConstants.logger.warn("Session has been paused after iterator is closed.");
            }
            catch (Exception exception) {
                nConstants.logger.warn("Iterator closed, exception was raised.", exception);
            }
            return;
        }
        if (nEvent2.getId() == 89) {
            nChannelIterate nChannelIterate2 = (nChannelIterate)nEvent2;
            if (nChannelIterate2.getCommand() == 8) {
                if (this.myUnackedEventManager != null) {
                    this.myUnackedEventManager.commit(nChannelIterate2.getAckEvents());
                }
            } else if (nChannelIterate2.getEvents() != null) {
                if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                    this.myChannel.getTraceLogger().info("Channel Iterate request successful. Received " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2), CLASS_NAME);
                }
                this.myWindow.addAll(nChannelIterate2.getEvents());
            } else {
                nPublished nPublished3 = nChannelIterate2.getEvent();
                if (nPublished3 != null) {
                    if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                        this.myChannel.getTraceLogger().info("Channel Iterate getNext request successful. Received " + ClientEventTraceLoggerContext.addChannelIterateInfo(nChannelIterate2), CLASS_NAME);
                    }
                    this.myWindow.add(nPublished3);
                }
            }
        } else if (nEvent2.getId() == 33) {
            nPopQueue nPopQueue2;
            nPublished nPublished4;
            if (nRuntime.sDevelopersBuild) {
                nConstants.logger.log(new Exception("We should not have received a nPopQueue in a channel iterator"));
            }
            if ((nPublished4 = (nPopQueue2 = (nPopQueue)nEvent2).getEvent()) != null) {
                this.myWindow.add(nPublished4);
            }
        } else if (nEvent2.getId() == 86) {
            if (this.myUnackedEventManager != null) {
                this.myUnackedEventManager.commit(((nAckEvent)nEvent2).getEIDs());
            }
        } else {
            try {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                try {
                    nExceptionEventProcessor.checkChannelNotFound(nEvent2);
                }
                catch (nChannelNotFoundException nChannelNotFoundException2) {
                    nConstants.logger.log("Can not locate channel : " + this.myChannel.getName());
                    throw nChannelNotFoundException2;
                }
                nExceptionEventProcessor.checkSessionPausedException(nEvent2);
                nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
                nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
                nExceptionEventProcessor.checkRealmNotFound(nEvent2);
                nExceptionEventProcessor.checkSelectorParser(nEvent2);
                nConstants.logger.log("nChannelIterator received a response from an unexpected type: " + nEvent2.getClass().getName());
                throw new nUnexpectedResponseException("channelIterator - " + nEvent2.getClass().getName());
            }
            catch (Exception exception) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Channel iterate getNext request failed. reason=" + exception.getMessage(), CLASS_NAME, exception);
                }
                throw exception;
            }
        }
    }

    private synchronized nConsumeEvent getPublishedEvent() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        if (this.myWindow.size() > 0) {
            nPublished nPublished2 = this.myWindow.remove(0);
            this.currentIdx = nPublished2.getEID();
            nConsumeEvent nConsumeEvent2 = nConsumeEventConverter.nPublishedTonConsumeEvent(nPublished2);
            nConsumeEvent2.setChannel(this.myChannel.getBaseChannel());
            nConsumeEvent2.setDurable(this.myNamedObject);
            if (!this.autoAck && this.myUnackedEventManager != null) {
                this.myUnackedEventManager.receivedEvent(nConsumeEvent2);
            } else {
                this.checkForAutoAck(nConsumeEvent2);
            }
            return nConsumeEvent2;
        }
        return null;
    }

    private void checkForAutoAck(nConsumeEvent nConsumeEvent2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnexpectedResponseException {
        if (this.isAutoAck() && this.myNamedObject != null && (this.myNamedObject.isShared() || this.myNamedObject.isSerial())) {
            long[] lArray = new long[]{nConsumeEvent2.getEventID()};
            if (this.myChannel.getTraceLogger().isTraceEnabled()) {
                this.myChannel.getTraceLogger().trace("Auto acknowledging event on iterator. iteratorId=" + this.myUniqueId + ", " + ClientEventTraceLoggerContext.eidFormat(lArray[0]) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            try {
                this.myChannel.getChannel().sendNamedAck(lArray, this.myNamedId, false, true);
            }
            catch (nIllegalArgumentException nIllegalArgumentException2) {
                throw new nUnexpectedResponseException("This channel object is obsolete please perform a findChannel and discard this object", nIllegalArgumentException2);
            }
        }
    }

    private void checkIllegalState() throws nUnexpectedResponseException {
        if (this.myChannel.isStoreObjectInvalid()) {
            throw new nUnexpectedResponseException("This channel object is obsolete please perform a findChannel and discard this object", new nIllegalStateException("This channel object is obsolete please perform a findChannel and discard this object"));
        }
    }
}

