/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.collections.multiq.fPriorityQueueFactory;
import com.pcbsys.foundation.drivers.jdk.fDefaultSocketHelper;
import com.pcbsys.foundation.drivers.proxy.fAuthFactory;
import com.pcbsys.foundation.filters.fEventRuleConstants;
import com.pcbsys.foundation.io.fConnectionSettings;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.logger.fLogging;
import com.pcbsys.foundation.logger.fLoggingFactory;
import com.pcbsys.foundation.logger.storelogger.StoreLogConfigLevel;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.threads.fThread;
import com.pcbsys.foundation.utils.StringUtils;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nProxyAuthenticatorHelper;

public class nConstants {
    static final fLogging logger = fLoggingFactory.getLogger(nConstants.class.getPackage().getName());
    public static final int sStandardWriteHandler = 3;
    public static final int sDirectWriteHandler = 2;
    public static final int sQueuedWriteHandler = 1;
    public static final long CHAN_DELETED_EVENT_ID = -2L;
    private static int maxUnackedEvents = -1;
    static final long NON_EXISTING_EVENT_ID = -1L;
    static final long START_EVENT_ID = -1L;

    public static void setWriteHandlerType(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                fConnectionSettings.sMyWriteHandlerType = n;
                break;
            }
        }
    }

    public static void honour3rdPartyCookies(boolean bl) {
        fConnectionSettings.setHonour3rdPartyCookies(bl);
    }

    public static boolean isHonouring3rdPartyCookies() {
        return fConnectionSettings.getHonour3rdPartyCookies();
    }

    public static int getWriteHandlerType() {
        return fConnectionSettings.sMyWriteHandlerType;
    }

    public static int getInitialConnectionTimeout() {
        return com.pcbsys.nirvana.base.nConstants.getInitialConnectionTimeout();
    }

    public static void setInitialConnectionTimeout(int n) {
        com.pcbsys.nirvana.base.nConstants.setInitialConnectionTimeout(n);
    }

    public static long getEVENTWAIT() {
        return com.pcbsys.nirvana.base.nConstants.getEVENTWAIT();
    }

    public static void setEVENTWAIT(long l) {
        com.pcbsys.nirvana.base.nConstants.setEVENTWAIT(l);
    }

    public static void setKeepAliveInterval(long l) {
        com.pcbsys.nirvana.base.nConstants.setKeepAliveInterval(l);
    }

    public static long getKeepAliveInterval() {
        return com.pcbsys.nirvana.base.nConstants.getKeepAliveInterval();
    }

    public static int getSubLowWater() {
        return com.pcbsys.nirvana.base.nConstants.getSubLowWater();
    }

    public static void setSubLowWater(int n) {
        com.pcbsys.nirvana.base.nConstants.setSubLowWater(n);
    }

    public static int getSubHighWater() {
        return com.pcbsys.nirvana.base.nConstants.getSubHighWater();
    }

    public static void setSubHighWater(int n) {
        com.pcbsys.nirvana.base.nConstants.setSubHighWater(n);
    }

    public static int getConnectionQueueHighWater() {
        return com.pcbsys.nirvana.base.nConstants.getConnectionQueueHighWater();
    }

    public static void setConnectionQueueHighWater(int n) {
        com.pcbsys.nirvana.base.nConstants.setConnectionQueueHighWater(n);
    }

    public static int getConnectionQueueLowWater() {
        return com.pcbsys.nirvana.base.nConstants.getConnectionQueueLowWater();
    }

    public static void setConnectionQueueLowWater(int n) {
        com.pcbsys.nirvana.base.nConstants.setConnectionQueueLowWater(n);
    }

    public static int getConnectionBlockWeighting() {
        return com.pcbsys.nirvana.base.nConstants.getConnectionBlockWeighting();
    }

    public static void setConnectionBlockWeighting(int n) {
        com.pcbsys.nirvana.base.nConstants.setConnectionBlockWeighting(n);
    }

    public static void setBlockLimit(int n) {
        com.pcbsys.nirvana.base.nConstants.setBlockLimit(n);
    }

    public static void setAccessWaitLimit(int n) {
        com.pcbsys.nirvana.base.nConstants.setAccessWaitLimit(n);
    }

    public static void setPushWaitLimit(int n) {
        com.pcbsys.nirvana.base.nConstants.setPushWaitLimit(n);
    }

    public static int getPushWaitLimit() {
        return com.pcbsys.nirvana.base.nConstants.getPushWaitLimit();
    }

    public static int getAccessWaitLimit() {
        return com.pcbsys.nirvana.base.nConstants.getAccessWaitLimit();
    }

    public static int getBlockLimit() {
        return com.pcbsys.nirvana.base.nConstants.getBlockLimit();
    }

    public static void setClientLogLevel(int n) {
        logger.setLogLevel(fLogLevel.valueFrom(n));
    }

    public static void enableDebug(boolean bl) {
        logger.setLogLevel(fLogLevel.DEBUG);
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static boolean attemptReconnectAfterAccessChange() {
        return com.pcbsys.nirvana.base.nConstants.doReconnectAfterACLRevoked();
    }

    public static void setReconnectAfterAccessChange(boolean bl) {
        com.pcbsys.nirvana.base.nConstants.setReconnectAfterACLRevoked(bl);
    }

    public static boolean attemptReconnectImmediately() {
        return com.pcbsys.nirvana.base.nConstants.getReconnectImmediately();
    }

    public static void setReconnectImmediately(boolean bl) {
        com.pcbsys.nirvana.base.nConstants.setReconnectImmediately(bl);
    }

    public static long getReconnectInterval() {
        return com.pcbsys.nirvana.base.nConstants.getReconnectInterval();
    }

    public static void setReconnectInterval(long l) {
        com.pcbsys.nirvana.base.nConstants.setReconnectInterval(l);
    }

    public static void setDefaultStoreCapacity(int n) {
        com.pcbsys.nirvana.base.nConstants.DEFAULT_STORE_CAPACITY = n;
    }

    public static void setDefaultStoreTTL(int n) {
        com.pcbsys.nirvana.base.nConstants.DEFAULT_STORE_TTL = n;
    }

    public static void setPermittedKeepAlivesMissed(int n) {
        com.pcbsys.nirvana.base.nConstants.setPermittedKeepAlivesMissed(n);
    }

    public static void setProxyAuthenticatorHelper(nProxyAuthenticatorHelper nProxyAuthenticatorHelper2) {
        fAuthFactory.setUserAuthenticationCallback(nProxyAuthenticatorHelper2);
    }

    public static nProxyAuthenticatorHelper getProxyAuthenticatorHelper() {
        return (nProxyAuthenticatorHelper)fAuthFactory.getUserAuthenticationCallback();
    }

    public static void setCertificateAlias(String string) {
        fConnectionSettings.sCertificateAlias = string;
    }

    public static void resetCertificateAlias() {
        fConnectionSettings.sCertificateAlias = "";
    }

    @Deprecated
    public static void setDataGroupQueueSize(int n) {
    }

    @Deprecated
    public static int getDataGroupQueueSize() {
        return -1;
    }

    public static void setSocketReceiveBufferSize(int n) {
        fDefaultSocketHelper.defaultReceiveBufferSize = n;
    }

    public static void setSocketSendBufferSize(int n) {
        fDefaultSocketHelper.defaultSendBufferSize = n;
    }

    public static int getSocketReceiveBufferSize() {
        return fDefaultSocketHelper.defaultReceiveBufferSize;
    }

    public static int getSocketSendBufferSize() {
        return fDefaultSocketHelper.defaultSendBufferSize;
    }

    @Deprecated
    public static void setEnabledPriorityQueues(boolean bl) {
    }

    @Deprecated
    public static boolean getEnabledPriorityQueues() {
        return false;
    }

    public static void setPriorityQueueCount(int n) {
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException();
        }
        fPriorityQueueFactory.sPriorityQueueNumber = n;
    }

    public static int getPriorityQueueCount() {
        if (nConstants.getEnabledPriorityQueues()) {
            return fPriorityQueueFactory.sPriorityQueueNumber;
        }
        return 0;
    }

    public static void setThreadReuseQueueSize(int n) {
        fThread.sMyReuseSize = n;
    }

    public static int getThreadReuseQueueSize() {
        return fThread.sMyReuseSize;
    }

    public static void setMaxUnackedEvents(int n) {
        maxUnackedEvents = n;
    }

    public static int getMaxUnackedEvents() {
        return maxUnackedEvents;
    }

    public static void setEnableAutoGC(boolean bl) {
        fMemoryManager.getInstance().setEnableGC(bl);
    }

    public static boolean getEnableAutoGC() {
        return fMemoryManager.getInstance().isEnableGC();
    }

    public static void setSupportExtendedFiltering(boolean bl) {
        fEventRuleConstants.setSupportExtended(bl);
    }

    public static boolean getSupportExtendedFiltering() {
        return fEventRuleConstants.canSupportExtended();
    }

    @Deprecated
    public static boolean allowStoreCaching() {
        return true;
    }

    @Deprecated
    public static boolean stripJMSMessageIdPrefix() {
        return false;
    }

    public static void setTraceStores(String string) {
        ClientEventTraceLoggerContext.getInstance().setEnabledStores(string);
    }

    public static void setTraceLoggerPath(String string) throws nIllegalArgumentException {
        if (StringUtils.isEmpty(string)) {
            throw new nIllegalArgumentException("Provided trace log path cannot be empty : " + string);
        }
        ClientEventTraceLoggerContext.getInstance().setLogPath(string);
    }

    public static void setTraceStoreLogLevel(StoreLogConfigLevel storeLogConfigLevel) throws IllegalStateException {
        ClientEventTraceLoggerContext.getInstance().setLogLevel(storeLogConfigLevel);
    }

    public static void setTraceStoreLogSize(int n) throws nIllegalArgumentException {
        ClientEventTraceLoggerContext clientEventTraceLoggerContext = ClientEventTraceLoggerContext.getInstance();
        if (n != clientEventTraceLoggerContext.getSingleLogSize()) {
            try {
                clientEventTraceLoggerContext.setSingleLogSize(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new nIllegalArgumentException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }

    public static void setTraceFolderLogSize(int n) throws nIllegalArgumentException {
        ClientEventTraceLoggerContext clientEventTraceLoggerContext = ClientEventTraceLoggerContext.getInstance();
        if (n != clientEventTraceLoggerContext.getGlobalLogSize()) {
            try {
                clientEventTraceLoggerContext.setGlobalLogSize(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new nIllegalArgumentException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

