/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.base.fStringEntry;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.foundation.utils.xmlHelper;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nHeader;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventFactory;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nMaxBufferSizeExceededException;
import com.pcbsys.nirvana.client.nMessageSigner;
import com.pcbsys.nirvana.client.nProtobufEventFactory;
import com.pcbsys.nirvana.client.nSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class nConsumeEventConverter {
    private static final Object subHelper_lock = new Object();
    private static final Object pubHelper_lock = new Object();
    private static final int sCompressionThreshold;
    private static final boolean sCompressionEnabled;
    private static final boolean sCloneDictionary;
    private static xmlHelper subHelper;
    private static xmlHelper pubHelper;
    private static final boolean shouldGenerateUUID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static nPublished nConsumeEventToPublishRequest(nConsumeEvent nConsumeEvent2, nMessageSigner nMessageSigner2, long l, ClientConnectionManager clientConnectionManager) throws nSecurityException, nMaxBufferSizeExceededException {
        Object object;
        Object object2;
        byte by = 0;
        if (nConsumeEvent2.isDom()) {
            by = 1;
            object2 = pubHelper_lock;
            synchronized (object2) {
                if (pubHelper == null) {
                    pubHelper = new xmlHelper();
                }
                nConsumeEvent2.encodeDomToBytes(pubHelper);
            }
        }
        object2 = null;
        if (nConsumeEvent2.getProperties() != null) {
            if (sCloneDictionary) {
                object2 = new fEventDictionary();
                ((fEventDictionary)object2).copy(nConsumeEvent2.getProperties().myDictionary, true);
            } else {
                object2 = nConsumeEvent2.getProperties().myDictionary;
            }
        }
        byte[] byArray = null;
        String string = nConsumeEvent2.getEventTag();
        if (string != null) {
            try {
                byArray = fStringByteConverter.convert(string);
            }
            catch (Exception exception) {
                byArray = string.getBytes();
            }
        }
        byte[] byArray2 = null;
        if (nMessageSigner2 != null) {
            try {
                byArray2 = nConsumeEvent2.sign(nMessageSigner2);
                by = (byte)(by | 8);
            }
            catch (Exception exception) {
                throw new nSecurityException(exception.getMessage());
            }
        }
        byte[] byArray3 = nConsumeEvent2.getEventData();
        if (sCompressionEnabled && byArray3 != null && (byArray3 = nConsumeEventConverter.compress(nConsumeEvent2.getEventData())).length != nConsumeEvent2.getEventData().length) {
            object = nConsumeEvent2.getHeader();
            if (object == null) {
                object = new nHeader();
                nConsumeEvent2.setHeader((nHeader)object);
            }
            ((nHeader)object).setCompressed(true);
        }
        object = nConsumeEventConverter.generateUniqueTag(nConsumeEvent2, byArray);
        nPublished nPublished2 = new nPublished(l, (byte[])object, byArray3, by, null, nConsumeEvent2.getTTL(), nConsumeEvent2.isPersistant(), byArray2);
        nPublished2.setTransient(nConsumeEvent2.isTransient());
        nPublished2.setHeader(nConsumeEvent2.getHeader());
        nPublished2.setDictionary((fEventDictionary)object2);
        nConsumeEventConverter.checkPublishedAgainstMBS(nPublished2, clientConnectionManager);
        return nPublished2;
    }

    private static byte[] generateUniqueTag(nConsumeEvent nConsumeEvent2, byte[] byArray) {
        if (shouldGenerateUUID) {
            fEventDictionary fEventDictionary2;
            fEventDictionary fEventDictionary3 = fEventDictionary2 = nConsumeEvent2.getProperties() != null ? nConsumeEvent2.getProperties().myDictionary : null;
            if (!(nConsumeEvent2.getHeader() != null && nConsumeEvent2.getHeader().getMessageId() != null || fEventDictionary2 != null && fEventDictionary2.containsKey("uuid") || byArray != null && byArray.length != 0)) {
                return fStringByteConverter.convert(UUID.randomUUID().toString());
            }
        }
        return byArray;
    }

    private static byte[] compress(byte[] byArray) {
        if (sCompressionEnabled && byArray.length > sCompressionThreshold) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(sCompressionThreshold);
                GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                gZIPOutputStream.write(byArray);
                gZIPOutputStream.flush();
                gZIPOutputStream.finish();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    private static byte[] decompress(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray2 = new byte[1000];
            boolean bl = true;
            while (bl) {
                int n = gZIPInputStream.read(byArray2, 0, byArray2.length);
                if (n > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                    continue;
                }
                bl = false;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static nConsumeEvent nPublishedTonConsumeEvent(nPublished nPublished2) {
        nConsumeEvent nConsumeEvent2;
        byte[] byArray = nPublished2.getData();
        if (nPublished2.getHeader() != null && nPublished2.getHeader().isCompressed()) {
            byArray = nConsumeEventConverter.decompress(nPublished2.getData());
        }
        if (nPublished2.isDom()) {
            Object object = subHelper_lock;
            synchronized (object) {
                if (subHelper == null) {
                    subHelper = new xmlHelper();
                }
                subHelper.decode(byArray);
                if (nPublished2.getDictionary() == null) {
                    nConsumeEvent2 = nConsumeEventFactory.create(fStringByteConverter.convert(nPublished2.getTag()), subHelper.getDoc(), nPublished2.getTTL(), nPublished2.isPersistant());
                } else {
                    nEventProperties nEventProperties2 = new nEventProperties(nPublished2.getDictionary());
                    nConsumeEvent2 = nConsumeEventFactory.create(nEventProperties2, subHelper.getDoc(), nPublished2.getTTL(), nPublished2.isPersistant());
                }
            }
        } else if (nPublished2.getHeader() != null && nPublished2.getHeader().getMessageType() == 6) {
            nConsumeEvent2 = nProtobufEventFactory.create(nPublished2.getTag(), byArray, nPublished2.getHeader().getType(), nPublished2.getTTL(), nPublished2.isPersistant());
        } else if (nPublished2.getDictionary() != null) {
            nEventProperties nEventProperties3 = new nEventProperties(nPublished2.getDictionary());
            String string = null;
            if (nPublished2.getTag() != null) {
                string = fStringByteConverter.convert(nPublished2.getTag());
            }
            nConsumeEvent2 = nConsumeEventFactory.create(string, nEventProperties3, byArray, nPublished2.getTTL(), nPublished2.isPersistant());
        } else {
            nConsumeEvent2 = nConsumeEventFactory.create(nPublished2.getTag(), byArray, nPublished2.getTTL(), nPublished2.isPersistant());
        }
        nConsumeEvent2.setEventID(nPublished2.getEID());
        nConsumeEvent2.setHeader(nPublished2.getHeader());
        if (nPublished2.getSignature() != null) {
            nConsumeEvent2.setSignature(nPublished2.getSignature());
        }
        nConsumeEvent2.setTransient(nPublished2.isTransient());
        nConsumeEvent2.setEndOfChannel(nPublished2.isEndOfChannel());
        nConsumeEvent2.multicastDelivered(nPublished2.isMulticastDelivered());
        return nConsumeEvent2;
    }

    static void checkPublishedAgainstMBS(nPublished nPublished2, ClientConnectionManager clientConnectionManager) throws nMaxBufferSizeExceededException {
        if (clientConnectionManager.isMaxBufferSizeClientCheck()) {
            int n = clientConnectionManager.getServerProvidedMaxBufferSize();
            byte[] byArray = nPublished2.getTag();
            byte[] byArray2 = nPublished2.getData();
            if (byArray != null && byArray.length > n) {
                throw new nMaxBufferSizeExceededException("Event tag exceeds the max buffer size. Tag size is " + byArray.length + " and max buffer size is " + n);
            }
            if (byArray2 != null && byArray2.length > n) {
                throw new nMaxBufferSizeExceededException("Event data exceeds the max buffer size. Data size is " + byArray2.length + " and max buffer size is " + n);
            }
            fEventDictionary fEventDictionary2 = nPublished2.getDictionary();
            if (fEventDictionary2 != null) {
                nConsumeEventConverter.checkDictionaryAgainstMBS(fEventDictionary2, n);
            }
            if (nPublished2.getHeader() != null) {
                nConsumeEventConverter.checkHeaderAgainstMBS(nPublished2.getHeader(), n);
            }
        }
    }

    private static void checkHeaderAgainstMBS(nHeader nHeader2, int n) throws nMaxBufferSizeExceededException {
        try {
            nConsumeEventConverter.checkDictionaryAgainstMBS(nHeader2.getDictionary(), n);
        }
        catch (nMaxBufferSizeExceededException nMaxBufferSizeExceededException2) {
            throw new nMaxBufferSizeExceededException("Header " + nMaxBufferSizeExceededException2.getMessage());
        }
        fEventDictionary fEventDictionary2 = new fEventDictionary();
        nHeader2.convertToDictionary(fEventDictionary2);
        try {
            nConsumeEventConverter.checkDictionaryAgainstMBS(fEventDictionary2, n);
        }
        catch (nMaxBufferSizeExceededException nMaxBufferSizeExceededException3) {
            throw new nMaxBufferSizeExceededException("Header " + nMaxBufferSizeExceededException3.getMessage());
        }
    }

    private static void checkSizeAgainstMBS(Object object, int n) throws nMaxBufferSizeExceededException {
        boolean bl = false;
        int n2 = 0;
        if (object instanceof fStringEntry) {
            n2 = ((fStringEntry)object).getBytes().length;
            bl = n2 > n;
        } else if (object instanceof fStringEntry[]) {
            for (fStringEntry fStringEntry2 : (fStringEntry[])object) {
                n2 = fStringEntry2.getBytes().length;
                if (n2 <= n) continue;
                bl = true;
                break;
            }
        } else if (object instanceof Byte[]) {
            n2 = ((Byte[])object).length;
            bl = n2 > n;
        } else if (object instanceof byte[]) {
            n2 = ((byte[])object).length;
            bl = n2 > n;
        } else if (object instanceof fEventDictionary) {
            nConsumeEventConverter.checkDictionaryAgainstMBS((fEventDictionary)object, n);
        } else if (object instanceof fEventDictionary[]) {
            for (fEventDictionary fEventDictionary2 : (fEventDictionary[])object) {
                nConsumeEventConverter.checkDictionaryAgainstMBS(fEventDictionary2, n);
            }
        }
        if (bl) {
            throw new nMaxBufferSizeExceededException("Dictionary value exceeds the max buffer size. Value size is " + n2 + " and max buffer size is " + n);
        }
    }

    private static void checkDictionaryAgainstMBS(fEventDictionary fEventDictionary2, int n) throws nMaxBufferSizeExceededException {
        Iterator<Map.Entry<fStringEntry, Object>> iterator = fEventDictionary2.getEntrySet();
        while (iterator.hasNext()) {
            Map.Entry<fStringEntry, Object> entry = iterator.next();
            int n2 = entry.getKey().getBytes().length;
            if (n2 > n) {
                throw new nMaxBufferSizeExceededException("Dictionary key exceeds the max buffer size. Key size is " + n2 + " and max buffer size is " + n + ". Key: " + nConsumeEventConverter.trimKey(entry.getKey().getString()));
            }
            try {
                nConsumeEventConverter.checkSizeAgainstMBS(entry.getValue(), n);
            }
            catch (nMaxBufferSizeExceededException nMaxBufferSizeExceededException2) {
                throw new nMaxBufferSizeExceededException(nMaxBufferSizeExceededException2.getMessage() + ". Key: " + nConsumeEventConverter.trimKey(entry.getKey().getString()));
            }
        }
    }

    private static String trimKey(String string) {
        if (string.length() < 20) {
            return string;
        }
        return string.substring(0, 8) + "..." + string.substring(string.length() - 8);
    }

    private nConsumeEventConverter() {
    }

    static {
        sCompressionEnabled = Boolean.valueOf(fSystemConfiguration.getProperty("Nirvana_EnableCompression", "false"));
        sCompressionThreshold = Integer.valueOf(fSystemConfiguration.getProperty("Nirvana_CompressionThreshold", "1000"));
        sCloneDictionary = Boolean.valueOf(fSystemConfiguration.getProperty("NirvanaCloneDictionary", "false"));
        subHelper = null;
        pubHelper = null;
        shouldGenerateUUID = Boolean.parseBoolean(fSystemConfiguration.getProperty("com.softwareag.um.client.GenerateEventUID", "false"));
    }
}

