/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nEventPublisher;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nMaxBufferSizeExceededException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nTransaction;
import com.pcbsys.nirvana.client.nTransactionAttributes;
import com.pcbsys.nirvana.client.nTransactionException;
import com.pcbsys.nirvana.client.nTransactionFactory;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

public class nConsumeEventFragmentWriter
implements nEventPublisher {
    private nAbstractChannel myStore;
    private final nEventPublisher myPublisher;
    private int mySize;

    public nConsumeEventFragmentWriter(nAbstractChannel nAbstractChannel2, int n) throws nIllegalArgumentException {
        if (n <= 0) {
            throw new nIllegalArgumentException("Max size is the number of bytes per event to be sent to the server, must be greater then 0");
        }
        if (nAbstractChannel2 == null) {
            throw new nIllegalArgumentException("Null store");
        }
        this.myStore = nAbstractChannel2;
        this.mySize = n;
        this.myPublisher = null;
    }

    public nConsumeEventFragmentWriter(nEventPublisher nEventPublisher2, int n) throws nIllegalArgumentException {
        if (n <= 0) {
            throw new nIllegalArgumentException("Max size is the number of bytes per event to be sent to the server, must be greater then 0");
        }
        if (nEventPublisher2 == null) {
            throw new nIllegalArgumentException("Null store");
        }
        this.myPublisher = nEventPublisher2;
        this.mySize = n;
    }

    @Override
    public void publish(nConsumeEvent nConsumeEvent2) throws nTransactionException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nRequestTimedOutException, nUnexpectedResponseException, nChannelNotFoundException, nIllegalArgumentException, nMaxBufferSizeExceededException {
        if (nConsumeEvent2 == null) {
            throw new nIllegalArgumentException("Null event");
        }
        if (nConsumeEvent2.getEventData() == null) {
            throw new nIllegalArgumentException("Null event data");
        }
        byte[] byArray = nConsumeEvent2.getEventData();
        if (byArray.length > this.mySize) {
            nEventProperties nEventProperties2;
            boolean bl;
            int n = byArray.length / this.mySize;
            if (byArray.length % this.mySize != 0) {
                ++n;
            }
            boolean bl2 = bl = nConsumeEvent2.getProperties() != null;
            if (bl) {
                nEventProperties2 = new nEventProperties(nConsumeEvent2.getProperties());
            } else {
                nEventProperties2 = new nEventProperties();
                nEventProperties2.put("nrvpub.tag", nConsumeEvent2.getEventTag());
            }
            nEventProperties2.put("nrvpub.fragments", n - 1);
            nTransaction nTransaction2 = null;
            if (this.myPublisher == null) {
                nTransaction2 = nTransactionFactory.create(new nTransactionAttributes(this.myStore));
            }
            int n2 = this.mySize;
            for (int i = 0; i < n; ++i) {
                if ((i + 1) * this.mySize > byArray.length) {
                    n2 = byArray.length - i * this.mySize;
                }
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, i * this.mySize, byArray2, 0, byArray2.length);
                nEventProperties2.put("nrvpub.fragementcount", i);
                nConsumeEvent nConsumeEvent3 = new nConsumeEvent(nEventProperties2, byArray2);
                nConsumeEvent3.setHeader(nConsumeEvent2.getHeader());
                if (this.myPublisher == null) {
                    nTransaction2.publish(nConsumeEvent3);
                } else {
                    this.myPublisher.publish(nConsumeEvent3);
                }
                nEventProperties2 = new nEventProperties();
            }
            if (this.myPublisher == null) {
                nTransaction2.commit();
            }
        } else if (this.myPublisher == null) {
            nTransaction nTransaction3 = nTransactionFactory.create(new nTransactionAttributes(this.myStore));
            nTransaction3.publish(nConsumeEvent2);
            nTransaction3.commit();
        } else {
            this.myPublisher.publish(nConsumeEvent2);
        }
    }
}

