/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.base.clientimpl.nDataGroupManager;
import com.pcbsys.nirvana.base.events.nDataGroupAdmin;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nConflationAttributes;
import com.pcbsys.nirvana.client.nDataGroupDeletedException;
import com.pcbsys.nirvana.client.nDataGroupIsReadOnlyException;
import com.pcbsys.nirvana.client.nDataGroupIterator;
import com.pcbsys.nirvana.client.nDataGroupListener;
import com.pcbsys.nirvana.client.nDataStream;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nRegisteredEvent;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class nDataGroup
extends nDataStream {
    private final nConflationAttributes myConflation;
    private final long myID;
    private final LinkedHashMap<String, nDataStream> myStreams;
    private final LinkedHashMap<String, nDataStream> mySnoopStreams;
    private final LinkedHashMap<String, nDataGroup> myGroups;
    private final LinkedHashMap<String, String> myPublishers;
    private final boolean isMulticastEnabled;
    private final int myPriority;
    private final nDataGroupManager myDataGroupManager;
    private volatile nDataGroupListener myListener;
    private volatile boolean isNested;
    private boolean closed;
    private boolean isReadOnly;

    public void add(nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (nDataStream2 instanceof nDataGroup) {
            this.add((nDataGroup)nDataStream2);
            return;
        }
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.addStream(this.myName, nDataStream2, false);
        this.addToStream(nDataStream2);
    }

    public void addSnoop(nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (nDataStream2 instanceof nDataGroup) {
            throw new IllegalArgumentException("DataGroup.addSnoop-" + nDataStream2);
        }
        if (this.isReadOnly) {
            throw new nSecurityException("Cannot add a snoop stream to a read-only DataGroup");
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.addStream(this.myName, nDataStream2, true);
        this.addToSnoopStream(nDataStream2);
    }

    public void add(nDataStream[] nDataStreamArray2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.addStream(this.myName, nDataStreamArray2);
        this.addToStream(nDataStreamArray2);
    }

    public void add(nDataGroup nDataGroup2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.addGroup(this.myName, nDataGroup2);
        this.addToGroup(nDataGroup2);
    }

    public void remove(nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.delStream(this.myName, nDataStream2.getName(), false);
    }

    public void removeSnoop(nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.delStream(this.myName, nDataStream2.getName(), true);
    }

    public void remove(nDataGroup nDataGroup2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nDataGroupDeletedException, nDataGroupIsReadOnlyException, nUnexpectedResponseException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        this.delGroup(this.myName, nDataGroup2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws nDataGroupDeletedException {
        int n = 0;
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            for (nDataGroup nDataGroup2 : this.myGroups.values()) {
                n += nDataGroup2.size();
            }
        }
        linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            return n + this.myStreams.size();
        }
    }

    public boolean isNested() {
        return this.isNested;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public nConflationAttributes getConflationAttributes() {
        return this.myConflation;
    }

    public boolean isMulticastEnabled() {
        return this.isMulticastEnabled;
    }

    public int getPriority() {
        return this.myPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublisher(String string) throws nBaseClientException {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        if (string.indexOf(64) == -1) {
            throw new nIllegalArgumentException("The subject must be of form user@host");
        }
        this.addPublisher(this.myName, string);
        LinkedHashMap<String, String> linkedHashMap = this.myPublishers;
        synchronized (linkedHashMap) {
            this.myPublishers.put(string, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublisher(String string) throws Exception {
        if (this.isReadOnly) {
            throw new nDataGroupIsReadOnlyException();
        }
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        if (string.indexOf(64) == -1) {
            throw new nIllegalArgumentException("The subject must be of form user@host");
        }
        this.delPublisher(this.myName, string);
        LinkedHashMap<String, String> linkedHashMap = this.myPublishers;
        synchronized (linkedHashMap) {
            this.myPublishers.remove(string);
        }
    }

    public void addListener(nDataGroupListener nDataGroupListener2) throws nDataGroupDeletedException {
        if (this.isClosed()) {
            throw new nDataGroupDeletedException();
        }
        nDataGroupListener nDataGroupListener3 = this.myListener;
        if (nDataGroupListener2 == nDataGroupListener3) {
            return;
        }
        this.myListener = nDataGroupListener2;
        if (nDataGroupListener3 == null || nDataGroupListener2 == null) {
            try {
                if (!this.isReadOnly()) {
                    this.myDataGroupManager.sendServerAddDataGroupListener(this, nDataGroupListener2);
                } else {
                    this.addDefaultGroupListener(nDataGroupListener2, nDataGroupListener2 != null);
                }
            }
            catch (nDataGroupDeletedException nDataGroupDeletedException2) {
                throw nDataGroupDeletedException2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addDefaultGroupListener(nDataGroupListener nDataGroupListener2, boolean bl) throws nSessionNotConnectedException, nRequestTimedOutException, nSessionPausedException, nDataGroupDeletedException {
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(3, bl);
        nEvent nEvent2 = this.myDataGroupManager.writeEvent(nDataGroupAdmin2);
        if (nEvent2 instanceof nDataGroupAdmin) {
            this.setListener(nDataGroupListener2);
        }
    }

    protected void setListener(nDataGroupListener nDataGroupListener2) throws nDataGroupDeletedException {
        if (this.isClosed()) {
            throw new nDataGroupDeletedException();
        }
        this.myListener = nDataGroupListener2;
    }

    protected nDataGroupListener getListener() {
        return this.myListener;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public nRegisteredEvent createRegisteredEvent() throws nIllegalStateException {
        if (this.myConflation != null && this.myConflation.getAction() == 0) {
            throw new nIllegalStateException("Registered events are not valid on data groups with a conflation attribute of dropped events");
        }
        return new nRegisteredEvent(this, this.myDataGroupManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nDataGroup getGroup(String string) throws nDataGroupDeletedException {
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataGroup> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            return this.myGroups.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGroupCount() throws nDataGroupDeletedException {
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataGroup> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            return this.myGroups.values().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<nDataGroup> getGroups() throws nDataGroupDeletedException {
        ArrayList<nDataGroup> arrayList;
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataGroup> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            arrayList = new ArrayList<nDataGroup>(this.myGroups.values());
        }
        return arrayList.iterator();
    }

    public Enumeration<nDataGroup> getGroupsEnumeration() throws nDataGroupDeletedException {
        final Iterator<nDataGroup> iterator = this.getGroups();
        return new Enumeration<nDataGroup>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public nDataGroup nextElement() {
                return (nDataGroup)iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populate(Collection<nDataStream> collection, Collection<nDataGroup> collection2) {
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            collection.addAll(this.myStreams.values());
        }
        linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            collection2.addAll(this.myGroups.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nDataStream getStream(String string) throws nDataGroupDeletedException {
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            return this.myStreams.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public nDataStream getSnoopStream(String string) throws nDataGroupDeletedException {
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.mySnoopStreams;
        synchronized (linkedHashMap) {
            return this.mySnoopStreams.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(nDataGroup nDataGroup2) throws nDataGroupDeletedException {
        if (this.isClosed()) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataGroup> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            return this.myGroups.containsKey(nDataGroup2.getName());
        }
    }

    public boolean contains(nDataStream nDataStream2) throws nDataGroupDeletedException {
        return this.contains(nDataStream2.getName());
    }

    public boolean containsSnoop(nDataStream nDataStream2) throws nDataGroupDeletedException {
        return this.containsSnoop(nDataStream2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) throws nDataGroupDeletedException {
        if (this.isClosed()) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            for (nDataGroup nDataGroup2 : this.myGroups.values()) {
                if (!nDataGroup2.contains(string)) continue;
                return true;
            }
        }
        linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            return this.myStreams.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSnoop(String string) throws nDataGroupDeletedException {
        if (this.isClosed()) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            for (nDataGroup nDataGroup2 : this.myGroups.values()) {
                if (!nDataGroup2.containsSnoop(string)) continue;
                return true;
            }
        }
        linkedHashMap = this.mySnoopStreams;
        synchronized (linkedHashMap) {
            return this.mySnoopStreams.containsKey(string);
        }
    }

    public Iterator<nDataStream> getStreams() throws nDataGroupDeletedException {
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        return new nDataGroupIterator(this);
    }

    public Enumeration<nDataStream> getStreamsEnumeration() throws nDataGroupDeletedException {
        final Iterator<nDataStream> iterator = this.getStreams();
        return new Enumeration<nDataStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public nDataStream nextElement() {
                return (nDataStream)iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getPublishers() throws nDataGroupDeletedException {
        ArrayList<String> arrayList;
        if (this.closed) {
            throw new nDataGroupDeletedException();
        }
        LinkedHashMap<String, String> linkedHashMap = this.myPublishers;
        synchronized (linkedHashMap) {
            arrayList = new ArrayList<String>(this.myPublishers.values());
        }
        return arrayList.iterator();
    }

    public Enumeration<String> getPublishersEnumeration() throws nDataGroupDeletedException {
        final Iterator<String> iterator = this.getPublishers();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public long getID() {
        return this.myID;
    }

    public nDataGroup[] getGroupsContaining() {
        if (this.isClosed()) {
            return new nDataGroup[0];
        }
        return this.myDataGroupManager.getGroupsContaining(this);
    }

    protected nDataGroup(com.pcbsys.nirvana.base.nDataGroup nDataGroup2, nDataGroupManager nDataGroupManager2, nConflationAttributes nConflationAttributes2, boolean bl, int n) {
        this(nDataGroup2.getName(), nDataGroup2.getID(), nDataGroupManager2, nConflationAttributes2, bl, n);
        this.initStreams(nDataGroup2, nConflationAttributes2, bl, n);
    }

    private void addStream(String string, nDataStream nDataStream2, boolean bl) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        String[] stringArray = new String[]{nDataStream2.getName()};
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(10, string, stringArray);
        nDataGroupAdmin2.setSnoopStream(bl);
        this.writeDataGroupAdminEvent(nDataGroupAdmin2, "addStream : ");
    }

    private void addStream(String string, nDataStream[] nDataStreamArray2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        String[] stringArray = new String[nDataStreamArray2.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (nDataStreamArray2[i] instanceof nDataGroup) {
                throw new IllegalArgumentException("DataGroup.addStream-" + i + "-" + nDataStreamArray2[i]);
            }
            stringArray[i] = nDataStreamArray2[i].getName();
        }
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(10, string, stringArray);
        this.writeDataGroupAdminEvent(nDataGroupAdmin2, "addStream : ");
    }

    private void delStream(String string, String string2, boolean bl) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(11, string, string2);
        nDataGroupAdmin2.setSnoopStream(bl);
        this.writeDataGroupAdminEvent(nDataGroupAdmin2, "delStream : ");
    }

    protected void addGroup(String string, nDataGroup nDataGroup2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.createAndWriteDataGroupAdminEvent(0, string, nDataGroup2.getName(), "addGroup : ");
    }

    private void delGroup(String string, String string2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.createAndWriteDataGroupAdminEvent(2, string, string2, "delGroup : ");
    }

    protected void addPublisher(String string, String string2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.createAndWriteDataGroupAdminEvent(21, string, string2, "addPublisher : ");
    }

    private void delPublisher(String string, String string2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.createAndWriteDataGroupAdminEvent(23, string, string2, "delPublisher : ");
    }

    private void createAndWriteDataGroupAdminEvent(int n, String string, String string2, String string3) throws nSessionNotConnectedException, nSessionPausedException, nSecurityException, nUnexpectedResponseException, nRequestTimedOutException {
        nDataGroupAdmin nDataGroupAdmin2 = new nDataGroupAdmin(n, string, string2);
        this.writeDataGroupAdminEvent(nDataGroupAdmin2, string3);
    }

    private void writeDataGroupAdminEvent(nDataGroupAdmin nDataGroupAdmin2, String string) throws nSecurityException, nUnexpectedResponseException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        nEvent nEvent2 = this.myDataGroupManager.writeEvent(nDataGroupAdmin2);
        if (nEvent2 instanceof nDataGroupAdmin) {
            return;
        }
        if (nEvent2 instanceof nExceptionEvent) {
            nExceptionEvent nExceptionEvent2 = (nExceptionEvent)nEvent2;
            nBaseClientException nBaseClientException2 = nExceptionFactory.getException(nExceptionEvent2.getExceptionId(), nExceptionEvent2.getMessage());
            throw new nUnexpectedResponseException(nBaseClientException2.getClass().toString() + ": " + nExceptionEvent2.getMessage());
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        throw new nUnexpectedResponseException(string + nEvent2.getClass().getName());
    }

    private nDataGroup(String string, long l, nDataGroupManager nDataGroupManager2, boolean bl, int n, nConflationAttributes nConflationAttributes2) {
        super(string, null);
        this.myID = l;
        this.myStreams = new LinkedHashMap();
        this.mySnoopStreams = new LinkedHashMap();
        this.myPublishers = new LinkedHashMap();
        this.myGroups = new LinkedHashMap();
        this.isMulticastEnabled = bl;
        this.myPriority = n;
        this.myConflation = nConflationAttributes2;
        this.myDataGroupManager = nDataGroupManager2;
    }

    protected nDataGroup(String string, long l, nDataGroupManager nDataGroupManager2, nConflationAttributes nConflationAttributes2, boolean bl, int n) {
        this(string, l, nDataGroupManager2, bl, n, nConflationAttributes2);
    }

    protected nDataGroup(com.pcbsys.nirvana.base.nDataGroup nDataGroup2, nDataGroupManager nDataGroupManager2, boolean bl, int n) {
        this(nDataGroup2.getName(), nDataGroup2.getID(), nDataGroupManager2, bl, n, nDataGroup2.getConflationInterval() > 0L ? new nConflationAttributes(nDataGroup2.getConflationInterval()) : null);
        if (this.myConflation != null) {
            if (nDataGroup2.isMergeEvents()) {
                try {
                    this.myConflation.setAction(1);
                }
                catch (nIllegalArgumentException nIllegalArgumentException2) {}
            } else {
                try {
                    this.myConflation.setAction(0);
                }
                catch (nIllegalArgumentException nIllegalArgumentException3) {
                    // empty catch block
                }
            }
        }
        this.initStreams(nDataGroup2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStreams(com.pcbsys.nirvana.base.nDataGroup nDataGroup2, nConflationAttributes nConflationAttributes2, boolean bl, int n) {
        Object object = this.myStreams;
        synchronized (object) {
            this.myStreams.clear();
        }
        object = nDataGroup2.values();
        while (object.hasNext()) {
            nDataStream nDataStream2;
            com.pcbsys.nirvana.base.nDataStream nDataStream3 = (com.pcbsys.nirvana.base.nDataStream)object.next();
            if (nDataStream3 instanceof com.pcbsys.nirvana.base.nDataGroup) {
                nDataStream2 = this.myDataGroupManager.getKnownDataGroup(((com.pcbsys.nirvana.base.nDataGroup)nDataStream3).getID());
                if (nDataStream2 == null) {
                    nDataStream2 = new nDataGroup((com.pcbsys.nirvana.base.nDataGroup)nDataStream3, this.myDataGroupManager, nConflationAttributes2, bl, n);
                    this.myDataGroupManager.putKnownDataGroup(((nDataGroup)nDataStream2).getID(), (nDataGroup)nDataStream2);
                }
                this.addToGroup((nDataGroup)nDataStream2);
                continue;
            }
            nDataStream2 = new nDataStream(nDataStream3.getName(), nDataStream3.getSubject());
            this.addToStream(nDataStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initStreams(com.pcbsys.nirvana.base.nDataGroup nDataGroup2, int n) {
        Object object = this.myStreams;
        synchronized (object) {
            this.myStreams.clear();
        }
        object = nDataGroup2.values();
        while (object.hasNext()) {
            nDataStream nDataStream2;
            com.pcbsys.nirvana.base.nDataStream nDataStream3 = (com.pcbsys.nirvana.base.nDataStream)object.next();
            if (nDataStream3 instanceof com.pcbsys.nirvana.base.nDataGroup) {
                nDataStream2 = this.myDataGroupManager.getKnownDataGroup(((com.pcbsys.nirvana.base.nDataGroup)nDataStream3).getID());
                if (nDataStream2 == null) {
                    nDataStream2 = new nDataGroup((com.pcbsys.nirvana.base.nDataGroup)nDataStream3, this.myDataGroupManager, ((com.pcbsys.nirvana.base.nDataGroup)nDataStream3).isEnableMulticast(), n);
                    this.myDataGroupManager.putKnownDataGroup(((nDataGroup)nDataStream2).getID(), (nDataGroup)nDataStream2);
                }
                this.addToGroup((nDataGroup)nDataStream2);
                continue;
            }
            nDataStream2 = new nDataStream(nDataStream3.getName(), nDataStream3.getSubject());
            this.addToStream(nDataStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.closed = true;
        LinkedHashMap<String, Object> linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            this.myStreams.clear();
        }
        linkedHashMap = this.mySnoopStreams;
        synchronized (linkedHashMap) {
            this.mySnoopStreams.clear();
        }
        linkedHashMap = this.myPublishers;
        synchronized (linkedHashMap) {
            this.myPublishers.clear();
        }
        linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            this.myGroups.clear();
        }
        this.myListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromList(nDataGroup nDataGroup2) {
        Object object = this.myGroups;
        synchronized (object) {
            this.myGroups.remove(nDataGroup2.myName);
        }
        object = this.myListener;
        try {
            if (object != null) {
                object.removedGroup(this, nDataGroup2, this.size());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromList(nDataStream nDataStream2, boolean bl) {
        Object object = this.myStreams;
        synchronized (object) {
            this.myStreams.remove(nDataStream2.getName());
        }
        object = this.myListener;
        try {
            if (object != null) {
                object.deletedStream(this, nDataStream2, this.size(), bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromSnoopList(nDataStream nDataStream2) {
        LinkedHashMap<String, nDataStream> linkedHashMap = this.mySnoopStreams;
        synchronized (linkedHashMap) {
            this.mySnoopStreams.remove(nDataStream2.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToStream(nDataStream nDataStream2) {
        if (nDataStream2 instanceof nDataGroup) {
            throw new IllegalArgumentException("DataGroup.addToStream-" + nDataStream2);
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.myStreams;
        synchronized (linkedHashMap) {
            if (this.myStreams.containsKey(nDataStream2.getName())) {
                return;
            }
            this.myStreams.put(nDataStream2.getName(), nDataStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSnoopStream(nDataStream nDataStream2) {
        if (nDataStream2 instanceof nDataGroup) {
            throw new IllegalArgumentException("DataGroup.addToSnoopSream-" + nDataStream2);
        }
        LinkedHashMap<String, nDataStream> linkedHashMap = this.mySnoopStreams;
        synchronized (linkedHashMap) {
            if (this.mySnoopStreams.containsKey(nDataStream2.getName())) {
                return;
            }
            this.mySnoopStreams.put(nDataStream2.getName(), nDataStream2);
        }
    }

    private void addToStream(nDataStream[] nDataStreamArray2) {
        for (nDataStream nDataStream2 : nDataStreamArray2) {
            this.addToStream(nDataStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToGroup(nDataGroup nDataGroup2) {
        LinkedHashMap<String, nDataGroup> linkedHashMap = this.myGroups;
        synchronized (linkedHashMap) {
            if (this.myGroups.containsKey(nDataGroup2.getName())) {
                return;
            }
            this.myGroups.put(nDataGroup2.getName(), nDataGroup2);
            nDataGroup2.isNested = true;
        }
    }

    void setReadOnly() {
        this.isReadOnly = true;
    }

    public nSession getSession() {
        return this.myDataGroupManager.getSession();
    }

    protected nDataGroupListener getMyListener() {
        return this.myListener;
    }

    protected void setMyListener(nDataGroupListener nDataGroupListener2) {
        this.myListener = nDataGroupListener2;
    }
}

