/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nSerialDurableAttributes;
import com.pcbsys.nirvana.client.nSharedDurableAttributes;

public class nDurableAttributes {
    private final nDurableType myType;
    private final String myName;
    protected String mySelector;
    private long startEID;
    private boolean isClustered;
    protected boolean isPersistent;

    public static nDurableAttributes create(nDurableType nDurableType2, String string) throws nIllegalArgumentException {
        if (string == null || string.length() < 1) {
            throw new nIllegalArgumentException("Durable name is invalid, must supply a valid string");
        }
        if (nDurableType2 == nDurableType.Shared) {
            return new nSharedDurableAttributes(nDurableType2, string);
        }
        if (nDurableType2 == nDurableType.Serial) {
            return new nSerialDurableAttributes(nDurableType2, string);
        }
        return new nDurableAttributes(nDurableType2, string);
    }

    public String getSelector() {
        return this.mySelector;
    }

    public void setSelector(String string) throws nIllegalArgumentException {
        if (this.myType != nDurableType.Shared && this.myType != nDurableType.Serial) {
            throw new nIllegalArgumentException("Selector is not supported on current durable type");
        }
        this.mySelector = string;
    }

    public long getStartEID() {
        return this.startEID;
    }

    public void setStartEID(long l) {
        this.startEID = l;
    }

    @Deprecated
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Deprecated
    public void setPersistent(boolean bl) throws nIllegalArgumentException {
        this.isPersistent = bl;
    }

    @Deprecated
    public boolean isClustered() {
        return this.isClustered;
    }

    @Deprecated
    public void setClustered(boolean bl) {
        this.isClustered = bl;
    }

    public String getName() {
        return this.myName;
    }

    public nDurableType getType() {
        return this.myType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Durable Attributes:");
        stringBuilder.append(this.getName()).append(",");
        stringBuilder.append("Type:").append(this.myType.toString()).append(",");
        stringBuilder.append("Persistent:").append(this.isPersistent).append(",");
        stringBuilder.append("Clustered:").append(this.isClustered).append(",");
        stringBuilder.append("Selector:").append(this.mySelector);
        return stringBuilder.toString();
    }

    protected nDurableAttributes(nDurableType nDurableType2, String string) {
        this.myType = nDurableType2;
        this.myName = string;
        this.isClustered = false;
        this.isPersistent = true;
        this.startEID = -2L;
    }

    public static enum nDurableType {
        Named,
        Shared,
        Serial;

    }
}

