/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nIndexedDurablePurgeEvent;
import com.pcbsys.nirvana.base.events.nIndexedDurableViewerEvent;
import com.pcbsys.nirvana.base.events.nManageNamedSub;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nDurable;
import com.pcbsys.nirvana.client.nDurableViewer;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nSignedEventListener;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class nIndexedDurable
extends nDurable {
    private static final String CLASS_NAME = nIndexedDurable.class.getSimpleName();
    private final List<nUnAckedEventManager> unackedEventManagers = new ArrayList<nUnAckedEventManager>();

    nIndexedDurable(nChannel nChannel2, String string, long l, long l2, boolean bl, boolean bl2, long l3, String string2) {
        super(nChannel2, string, l, l2, bl, bl2, l3, string2);
    }

    public boolean rebuildSelector(String string) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalArgumentException {
        String string2 = this.getSelector();
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        if ((string2 = string2.trim()).equals(string)) {
            return false;
        }
        if (this.myChannel.getTraceLogger().isTraceEnabled()) {
            this.myChannel.getTraceLogger().trace("Rebuilding selector for durable durableName=" + this.getName() + ", oldSelector=" + this.getSelector() + ", newSelector=" + string, CLASS_NAME);
        }
        nManageNamedSub nManageNamedSub2 = new nManageNamedSub(this.myChannel.getBaseAttributes().getUniqueId(), this.myUniqueId, string);
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nManageNamedSub2);
        if (nEvent2 instanceof nManageNamedSub) {
            this.mySelector = string;
            return true;
        }
        nExceptionEventProcessor.checkIllegalArgument(nEvent2);
        return false;
    }

    protected void setSelector(String string) {
        this.mySelector = string;
    }

    @Override
    public long getOutstandingEvents() {
        return this.myLength;
    }

    @Override
    protected void registerUnackedEventManager(nUnAckedEventManager nUnAckedEventManager2) {
        this.unackedEventManagers.add(nUnAckedEventManager2);
    }

    @Override
    public nEventListener wrapEventListener(nEventListener nEventListener2, nUnAckedEventManager nUnAckedEventManager2) {
        if (nEventListener2 instanceof nSignedEventListener) {
            return new IndexDurableEventListenerSigned((nSignedEventListener)nEventListener2, nUnAckedEventManager2);
        }
        return new IndexDurableEventListener(nEventListener2, nUnAckedEventManager2);
    }

    @Override
    protected void unregisterUnackedEventManager(nUnAckedEventManager nUnAckedEventManager2) {
        this.unackedEventManagers.remove(nUnAckedEventManager2);
    }

    @Override
    protected List<nUnAckedEventManager> getUnackedEventManagers() {
        return this.unackedEventManagers;
    }

    @Override
    public void ack(long[] lArray) throws nIllegalArgumentException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException {
        this.ack(lArray, true);
    }

    @Override
    public void ack(long[] lArray, boolean bl) throws nIllegalArgumentException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        StringBuilder stringBuilder = null;
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        for (long l : lArray) {
            if (this.isEIDUnackedOnThisConnection(l)) {
                lArray2[n++] = l;
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder("The following EIDs were not consumed by this connection : ");
            }
            stringBuilder.append(l).append(",");
        }
        if (stringBuilder != null) {
            throw new nIllegalArgumentException(stringBuilder.toString());
        }
        Arrays.sort(lArray2);
        if (this.myChannel.getTraceLogger().isTraceEnabled()) {
            this.myChannel.getTraceLogger().trace("Index durable ack invoked. " + ClientEventTraceLoggerContext.eidFormat(lArray2) + ", isSynchronous=" + bl + ", " + ClientEventTraceLoggerContext.addDurableInfo(this), CLASS_NAME);
        }
        this.myChannel.getBaseChannel().sendNamedAck(lArray2, this.myUniqueId, bl, true);
        this.commitEIDs(lArray2);
    }

    private boolean isEIDUnackedOnThisConnection(long l) {
        for (nUnAckedEventManager nUnAckedEventManager2 : this.unackedEventManagers) {
            if (!nUnAckedEventManager2.contains(l)) continue;
            return true;
        }
        return false;
    }

    private void commitEIDs(long[] lArray) {
        for (nUnAckedEventManager nUnAckedEventManager2 : this.unackedEventManagers) {
            nUnAckedEventManager2.commit(lArray);
        }
    }

    @Override
    public void remove(long l) throws nBaseClientException {
        nIndexedDurablePurgeEvent nIndexedDurablePurgeEvent2 = new nIndexedDurablePurgeEvent(1, this.getChannelUniqueId(), this.getID());
        nIndexedDurablePurgeEvent2.setCurrentEID(l);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Index durable purge request. " + ClientEventTraceLoggerContext.addIndexPurgeInfo(nIndexedDurablePurgeEvent2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nIndexedDurablePurgeEvent2);
        this.handleResponse(nEvent2, "Failed to call remove(long eid) on nSharedDurable with name: " + this.myName + " eid: " + l + " on channel: " + this.myChannel.getName());
    }

    @Override
    public void remove(long l, long l2) throws nBaseClientException {
        if (l > l2) {
            throw new nIllegalArgumentException("Start ID is higher than End ID");
        }
        nIndexedDurablePurgeEvent nIndexedDurablePurgeEvent2 = new nIndexedDurablePurgeEvent(2, this.getChannelUniqueId(), this.getID());
        nIndexedDurablePurgeEvent2.setCurrentEID(l);
        nIndexedDurablePurgeEvent2.setEndEID(l2);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Index durable purge request. " + ClientEventTraceLoggerContext.addIndexPurgeInfo(nIndexedDurablePurgeEvent2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nIndexedDurablePurgeEvent2);
        this.handleResponse(nEvent2, "Failed to call remove(long start, long end) on nSharedDurable with name: " + this.myName + " startEID: " + l + " endEID: " + l2 + " on channel: " + this.myChannel.getName());
    }

    @Override
    public void removeAll() throws nBaseClientException {
        nIndexedDurablePurgeEvent nIndexedDurablePurgeEvent2 = new nIndexedDurablePurgeEvent(3, this.getChannelUniqueId(), this.getID());
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Index durable purge request. " + ClientEventTraceLoggerContext.addIndexPurgeInfo(nIndexedDurablePurgeEvent2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nIndexedDurablePurgeEvent2);
        this.handleResponse(nEvent2, "Failed to call removeAll() on nSharedDurable with name: " + this.myName + " on channel: " + this.myChannel.getName());
    }

    @Override
    public void remove(String string) throws nBaseClientException {
        nIndexedDurablePurgeEvent nIndexedDurablePurgeEvent2 = new nIndexedDurablePurgeEvent(4, this.getChannelUniqueId(), this.getID());
        nIndexedDurablePurgeEvent2.setSelector(string);
        nIndexedDurablePurgeEvent2.setCurrentEID(-1L);
        nIndexedDurablePurgeEvent2.setEndEID(Long.MAX_VALUE);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Index durable purge request. " + ClientEventTraceLoggerContext.addIndexPurgeInfo(nIndexedDurablePurgeEvent2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
        nEvent nEvent2 = this.myChannel.getBaseChannel().writeEvent(nIndexedDurablePurgeEvent2);
        this.handleResponse(nEvent2, "Failed to call remove(String filter) on nSharedDurable with name: " + this.myName + " filter: " + string + " on channel: " + this.myChannel.getName());
    }

    protected long getChannelUniqueId() {
        return this.myChannel.getBaseAttributes().getUniqueId();
    }

    private void handleResponse(nEvent nEvent2, String string) throws nBaseClientException {
        if (nEvent2 instanceof nExceptionEvent) {
            nExceptionEvent nExceptionEvent2 = (nExceptionEvent)nEvent2;
            nBaseClientException nBaseClientException2 = nExceptionFactory.getException(nExceptionEvent2.getExceptionId(), nExceptionEvent2.getMessage());
            nConstants.logger.warn(string, nBaseClientException2);
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Index durable purge request failed. reason=" + nBaseClientException2.getMessage() + ", requestId=" + ((nExceptionEvent)nEvent2).getRequestId() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
            }
            throw nBaseClientException2;
        }
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Index durable purge request succeed. " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myChannel.getConnectionManager()), CLASS_NAME);
        }
    }

    @Override
    public nDurableViewer createViewer() throws nBaseClientException {
        return new nIndexedDurableViewer(this);
    }

    private static class IndexDurableEventListenerSigned
    extends IndexDurableEventListener
    implements nSignedEventListener {
        private final nSignedEventListener signedEventListener;

        IndexDurableEventListenerSigned(nSignedEventListener nSignedEventListener2, nUnAckedEventManager nUnAckedEventManager2) {
            super(nSignedEventListener2, nUnAckedEventManager2);
            this.signedEventListener = nSignedEventListener2;
        }

        @Override
        public void go(nConsumeEvent nConsumeEvent2, Object object) {
            this.signedEventListener.go(nConsumeEvent2, object);
        }

        @Override
        public void error(nConsumeEvent nConsumeEvent2, byte[] byArray, Exception exception) {
            this.signedEventListener.error(nConsumeEvent2, byArray, exception);
        }
    }

    private static class IndexDurableEventListener
    implements nEventListener {
        final nEventListener eventListener;
        private final nUnAckedEventManager unacknowledgedEventManager;

        IndexDurableEventListener(nEventListener nEventListener2, nUnAckedEventManager nUnAckedEventManager2) {
            this.eventListener = nEventListener2;
            this.unacknowledgedEventManager = nUnAckedEventManager2;
        }

        @Override
        public void go(nConsumeEvent nConsumeEvent2) {
            this.unacknowledgedEventManager.receivedEvent(nConsumeEvent2);
            this.eventListener.go(nConsumeEvent2);
        }
    }

    private static class nIndexedDurableViewer
    extends nDurableViewer {
        private final long myTopicId;
        private final long myDurableId;
        private long myCurrentID;
        private List<nConsumeEvent> myList;
        private boolean isClosed = false;

        private nIndexedDurableViewer(nIndexedDurable nIndexedDurable2) throws nBaseClientException {
            super(nIndexedDurable2);
            this.myTopicId = this.myDurable.myChannel.getBaseAttributes().getUniqueId();
            this.myDurableId = this.myDurable.getID();
            this.myDurable.viewerAdded(this);
            this.myCurrentID = -1L;
            this.myList = new LinkedList<nConsumeEvent>();
        }

        @Override
        public synchronized void close() throws nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException {
            if (!this.isClosed) {
                this.isClosed = true;
                this.myDurable.viewerDeleted(this);
                this.myList.clear();
            }
        }

        @Override
        public synchronized nConsumeEvent next() throws nSecurityException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException, nChannelNotFoundException, nIllegalStateException {
            if (!this.isClosed) {
                if (this.myList.size() == 0) {
                    this.loadArray();
                }
                nConsumeEvent nConsumeEvent2 = null;
                if (this.myList.size() > 0) {
                    nConsumeEvent2 = this.myList.remove(0);
                    this.myCurrentID = nConsumeEvent2.getEventID();
                }
                return nConsumeEvent2;
            }
            throw (nIllegalStateException)nExceptionFactory.getException(29, "Durable Viewer was closed.");
        }

        private void loadArray() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nChannelNotFoundException, nSecurityException {
            ArrayList<nPublished> arrayList;
            nIndexedDurableViewerEvent nIndexedDurableViewerEvent2 = new nIndexedDurableViewerEvent(1, this.myTopicId, this.myDurableId);
            nIndexedDurableViewerEvent2.setCurrentEID(this.myCurrentID);
            nEvent nEvent2 = this.myDurable.myChannel.getBaseChannel().writeEvent(nIndexedDurableViewerEvent2);
            if (nEvent2 instanceof nIndexedDurableViewerEvent && (arrayList = ((nIndexedDurableViewerEvent)nEvent2).getEvents()) != null && arrayList.size() > 0) {
                for (nPublished nPublished2 : arrayList) {
                    this.myList.add(nConsumeEventConverter.nPublishedTonConsumeEvent(nPublished2));
                }
            }
            nExceptionEventProcessor.checkChannelNotFound(nEvent2);
            nExceptionEventProcessor.checkSecurityException(nEvent2);
        }
    }
}

