/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nMessageSigner;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

public class nPassphraseSigner
implements nMessageSigner {
    private byte[] myPassphrase;
    private MessageDigest myDigest;
    private static String defaultAlgorithm = "SHA";

    public static String getDefaultAlgorithm() {
        return defaultAlgorithm;
    }

    public nPassphraseSigner(String string) throws NoSuchAlgorithmException, nIllegalArgumentException {
        this(string, defaultAlgorithm);
    }

    public nPassphraseSigner(String string, String string2) throws NoSuchAlgorithmException, nIllegalArgumentException {
        if (string == null) {
            throw new nIllegalArgumentException("Supplied passphrase can not be null");
        }
        if (string2 == null) {
            throw new nIllegalArgumentException("Supplied algorithm can not be null");
        }
        if (string.length() == 0) {
            throw new nIllegalArgumentException("Passphrase must be at least one character");
        }
        this.myDigest = MessageDigest.getInstance(string2);
        try {
            this.myPassphrase = fStringByteConverter.convert(string);
        }
        catch (Exception exception) {
            this.myPassphrase = string.getBytes();
        }
        this.myDigest.update(this.myPassphrase);
    }

    @Override
    public Provider getProvider() {
        return this.myDigest.getProvider();
    }

    @Override
    public void update(byte[] byArray) throws Exception {
        this.myDigest.update(byArray);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] byArray = this.myDigest.digest();
        this.myDigest.update(this.myPassphrase);
        this.myDigest.update(byArray);
        byArray = this.myDigest.digest();
        this.myDigest.update(this.myPassphrase);
        return byArray;
    }
}

