/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.events.nQueueTransactionStatus;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nChannelAlreadySubscribedException;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nEventListener;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nQueueReader;
import com.pcbsys.nirvana.client.nQueueReaderContext;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nSignedEventListener;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;

public class nQueueAsyncReader
extends nQueueReader {
    private static final String CLASS_NAME = nQueueAsyncReader.class.getSimpleName();

    protected nQueueAsyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2) throws nIllegalArgumentException, nSecurityException {
        this(nQueue2, nQueueReaderContext2, null);
    }

    protected nQueueAsyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, nUnAckedEventManager nUnAckedEventManager2) throws nIllegalArgumentException, nSecurityException {
        this(nQueue2, nQueueReaderContext2, false, nUnAckedEventManager2);
    }

    protected nQueueAsyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, boolean bl) throws nIllegalArgumentException, nSecurityException {
        this(nQueue2, nQueueReaderContext2, bl, null);
    }

    protected nQueueAsyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, boolean bl, nUnAckedEventManager nUnAckedEventManager2) throws nIllegalArgumentException, nSecurityException {
        block14: {
            Object object;
            super(nQueue2, nQueueReaderContext2, nQueueTransactionStatus.ASYNC_READER_UNIQUE_ID, nUnAckedEventManager2);
            if (nQueue2.getTraceLogger().isTraceEnabled()) {
                object = "Unavailable";
                try {
                    object = this.getReaderId();
                }
                catch (nSessionNotConnectedException nSessionNotConnectedException2) {
                    // empty catch block
                }
                nQueue2.getTraceLogger().trace("Creating a queue asynchronous reader. readerId=" + (String)object + ClientEventTraceLoggerContext.addClientConnectionInfo(nQueue2.getConnectionManager()), CLASS_NAME);
            }
            if (nQueueReaderContext2.getListener() == null) {
                throw new nIllegalArgumentException("Must supply an Event Listener");
            }
            try {
                object = new EventConsumerWrapper(nQueueReaderContext2.getListener());
                nQueue2.getBaseChannel().addSubscriber((nEventListener)object, nQueueReaderContext2.getSelector(), nQueueReaderContext2.getWindow(), nQueueReaderContext2.getValidator(), false, nQueueReaderContext2.canMaintainPriority(), nQueueReaderContext2.isInfiniteWindow());
            }
            catch (nChannelAlreadySubscribedException nChannelAlreadySubscribedException2) {
                if (!bl) {
                    nConstants.logger.warn(nChannelAlreadySubscribedException2);
                    throw new nIllegalArgumentException(nChannelAlreadySubscribedException2.toString());
                }
                nConstants.logger.warn("Removing and adding subscriber for queue reader - " + nChannelAlreadySubscribedException2);
                try {
                    nQueue2.getBaseChannel().removeSubscriber();
                    Thread.sleep(500L);
                    nQueue2.getBaseChannel().addSubscriber(new EventConsumerWrapper(nQueueReaderContext2.getListener()), nQueueReaderContext2.getSelector(), nQueueReaderContext2.getWindow(), nQueueReaderContext2.getValidator(), false, nQueueReaderContext2.canMaintainPriority(), nQueueReaderContext2.isInfiniteWindow());
                    nConstants.logger.warn("Successfully removed and added subscriber for queue reader");
                }
                catch (Exception exception) {
                    if (exception instanceof nSessionNotConnectedException || exception instanceof nRequestTimedOutException) {
                        nConstants.logger.warn("nQueueAsyncReader failed to handle nChannelAlreadySubscribedException - " + exception);
                        break block14;
                    }
                    nConstants.logger.warn(nChannelAlreadySubscribedException2);
                }
            }
            catch (Exception exception) {
                if (exception instanceof nSessionNotConnectedException || exception instanceof nRequestTimedOutException) {
                    nConstants.logger.warn("nQueueAsyncReader failed to initialise - " + exception);
                } else {
                    nConstants.logger.warn(exception);
                }
                if (exception instanceof nSecurityException) {
                    throw (nSecurityException)exception;
                }
                throw new nIllegalArgumentException("nQueueAsyncReader failed to initialise - " + exception);
            }
        }
    }

    @Override
    protected void receivedEvent(nConsumeEvent nConsumeEvent2) {
    }

    @Override
    public String getReaderId() throws nSessionNotConnectedException {
        return this.myQueue.getSession().getId();
    }

    @Override
    protected final void close() throws nUnexpectedResponseException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException {
        if (this.myQueue.getTraceLogger().isTraceEnabled()) {
            this.myQueue.getTraceLogger().trace("Closing queue asynchronous reader. " + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myQueue.getConnectionManager()), CLASS_NAME);
        }
        this.isClosed = true;
        this.myQueue.getBaseChannel().removeSubscriber(true);
        this.eventsConsumed = false;
    }

    class EventConsumerWrapper
    implements nSignedEventListener {
        private nEventListener listener;

        EventConsumerWrapper(nEventListener nEventListener2) {
            this.listener = nEventListener2;
        }

        @Override
        public void go(nConsumeEvent nConsumeEvent2) {
            nQueueAsyncReader.this.eventsConsumed = true;
            nConsumeEvent2.setQueueReader(nQueueAsyncReader.this);
            nQueueAsyncReader.this.receivedEvent(nConsumeEvent2);
            this.listener.go(nConsumeEvent2);
        }

        @Override
        public void go(nConsumeEvent nConsumeEvent2, Object object) {
            nConsumeEvent2.setQueueReader(nQueueAsyncReader.this);
            nQueueAsyncReader.this.receivedEvent(nConsumeEvent2);
            if (this.listener instanceof nSignedEventListener) {
                ((nSignedEventListener)this.listener).go(nConsumeEvent2, object);
            } else {
                this.listener.go(nConsumeEvent2);
            }
        }

        @Override
        public void error(nConsumeEvent nConsumeEvent2, byte[] byArray, Exception exception) {
            nConsumeEvent2.setQueueReader(nQueueAsyncReader.this);
            nQueueAsyncReader.this.receivedEvent(nConsumeEvent2);
            if (this.listener instanceof nSignedEventListener) {
                ((nSignedEventListener)this.listener).error(nConsumeEvent2, byArray, exception);
            } else {
                this.listener.go(nConsumeEvent2);
            }
        }
    }
}

