/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.base.AckRollbackHelper;
import com.pcbsys.nirvana.base.events.nPeekQueue;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nQueueTransactionStatus;
import com.pcbsys.nirvana.base.nRuntime;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nQueuePeekContext;
import com.pcbsys.nirvana.client.nQueueReaderContext;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class nQueueReader {
    private static final AtomicInteger peekContextID = new AtomicInteger(0);
    protected final nQueue myQueue;
    protected final nQueueReaderContext myContext;
    protected boolean isClosed = false;
    protected nPublished[] batch;
    protected long myTimeout = 1L;
    boolean eventsConsumed = false;
    int batchIdx;
    private boolean isClosedLocal = false;
    private final nUnAckedEventManager myOutstandingEvents;
    private final AckRollbackHelper.HelperAttributes helperAttributes = new AckRollbackHelper.HelperAttributes();
    private final AckRollbackHelper ackRollbackHelper = new AckRollbackHelper();
    protected final int myUniqueReaderId;

    public abstract String getReaderId() throws nSessionNotConnectedException;

    public final nConsumeEvent[] peek(nQueuePeekContext nQueuePeekContext2) throws nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSessionPausedException, nIllegalArgumentException, nIllegalStateException {
        this.testClosed();
        if (nQueuePeekContext2 == null) {
            throw new nIllegalArgumentException("Invalid context : null");
        }
        nPeekQueue nPeekQueue2 = this.myQueue.getBaseChannel().peekQueue(nQueuePeekContext2, this.myUniqueReaderId);
        nPublished[] nPublishedArray = nPeekQueue2.getWindow();
        if (nPublishedArray != null) {
            nConsumeEvent[] nConsumeEventArray = new nConsumeEvent[nPublishedArray.length];
            for (int i = 0; i < nPublishedArray.length; ++i) {
                nConsumeEventArray[i] = nConsumeEventConverter.nPublishedTonConsumeEvent(nPublishedArray[i]);
            }
            nQueuePeekContext2.setIndex(nPeekQueue2.getIndex());
            nQueuePeekContext2.setHasMore(nPeekQueue2.hasMore());
            nQueuePeekContext2.setWindowSize(nPeekQueue2.getWindowSize());
            this.eventsConsumed = true;
            return nConsumeEventArray;
        }
        nQueuePeekContext2.setHasMore(false);
        return null;
    }

    public static nQueuePeekContext createContext() {
        return new nQueuePeekContext();
    }

    public static nQueuePeekContext createContext(int n) {
        return new nQueuePeekContext(n);
    }

    public static nQueuePeekContext createContext(int n, String string) {
        return new nQueuePeekContext(n, string);
    }

    final void testClosed() throws nIllegalStateException {
        if (this.isClosedLocal) {
            return;
        }
        if (this.isClosed) {
            throw new nIllegalStateException("Reader has been closed.");
        }
        if (this.myQueue.isStoreObjectInvalid()) {
            throw new nIllegalStateException("This queue object is obsolete please perform a findQueue and discard this object");
        }
    }

    protected nQueueReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, int n, nUnAckedEventManager nUnAckedEventManager2) {
        this.myQueue = nQueue2;
        this.myContext = nQueueReaderContext2;
        this.myOutstandingEvents = nUnAckedEventManager2;
        this.myUniqueReaderId = n;
        this.helperAttributes.setChannel(this.myQueue.getBaseChannel());
        this.helperAttributes.setReaderUniqueId(this.myUniqueReaderId);
        this.helperAttributes.setUnAckedEventManager(nUnAckedEventManager2);
    }

    protected nQueueReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, nUnAckedEventManager nUnAckedEventManager2) {
        this(nQueue2, nQueueReaderContext2, peekContextID.incrementAndGet(), nUnAckedEventManager2);
    }

    protected nQueueReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2) {
        this(nQueue2, nQueueReaderContext2, null);
    }

    protected nQueue getQueue() {
        return this.myQueue;
    }

    protected void reconnected() {
        this.myOutstandingEvents.clear();
    }

    protected void rollEids(List<Long> list) {
        for (Long l : list) {
            this.myOutstandingEvents.rollback(l, false);
        }
    }

    void handleStatus(nQueueTransactionStatus nQueueTransactionStatus2) {
        if (this.myOutstandingEvents == null) {
            return;
        }
        if (nQueueTransactionStatus2.commitEidSeq()) {
            long[] lArray = nQueueTransactionStatus2.getEIDSequence();
            if (lArray == null) {
                this.myOutstandingEvents.clear();
            } else if (nRuntime.sDevelopersBuild) {
                nConstants.logger.log("Received a list of EID's to set however this is unsupported");
            }
        }
    }

    nUnAckedEventManager getEventManager() {
        return this.myOutstandingEvents;
    }

    protected abstract void close() throws nUnexpectedResponseException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException;

    protected abstract void receivedEvent(nConsumeEvent var1);

    protected final void closeLocally() {
        this.isClosedLocal = true;
    }

    public boolean hasConsumedEvents() {
        return this.eventsConsumed;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isClosedLocally() {
        return this.isClosedLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCommitOrRollback(long l, boolean bl, boolean bl2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        boolean bl3 = true;
        long l2 = 0L;
        if (this.myTimeout < 0L) {
            this.myTimeout += Long.MAX_VALUE;
        }
        if (this.myTimeout == 0L) {
            this.myTimeout = 1L;
        }
        this.helperAttributes.setAckPrevious(bl2);
        while (bl3 && l2 < this.myTimeout) {
            nQueueReader nQueueReader2;
            this.testClosed();
            try {
                nIllegalStateException nIllegalStateException2;
                long[] lArray;
                if (bl) {
                    lArray = l < 0L ? this.myOutstandingEvents.getEIDs(Long.MAX_VALUE, bl2) : this.myOutstandingEvents.getEIDs(l, bl2);
                    try {
                        this.ackRollbackHelper.sendQueueAck(lArray, this.helperAttributes);
                    }
                    catch (nIllegalArgumentException nIllegalArgumentException2) {
                        nIllegalStateException2 = new nIllegalStateException("Illegal or invalid helper attribute");
                        nIllegalStateException2.initCause(nIllegalArgumentException2);
                        throw nIllegalStateException2;
                    }
                }
                lArray = this.myOutstandingEvents.getEIDsToRollback(l, bl2);
                try {
                    this.ackRollbackHelper.sendQueueRollback(lArray, this.helperAttributes);
                }
                catch (nIllegalArgumentException nIllegalArgumentException3) {
                    nIllegalStateException2 = new nIllegalStateException("Illegal or invalid helper attribute");
                    nIllegalStateException2.initCause(nIllegalArgumentException3);
                    throw nIllegalStateException2;
                }
                bl3 = false;
                this.eventsConsumed = false;
            }
            catch (nSessionPausedException nSessionPausedException2) {
                if (this.myTimeout == 1L) {
                    throw nSessionPausedException2;
                }
                while (this.myQueue.getConnectionManager().isPaused() && l2 < this.myTimeout) {
                    nQueueReader2 = this;
                    synchronized (nQueueReader2) {
                        try {
                            this.wait(nConstants.getPushWaitLimit());
                            l2 += (long)nConstants.getPushWaitLimit();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                if (this.myTimeout == 1L) {
                    throw nRequestTimedOutException2;
                }
                nQueueReader2 = this;
                synchronized (nQueueReader2) {
                    try {
                        this.wait(nConstants.getPushWaitLimit());
                        l2 += (long)nConstants.getPushWaitLimit();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (bl3 && l2 >= this.myTimeout) {
            if (bl) {
                throw new nRequestTimedOutException("Failed to commit eid " + l + " before timeout " + this.myTimeout);
            }
            throw new nRequestTimedOutException("Failed to rollback eid " + l + " before timeout " + this.myTimeout);
        }
    }
}

