/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManager;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nExceptionEvent;
import com.pcbsys.nirvana.base.events.nPopQueue;
import com.pcbsys.nirvana.base.events.nPopQueueCommand;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nExceptionFactory;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.RequestTimeoutHelper;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannelImpl;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nQueueReader;
import com.pcbsys.nirvana.client.nQueueReaderContext;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import java.util.Arrays;

public class nQueueSyncReader
extends nQueueReader {
    private static final String CLASS_NAME = nQueueSyncReader.class.getSimpleName();
    protected final long READER_CLOSE_TIMEOUT = 10000L;
    private nQueueReaderManager queueReaderManager;

    nQueueSyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, nQueueReaderManager nQueueReaderManager2) {
        this(nQueue2, nQueueReaderContext2, null, nQueueReaderManager2);
    }

    protected nQueueSyncReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, nUnAckedEventManager nUnAckedEventManager2, nQueueReaderManager nQueueReaderManager2) {
        super(nQueue2, nQueueReaderContext2, nUnAckedEventManager2);
        this.queueReaderManager = nQueueReaderManager2;
    }

    public final nConsumeEvent pop() throws nSessionNotConnectedException, nSessionPausedException, nSecurityException, nIllegalStateException {
        return this.pop(-1L, this.myContext.getSelector());
    }

    public final nConsumeEvent pop(long l) throws nSessionNotConnectedException, nSessionPausedException, nSecurityException, nIllegalStateException {
        return this.pop(l, this.myContext.getSelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final nConsumeEvent pop(long l, String string) throws nSessionNotConnectedException, nSessionPausedException, nSecurityException, nIllegalStateException {
        if (this.myQueue.getTraceLogger().isInfoEnabled()) {
            this.myQueue.getTraceLogger().info("Pop from queue initiated. readerId=" + this.getReaderId() + ", conn=" + this.myQueue.getBaseChannel().getConnectionManager().getSessionInfo(), CLASS_NAME);
        }
        this.testClosed();
        nQueueSyncReader nQueueSyncReader2 = this;
        synchronized (nQueueSyncReader2) {
            Object object;
            nEvent nEvent2;
            if (this.batch != null) {
                nConsumeEvent nConsumeEvent2 = nConsumeEventConverter.nPublishedTonConsumeEvent(this.batch[this.batchIdx]);
                nConsumeEvent2.setChannel(this.myQueue.getBaseChannel());
                nConsumeEvent2.setQueueReader(this);
                if (this.myQueue.getTraceLogger().isInfoEnabled()) {
                    this.myQueue.getTraceLogger().info("Events present in the client side batch, retrieving from the batch. readerId=" + this.getReaderId() + ", event={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent2) + "}", CLASS_NAME);
                }
                ++this.batchIdx;
                if (this.batchIdx == this.batch.length) {
                    this.batch = null;
                    this.batchIdx = 0;
                }
                this.receivedEvent(nConsumeEvent2);
                return nConsumeEvent2;
            }
            nPopQueue nPopQueue2 = new nPopQueue(this.myQueue.getBaseAttributes(), nPopQueueCommand.POP, string, (long)this.myUniqueReaderId);
            nPopQueue2.setTimeout(l);
            nPopQueue2.setWindowSize(this.getWindowSize());
            nPopQueue2.setIsInfiniteWindow(this.myContext.isInfiniteWindow());
            nPopQueue2.setBatchSize(this.myContext.getPeekBatchSize());
            if (this.myQueue.getTraceLogger().isInfoEnabled()) {
                this.myQueue.getTraceLogger().info("Requesting events from server. Sending nPopQueue event={" + ClientEventTraceLoggerContext.addPopQueueInfo(nPopQueue2) + "}", CLASS_NAME);
            }
            long l2 = fTimer.getTicks();
            try {
                nEvent2 = this.myQueue.getBaseChannel().writeEvent(nPopQueue2, RequestTimeoutHelper.getResetTimeout(l));
                if (fTimer.getTicks() - l2 > RequestTimeoutHelper.getDelayTimeout(l)) {
                    object = this.myQueue.getChannel();
                    nConstants.logger.fatal("Queue Sync Reader> Pop queue event with ID " + nPopQueue2.getRequestId() + " is delayed for queue " + ((nChannelImpl)object).getName() + ", session ID " + Long.toHexString(((nChannelImpl)object).getConnectionManager().getServerProvidedSessionID()) + ", connection " + ((nChannelImpl)object).getConnectionManager().getLocalHostAndPort() + ", elapsed time ms " + (fTimer.getTicks() - l2));
                }
                if (this.myQueue.getTraceLogger().isWarnEnabled()) {
                    object = "Pop request delayed. requestId=" + nPopQueue2.getRequestId() + ", elapsedTime=" + (fTimer.getTicks() - l2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myQueue.getConnectionManager());
                    this.myQueue.getTraceLogger().warn((String)object, CLASS_NAME);
                }
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                nChannelImpl nChannelImpl2 = this.myQueue.getChannel();
                if (this.myQueue.getTraceLogger().isWarnEnabled()) {
                    String string2 = "Resetting client connection because pop request timed out requestId=" + nPopQueue2.getRequestId() + ", readerId=" + this.getReaderId() + ", elapsedTime=" + (fTimer.getTicks() - l2) + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myQueue.getConnectionManager());
                    this.myQueue.getTraceLogger().warn(string2, CLASS_NAME);
                }
                nConstants.logger.fatal("Queue Sync Reader> Resetting client connection because request with ID " + nPopQueue2.getRequestId() + " timed out for queue " + nChannelImpl2.getName() + ", session ID " + Long.toHexString(nChannelImpl2.getConnectionManager().getServerProvidedSessionID()) + ", connection " + nChannelImpl2.getConnectionManager().getLocalHostAndPort() + ", elapsed time ms " + (fTimer.getTicks() - l2));
                nChannelImpl2.getConnectionManager().resetConnection();
                return null;
            }
            if (nEvent2 instanceof nPopQueue) {
                object = (nPopQueue)nEvent2;
                nPublished nPublished2 = ((nPopQueue)object).getEvent();
                nPublished[] nPublishedArray = ((nPopQueue)object).getEvents();
                if (nPublished2 != null) {
                    this.eventsConsumed = true;
                    nConsumeEvent nConsumeEvent3 = nConsumeEventConverter.nPublishedTonConsumeEvent(nPublished2);
                    nConsumeEvent3.setChannel(this.myQueue.getBaseChannel());
                    nConsumeEvent3.setQueueReader(this);
                    this.receivedEvent(nConsumeEvent3);
                    if (this.myQueue.getTraceLogger().isInfoEnabled()) {
                        this.myQueue.getTraceLogger().info("Received response from server. readerId=" + this.getReaderId() + ", requestId=" + nPopQueue2.getRequestId() + ", event={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent3) + "}", CLASS_NAME);
                    }
                    return nConsumeEvent3;
                }
                if (nPublishedArray != null) {
                    this.eventsConsumed = true;
                    this.batch = nPublishedArray;
                    this.batchIdx = 0;
                    nConsumeEvent nConsumeEvent4 = nConsumeEventConverter.nPublishedTonConsumeEvent(nPublishedArray[this.batchIdx]);
                    nConsumeEvent4.setChannel(this.myQueue.getBaseChannel());
                    nConsumeEvent4.setQueueReader(this);
                    this.receivedEvent(nConsumeEvent4);
                    if (this.myQueue.getTraceLogger().isInfoEnabled()) {
                        this.myQueue.getTraceLogger().info("Received batch response from server. readerId=" + this.getReaderId() + ", requestId=" + nPopQueue2.getRequestId() + ", batchEids=" + ClientEventTraceLoggerContext.addPubEventsInfo(Arrays.asList(nPublishedArray)) + " Retrieving event from the batch={" + ClientEventTraceLoggerContext.addConsumeEventTraceInfo(nConsumeEvent4) + "}", CLASS_NAME);
                    }
                    ++this.batchIdx;
                    if (this.batchIdx == this.batch.length) {
                        this.batch = null;
                        this.batchIdx = 0;
                    }
                    return nConsumeEvent4;
                }
            } else {
                try {
                    if (nEvent2 instanceof nExceptionEvent) {
                        object = (nExceptionEvent)nEvent2;
                        nBaseClientException nBaseClientException2 = nExceptionFactory.getException(((nExceptionEvent)object).getExceptionId(), ((nExceptionEvent)object).getMessage());
                        throw new nIllegalStateException(nBaseClientException2.getMessage());
                    }
                    nExceptionEventProcessor.checkSecurityException(nEvent2);
                }
                catch (Exception exception) {
                    if (this.myQueue.getTraceLogger().isWarnEnabled()) {
                        this.myQueue.getTraceLogger().warn("Pop queue request failed. requestId=" + nPopQueue2.getRequestId() + ", readerId=" + this.getReaderId() + ", reason=" + exception.getMessage(), CLASS_NAME, exception);
                    }
                    throw exception;
                }
            }
        }
        if (this.myQueue.getTraceLogger().isInfoEnabled()) {
            this.myQueue.getTraceLogger().info("No events present in pop queue response readerId=" + this.getReaderId() + ", conn=" + this.myQueue.getConnectionManager().getSessionInfo(), CLASS_NAME);
        }
        return null;
    }

    public boolean hasEventsCached() {
        if (this.batch != null) {
            return true;
        }
        return this.queueReaderManager.hasEventsWaiting(this.myQueue.getBaseAttributes().getUniqueId(), this.myUniqueReaderId);
    }

    @Override
    public String getReaderId() throws nSessionNotConnectedException {
        return this.myQueue.getSession().getId() + "-" + this.myUniqueReaderId;
    }

    @Override
    protected void close() throws nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException {
        nPopQueue nPopQueue2 = new nPopQueue(this.myQueue.getQueueAttributes().getUniqueId(), nPopQueueCommand.CLOSE, this.myUniqueReaderId);
        nEvent nEvent2 = this.myQueue.getBaseChannel().writeEvent(nPopQueue2, 10000L);
        if (nEvent2 != null && nEvent2.getId() != 33) {
            nExceptionEventProcessor.checkSessionPausedException(nEvent2);
            nExceptionEventProcessor.checkSessionNotConnectedException(nEvent2);
            nExceptionEventProcessor.checkRequestTimeoutException(nEvent2);
        }
        this.isClosed = true;
    }

    @Override
    protected void receivedEvent(nConsumeEvent nConsumeEvent2) {
    }

    protected int getWindowSize() {
        return 0;
    }
}

