/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.nirvana.base.clientimpl.nQueueReaderManager;
import com.pcbsys.nirvana.base.nUnAckedEventManager;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nIllegalStateException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nQueueReaderContext;
import com.pcbsys.nirvana.client.nQueueSyncReader;
import com.pcbsys.nirvana.client.nQueueTransactionReader;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;

public final class nQueueSyncTransactionReader
extends nQueueSyncReader
implements nQueueTransactionReader {
    private static final String CLASS_NAME = nQueueSyncTransactionReader.class.getSimpleName();

    protected nQueueSyncTransactionReader(nQueue nQueue2, nQueueReaderContext nQueueReaderContext2, nQueueReaderManager nQueueReaderManager2) {
        super(nQueue2, nQueueReaderContext2, new nUnAckedEventManager(), nQueueReaderManager2);
        if (nQueueReaderContext2.getWindow() == 0) {
            nQueueReaderContext2.setWindow(10);
        }
        this.myTimeout = this.myContext.getTimeout();
    }

    @Override
    public final void commit() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.commit(-1L);
    }

    @Override
    public final void commit(long l) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.commit(l, true);
    }

    @Override
    public final void commit(long l, boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.testClosed();
        if (this.myQueue.getTraceLogger().isTraceEnabled()) {
            this.myQueue.getTraceLogger().trace("Queue sync transaction reader commit invoked. eventId=" + l + ", ackPrevious=" + bl + ", readerId=" + this.getReaderId(), CLASS_NAME);
        }
        this.doCommitOrRollback(l, true, bl);
        this.getEventManager().commit(l, bl);
    }

    @Override
    public final void rollback() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.rollback(-1L);
    }

    @Override
    public final void rollback(long l) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.rollback(l, false);
    }

    @Override
    public final void rollback(long l, boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nIllegalStateException {
        this.testClosed();
        if (this.myQueue.getTraceLogger().isTraceEnabled()) {
            this.myQueue.getTraceLogger().trace("Queue sync transaction reader rollback invoked. eventId=" + l + ", individualRollback=" + bl + ", readerId=" + this.getReaderId(), CLASS_NAME);
        }
        this.doCommitOrRollback(l, false, !bl);
        this.getEventManager().rollback(l, bl);
    }

    @Override
    protected void receivedEvent(nConsumeEvent nConsumeEvent2) {
        this.getEventManager().receivedEvent(nConsumeEvent2);
    }

    @Override
    public void close() {
        block5: {
            try {
                super.close();
            }
            catch (nSessionPausedException nSessionPausedException2) {
                this.isClosed = true;
                if (nConstants.logger.isDebugEnabled()) {
                    nConstants.logger.debug("Session paused while closing reader with id " + this.myUniqueReaderId);
                }
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                nConstants.logger.error("Failed to close reader with id " + this.myUniqueReaderId, nRequestTimedOutException2);
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {
                if (!nConstants.logger.isDebugEnabled()) break block5;
                nConstants.logger.debug("Session disconnected while closing reader with id " + this.myUniqueReaderId);
            }
        }
    }

    @Override
    protected int getWindowSize() {
        return this.myContext.getWindow() > 0 ? this.myContext.getWindow() : nQueueReaderContext.DEFAULT_WINDOW_SIZE;
    }
}

