/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.clientimpl.CommonStaticMethods;
import com.pcbsys.nirvana.base.clientimpl.nConnectionManagerBuilder;
import com.pcbsys.nirvana.base.clientimpl.nConnectionStatisticsManager;
import com.pcbsys.nirvana.base.clientimpl.nDataGroupManager;
import com.pcbsys.nirvana.base.clientimpl.nEventProcessor;
import com.pcbsys.nirvana.base.clientimpl.nExceptionListenerManager;
import com.pcbsys.nirvana.base.clientimpl.nRealmManager;
import com.pcbsys.nirvana.base.clientimpl.nRedirectManager;
import com.pcbsys.nirvana.base.clientimpl.nStoreManager;
import com.pcbsys.nirvana.base.clientimpl.singleconnection.eventhandlers.EventHandlerInitialiser;
import com.pcbsys.nirvana.base.events.nAddRealm;
import com.pcbsys.nirvana.base.events.nBatchPublish;
import com.pcbsys.nirvana.base.events.nCancelRequests;
import com.pcbsys.nirvana.base.events.nClientHeartBeat;
import com.pcbsys.nirvana.base.events.nDataStreamPublish;
import com.pcbsys.nirvana.base.events.nDelRealm;
import com.pcbsys.nirvana.base.events.nDeleteChannel;
import com.pcbsys.nirvana.base.events.nDeleteChannels;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nFindAndSubscribe;
import com.pcbsys.nirvana.base.events.nGetChannelList;
import com.pcbsys.nirvana.base.events.nGetRealm;
import com.pcbsys.nirvana.base.events.nHasQuorum;
import com.pcbsys.nirvana.base.events.nMakeChannel;
import com.pcbsys.nirvana.base.events.nMakeChannels;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nRedirection;
import com.pcbsys.nirvana.base.events.nServerDisconnect;
import com.pcbsys.nirvana.base.events.nServerExtensionEvent;
import com.pcbsys.nirvana.base.events.nUserFind;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.base.nThreadManager;
import com.pcbsys.nirvana.client.SessionAttributes;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nAsyncExceptionListener;
import com.pcbsys.nirvana.client.nBaseClientException;
import com.pcbsys.nirvana.client.nChannel;
import com.pcbsys.nirvana.client.nChannelAlreadyExistsException;
import com.pcbsys.nirvana.client.nChannelAttributes;
import com.pcbsys.nirvana.client.nChannelIteratorHelper;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConflationAttributes;
import com.pcbsys.nirvana.client.nConnectionQueueListener;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nCreateResult;
import com.pcbsys.nirvana.client.nDataGroup;
import com.pcbsys.nirvana.client.nDataGroupListener;
import com.pcbsys.nirvana.client.nDataGroupManagerHelper;
import com.pcbsys.nirvana.client.nDataStream;
import com.pcbsys.nirvana.client.nDataStreamListener;
import com.pcbsys.nirvana.client.nDeleteResult;
import com.pcbsys.nirvana.client.nDurableHelper;
import com.pcbsys.nirvana.client.nEventProperties;
import com.pcbsys.nirvana.client.nFindResult;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nIllegalChannelMode;
import com.pcbsys.nirvana.client.nMaxBufferSizeExceededException;
import com.pcbsys.nirvana.client.nNameSpaceConflictException;
import com.pcbsys.nirvana.client.nQueue;
import com.pcbsys.nirvana.client.nQueueReaderManagerHelper;
import com.pcbsys.nirvana.client.nRealm;
import com.pcbsys.nirvana.client.nRealmAlreadyBoundException;
import com.pcbsys.nirvana.client.nRealmInUseException;
import com.pcbsys.nirvana.client.nRealmNotFoundException;
import com.pcbsys.nirvana.client.nRealmUnreachableException;
import com.pcbsys.nirvana.client.nReconnectHandler;
import com.pcbsys.nirvana.client.nRedirectManagerHelper;
import com.pcbsys.nirvana.client.nRegisteredEvent;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nServerExtensionCallback;
import com.pcbsys.nirvana.client.nSessionAlreadyInitialisedException;
import com.pcbsys.nirvana.client.nSessionAttributes;
import com.pcbsys.nirvana.client.nSessionFactory;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nStoreManagerHelper;
import com.pcbsys.nirvana.client.nStorePermission;
import com.pcbsys.nirvana.client.nSubject;
import com.pcbsys.nirvana.client.nSubscriptionAttributes;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import com.pcbsys.nirvana.client.nUnknownRemoteRealmException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class nSession {
    private static final String CLASS_NAME = nSession.class.getSimpleName();
    private static final AtomicInteger sClientSideID = new AtomicInteger(0);
    private final String myUsername;
    private final String myPassword;
    private final nSessionAttributes myAttributes;
    protected final String myUniqueClientAllocatedID;
    private boolean isPaused;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final nThreadManager myThreadManager;
    protected final nEventProcessor myEventProcessor;
    private final nExceptionListenerManager myExceptionListenerManager;
    private final nConnectionStatisticsManager myConnectionStatisticsManager;
    protected final nStoreManager myStoreManager;
    protected final nDataGroupManager myDataGroupManager;
    private final nRealmManager myRealmManager;
    final nRedirectManager myRedirectionManager;
    protected final ClientConnectionManager myConnectionManager;
    private nDurableHelper myDurableHelper;

    private nSession(nSessionAttributes nSessionAttributes2, String string, String string2) throws nIllegalArgumentException {
        if (nSessionAttributes2 == null) {
            throw new nIllegalArgumentException("Provided nSessionAttributes was null");
        }
        for (int i = 0; i < nSessionAttributes2.getConnections().size(); ++i) {
            for (fConnectionDetails fConnectionDetails2 : nSessionAttributes2.getConnections().get(i)) {
                if (fConnectionDetails2.getType() != 12 || Constants.sMappingSupported) continue;
                throw new nIllegalArgumentException("SHM protocol is not supported on current platform");
            }
        }
        if (this.isAdminApiSession() && nSessionAttributes2.getConnections().size() > 1) {
            throw new nIllegalArgumentException("Provided nSessionAttributes is configured for horizontal scalabilty, this is illegal when we are a admin sesison");
        }
        this.myAttributes = nSessionAttributes2;
        this.myUsername = string;
        this.myPassword = string2;
        this.myUniqueClientAllocatedID = Long.toString(sClientSideID.incrementAndGet());
        nConstants.logger.warn("Session " + this.myUniqueClientAllocatedID + " has been created with URL list: " + this.myAttributes.toString());
        this.myThreadManager = new nThreadManager(this.myUniqueClientAllocatedID);
        this.myDurableHelper = new nDurableHelper();
        this.myConnectionManager = new nConnectionManagerBuilder().setUniqueClientAllocatedID(this.myUniqueClientAllocatedID).setSession(this).setSessionAttributes(new SessionAttributes(this.myAttributes)).setThreadManager(this.myThreadManager).setQueueReaderManagerHelper(new nQueueReaderManagerHelper()).setDataGroupManagerHelper(new nDataGroupManagerHelper()).setChannelIteratorHelper(new nChannelIteratorHelper()).setRedirectManagerHelper(new nRedirectManagerHelper()).setStoreManagerHelper(new nStoreManagerHelper()).setDurableManagerHelper(this.myDurableHelper).setUsername(this.myUsername).setPassword(this.myPassword).setAdminApiSession(this.isAdminApiSession()).createConnectionManager();
        this.myExceptionListenerManager = this.myConnectionManager.getExceptionListenerManager();
        this.myStoreManager = this.myConnectionManager.getStoreManager();
        this.myDataGroupManager = this.myConnectionManager.getDataGroupManager();
        this.myRealmManager = this.myConnectionManager.getRealmManager();
        this.myRedirectionManager = this.myConnectionManager.getRedirectManager();
        this.myConnectionStatisticsManager = this.myConnectionManager.getConnectionStatisticsManager();
        this.myEventProcessor = this.myConnectionManager.getEventProcessor();
        nConstants.logger.warn("Session " + this.myUniqueClientAllocatedID + " has been created with URL list: " + this.myAttributes.toString());
    }

    protected nSession(nSessionAttributes nSessionAttributes2) throws nIllegalArgumentException {
        this(nSessionAttributes2, null, fEnvironment.getUsername(), null);
    }

    protected nSession(nSession nSession2, String string, String string2) throws nIllegalArgumentException {
        this(nSession2 != null ? nSession2.myAttributes : null, string, string2);
        this.myConnectionManager.configureMultiplexManager(nSession2.myConnectionManager);
    }

    protected nSession(nSessionAttributes nSessionAttributes2, nReconnectHandler nReconnectHandler2) throws nIllegalArgumentException {
        this(nSessionAttributes2, nReconnectHandler2, fEnvironment.getUsername(), null);
        if (nReconnectHandler2 == null) {
            throw new nIllegalArgumentException("nReconnectHandler was null");
        }
    }

    protected nSession(nSessionAttributes nSessionAttributes2, nReconnectHandler nReconnectHandler2, String string, String string2) throws nIllegalArgumentException {
        this(nSessionAttributes2, string, string2);
        this.myConnectionManager.addReconnectHandler(nReconnectHandler2);
    }

    public void init() throws nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nSessionAlreadyInitialisedException {
        this.init(null);
    }

    @Deprecated
    public void init(boolean bl) throws nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nSessionAlreadyInitialisedException {
        this.myAttributes.setDisconnectOnClusterFailure(bl);
        this.init(null);
    }

    @Deprecated
    public nDataStream init(boolean bl, nDataStreamListener nDataStreamListener2) throws nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nSessionAlreadyInitialisedException {
        this.myAttributes.setDisconnectOnClusterFailure(bl);
        return this.init(nDataStreamListener2);
    }

    public nDataStream init(nDataStreamListener nDataStreamListener2) throws nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nSessionAlreadyInitialisedException {
        if (this.myConnectionManager.isInitialised()) {
            throw new nSessionAlreadyInitialisedException("Session already initialised");
        }
        this.myThreadManager.initialise();
        return this.myConnectionManager.initialise(nDataStreamListener2, this.getEventHandlerInitialser(), this.myAttributes.isDisconnectOnClusterFailure(), this.myAttributes.isSessionThreadsDaemon());
    }

    @Deprecated
    public void setReadThreadAsDaemon(boolean bl) {
        this.myAttributes.setSessionThreadsAsDaemon(bl);
    }

    public void setThreadPoolSize(int n) {
        this.myThreadManager.setThreadPoolSize(n);
    }

    public int getThreadPoolSize() {
        return this.myThreadManager.getThreadPoolSize();
    }

    public synchronized void enableThreading() {
        this.myThreadManager.enableThreading(true);
    }

    public synchronized void enableThreading(boolean bl) {
        this.myThreadManager.enableThreading(bl);
    }

    public synchronized void enableThreading(int n) {
        this.myThreadManager.setThreadPoolSize(n);
        this.myThreadManager.enableThreading();
    }

    public void unblockThread(String string) {
        this.myConnectionManager.unblockThread(string);
    }

    public synchronized void pause(boolean bl) {
        nConstants.logger.warn("Pausing nSession");
        this.isPaused = true;
        if (bl) {
            try {
                nCancelRequests nCancelRequests2 = new nCancelRequests();
                nCancelRequests2.setSynchronous(false);
                this.myEventProcessor.writeEvent(nCancelRequests2);
                this.myConnectionManager.releaseRequests();
            }
            catch (Exception exception) {
                nConstants.logger.error("Failed to process session pause request due to: " + exception.getMessage(), exception);
            }
        }
    }

    public synchronized void resume() {
        nConstants.logger.warn("Resuming nSession");
        this.isPaused = false;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isConnected() {
        return this.myConnectionManager.isConnected() && !this.isClosing.get();
    }

    public boolean isInitialised() {
        return this.myConnectionManager.isInitialised();
    }

    public String getId() throws nSessionNotConnectedException {
        if (this.isConnected()) {
            return this.myConnectionManager.getLocalHostAndPort();
        }
        throw new nSessionNotConnectedException("The session is not currently connected");
    }

    public String get3rdPartyCookie() throws nSessionNotConnectedException {
        return this.myConnectionManager.getThirdPartyCookies();
    }

    public String getRemoteId() throws nSessionNotConnectedException {
        return this.myConnectionManager.getRemoteUrl();
    }

    public void setAdditionalPrincipals(String[] stringArray) {
        this.myConnectionManager.setPrincipals(stringArray);
    }

    public long getSessionConnectionId() {
        return this.myConnectionManager.getServerProvidedSessionID();
    }

    public void addConnectionQueueListener(nConnectionQueueListener nConnectionQueueListener2) throws nIllegalArgumentException {
        if (nConstants.getWriteHandlerType() != 1) {
            return;
        }
        if (nConnectionQueueListener2 == null) {
            throw new nIllegalArgumentException("Must supply a non null nConnectionQueueListener");
        }
        this.myConnectionStatisticsManager.addInternalConnectionQueueConnectionListener(nConnectionQueueListener2);
    }

    @Deprecated
    public void addConnectionQueueListener(nConnectionQueueListener nConnectionQueueListener2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws nIllegalArgumentException {
        this.addConnectionQueueListener(nConnectionQueueListener2);
    }

    public void removeConnectionQueueListener(nConnectionQueueListener nConnectionQueueListener2) throws nIllegalArgumentException {
        if (nConnectionQueueListener2 == null) {
            throw new nIllegalArgumentException("Must supply a non null nConnectionQueueListener");
        }
        this.myConnectionStatisticsManager.removeInternalConnectionQueueListener(nConnectionQueueListener2);
    }

    public nSubject[] getSubject() throws nSessionNotConnectedException {
        if (this.isConnected()) {
            fSubject fSubject2 = this.myConnectionManager.getSubjectFromConnection();
            nSubject[] nSubjectArray = new nSubject[fSubject2.getPrincipals().size()];
            for (int i = 0; i < fSubject2.getPrincipals().size(); ++i) {
                nSubjectArray[i] = new nSubject((fPrincipal)fSubject2.getPrincipals().elementAt(i));
            }
            return nSubjectArray;
        }
        throw new nSessionNotConnectedException("The session is not currently connected");
    }

    public nSubject getSubjectObject() throws nSessionNotConnectedException {
        fSubject fSubject2 = this.myConnectionManager.getSubjectFromConnection();
        if (fSubject2 != null) {
            return new nSubject(fSubject2);
        }
        throw new nSessionNotConnectedException("The session is not currently connected");
    }

    public long getOutputByteCount() {
        try {
            return this.myConnectionStatisticsManager.getOutputByteCount();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1L;
        }
    }

    public long getInputByteCount() {
        try {
            return this.myConnectionStatisticsManager.getInputByteCount();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1L;
        }
    }

    public long getQueueSize() {
        try {
            return this.myConnectionStatisticsManager.getQueueSize();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1L;
        }
    }

    public long getSentEventCount() {
        try {
            return this.myConnectionStatisticsManager.getEventTxCount();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1L;
        }
    }

    public long getReceivedEventCount() {
        try {
            return this.myConnectionStatisticsManager.getEventRxCount();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1L;
        }
    }

    public int getCurrentLatency() {
        try {
            return this.myConnectionStatisticsManager.getCurrentResponseTime();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return -1;
        }
    }

    public boolean isConnectionVirtual() {
        try {
            return this.myConnectionManager.isVirtual();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
            return false;
        }
    }

    public String getConnectionList() {
        return this.myConnectionManager.getServerProvidedURLList();
    }

    public void updateConnectionListWithServerList() {
        try {
            this.myConnectionManager.updateConnectionListWithServerList();
        }
        catch (nIllegalArgumentException | IOException exception) {
            // empty catch block
        }
    }

    public long getServerTime() throws nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSessionPausedException, nSecurityException {
        nClientHeartBeat nClientHeartBeat2 = new nClientHeartBeat();
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nClientHeartBeat2);
        if (nEvent2 instanceof nClientHeartBeat) {
            return ((nClientHeartBeat)nEvent2).getServerTime();
        }
        return 0L;
    }

    public String getServerRealmName() throws nSessionNotConnectedException {
        return this.myConnectionManager.getServerProvidedRealmName();
    }

    public void addReconnectHandler(nReconnectHandler nReconnectHandler2) {
        this.myConnectionManager.addReconnectHandler(nReconnectHandler2);
    }

    public void removeReconnectHandler(nReconnectHandler nReconnectHandler2) {
        this.myConnectionManager.removeReconnectHandler(nReconnectHandler2);
    }

    public boolean isMemberOfCluster() {
        return this.myConnectionManager.isMemberOfCluster();
    }

    public boolean hasQuorum() throws nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nSessionPausedException, nSecurityException {
        nHasQuorum nHasQuorum2 = new nHasQuorum();
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nHasQuorum2);
        return nEvent2 instanceof nHasQuorum && ((nHasQuorum)nEvent2).hasQuorum();
    }

    protected com.pcbsys.nirvana.base.clientimpl.nDurableHelper getDurableManagerHelper() {
        return this.myDurableHelper;
    }

    public void close() {
        try {
            nSessionFactory.close(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void mainClose() {
        if (this.isClosing.getAndSet(true)) {
            return;
        }
        try {
            try {
                this.myEventProcessor.writeEvent(new nServerDisconnect(), 5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myConnectionManager.close();
        }
        finally {
            try {
                this.myThreadManager.close();
            }
            catch (Throwable throwable) {}
        }
        nConstants.logger.warn("Session " + this.myUniqueClientAllocatedID + " has been closed");
    }

    public String getUsername() {
        return this.myUsername;
    }

    protected String getPassword() {
        return this.myPassword;
    }

    public nSessionAttributes getAttributes() {
        return this.myAttributes;
    }

    public int getServerMaxBufferSize() {
        return this.myConnectionManager.getServerProvidedMaxBufferSize();
    }

    public boolean isMaxBufferSizeClientCheck() {
        return this.myConnectionManager.isMaxBufferSizeClientCheck();
    }

    public void setHTTPURLParameter(String string) {
        if (string != null && (string.contains("?") || string.length() == 0)) {
            this.myConnectionManager.setHTTPURLParameters(string);
        }
    }

    public void addAsyncExceptionListener(nAsyncExceptionListener nAsyncExceptionListener2) throws nIllegalArgumentException {
        this.myExceptionListenerManager.add(nAsyncExceptionListener2);
    }

    public void removeAsyncExceptionListener(nAsyncExceptionListener nAsyncExceptionListener2) throws nIllegalArgumentException {
        this.myExceptionListenerManager.remove(nAsyncExceptionListener2);
    }

    public void setChannelMultiplexing(boolean bl) throws nSessionAlreadyInitialisedException {
        if (this.myConnectionManager.isInitialised()) {
            throw new nSessionAlreadyInitialisedException("Session has been initialised already");
        }
        this.myStoreManager.setMultiplexStoreFlag(bl);
    }

    public boolean getChannelMultiplexing() {
        return this.myStoreManager.isMultiplexStores();
    }

    protected boolean isAdminApiSession() {
        return false;
    }

    protected EventHandlerInitialiser getEventHandlerInitialser() {
        return new EventHandlerInitialiser();
    }

    public void addRealm(nRealm nRealm2) throws nRealmAlreadyBoundException, nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nRealmNotFoundException, nUnexpectedResponseException, nSessionPausedException, nRequestTimedOutException, nNameSpaceConflictException {
        this.addRealm(nRealm2, null);
    }

    public void addRealm(nRealm nRealm2, nSession nSession2) throws nRealmAlreadyBoundException, nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nRealmNotFoundException, nUnexpectedResponseException, nSessionPausedException, nRequestTimedOutException, nNameSpaceConflictException {
        this.addRealm(nRealm2, nSession2, null, null);
    }

    protected void addRealm(nRealm nRealm2, nSession nSession2, String string, String string2) throws nRealmAlreadyBoundException, nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nRealmNotFoundException, nUnexpectedResponseException, nRequestTimedOutException, nSessionPausedException, nNameSpaceConflictException {
        this.addRealmReentrantBase(nRealm2, nSession2, false, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRealmReentrantBase(nRealm nRealm2, nSession nSession2, boolean bl, String string, String string2) throws nRealmAlreadyBoundException, nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nRealmNotFoundException, nUnexpectedResponseException, nRequestTimedOutException, nSessionPausedException, nNameSpaceConflictException {
        Object object;
        if (nRealm2 == null) {
            throw new nIllegalArgumentException("Must supply a non null nRealm");
        }
        if (nRealm2.getName() == null) {
            throw new nIllegalArgumentException("Must supply a valid nRealm. Name is not set");
        }
        if (nRealm2.getRealm().getPublicKey() == null) {
            boolean bl2 = false;
            try {
                if (nSession2 == null) {
                    bl2 = true;
                    nSession2 = nSessionFactory.create(new nSessionAttributes(nRealm2.getProtocols()));
                    try {
                        nSession2.init();
                    }
                    catch (nSessionAlreadyInitialisedException nSessionAlreadyInitialisedException2) {
                        // empty catch block
                    }
                }
                object = nSession2.getRealm(nSession2.getServerRealmName());
                byte[] byArray = ((nRealm)object).getRealm().getPublicKey();
                if (!bl) {
                    nRealm nRealm3 = this.getRealm(this.getServerRealmName(), true);
                    String[] stringArray = this.checkForNAT(nRealm3.getProtocols(), nRealm3.getHosts());
                    nRealm nRealm4 = new nRealm(nRealm3.getName(), stringArray);
                    nRealm4.getRealm().setPublicKey(nRealm3.getRealm().getPublicKey());
                    try {
                        nSession2.addRealmReentrantBase(nRealm4, this, true, string2, string);
                    }
                    catch (nRealmAlreadyBoundException nRealmAlreadyBoundException2) {
                        // empty catch block
                    }
                }
                nRealm2.getRealm().setPublicKey(byArray);
                nRealm2.setName(((nRealm)object).getName());
            }
            finally {
                if (bl2) {
                    nSession2.close();
                }
            }
        }
        nAddRealm nAddRealm2 = new nAddRealm(nRealm2.getRealm());
        nAddRealm2.setSourceRealm(string);
        object = this.myEventProcessor.writeEvent(nAddRealm2);
        if (object instanceof nAddRealm) {
            return;
        }
        if (object instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            this.myRedirectionManager.processRealmRedirect((nRedirection)object, nRealm2);
            return;
        }
        nExceptionEventProcessor.checkSecurityException((nEvent)object);
        nExceptionEventProcessor.checkRealmAlreadyBound((nEvent)object);
        nExceptionEventProcessor.checkRealmUnreachable((nEvent)object);
        nExceptionEventProcessor.checkNameSpaceConflict((nEvent)object);
        throw new nUnexpectedResponseException("addRealm");
    }

    private String[] checkForNAT(String[] stringArray, List<String> list) {
        try {
            String string = this.myConnectionManager.getSessionAttributesList().get(0).getHost();
            InetAddress inetAddress = InetAddress.getByName(string);
            for (String stringArray22 : list) {
                if (!InetAddress.getByName(stringArray22).equals(inetAddress)) continue;
                return stringArray;
            }
            List<fConnectionDetails> list2 = this.myConnectionManager.getSessionAttributesList();
            String[] stringArray2 = new String[stringArray.length + list2.size()];
            System.arraycopy(stringArray, 0, stringArray2, list2.size(), stringArray.length);
            int n = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                fConnectionDetails fConnectionDetails2 = (fConnectionDetails)iterator.next();
                stringArray2[n++] = fConnectionDetails2.toString();
            }
            return stringArray2;
        }
        catch (IOException iOException) {
            return stringArray;
        }
    }

    public void deleteRealm(nRealm nRealm2) throws nRealmNotFoundException, nSessionPausedException, nRealmUnreachableException, nSecurityException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException, nRealmInUseException {
        if (nRealm2 == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nRealm");
        }
        this.deleteRealm(nRealm2.getName(), true);
    }

    private void deleteRealm(String string, boolean bl) throws nRealmNotFoundException, nSessionPausedException, nSecurityException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException, nRealmInUseException {
        Object object;
        Object object2;
        if (string == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nRealm");
        }
        if (bl) {
            object2 = null;
            try {
                object = this.getRealm(string, true);
                object2 = nSessionFactory.create(new nSessionAttributes(((nRealm)object).getProtocols()));
                try {
                    ((nSession)object2).init();
                }
                catch (nSessionAlreadyInitialisedException nSessionAlreadyInitialisedException2) {
                    nConstants.logger.fatal(nSessionAlreadyInitialisedException2);
                }
                try {
                    super.deleteRealm(this.getServerRealmName(), false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {
                throw nSessionNotConnectedException2;
            }
            catch (Exception exception) {
                nRealmNotFoundException nRealmNotFoundException2 = new nRealmNotFoundException(exception.getMessage());
                nRealmNotFoundException2.initCause(exception);
                throw nRealmNotFoundException2;
            }
            finally {
                if (object2 != null) {
                    ((nSession)object2).close();
                }
            }
        }
        if ((object = this.myEventProcessor.writeEvent((nEvent)(object2 = new nDelRealm(string)))) instanceof nDelRealm) {
            return;
        }
        nExceptionEventProcessor.checkSecurityException((nEvent)object);
        nExceptionEventProcessor.checkRealmNotFound((nEvent)object);
        nExceptionEventProcessor.checkRealmInUse((nEvent)object);
        throw new nUnexpectedResponseException("deleteRealm");
    }

    public nRealm getRealm(String string) throws nRealmNotFoundException, nSessionPausedException, nSecurityException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.getRealm(string, false);
    }

    protected nRealm getRealm(String string, boolean bl) throws nRealmNotFoundException, nSessionPausedException, nSecurityException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        if (string == null) {
            throw new nIllegalArgumentException("Invalid realm name supplied. null");
        }
        if (string.length() == 0 || string.trim().length() == 0) {
            throw new nIllegalArgumentException("Invalid realm name supplied. empty string");
        }
        com.pcbsys.nirvana.base.nRealm nRealm2 = this.myRealmManager.get(string);
        if (nRealm2 != null) {
            return new nRealm(nRealm2);
        }
        nGetRealm nGetRealm2 = new nGetRealm(string);
        nGetRealm2.setIsAdmin(bl);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nGetRealm2);
        if (nEvent2 instanceof nGetRealm) {
            nGetRealm nGetRealm3 = (nGetRealm)nEvent2;
            this.myRealmManager.put(nGetRealm3.getName(), nGetRealm3.getRealm());
            return new nRealm(nGetRealm3.getRealm());
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkRealmNotFound(nEvent2);
        throw new nUnexpectedResponseException("getRealm");
    }

    public nRealm[] getRealms() throws nSecurityException, nSessionNotConnectedException, nSessionPausedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.getRealms(false);
    }

    public nRealm[] getRealms(boolean bl) throws nSecurityException, nSessionNotConnectedException, nSessionPausedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        nGetRealm nGetRealm2 = new nGetRealm(true, bl);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nGetRealm2);
        if (nEvent2 instanceof nGetRealm) {
            nGetRealm nGetRealm3 = (nGetRealm)nEvent2;
            com.pcbsys.nirvana.base.nRealm[] nRealmArray = nGetRealm3.getRealms();
            if (nRealmArray != null) {
                nRealm[] nRealmArray2 = new nRealm[nRealmArray.length];
                for (int i = 0; i < nRealmArray.length; ++i) {
                    nRealmArray2[i] = new nRealm(nRealmArray[i]);
                }
                return nRealmArray2;
            }
            return null;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        throw new nUnexpectedResponseException("getRealms");
    }

    /*
     * WARNING - void declaration
     */
    public nFindResult[] find(nChannelAttributes[] nChannelAttributesArray) throws nSessionPausedException, nUnknownRemoteRealmException, nSecurityException, nUnexpectedResponseException, nSessionNotConnectedException, nIllegalArgumentException, nRequestTimedOutException {
        void object;
        if (nChannelAttributesArray == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nChannelAttributes");
        }
        if (nChannelAttributesArray.length == 0) {
            throw new nIllegalArgumentException("Must supply at least 1 channel attribute");
        }
        Object arrayList = nChannelAttributesArray;
        int n = ((nChannelAttributes[])arrayList).length;
        boolean bl = false;
        while (object < n) {
            nChannelAttributes nChannelAttributes2 = arrayList[object];
            if (nChannelAttributes2 == null) {
                throw new nIllegalArgumentException("Attributes cannot contain null values");
            }
            ++object;
        }
        arrayList = new ArrayList();
        LinkedHashMap<String, nFindResult> linkedHashMap = new LinkedHashMap<String, nFindResult>();
        nChannelAttributes[] nChannelAttributesArray2 = nChannelAttributesArray;
        int n2 = nChannelAttributesArray2.length;
        for (int i = 0; i < n2; ++i) {
            nChannelAttributes nChannelAttributes3 = nChannelAttributesArray2[i];
            Object object2 = this.myStoreManager.get(nChannelAttributes3.getBaseAttributesValidated());
            if (object2 != null) {
                linkedHashMap.put(nChannelAttributes3.getName(), new nFindResult(nChannelAttributes3, (nAbstractChannel)object2));
                continue;
            }
            ((ArrayList)arrayList).add(nChannelAttributes3.getBaseAttributesValidated());
        }
        if (((ArrayList)arrayList).size() != 0) {
            nEvent nEvent2 = this.myEventProcessor.writeEvent(new nGetChannelList((Collection<com.pcbsys.nirvana.base.nChannelAttributes>)arrayList));
            if (nEvent2 instanceof nGetChannelList) {
                nGetChannelList nGetChannelList2 = (nGetChannelList)nEvent2;
                Collection<com.pcbsys.nirvana.base.nChannelAttributes> collection = nGetChannelList2.getChannelList();
                for (Object object2 : collection) {
                    linkedHashMap.put(((com.pcbsys.nirvana.base.nChannelAttributes)object2).getName(), new nFindResult(new nChannelAttributes((com.pcbsys.nirvana.base.nChannelAttributes)object2), this.myStoreManager.get((com.pcbsys.nirvana.base.nChannelAttributes)object2)));
                }
            } else {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "Unexpected response when finding stores");
            }
        }
        for (nChannelAttributes nChannelAttributes4 : nChannelAttributesArray) {
            if (linkedHashMap.containsKey(nChannelAttributes4.getName())) continue;
            linkedHashMap.put(nChannelAttributes4.getName(), new nFindResult(nChannelAttributes4, new nChannelNotFoundException("Specified attribute not found on server")));
        }
        nFindResult[] nFindResultArray = new nFindResult[linkedHashMap.size()];
        int n3 = 0;
        Iterator iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            nFindResult nFindResult2;
            nFindResultArray[n3] = nFindResult2 = (nFindResult)iterator.next();
            ++n3;
        }
        return nFindResultArray;
    }

    public nSubscriptionAttributes[] subscribe(nSubscriptionAttributes[] nSubscriptionAttributesArray) throws Exception {
        for (nSubscriptionAttributes nSubscriptionAttributes2 : nSubscriptionAttributesArray) {
            if (nSubscriptionAttributes2 != null) continue;
            throw new nIllegalArgumentException("Attributes cannot contain null values");
        }
        Object[] objectArray = new com.pcbsys.nirvana.base.nSubscriptionAttributes[nSubscriptionAttributesArray.length];
        for (int i = 0; i < nSubscriptionAttributesArray.length; ++i) {
            if (nSubscriptionAttributesArray[i] == null) continue;
            objectArray[i] = new com.pcbsys.nirvana.base.nSubscriptionAttributes(nSubscriptionAttributesArray[i].getChannelName(), nSubscriptionAttributesArray[i].getSelector(), nSubscriptionAttributesArray[i].getEID());
        }
        nFindAndSubscribe nFindAndSubscribe2 = new nFindAndSubscribe((com.pcbsys.nirvana.base.nSubscriptionAttributes[])objectArray, nSubscriptionAttributesArray);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nFindAndSubscribe2);
        if (nEvent2 instanceof nFindAndSubscribe) {
            return nSubscriptionAttributesArray;
        }
        return null;
    }

    public nChannelAttributes[] getChannels() throws nSecurityException, nSessionNotConnectedException, nSessionPausedException, nUnexpectedResponseException, nRequestTimedOutException {
        return this.getChannels(null);
    }

    public nChannelAttributes[] getChannels(String string) throws nSecurityException, nSessionNotConnectedException, nSessionPausedException, nUnexpectedResponseException, nRequestTimedOutException {
        nEvent nEvent2 = this.myEventProcessor.writeEvent(new nGetChannelList(string));
        if (nEvent2 instanceof nGetChannelList) {
            nGetChannelList nGetChannelList2 = (nGetChannelList)nEvent2;
            Collection<com.pcbsys.nirvana.base.nChannelAttributes> collection = nGetChannelList2.getChannelList();
            nChannelAttributes[] nChannelAttributesArray = new nChannelAttributes[collection.size()];
            int n = 0;
            for (com.pcbsys.nirvana.base.nChannelAttributes nChannelAttributes2 : collection) {
                try {
                    nChannelAttributesArray[n] = new nChannelAttributes(nChannelAttributes2.getName(), nChannelAttributes2.getMaxEvents(), nChannelAttributes2.getTTL(), nChannelAttributes2.getType());
                    nChannelAttributesArray[n].setChannelMode(nChannelAttributes2.getChannelMode());
                    nChannelAttributesArray[n].setPublishKeys(nChannelAttributes2.getPublishKeys());
                    nChannelAttributesArray[n].setMetaData(nChannelAttributes2.getMetaData());
                    nChannelAttributesArray[n].setClusterWide(nChannelAttributes2.isClusterWide());
                    nChannelAttributesArray[n].setUniqueId(nChannelAttributes2.getUniqueId());
                    nChannelAttributesArray[n].setAutoDelete(nChannelAttributes2.isAutoDelete());
                    nChannelAttributesArray[n].useJMSEngine(nChannelAttributes2.isUseJMSEngine());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            return nChannelAttributesArray;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        throw new nUnexpectedResponseException("getChannels");
    }

    public nCreateResult[] create(nChannelAttributes[] nChannelAttributesArray) throws nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.create(nChannelAttributesArray, null);
    }

    public nCreateResult[] create(nChannelAttributes[] nChannelAttributesArray, Collection<Collection<nStorePermission>> collection) throws nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        nMakeChannels nMakeChannels2;
        nEvent nEvent2;
        boolean bl;
        if (nChannelAttributesArray == null || nChannelAttributesArray.length == 0) {
            throw new nIllegalArgumentException("Provide a valid non null or empty array of nChannelAttributes");
        }
        boolean bl2 = bl = collection != null;
        if (bl && collection.size() != nChannelAttributesArray.length) {
            throw new nIllegalArgumentException("The number of permission lists must be equal to the number of the channels/queues requested be created.");
        }
        nMakeChannel[] nMakeChannelArray = new nMakeChannel[nChannelAttributesArray.length];
        Iterator<Collection<nStorePermission>> iterator = bl ? collection.iterator() : null;
        for (int i = 0; i < nChannelAttributesArray.length; ++i) {
            if (nChannelAttributesArray[i] == null) {
                throw new nIllegalArgumentException("Provide a valid non null nChannelAttributes element inside array");
            }
            if (nChannelAttributesArray[i].getChannelMode() == 101) {
                this.checkQueueAttributes(nChannelAttributesArray[i]);
            }
            nEvent2 = bl ? iterator.next() : null;
            nMakeChannels2 = bl && nEvent2 != null ? nStorePermission.getBaseStorePermissions((Collection<nStorePermission>)((Object)nEvent2), nChannelAttributesArray[i].getBaseAttributes().getChannelMode()) : null;
            nMakeChannelArray[i] = new nMakeChannel(nChannelAttributesArray[i].getBaseAttributesValidated(), (com.pcbsys.nirvana.base.nStorePermission[])nMakeChannels2);
        }
        nMakeChannels nMakeChannels3 = new nMakeChannels(nMakeChannelArray);
        nEvent2 = this.myEventProcessor.writeEvent(nMakeChannels3);
        if (nEvent2 instanceof nMakeChannels) {
            nMakeChannels2 = (nMakeChannels)nEvent2;
            fExternalable[] fExternalableArray = nMakeChannels2.getResults();
            nBaseClientException[] nBaseClientExceptionArray = CommonStaticMethods.getChannelAttributesException(nMakeChannels2);
            nCreateResult[] nCreateResultArray = new nCreateResult[fExternalableArray.length];
            for (int i = 0; i < fExternalableArray.length; ++i) {
                if (fExternalableArray[i] instanceof nMakeChannel) {
                    com.pcbsys.nirvana.base.nChannelAttributes nChannelAttributes2 = ((nMakeChannel)fExternalableArray[i]).getChannelAttributes();
                    nCreateResultArray[i] = new nCreateResult(this.myStoreManager.get(nChannelAttributes2));
                    continue;
                }
                nCreateResultArray[i] = new nCreateResult(nChannelAttributesArray[i], nBaseClientExceptionArray[i]);
            }
            return nCreateResultArray;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelAlreadyExists(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkNameSpaceConflictThrowIllegal(nEvent2);
        nExceptionEventProcessor.checkIllegalArgument(nEvent2);
        throw new nUnexpectedResponseException("create(nChannelAttributes[])");
    }

    public nDeleteResult[] delete(nChannelAttributes[] nChannelAttributesArray) throws nUnknownRemoteRealmException, nSecurityException, nChannelNotFoundException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        if (nChannelAttributesArray == null || nChannelAttributesArray.length == 0) {
            throw new nIllegalArgumentException("Must supply a valid non null or empty array of nChannelAttributes");
        }
        nDeleteChannel[] nDeleteChannelArray = new nDeleteChannel[nChannelAttributesArray.length];
        for (int i = 0; i < nChannelAttributesArray.length; ++i) {
            nDeleteChannelArray[i] = new nDeleteChannel(nChannelAttributesArray[i].getBaseAttributesValidated());
        }
        nDeleteChannels nDeleteChannels2 = new nDeleteChannels(nDeleteChannelArray);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nDeleteChannels2);
        if (nEvent2 instanceof nDeleteChannels) {
            nDeleteChannels nDeleteChannels3 = (nDeleteChannels)nEvent2;
            fExternalable[] fExternalableArray = nDeleteChannels3.getResults();
            nBaseClientException[] nBaseClientExceptionArray = CommonStaticMethods.getChannelAttributesException(nDeleteChannels3);
            nDeleteResult[] nDeleteResultArray = new nDeleteResult[fExternalableArray.length];
            for (int i = 0; i < fExternalableArray.length; ++i) {
                if (fExternalableArray[i] instanceof nDeleteChannel) {
                    nDeleteChannel nDeleteChannel2 = (nDeleteChannel)fExternalableArray[i];
                    nDeleteResultArray[i] = new nDeleteResult(new nChannelAttributes(nDeleteChannel2.getChannelAttributes()));
                    continue;
                }
                nDeleteResultArray[i] = new nDeleteResult(nChannelAttributesArray[i], nBaseClientExceptionArray[i]);
            }
            return nDeleteResultArray;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelNotFound(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkNameSpaceConflictThrowIllegal(nEvent2);
        throw new nUnexpectedResponseException("delete(nChannelAttributes[])");
    }

    public void write(nConsumeEvent nConsumeEvent2, nAbstractChannel[] nAbstractChannelArray) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(nConsumeEvent2, nAbstractChannelArray, false);
    }

    public void write(nConsumeEvent[] nConsumeEventArray, nAbstractChannel nAbstractChannel2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(nConsumeEventArray, nAbstractChannel2, false);
    }

    public void write(nConsumeEvent[] nConsumeEventArray, nAbstractChannel[] nAbstractChannelArray) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(nConsumeEventArray, nAbstractChannelArray, false);
    }

    public void write(nConsumeEvent[] nConsumeEventArray, nAbstractChannel[] nAbstractChannelArray, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[nConsumeEventArray.length];
        for (int i = 0; i < nPublishedArray.length; ++i) {
            nPublishedArray[i] = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEventArray[i], null, -1L, this.myConnectionManager);
        }
        long[] lArray = new long[nAbstractChannelArray.length];
        for (int i = 0; i < nAbstractChannelArray.length; ++i) {
            lArray[i] = nAbstractChannelArray[i].getBaseAttributes().getUniqueId();
        }
        nBatchPublish nBatchPublish2 = new nBatchPublish(nPublishedArray, lArray);
        nBatchPublish2.setSynchronous(bl);
        this.myEventProcessor.writeEvent(nBatchPublish2);
    }

    public void write(nConsumeEvent nConsumeEvent2, nAbstractChannel[] nAbstractChannelArray, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(new nConsumeEvent[]{nConsumeEvent2}, nAbstractChannelArray, bl);
    }

    public void write(nConsumeEvent[] nConsumeEventArray, nAbstractChannel nAbstractChannel2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(nConsumeEventArray, new nAbstractChannel[]{nAbstractChannel2}, bl);
    }

    public void write(nConsumeEvent nConsumeEvent2, nAbstractChannel nAbstractChannel2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.write(new nConsumeEvent[]{nConsumeEvent2}, new nAbstractChannel[]{nAbstractChannel2}, bl);
    }

    public void write(Map<nConsumeEvent, nAbstractChannel> map, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[map.size()];
        long[] lArray = new long[map.size()];
        int n = 0;
        for (Map.Entry<nConsumeEvent, nAbstractChannel> entry : map.entrySet()) {
            nPublishedArray[n] = nConsumeEventConverter.nConsumeEventToPublishRequest(entry.getKey(), null, -1L, this.myConnectionManager);
            lArray[n++] = entry.getValue().getBaseAttributes().getUniqueId();
        }
        nBatchPublish nBatchPublish2 = new nBatchPublish(nPublishedArray, lArray, false);
        nBatchPublish2.setSynchronous(bl);
        this.myEventProcessor.writeEvent(nBatchPublish2);
    }

    public nChannel createChannel(nChannelAttributes nChannelAttributes2) throws nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createChannel(nChannelAttributes2, 0L);
    }

    public nChannel createChannel(nChannelAttributes nChannelAttributes2, long l) throws nUnknownRemoteRealmException, nSecurityException, nChannelAlreadyExistsException, nSessionPausedException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createChannel(nChannelAttributes2, l, -1L, null);
    }

    public nChannel createChannel(nChannelAttributes nChannelAttributes2, long l, long l2) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelAlreadyExistsException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createChannel(nChannelAttributes2, l, l2, null);
    }

    public nChannel createChannel(nChannelAttributes nChannelAttributes2, long l, Collection<nStorePermission> collection) throws nIllegalArgumentException, nUnexpectedResponseException, nUnknownRemoteRealmException, nChannelAlreadyExistsException, nSecurityException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        return this.createChannel(nChannelAttributes2, l, -1L, collection);
    }

    private nChannel createChannel(nChannelAttributes nChannelAttributes2, long l, long l2, Collection<nStorePermission> collection) throws nIllegalArgumentException, nUnexpectedResponseException, nUnknownRemoteRealmException, nChannelAlreadyExistsException, nSecurityException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Provide a valid non null nChannelAttributes");
        }
        if (l < 0L) {
            throw new nIllegalArgumentException("Provide an EID greater than -1");
        }
        if (l == Long.MAX_VALUE) {
            throw new nIllegalArgumentException("Provide an EID less than 9223372036854775807");
        }
        --l;
        try {
            nChannelAttributes2.setChannelMode(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        l = l < 0L ? -1L : l;
        com.pcbsys.nirvana.base.nStorePermission[] nStorePermissionArray = collection != null ? nStorePermission.getBaseStorePermissions(collection, 100) : null;
        nMakeChannel nMakeChannel2 = new nMakeChannel(nChannelAttributes2.getBaseAttributesValidated(), l, l2, nStorePermissionArray);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nMakeChannel2);
        if (nEvent2 instanceof nMakeChannel) {
            nMakeChannel nMakeChannel3 = (nMakeChannel)nEvent2;
            try {
                nChannel nChannel2 = this.myStoreManager.getChannel(nMakeChannel3.getChannelAttributes());
                if (nChannel2.getTraceLogger().isInfoEnabled()) {
                    nChannel2.getTraceLogger().info("Created channel successfully. " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                return nChannel2;
            }
            catch (nIllegalChannelMode nIllegalChannelMode2) {}
        } else if (nEvent2 instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            nChannel nChannel3 = this.myRedirectionManager.getChannel(nChannelAttributes2, (nRedirection)nEvent2, l);
            if (nChannel3.getTraceLogger().isInfoEnabled()) {
                nChannel3.getTraceLogger().info("Create channel call being redirected for channel " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            return nChannel3;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelAlreadyExists(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkNameSpaceConflictThrowIllegal(nEvent2);
        nExceptionEventProcessor.checkIllegalArgument(nEvent2);
        throw new nUnexpectedResponseException("createChannel");
    }

    public nChannel findChannel(nChannelAttributes nChannelAttributes2) throws nChannelNotFoundException, nSessionPausedException, nUnknownRemoteRealmException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalChannelMode {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nChannelAttributes");
        }
        nChannel nChannel2 = this.myStoreManager.getChannel(nChannelAttributes2.getBaseAttributes());
        if (nChannel2 != null) {
            return nChannel2;
        }
        try {
            nChannelAttributes2.setChannelMode(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nUserFind nUserFind2 = new nUserFind(nChannelAttributes2.getBaseAttributesValidated());
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nUserFind2);
        if (nEvent2 instanceof nUserFind) {
            return this.myStoreManager.getChannel(((nUserFind)nEvent2).getChannelAttributes());
        }
        if (nEvent2 instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            return this.myRedirectionManager.getChannel(nChannelAttributes2, (nRedirection)nEvent2);
        }
        nExceptionEventProcessor.checkCommonExceptions(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "findChannel");
        throw new nUnexpectedResponseException("findChannel");
    }

    public nQueue findQueue(nChannelAttributes nChannelAttributes2) throws nChannelNotFoundException, nSessionPausedException, nUnknownRemoteRealmException, nSecurityException, nSessionNotConnectedException, nIllegalArgumentException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalChannelMode {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nChannelAttributes");
        }
        try {
            nChannelAttributes2.setChannelMode(101);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nQueue nQueue2 = this.myStoreManager.getQueue(nChannelAttributes2.getBaseAttributesValidated());
        if (nQueue2 != null) {
            return nQueue2;
        }
        nUserFind nUserFind2 = new nUserFind(nChannelAttributes2.getBaseAttributesValidated());
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nUserFind2);
        if (nEvent2 instanceof nUserFind) {
            return this.myStoreManager.getQueue(((nUserFind)nEvent2).getChannelAttributes());
        }
        if (nEvent2 instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            this.myRedirectionManager.getQueue(nChannelAttributes2, (nRedirection)nEvent2);
        }
        nExceptionEventProcessor.checkCommonExceptions(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "findQueue");
        throw new nUnexpectedResponseException("findQueue");
    }

    public void deleteChannel(nChannelAttributes nChannelAttributes2) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nChannelAttributes");
        }
        nChannelAttributes2.setChannelMode(100);
        this.deleteStore(nChannelAttributes2);
    }

    public nQueue createQueue(nChannelAttributes nChannelAttributes2, long l) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelAlreadyExistsException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createQueue(nChannelAttributes2, l, null);
    }

    public nQueue createQueue(nChannelAttributes nChannelAttributes2, Collection<nStorePermission> collection) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelAlreadyExistsException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createQueue(nChannelAttributes2, -1L, collection);
    }

    public nQueue createQueue(nChannelAttributes nChannelAttributes2) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelAlreadyExistsException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        return this.createQueue(nChannelAttributes2, -1L);
    }

    private nQueue createQueue(nChannelAttributes nChannelAttributes2, long l, Collection<nStorePermission> collection) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelAlreadyExistsException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        this.checkQueueAttributes(nChannelAttributes2);
        try {
            nChannelAttributes2.setChannelMode(101);
        }
        catch (Exception exception) {
            // empty catch block
        }
        com.pcbsys.nirvana.base.nStorePermission[] nStorePermissionArray = collection != null ? nStorePermission.getBaseStorePermissions(collection, 101) : null;
        nMakeChannel nMakeChannel2 = new nMakeChannel(nChannelAttributes2.getBaseAttributesValidated(), -1L, l, nStorePermissionArray);
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nMakeChannel2);
        if (nEvent2 instanceof nMakeChannel) {
            nMakeChannel nMakeChannel3 = (nMakeChannel)nEvent2;
            try {
                nQueue nQueue2 = this.myStoreManager.getQueue(nMakeChannel3.getChannelAttributes());
                if (nQueue2.getTraceLogger().isInfoEnabled()) {
                    nQueue2.getTraceLogger().info("Created queue successfully. " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                return nQueue2;
            }
            catch (nIllegalChannelMode nIllegalChannelMode2) {}
        } else if (nEvent2 instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            nQueue nQueue3 = this.myRedirectionManager.getOrCreateQueue(nChannelAttributes2, (nRedirection)nEvent2);
            if (nQueue3.getTraceLogger().isInfoEnabled()) {
                nQueue3.getTraceLogger().info("Creating queue call being redirected for queue " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            return nQueue3;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent2);
        nExceptionEventProcessor.checkChannelAlreadyExists(nEvent2);
        nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
        nExceptionEventProcessor.checkNameSpaceConflictThrowIllegal(nEvent2);
        nExceptionEventProcessor.checkIllegalArgument(nEvent2);
        throw new nUnexpectedResponseException("createQueue");
    }

    public void deleteQueue(nChannelAttributes nChannelAttributes2) throws nUnknownRemoteRealmException, nSessionPausedException, nSecurityException, nChannelNotFoundException, nSessionNotConnectedException, nUnexpectedResponseException, nRequestTimedOutException, nIllegalArgumentException {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Must supply a valid non null nChannelAttributes");
        }
        nChannelAttributes2.setChannelMode(101);
        this.deleteStore(nChannelAttributes2);
    }

    private void deleteStore(nChannelAttributes nChannelAttributes2) throws nIllegalArgumentException, nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nUnknownRemoteRealmException, nSecurityException, nUnexpectedResponseException, nChannelNotFoundException {
        nDeleteChannel nDeleteChannel2 = new nDeleteChannel(nChannelAttributes2.getBaseAttributesValidated());
        nAbstractChannel nAbstractChannel2 = this.myStoreManager.get(nChannelAttributes2.getBaseAttributesValidated());
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nDeleteChannel2);
        if (nEvent2 instanceof nDeleteChannel) {
            if (nAbstractChannel2 != null && nAbstractChannel2.getTraceLogger().isInfoEnabled()) {
                nAbstractChannel2.getTraceLogger().info("Deleted store successfully. " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            ClientEventTraceLoggerContext.getInstance().removeStoreTraceLogger(nChannelAttributes2.getName());
            return;
        }
        if (nEvent2 instanceof nRedirection) {
            nConstants.logger.info("Being redirected");
            if (nAbstractChannel2 != null && nAbstractChannel2.getTraceLogger().isInfoEnabled()) {
                nAbstractChannel2.getTraceLogger().info("Deleting store call being redirected for store " + ClientEventTraceLoggerContext.addChAttributesInfo(nChannelAttributes2) + ", conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            this.myRedirectionManager.deleteStore(nChannelAttributes2, (nRedirection)nEvent2);
            ClientEventTraceLoggerContext.getInstance().removeStoreTraceLogger(nChannelAttributes2.getName());
            return;
        }
        try {
            nExceptionEventProcessor.checkSecurityException(nEvent2);
            nExceptionEventProcessor.checkChannelNotFound(nEvent2);
            nExceptionEventProcessor.checkUnknownRemoteRealm(nEvent2);
            throw new nUnexpectedResponseException("deleteStore");
        }
        catch (Exception exception) {
            if (nAbstractChannel2 != null && nAbstractChannel2.getTraceLogger().isErrorEnabled()) {
                nAbstractChannel2.getTraceLogger().error("Deleting store call failed. conn=" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
            }
            ClientEventTraceLoggerContext.getInstance().removeStoreTraceLogger(nChannelAttributes2.getName());
            throw exception;
        }
    }

    private void checkQueueAttributes(nChannelAttributes nChannelAttributes2) throws nIllegalArgumentException {
        if (nChannelAttributes2 == null) {
            throw new nIllegalArgumentException("Provide a valid non null nChannelAttributes");
        }
        if (nChannelAttributes2.isJMSEngine()) {
            throw new nIllegalArgumentException("JMS engine cannot be used when creating a queue");
        }
    }

    public String getStreamId() {
        return this.myDataGroupManager.getSessionDataStream().getName();
    }

    public synchronized void pauseStream() {
        this.myDataGroupManager.pauseStream();
    }

    public synchronized void resumeStream() {
        this.myDataGroupManager.resumeStream();
    }

    public void writeDataStream(nConsumeEvent nConsumeEvent2, nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEvent2, nDataStream2, false);
    }

    public void writeDataStream(nConsumeEvent nConsumeEvent2, nDataStream[] nDataStreamArray2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEvent2, nDataStreamArray2, false);
    }

    public void writeDataStream(nConsumeEvent[] nConsumeEventArray, nDataStream nDataStream2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEventArray, nDataStream2, false);
    }

    public void writeDataStream(nConsumeEvent[] nConsumeEventArray, nDataStream[] nDataStreamArray2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEventArray, nDataStreamArray2, false);
    }

    public void writeDataStream(Map<nConsumeEvent, nDataStream> map) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(map, false);
    }

    public void writeDataStream(Map<nConsumeEvent, nDataStream> map, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[map.size()];
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<nConsumeEvent, nDataStream> entry : map.entrySet()) {
            nConsumeEvent nConsumeEvent2 = entry.getKey();
            nPublishedArray[n] = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEvent2, null, -1L, this.myConnectionManager);
            stringArray[n++] = entry.getValue().getName();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublishedArray, stringArray, false, false, bl));
    }

    public void writeDataStream(nConsumeEvent nConsumeEvent2, nDataStream nDataStream2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEvent2, new nDataStream[]{nDataStream2}, bl);
    }

    public void writeDataStream(nConsumeEvent nConsumeEvent2, nDataStream[] nDataStreamArray2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished nPublished2 = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEvent2, null, -1L, this.myConnectionManager);
        String[] stringArray = new String[nDataStreamArray2.length];
        for (int i = 0; i < nDataStreamArray2.length; ++i) {
            stringArray[i] = nDataStreamArray2[i].getName();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublished2, stringArray, true, false, bl));
    }

    public void writeDataStream(nConsumeEvent[] nConsumeEventArray, nDataStream nDataStream2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataStream(nConsumeEventArray, new nDataStream[]{nDataStream2}, bl);
    }

    public void writeDataStream(nConsumeEvent[] nConsumeEventArray, nDataStream[] nDataStreamArray2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[nConsumeEventArray.length];
        for (int i = 0; i < nPublishedArray.length; ++i) {
            nPublishedArray[i] = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEventArray[i], null, -1L, this.myConnectionManager);
        }
        String[] stringArray = new String[nDataStreamArray2.length];
        for (int i = 0; i < nDataStreamArray2.length; ++i) {
            stringArray[i] = nDataStreamArray2[i].getName();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublishedArray, stringArray, true, false, bl));
    }

    public void writeDataGroup(nConsumeEvent nConsumeEvent2, nDataGroup nDataGroup2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEvent2, nDataGroup2, false);
    }

    public void writeDataGroup(nConsumeEvent nConsumeEvent2, nDataGroup[] nDataGroupArray) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEvent2, nDataGroupArray, false);
    }

    public void writeDataGroup(nConsumeEvent[] nConsumeEventArray, nDataGroup nDataGroup2) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEventArray, nDataGroup2, false);
    }

    public void writeDataGroup(Map<nConsumeEvent, nDataGroup> map) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(map, false);
    }

    public void writeDataGroup(nConsumeEvent[] nConsumeEventArray, nDataGroup[] nDataGroupArray) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEventArray, nDataGroupArray, false);
    }

    public void writeDataGroup(nConsumeEvent nConsumeEvent2, nDataGroup nDataGroup2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEvent2, new nDataGroup[]{nDataGroup2}, bl);
    }

    public void writeDataGroup(nConsumeEvent nConsumeEvent2, nDataGroup[] nDataGroupArray, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished nPublished2 = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEvent2, null, -1L, this.myConnectionManager);
        long[] lArray = new long[nDataGroupArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = nDataGroupArray[i].getID();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublished2, lArray, true, false, bl));
    }

    public void writeDataGroup(nConsumeEvent[] nConsumeEventArray, nDataGroup nDataGroup2, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        this.writeDataGroup(nConsumeEventArray, new nDataGroup[]{nDataGroup2}, bl);
    }

    public void writeDataGroup(nConsumeEvent[] nConsumeEventArray, nDataGroup[] nDataGroupArray, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[nConsumeEventArray.length];
        for (int i = 0; i < nPublishedArray.length; ++i) {
            nPublishedArray[i] = nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEventArray[i], null, -1L, this.myConnectionManager);
        }
        long[] lArray = new long[nDataGroupArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = nDataGroupArray[i].getID();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublishedArray, lArray, true, false, bl));
    }

    public void writeDataGroup(Map<nConsumeEvent, nDataGroup> map, boolean bl) throws nSecurityException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nMaxBufferSizeExceededException {
        nPublished[] nPublishedArray = new nPublished[map.size()];
        long[] lArray = new long[map.size()];
        int n = 0;
        for (Map.Entry<nConsumeEvent, nDataGroup> entry : map.entrySet()) {
            nPublishedArray[n] = nConsumeEventConverter.nConsumeEventToPublishRequest(entry.getKey(), null, -1L, this.myConnectionManager);
            lArray[n++] = entry.getValue().getID();
        }
        this.writeDataStreamPublish(new nDataStreamPublish(nPublishedArray, lArray, false, false, bl));
    }

    private void writeDataStreamPublish(nDataStreamPublish nDataStreamPublish2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException {
        nEvent nEvent2 = this.myEventProcessor.writeEvent(nDataStreamPublish2);
        nExceptionEventProcessor.checkPublishPausedException(nEvent2);
    }

    public void commitRegisteredEventsToDataGroups(nRegisteredEvent[] nRegisteredEventArray) throws nSecurityException, nSessionPausedException, nIllegalArgumentException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nMaxBufferSizeExceededException {
        this.commitRegisteredEventsToDataGroups(nRegisteredEventArray, false);
    }

    public void commitRegisteredEventsToDataGroups(nRegisteredEvent[] nRegisteredEventArray, boolean bl) throws nSecurityException, nSessionPausedException, nIllegalArgumentException, nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nMaxBufferSizeExceededException {
        LinkedHashMap<nConsumeEvent, nDataGroup> linkedHashMap = new LinkedHashMap<nConsumeEvent, nDataGroup>();
        for (nRegisteredEvent nRegisteredEvent2 : nRegisteredEventArray) {
            if (!nRegisteredEvent2.isDataGroup()) {
                throw new nIllegalArgumentException("Registered events must be from Data Group objects to use this method");
            }
            linkedHashMap.put(nRegisteredEvent2.getChangedEvent(bl), nRegisteredEvent2.getDataGroup());
        }
        this.writeDataGroup(linkedHashMap, true);
    }

    public nDataGroup createDataGroup(String string) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, null, null, false, false);
    }

    public nDataGroup createDataGroup(String string, nDataGroupListener nDataGroupListener2) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, nDataGroupListener2, null, false, false);
    }

    public nDataGroup createDataGroup(String string, nDataGroupListener nDataGroupListener2, nConflationAttributes nConflationAttributes2) throws nRequestTimedOutException, nIllegalArgumentException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, nDataGroupListener2, nConflationAttributes2, false, false);
    }

    public nDataGroup createDataGroup(String string, boolean bl) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, null, null, bl, false);
    }

    public nDataGroup createDataGroup(String string, nDataGroupListener nDataGroupListener2, boolean bl) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, nDataGroupListener2, null, bl, false);
    }

    public nDataGroup createDataGroup(String string, nDataGroupListener nDataGroupListener2, nConflationAttributes nConflationAttributes2, boolean bl, boolean bl2) throws nRequestTimedOutException, nIllegalArgumentException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroup(string, nDataGroupListener2, nConflationAttributes2, bl, bl2, 4);
    }

    public nDataGroup createDataGroup(String string, nDataGroupListener nDataGroupListener2, nConflationAttributes nConflationAttributes2, boolean bl, boolean bl2, int n) throws nRequestTimedOutException, nIllegalArgumentException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        if (string == null || string.length() == 0) {
            throw new nIllegalArgumentException("Please supply a valid Data Group Name");
        }
        if (n < 0 || n > 9) {
            throw new nIllegalArgumentException(String.format("Please supply a priority level between %d and %d", 0, 9));
        }
        return this.myDataGroupManager.findOrCreateGroup(string, nDataGroupListener2, nConflationAttributes2, bl, bl2, n);
    }

    public nDataGroup[] createDataGroups(String[] stringArray) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroups(stringArray, null);
    }

    public nDataGroup[] createDataGroups(String[] stringArray, boolean bl) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroups(stringArray, null, bl);
    }

    public nDataGroup[] createDataGroups(String[] stringArray, nConflationAttributes nConflationAttributes2) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.createDataGroups(stringArray, nConflationAttributes2, false);
    }

    public nDataGroup[] createDataGroups(String[] stringArray, nConflationAttributes nConflationAttributes2, boolean bl) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.myDataGroupManager.createDataGroups(stringArray, nConflationAttributes2, bl);
    }

    public void deleteDataGroup(String[] stringArray) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.myDataGroupManager.deleteDataGroup(stringArray);
    }

    public void deleteDataGroup(String string) throws nIllegalArgumentException, nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.myDataGroupManager.deleteDataGroup(string);
    }

    public void deleteDataGroup(nDataGroup nDataGroup2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.myDataGroupManager.deleteDataGroup(nDataGroup2);
    }

    public void deleteDataGroup(nDataGroup[] nDataGroupArray) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        this.myDataGroupManager.deleteDataGroup(nDataGroupArray);
    }

    public nDataGroup getDefaultDataGroup() throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.myDataGroupManager.getDefaultDataGroup(null, false);
    }

    public nDataGroup getDefaultDataGroup(nDataGroupListener nDataGroupListener2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.myDataGroupManager.getDefaultDataGroup(nDataGroupListener2, true);
    }

    public nDataGroup[] getDataGroups() throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.getDataGroups(null, null);
    }

    public nDataGroup[] getDataGroups(String string) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.getDataGroups(string, null);
    }

    public nDataGroup[] getDataGroups(nDataGroupListener nDataGroupListener2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.getDataGroups(null, nDataGroupListener2);
    }

    public nDataGroup[] getDataGroups(String string, nDataGroupListener nDataGroupListener2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nUnexpectedResponseException {
        return this.myDataGroupManager.getDataGroups(string, nDataGroupListener2);
    }

    public int getKnownGroupCount() {
        return this.myDataGroupManager.getKnownGroupCount();
    }

    protected void registerExtensionCallback(nServerExtensionCallback nServerExtensionCallback2) {
        this.myConnectionManager.registerExtensionCallback(nServerExtensionCallback2);
    }

    protected void sendExtensionData(long l, byte[] byArray, nEventProperties nEventProperties2) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException {
        fEventDictionary fEventDictionary2 = null;
        if (nEventProperties2 != null) {
            fEventDictionary2 = nEventProperties2.myDictionary;
        }
        nServerExtensionEvent nServerExtensionEvent2 = new nServerExtensionEvent(l, byArray, fEventDictionary2);
        this.myEventProcessor.writeEvent(nServerExtensionEvent2);
    }
}

