/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.nirvana.base.UrlProcessor;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nRealm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public class nSessionAttributes {
    public static final String KEYSTORE_PATH = "com.softwareag.um.client.ssl.keystore_path";
    public static final String KEYSTORE_PASSWORD = "com.softwareag.um.client.ssl.keystore_password";
    public static final String CERTIFICATE_ALIAS = "com.softwareag.um.client.ssl.certificate_alias";
    public static final String TRUSTSTORE_PATH = "com.softwareag.um.client.ssl.truststore_path";
    public static final String TRUSTSTORE_PASSWORD = "com.softwareag.um.client.ssl.truststore_password";
    public static final String ENABLED_CIPHERS = "com.softwareag.um.client.ssl.enabled_ciphers";
    public static final String SSL_PROTOCOL = "com.softwareag.um.client.ssl.ssl_protocol";
    private static final String ALTERNATIVE_SSL_PROTOCOL = "SSLClientProtocol";
    public static final String PKCS11_NSS_CONFIG = "com.softwareag.um.client.pkcs11_nss_config";
    public static final String PKCS11_NSS_NAME = "com.softwareag.um.client.pkcs11_nss_name";
    public static final String FOLLOW_THE_MASTER = "com.softwareag.um.client.follow_the_master";
    private static final String ALTERNATIVE_FOLLOW_THE_MASTER = "FollowTheMaster";
    public static final String SESSION_DISABLE_RECONNECT = "com.softwareag.um.client.session_disable_reconnect";
    private static final String ALTERNATIVE_SESSION_DISABLE_RECONNECT = "SessionDisableReconnect";
    public static final String WRITE_HANDLER = "com.softwareag.um.client.write_handler";
    private static final String ALTERNATIVE_WRITE_HANDLER = "WriteHandler";
    private static final String ALTERNATIVE_2_WRITE_HANDLER = "nirvana.writeHandler";
    public static final String ADAPTER_BUFFER = "com.softwareag.um.client.network_io_buffer_size";
    private static final String ALTERNATIVE_ADAPTER_BUFFER = "AdapterBuffer";
    private static final String ALTERNATIVE_2_ADAPTER_BUFFER = "nirvana.adapterBuffer";
    private static final long sInitialConnectionRetryCountDefault = 0L;
    private static final boolean sConfiguredFollowTheMaster;
    private static final boolean sConfiguredDisableReconnect;
    private static String pkcs11NSSConfig;
    private static String pkcs11NSSName;
    private final List<List<fConnectionDetails>> connectionDetails;
    private final long initialConnectionRetryCount;
    private String keyStorePath;
    private String keyStorePassword;
    private String certificateAlias;
    private String trustStorePath;
    private String trustStorePassword;
    private String[] enabledCiphers;
    private String sslProtocol;
    private boolean requestPriorityConnection;
    private boolean followTheMaster = sConfiguredFollowTheMaster;
    private boolean disconnectOnClusterFailure = false;
    private String mySessionName = "";
    private boolean disableReconnect = sConfiguredDisableReconnect;
    private boolean requestUnthrottledConnection = false;
    private boolean isSessionThreadsDaemon = false;
    private boolean isAdviseAsynchronousEventListenersOfStoreDelete = true;
    private boolean reconnectImmediately = nConstants.attemptReconnectImmediately();
    private long reconnectInterval = nConstants.getReconnectInterval();

    private void setupSSL() {
        this.keyStorePath = fSystemConfiguration.getProperty(KEYSTORE_PATH);
        this.keyStorePassword = fSystemConfiguration.getProperty(KEYSTORE_PASSWORD);
        this.certificateAlias = fSystemConfiguration.getProperty(CERTIFICATE_ALIAS);
        this.trustStorePath = fSystemConfiguration.getProperty(TRUSTSTORE_PATH);
        this.trustStorePassword = fSystemConfiguration.getProperty(TRUSTSTORE_PASSWORD);
        String string = fSystemConfiguration.getProperty(ENABLED_CIPHERS);
        this.enabledCiphers = string != null ? string.split(",") : null;
        this.sslProtocol = fSystemConfiguration.getProperty(ALTERNATIVE_SSL_PROTOCOL, fSystemConfiguration.getProperty(SSL_PROTOCOL));
    }

    public nSessionAttributes(nRealm nRealm2) throws nIllegalArgumentException {
        this(nRealm2, 0L);
    }

    public nSessionAttributes(nRealm nRealm2, long l) throws nIllegalArgumentException {
        if (nRealm2 == null) {
            throw new nIllegalArgumentException("Invalid nRealm object supplied : <null>");
        }
        if (nRealm2.getConnections().size() == 0) {
            throw new nIllegalArgumentException("Realm has no defined connections");
        }
        this.initialConnectionRetryCount = l;
        this.setupSSL();
        ArrayList<List<fConnectionDetails>> arrayList = new ArrayList<List<fConnectionDetails>>();
        ArrayList<fConnectionDetails> arrayList2 = new ArrayList<fConnectionDetails>(nRealm2.getConnectionDetails());
        arrayList.add(Collections.unmodifiableList(arrayList2));
        this.connectionDetails = Collections.unmodifiableList(arrayList);
        this.validateConnectionDetails();
    }

    public nSessionAttributes(String string) throws nIllegalArgumentException {
        this(string, 0L);
    }

    public nSessionAttributes(String string, long l) throws nIllegalArgumentException {
        this(UrlProcessor.processURL(string), l);
    }

    public nSessionAttributes(String[] stringArray) throws nIllegalArgumentException {
        this(stringArray, 0L);
    }

    public nSessionAttributes(String[] stringArray, long l) throws nIllegalArgumentException {
        this(UrlProcessor.preprocessURL(stringArray), l);
    }

    private nSessionAttributes(List<List<String>> list, long l) throws nIllegalArgumentException {
        this.initialConnectionRetryCount = l;
        this.setupSSL();
        ArrayList<List<fConnectionDetails>> arrayList = new ArrayList<List<fConnectionDetails>>();
        for (List<String> list2 : list) {
            try {
                arrayList.add(Collections.unmodifiableList(UrlProcessor.createConnectionList(list2)));
            }
            catch (IOException iOException) {
                throw new nIllegalArgumentException(iOException.getMessage(), iOException);
            }
        }
        this.connectionDetails = Collections.unmodifiableList(arrayList);
        this.validateConnectionDetails();
    }

    public static void setPKCS11NSSConfigFile(String string) {
        pkcs11NSSConfig = string;
    }

    public static void setPKCS11NSSName(String string) {
        pkcs11NSSName = string;
    }

    public static String getPKCS11NSSConfigFile() {
        return pkcs11NSSConfig;
    }

    public static String getPKCS11NSSName() {
        return pkcs11NSSName;
    }

    private void validateConnectionDetails() throws nIllegalArgumentException {
        if (this.connectionDetails.isEmpty()) {
            throw new nIllegalArgumentException("No URL's have been configured");
        }
    }

    @Deprecated
    public boolean isRequestPriorityConnection() {
        return this.requestPriorityConnection;
    }

    @Deprecated
    public void setRequestPriorityConnection(boolean bl) {
        this.requestPriorityConnection = bl;
    }

    public void setRequestUnthrottledConnection(boolean bl) {
        this.requestUnthrottledConnection = bl;
    }

    public boolean isRequestUnthrottledConnection() {
        return this.requestUnthrottledConnection;
    }

    public boolean isFollowTheMaster() {
        return this.followTheMaster;
    }

    public void setFollowTheMaster(boolean bl) {
        this.followTheMaster = bl;
    }

    public boolean isDisconnectOnClusterFailure() {
        return this.disconnectOnClusterFailure;
    }

    public void setDisconnectOnClusterFailure(boolean bl) {
        this.disconnectOnClusterFailure = bl;
    }

    public boolean getReconnectImmediately() {
        return this.reconnectImmediately;
    }

    public void setReconnectImmediately(boolean bl) {
        this.reconnectImmediately = bl;
    }

    public long getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(long l) {
        this.reconnectInterval = l;
    }

    public long getInitialConnectionRetryCount() {
        return this.initialConnectionRetryCount;
    }

    public int getNumberOfConnections() {
        return this.connectionDetails.get(0).size();
    }

    public String getConnectionDetail(int n) {
        if (n < 0 || this.connectionDetails.isEmpty() || n >= this.connectionDetails.get(0).size()) {
            throw new NoSuchElementException("Array index out of bounds");
        }
        return this.connectionDetails.get(0).get(n).toString();
    }

    protected List<List<fConnectionDetails>> getConnections() {
        return this.connectionDetails;
    }

    public void setDisableReconnect(boolean bl) {
        this.disableReconnect = bl;
    }

    public boolean isDisableReconnect() {
        return this.disableReconnect;
    }

    public String getName() {
        return this.mySessionName;
    }

    public void setName(String string) {
        this.mySessionName = string;
    }

    public boolean isAdviseAsynchronousEventListenersOfStoreDelete() {
        return this.isAdviseAsynchronousEventListenersOfStoreDelete;
    }

    public void setAdviseAsynchronousEventListenersOfStoreDelete(boolean bl) {
        this.isAdviseAsynchronousEventListenersOfStoreDelete = bl;
    }

    public void setKeystore(String string, String string2) {
        this.keyStorePath = string;
        this.keyStorePassword = string2;
    }

    public void setKeystore(String string, String string2, String string3) {
        this.keyStorePath = string;
        this.keyStorePassword = string2;
        if (string3 != null) {
            string3 = string3.toLowerCase();
        }
        this.certificateAlias = string3;
    }

    public void setTruststore(String string, String string2) {
        this.trustStorePath = string;
        this.trustStorePassword = string2;
    }

    public void setEnabledCiphers(String[] stringArray) {
        this.enabledCiphers = stringArray;
    }

    public void setSSLProtocol(String string) {
        this.sslProtocol = string;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getKeyStorePass() {
        return this.keyStorePassword;
    }

    public String getKeyStoreCert() {
        return this.certificateAlias;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getTrustStorePass() {
        return this.trustStorePassword;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public void setSessionThreadsAsDaemon(boolean bl) {
        this.isSessionThreadsDaemon = bl;
    }

    public boolean isSessionThreadsDaemon() {
        return this.isSessionThreadsDaemon;
    }

    public boolean isHorizontalScalabilityEnabled() {
        return this.connectionDetails.size() > 1;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":conns=" + this.connectionDetails.size() + "/" + this.connectionDetails;
    }

    static {
        String string;
        pkcs11NSSConfig = fSystemConfiguration.getProperty(PKCS11_NSS_CONFIG);
        pkcs11NSSName = fSystemConfiguration.getProperty(PKCS11_NSS_NAME);
        sConfiguredFollowTheMaster = Boolean.parseBoolean(fSystemConfiguration.getProperty(ALTERNATIVE_FOLLOW_THE_MASTER, fSystemConfiguration.getProperty(FOLLOW_THE_MASTER, "false")));
        sConfiguredDisableReconnect = Boolean.parseBoolean(fSystemConfiguration.getProperty(ALTERNATIVE_SESSION_DISABLE_RECONNECT, fSystemConfiguration.getProperty(SESSION_DISABLE_RECONNECT, "false")));
        String string2 = fSystemConfiguration.getProperty(ALTERNATIVE_2_WRITE_HANDLER, fSystemConfiguration.getProperty(ALTERNATIVE_WRITE_HANDLER, fSystemConfiguration.getProperty(WRITE_HANDLER)));
        if (string2 != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (string2.equalsIgnoreCase("direct") || n == 2) {
                nConstants.setWriteHandlerType(2);
            } else if (string2.equalsIgnoreCase("peak") || string2.equalsIgnoreCase("standard") || n == 3) {
                nConstants.setWriteHandlerType(3);
            } else if (string2.equalsIgnoreCase("queue") || n == 1) {
                nConstants.setWriteHandlerType(1);
            }
        }
        if ((string = fSystemConfiguration.getProperty(ALTERNATIVE_ADAPTER_BUFFER, fSystemConfiguration.getProperty(ALTERNATIVE_2_ADAPTER_BUFFER, fSystemConfiguration.getProperty(ADAPTER_BUFFER)))) != null) {
            try {
                int n = Integer.parseInt(string);
                nConstants.setSocketReceiveBufferSize(n);
                nConstants.setSocketSendBufferSize(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

