/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fRuntime;
import com.pcbsys.foundation.drivers.jdk.fJDKHelper;
import com.pcbsys.foundation.io.fWriteHandlerFlushManager;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.pcbsys.nirvana.client.SAGClientIDReader;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nReconnectHandler;
import com.pcbsys.nirvana.client.nSession;
import com.pcbsys.nirvana.client.nSessionAttributes;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class nSessionFactory {
    private static final boolean sEnableMultiplexedSessions;
    private static final Map<nSession, SessionConstructionInfo> sessionList;
    private static String SAG_PRODUCT_CODE;

    static void reloadSAGClientID() {
        SAG_PRODUCT_CODE = SAGClientIDReader.initializeSAGClientID();
    }

    static String getSAGAppID() {
        return SAG_PRODUCT_CODE;
    }

    public static nSession createMultiplexed(nSession nSession2) throws nIllegalArgumentException {
        return nSessionFactory.createMultiplexed(nSession2, null, null);
    }

    public static nSession createMultiplexed(nSession nSession2, String string) throws nIllegalArgumentException {
        return nSessionFactory.createMultiplexed(nSession2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static nSession createMultiplexed(nSession nSession2, String string, String string2) throws nIllegalArgumentException {
        if (nSession2 == null) {
            throw new nIllegalArgumentException("Null nSession supplied");
        }
        if (sEnableMultiplexedSessions) {
            nSession nSession3 = nSession2;
            synchronized (nSession3) {
                nSession nSession4 = new nSession(nSession2, string == null ? nSession2.getUsername() : string, string == null ? nSession2.getPassword() : string2);
                nSessionFactory.recordSession(nSession4);
                return nSession4;
            }
        }
        return nSessionFactory.create(nSession2.getAttributes());
    }

    public static nSession createMultiplexed(nSessionAttributes nSessionAttributes2) throws nIllegalArgumentException, nSessionNotConnectedException {
        return nSessionFactory.createMultiplexed(nSessionAttributes2, null, null);
    }

    public static nSession createMultiplexed(nSessionAttributes nSessionAttributes2, String string) throws nIllegalArgumentException, nSessionNotConnectedException {
        return nSessionFactory.createMultiplexed(nSessionAttributes2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static nSession createMultiplexed(nSessionAttributes nSessionAttributes2, String string, String string2) throws nIllegalArgumentException, nSessionNotConnectedException {
        if (nSessionAttributes2 == null) {
            throw new nIllegalArgumentException("Null nSessionAttributes supplied");
        }
        Map<nSession, SessionConstructionInfo> map = sessionList;
        synchronized (map) {
            for (nSession nSession2 : sessionList.keySet()) {
                if (nSessionAttributes2.getNumberOfConnections() != nSession2.getAttributes().getNumberOfConnections()) continue;
                boolean bl = true;
                for (int i = 0; i < nSessionAttributes2.getNumberOfConnections(); ++i) {
                    boolean bl2 = false;
                    for (int j = 0; j < nSession2.getAttributes().getNumberOfConnections(); ++j) {
                        try {
                            if (!nSession2.getAttributes().getConnectionDetail(j).equals(nSessionAttributes2.getConnectionDetail(i))) continue;
                            bl2 = true;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (nSession2.isConnected()) {
                    return nSessionFactory.createMultiplexed(nSession2, string, string2);
                }
                throw new nSessionNotConnectedException("session not connected");
            }
        }
        if (string != null) {
            return nSessionFactory.create(nSessionAttributes2, string, string2);
        }
        return nSessionFactory.create(nSessionAttributes2);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, fEnvironment.getUsername(), null);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2, nReconnectHandler nReconnectHandler2) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, nReconnectHandler2, fEnvironment.getUsername(), null);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2, nReconnectHandler nReconnectHandler2, String string) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, nReconnectHandler2, string, null);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2, nReconnectHandler nReconnectHandler2, String string, String string2) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, string, string2, nReconnectHandler2, true);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2, String string) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, string, null);
    }

    public static nSession create(nSessionAttributes nSessionAttributes2, String string, String string2) throws nIllegalArgumentException {
        return nSessionFactory.create(nSessionAttributes2, string, string2, null, false);
    }

    private static nSession create(nSessionAttributes nSessionAttributes2, String string, String string2, nReconnectHandler nReconnectHandler2, boolean bl) throws nIllegalArgumentException {
        if (nSessionAttributes2 == null) {
            throw new nIllegalArgumentException("Null nSessionAttributes supplied");
        }
        if (bl && nReconnectHandler2 == null) {
            throw new nIllegalArgumentException("Null nReconnectHandler supplied");
        }
        nSession nSession2 = new nSession(nSessionAttributes2, nReconnectHandler2, string, string2);
        nSessionFactory.recordSession(nSession2);
        return nSession2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(nSession nSession2) throws nIllegalArgumentException {
        if (nSession2 != null) {
            SessionConstructionInfo sessionConstructionInfo;
            Map<nSession, SessionConstructionInfo> map = sessionList;
            synchronized (map) {
                sessionConstructionInfo = sessionList.remove(nSession2);
            }
            nSession2.mainClose();
            if (sessionConstructionInfo == null) {
                throw new nIllegalArgumentException("Unknown session");
            }
        } else {
            throw new nIllegalArgumentException("Null session supplied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Map<nSession, SessionConstructionInfo> map = sessionList;
        synchronized (map) {
            Iterator<nSession> iterator = sessionList.keySet().iterator();
            while (iterator.hasNext()) {
                nSession nSession2 = iterator.next();
                iterator.remove();
                try {
                    nSession2.mainClose();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recordSession(nSession nSession2) {
        Map<nSession, SessionConstructionInfo> map = sessionList;
        synchronized (map) {
            sessionList.put(nSession2, new SessionConstructionInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNoVended() {
        Map<nSession, SessionConstructionInfo> map = sessionList;
        synchronized (map) {
            return sessionList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<nSession, SessionConstructionInfo> getCurrentSessions() {
        Map<nSession, SessionConstructionInfo> map = sessionList;
        synchronized (map) {
            return new LinkedHashMap<nSession, SessionConstructionInfo>(sessionList);
        }
    }

    static {
        sessionList = new LinkedHashMap<nSession, SessionConstructionInfo>();
        fJDKHelper.setupEnvironment();
        if (!fSystemConfiguration.isAnApplet()) {
            String string = fSystemConfiguration.getProperty("EnableMultiplexed", "true");
            sEnableMultiplexedSessions = Boolean.parseBoolean(string);
        } else {
            sEnableMultiplexedSessions = false;
        }
        if (!fRuntime.isServer()) {
            fWriteHandlerFlushManager.getInstance().setFlushCount(1);
            SAG_PRODUCT_CODE = SAGClientIDReader.initializeSAGClientID();
        }
    }

    static class SessionConstructionInfo {
        Exception myCreationPath = new Exception("Created");
        long myCreationTime;

        SessionConstructionInfo() {
            this.myCreationPath.fillInStackTrace();
            this.myCreationTime = System.currentTimeMillis();
        }

        public Exception getConstruction() {
            return this.myCreationPath;
        }

        public String toString() {
            return "Created:" + new Date(this.myCreationTime) + "\n" + this.myCreationPath.toString();
        }
    }
}

