/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.base.fEventDictionary;
import com.pcbsys.nirvana.base.nConstants;
import com.pcbsys.nirvana.client.nIllegalArgumentException;

public final class nStoreProperties {
    private fEventDictionary myParameters;

    public void copy(nStoreProperties nStoreProperties2) {
        try {
            this.setCacheOnReload(nStoreProperties2.getCacheOnReload());
            this.setEnableCaching(nStoreProperties2.getEnableCaching());
            this.setEnableReadBuffering(nStoreProperties2.getEnableReadBuffering());
            this.setHonorCapacityWhenFull(nStoreProperties2.getHonorCapacityWhenFull());
            this.setPerformAutomaticMaintenance(nStoreProperties2.getPerformAutomaticMaintenance());
            this.setReadBufferSize(nStoreProperties2.getReadBufferSize());
            this.setSyncBatchTime(nStoreProperties2.getSyncBatchTime());
            this.setSyncMaxBatchSize(nStoreProperties2.getSyncMaxBatchSize());
            this.setSyncOnEachWrite(nStoreProperties2.canSyncOnEachWrite());
            this.setClientMergeEngineClassname(nStoreProperties2.getClientMergeEngineClassname());
            this.setFanoutArchiveTarget(nStoreProperties2.getFanoutArchiveTarget());
            this.setPriority(nStoreProperties2.getPriority());
            this.setStampDictionary(nStoreProperties2.getStampDictionary());
            this.enableMulticast(nStoreProperties2.enableMulticast());
            this.setMultiFileEventsPerSpindle(nStoreProperties2.getMultiFileEventsPerSpindle());
        }
        catch (Exception exception) {
            nConstants.logger.error("Exception in nStoreProperties : " + exception.getMessage());
        }
    }

    public boolean getHonorCapacityWhenFull() {
        if (this.myParameters.containsKey("HonourCapacity")) {
            return this.myParameters.getBoolean("HonourCapacity");
        }
        return false;
    }

    public void setHonorCapacityWhenFull(boolean bl) {
        this.myParameters.put("HonourCapacity", bl);
    }

    public boolean canSyncOnEachWrite() {
        if (this.myParameters.containsKey("SyncOnWrite")) {
            return this.myParameters.getBoolean("SyncOnWrite");
        }
        return false;
    }

    public void setSyncOnEachWrite(boolean bl) {
        if (bl) {
            this.myParameters.put("SyncOnWrite", true);
        } else {
            this.myParameters.remove("SyncOnWrite");
        }
    }

    public int getSyncMaxBatchSize() {
        if (this.myParameters.containsKey("SyncBatchSize")) {
            return this.myParameters.getInt("SyncBatchSize");
        }
        return 0;
    }

    public void setSyncMaxBatchSize(int n) {
        if (n >= 1 && n < 1000) {
            this.myParameters.put("SyncBatchSize", n);
        } else {
            this.myParameters.remove("SyncBatchSize");
        }
    }

    public int getSyncBatchTime() {
        if (this.myParameters.containsKey("SyncTime")) {
            return this.myParameters.getInt("SyncTime");
        }
        return 0;
    }

    public void setSyncBatchTime(int n) {
        if (n > 1 && n < 1000) {
            this.myParameters.put("SyncTime", n);
        } else {
            this.myParameters.remove("SyncTime");
        }
    }

    public boolean getPerformAutomaticMaintenance() {
        if (this.myParameters.containsKey("PerformMaint")) {
            return this.myParameters.getBoolean("PerformMaint");
        }
        return false;
    }

    public void setPerformAutomaticMaintenance(boolean bl) {
        this.myParameters.put("PerformMaint", bl);
    }

    @Deprecated
    public String getFanoutArchiveTarget() {
        return this.myParameters.getString("FanoutArchiveTarget");
    }

    @Deprecated
    public void setFanoutArchiveTarget(String string) {
        if (string != null) {
            this.myParameters.put("FanoutArchiveTarget", string);
        } else {
            this.myParameters.remove("FanoutArchiveTarget");
        }
    }

    public String getClientMergeEngineClassname() {
        return this.myParameters.getString("MergeClassName");
    }

    public void setClientMergeEngineClassname(String string) {
        if (string != null) {
            this.myParameters.put("MergeClassName", string);
        } else {
            this.myParameters.remove("MergeClassName");
        }
    }

    public boolean getEnableCaching() {
        if (this.myParameters.containsKey("EnableCaching")) {
            return this.myParameters.getBoolean("EnableCaching");
        }
        return true;
    }

    public void setEnableCaching(boolean bl) {
        this.myParameters.put("EnableCaching", bl);
    }

    public boolean getCacheOnReload() {
        if (this.myParameters.containsKey("CacheOnReload")) {
            return this.myParameters.getBoolean("CacheOnReload");
        }
        return true;
    }

    public void setCacheOnReload(boolean bl) {
        this.myParameters.put("CacheOnReload", bl);
    }

    @Deprecated
    public boolean getEnableReadBuffering() {
        if (this.myParameters.containsKey("EnableStoreBuffering")) {
            return this.myParameters.getBoolean("EnableStoreBuffering");
        }
        return true;
    }

    @Deprecated
    public void setEnableReadBuffering(boolean bl) {
        this.myParameters.put("EnableStoreBuffering", bl);
    }

    @Deprecated
    public long getReadBufferSize() {
        if (this.myParameters.containsKey("StoreBufferSize")) {
            return this.myParameters.getLong("StoreBufferSize");
        }
        return 10240L;
    }

    @Deprecated
    public void setReadBufferSize(long l) {
        if (l > 1024L) {
            this.myParameters.put("StoreBufferSize", l);
        } else {
            this.myParameters.remove("StoreBufferSize");
        }
    }

    public void setPriority(int n) throws nIllegalArgumentException {
        if (n < 0 || n > 9) {
            throw new nIllegalArgumentException("Invalid priority level set : " + n + ". Must be a value between 1 and 10");
        }
        this.myParameters.put("Priority", n);
    }

    public int getPriority() {
        int n = 4;
        if (this.myParameters.containsKey("Priority") && ((n = this.myParameters.getInt("Priority")) < 0 || n > 9)) {
            return 4;
        }
        return n;
    }

    public int getStampDictionary() {
        return this.myParameters.getInt("StampDictionary");
    }

    public void setStampDictionary(int n) {
        if (n != 1 && n != -1 && n != 0) {
            throw new IllegalArgumentException("StampDictionary must have one of the following values: [1, -1, 0].");
        }
        this.myParameters.put("StampDictionary", n);
        this.myParameters.put("StampDictionary", n);
    }

    public int getMultiFileEventsPerSpindle() {
        if (this.myParameters.containsKey("multiFileEventsPerSpindle")) {
            return this.myParameters.getInt("multiFileEventsPerSpindle");
        }
        return 0;
    }

    public void setMultiFileEventsPerSpindle(int n) {
        this.myParameters.put("multiFileEventsPerSpindle", n);
    }

    public boolean enableMulticast() {
        if (this.myParameters.containsKey("EnableMulticast")) {
            return this.myParameters.getBoolean("EnableMulticast");
        }
        return false;
    }

    public void enableMulticast(boolean bl) {
        if (this.myParameters.containsKey("EnableMulticast")) {
            this.myParameters.remove("EnableMulticast");
        }
        this.myParameters.put("EnableMulticast", bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof nStoreProperties)) {
            return false;
        }
        if (this.getPerformAutomaticMaintenance() != ((nStoreProperties)object).getPerformAutomaticMaintenance()) {
            return false;
        }
        if (this.getHonorCapacityWhenFull() != ((nStoreProperties)object).getHonorCapacityWhenFull()) {
            return false;
        }
        if (this.getEnableCaching() != ((nStoreProperties)object).getEnableCaching()) {
            return false;
        }
        if (this.getCacheOnReload() != ((nStoreProperties)object).getCacheOnReload()) {
            return false;
        }
        if (this.getEnableReadBuffering() != ((nStoreProperties)object).getEnableReadBuffering()) {
            return false;
        }
        if (this.enableMulticast() != ((nStoreProperties)object).enableMulticast()) {
            return false;
        }
        if (this.getReadBufferSize() != ((nStoreProperties)object).getReadBufferSize()) {
            return false;
        }
        if (this.canSyncOnEachWrite() != ((nStoreProperties)object).canSyncOnEachWrite()) {
            return false;
        }
        if (this.getSyncMaxBatchSize() != ((nStoreProperties)object).getSyncMaxBatchSize()) {
            return false;
        }
        if (this.getSyncBatchTime() != ((nStoreProperties)object).getSyncBatchTime()) {
            return false;
        }
        if (this.getFanoutArchiveTarget() != null) {
            if (((nStoreProperties)object).getFanoutArchiveTarget() == null) return false;
            if (!this.getFanoutArchiveTarget().equals(((nStoreProperties)object).getFanoutArchiveTarget())) {
                return false;
            }
        } else if (((nStoreProperties)object).getFanoutArchiveTarget() != null) {
            return false;
        }
        if (this.getPriority() != ((nStoreProperties)object).getPriority()) {
            return false;
        }
        if (this.getMultiFileEventsPerSpindle() == ((nStoreProperties)object).getMultiFileEventsPerSpindle()) return this.getStampDictionary() == ((nStoreProperties)object).getStampDictionary();
        return false;
    }

    protected nStoreProperties(fEventDictionary fEventDictionary2) {
        this.myParameters = fEventDictionary2;
    }
}

