/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.nirvana.client;

import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.nirvana.base.ClientEventTraceLoggerContext;
import com.pcbsys.nirvana.base.clientimpl.ClientConnectionManager;
import com.pcbsys.nirvana.base.events.nEvent;
import com.pcbsys.nirvana.base.events.nPublished;
import com.pcbsys.nirvana.base.events.nTXAbort;
import com.pcbsys.nirvana.base.events.nTXCommit;
import com.pcbsys.nirvana.base.events.nTXIsCommitted;
import com.pcbsys.nirvana.base.events.nTXPublishCommit;
import com.pcbsys.nirvana.base.events.nTXPublishRequest;
import com.pcbsys.nirvana.base.nExceptionEventProcessor;
import com.pcbsys.nirvana.client.nAbstractChannel;
import com.pcbsys.nirvana.client.nChannelNotFoundException;
import com.pcbsys.nirvana.client.nConstants;
import com.pcbsys.nirvana.client.nConsumeEvent;
import com.pcbsys.nirvana.client.nConsumeEventConverter;
import com.pcbsys.nirvana.client.nIllegalArgumentException;
import com.pcbsys.nirvana.client.nMaxBufferSizeExceededException;
import com.pcbsys.nirvana.client.nRequestTimedOutException;
import com.pcbsys.nirvana.client.nSecurityException;
import com.pcbsys.nirvana.client.nSessionNotConnectedException;
import com.pcbsys.nirvana.client.nSessionPausedException;
import com.pcbsys.nirvana.client.nTransactionAlreadyAbortedException;
import com.pcbsys.nirvana.client.nTransactionAlreadyCommittedException;
import com.pcbsys.nirvana.client.nTransactionAttributes;
import com.pcbsys.nirvana.client.nTransactionIncompleteException;
import com.pcbsys.nirvana.client.nTransactionNoEventsException;
import com.pcbsys.nirvana.client.nTransactionNoSuchTXIDException;
import com.pcbsys.nirvana.client.nTransactionNotCommittedException;
import com.pcbsys.nirvana.client.nTransactionNotStartedException;
import com.pcbsys.nirvana.client.nUnexpectedResponseException;
import com.pcbsys.nirvana.client.nUnknownTransactionIdException;
import java.util.Collections;
import java.util.Date;
import org.w3c.dom.Document;

public class nTransaction {
    private static final String CLASS_NAME = nTransaction.class.getSimpleName();
    private final long myTimeout;
    private final nTransactionAttributes myAttributes;
    private final nAbstractChannel myChannel;
    private long myTXId;
    private Vector<nPublished> myPublishStorage = null;
    private boolean hasPublished = false;
    private boolean hasCommitted = false;
    private boolean hasAborted = false;
    private long myStartEID = 0L;
    private long myEndEID = 0L;
    private final boolean isTransactionXA;
    private final ClientConnectionManager myConnectionManager;

    protected nTransaction(nTransactionAttributes nTransactionAttributes2, boolean bl) {
        this(nTransactionAttributes2, -1L, bl);
    }

    protected nTransaction(nTransactionAttributes nTransactionAttributes2) {
        this(nTransactionAttributes2, -1L, false);
    }

    protected nTransaction(nTransactionAttributes nTransactionAttributes2, long l) {
        this(nTransactionAttributes2, l, false);
    }

    private nTransaction(nTransactionAttributes nTransactionAttributes2, long l, boolean bl) {
        this.isTransactionXA = bl;
        this.myAttributes = nTransactionAttributes2;
        this.myChannel = nTransactionAttributes2.getChannel();
        this.myConnectionManager = this.myChannel.getConnectionManager();
        this.myTimeout = nTransactionAttributes2.getTimeout();
        if (l <= -1L) {
            this.hasPublished = false;
            this.myTXId = -1L;
        } else {
            this.hasPublished = true;
            this.myTXId = l;
        }
    }

    public long getStartEID() throws nTransactionNotCommittedException {
        if (!this.hasCommitted) {
            throw new nTransactionNotCommittedException();
        }
        return this.myStartEID;
    }

    public long getEndEID() throws nTransactionNotCommittedException {
        if (!this.hasCommitted) {
            throw new nTransactionNotCommittedException();
        }
        return this.myEndEID;
    }

    public long getTXID() {
        try {
            return this.getTransactionID();
        }
        catch (nSessionNotConnectedException nSessionNotConnectedException2) {
        }
        catch (nSessionPausedException nSessionPausedException2) {
            // empty catch block
        }
        return this.myTXId;
    }

    private long getTransactionID() throws nSessionNotConnectedException, nSessionPausedException {
        return this.getTransactionID(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTransactionID(boolean bl) throws nSessionNotConnectedException, nSessionPausedException {
        boolean bl2 = false;
        nTransaction nTransaction2 = this;
        synchronized (nTransaction2) {
            if (this.myTXId == -1L) {
                this.myTXId = this.myConnectionManager.allocateTransactionID(this.myChannel);
                bl2 = true;
            }
        }
        if (bl2 && bl) {
            try {
                this.myChannel.getBaseChannel().writeEvent(new nTXPublishRequest(this.myChannel.getBaseAttributes().getUniqueId(), this.myTXId, new Vector<nPublished>(), this.myAttributes.getTTL()));
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                // empty catch block
            }
        }
        return this.myTXId;
    }

    public nTransactionAttributes getAttributes() {
        return this.myAttributes;
    }

    public boolean isAborted() throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nTransactionIncompleteException {
        return this.isAborted(false);
    }

    public boolean isAborted(boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nTransactionIncompleteException {
        try {
            this.checkTransactionsState(bl);
        }
        catch (nUnknownTransactionIdException nUnknownTransactionIdException2) {
            // empty catch block
        }
        return this.hasAborted;
    }

    public boolean isCommitted() throws nSessionNotConnectedException, nSessionPausedException, nUnknownTransactionIdException, nRequestTimedOutException, nTransactionIncompleteException {
        return this.isCommitted(false);
    }

    public boolean isCommitted(boolean bl) throws nSessionNotConnectedException, nSessionPausedException, nUnknownTransactionIdException, nRequestTimedOutException, nTransactionIncompleteException {
        this.checkTransactionsState(bl);
        return this.hasCommitted;
    }

    private void checkTransactionsState(boolean bl) throws nTransactionIncompleteException, nUnknownTransactionIdException, nSessionPausedException, nSessionNotConnectedException, nRequestTimedOutException {
        nEvent nEvent2;
        if (!bl) {
            if (this.hasCommitted || this.hasAborted) {
                return;
            }
            if (!this.hasPublished || this.myPublishStorage != null) {
                throw new nTransactionIncompleteException("The transaction has not been constructed with the server " + this.getTXID());
            }
        }
        if ((nEvent2 = this.myChannel.getBaseChannel().writeEvent(new nTXIsCommitted(this.getTransactionID()))) instanceof nTXIsCommitted) {
            nTXIsCommitted nTXIsCommitted2 = (nTXIsCommitted)nEvent2;
            if (nTXIsCommitted2.getKey() == 0L) {
                throw new nUnknownTransactionIdException();
            }
            this.hasCommitted = nTXIsCommitted2.isCommitted();
            this.hasAborted = nTXIsCommitted2.isAborted();
        }
    }

    public void push(nConsumeEvent nConsumeEvent2) throws nSessionNotConnectedException, nSessionPausedException, nTransactionAlreadyCommittedException, nSecurityException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        this.publish(nConsumeEvent2);
    }

    public void publish(nConsumeEvent nConsumeEvent2) throws nSessionNotConnectedException, nSessionPausedException, nTransactionAlreadyCommittedException, nSecurityException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        Vector<nConsumeEvent> vector = new Vector<nConsumeEvent>();
        vector.addElement(nConsumeEvent2);
        try {
            this.publish(vector);
        }
        catch (nTransactionNoEventsException nTransactionNoEventsException2) {
            // empty catch block
        }
    }

    @Deprecated
    public void publish(String string, Document document) throws nSessionNotConnectedException, nSessionPausedException, nTransactionAlreadyCommittedException, nSecurityException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        this.publish(new nConsumeEvent(string, document));
    }

    public void publish(java.util.Vector vector) throws nSessionNotConnectedException, nTransactionAlreadyCommittedException, nTransactionNoEventsException, nSecurityException, nSessionPausedException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        if (this.hasCommitted) {
            throw new nTransactionAlreadyCommittedException(" tx id " + this.getTransactionID());
        }
        if (this.hasAborted) {
            throw new nTransactionAlreadyAbortedException(" tx id " + this.getTransactionID());
        }
        this.checkIfStoreIsInvalid();
        if (vector.size() == 0) {
            throw new nTransactionNoEventsException();
        }
        long l = this.myChannel.getBaseAttributes().getUniqueId();
        if (!this.isTransactionXA) {
            if (this.myPublishStorage == null) {
                this.myPublishStorage = new Vector();
            }
            for (Object e : vector) {
                nPublished nPublished2 = this.convertPublishEvent((nConsumeEvent)e);
                this.myPublishStorage.add(nPublished2);
                if (!this.myChannel.getTraceLogger().isInfoEnabled()) continue;
                this.myChannel.getTraceLogger().info("Publish request. nPublished={" + ClientEventTraceLoggerContext.addPubEventTraceInfo(nPublished2) + "}" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            return;
        }
        this.hasPublished = true;
        Vector<nPublished> vector2 = this.myPublishStorage;
        this.myPublishStorage = null;
        if (vector2 == null) {
            vector2 = new Vector();
        }
        long l2 = this.getTransactionID(false);
        for (int i = 0; i < vector.size(); ++i) {
            nConsumeEvent nConsumeEvent2 = (nConsumeEvent)vector.elementAt(i);
            nPublished nPublished3 = this.convertPublishEvent(nConsumeEvent2);
            vector2.add(nPublished3);
            if (!this.myChannel.getTraceLogger().isTraceEnabled()) continue;
            this.myChannel.getTraceLogger().trace("XA> Publish request. nPublished={" + ClientEventTraceLoggerContext.addPubEventTraceInfo(nPublished3) + "}" + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager) + ", transactionId=" + l2, CLASS_NAME);
        }
        nTXPublishRequest nTXPublishRequest2 = new nTXPublishRequest(l, l2, vector2, this.myAttributes.getTTL());
        try {
            this.myChannel.getBaseChannel().writeEvent(nTXPublishRequest2);
        }
        catch (nRequestTimedOutException nRequestTimedOutException2) {
            // empty catch block
        }
    }

    private nPublished convertPublishEvent(nConsumeEvent nConsumeEvent2) throws nMaxBufferSizeExceededException, nSecurityException {
        return nConsumeEventConverter.nConsumeEventToPublishRequest(nConsumeEvent2, this.myAttributes.getSigner(), this.myChannel.getBaseAttributes().getUniqueId(), this.myConnectionManager);
    }

    public void abort() throws nSessionNotConnectedException, nRequestTimedOutException, nChannelNotFoundException, nSecurityException, nUnexpectedResponseException, nTransactionNotStartedException, nTransactionNoSuchTXIDException, nTransactionAlreadyCommittedException, nSessionPausedException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        this.commitOrAbortAndConfirm(false, this.myTimeout, -1L);
    }

    public void commit() throws nSessionNotConnectedException, nRequestTimedOutException, nTransactionNotStartedException, nUnexpectedResponseException, nSessionPausedException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSecurityException, nTransactionAlreadyCommittedException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        this.commitOrAbortAndConfirm(true, this.myTimeout, -1L);
    }

    public void commit(Date date) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nTransactionNotStartedException, nUnexpectedResponseException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSecurityException, nTransactionAlreadyCommittedException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        Date date2 = new Date();
        this.commit(date.getTime() - date2.getTime());
    }

    public void commit(long l) throws nSessionNotConnectedException, nSessionPausedException, nRequestTimedOutException, nTransactionNotStartedException, nUnexpectedResponseException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSecurityException, nTransactionAlreadyCommittedException, nTransactionAlreadyAbortedException, nMaxBufferSizeExceededException {
        this.commitOrAbortAndConfirm(true, this.myTimeout, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitOrAbortAndConfirm(boolean bl, long l, long l2) throws nTransactionNotStartedException, nUnexpectedResponseException, nSessionPausedException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSecurityException, nTransactionAlreadyCommittedException, nTransactionAlreadyAbortedException, nSessionNotConnectedException, nRequestTimedOutException {
        long l3;
        if (this.hasAborted) {
            throw new nTransactionAlreadyAbortedException(" tx id " + this.getTransactionID());
        }
        if (this.hasCommitted) {
            throw new nTransactionAlreadyCommittedException(" tx id " + this.getTransactionID());
        }
        this.checkIfStoreIsInvalid();
        if (!this.hasPublished && this.myPublishStorage == null) {
            throw new nTransactionNotStartedException();
        }
        int n = 0;
        boolean bl2 = true;
        if (l < 0L) {
            l3 = Long.MAX_VALUE;
            l = Long.MAX_VALUE;
        } else {
            l3 = System.currentTimeMillis() + l;
        }
        while (bl2 && l3 > System.currentTimeMillis() || n == 0) {
            nTransaction nTransaction2;
            this.checkIfStoreIsInvalid();
            try {
                if (n > 0) {
                    if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                        this.myChannel.getTraceLogger().info("Retrying transactional operation. retryCount=" + n + ", transactionId=" + this.myTXId + ", isCommit=" + bl + ", timeout=" + l + ", txDelay=" + l2, CLASS_NAME);
                    }
                    try {
                        if (bl ? this.isCommitted(true) : this.isAborted(true)) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    if (this.myPublishStorage != null) {
                        this.publishCommit(l2);
                    } else {
                        this.doCommit(l2);
                    }
                } else {
                    this.doAbort();
                }
                bl2 = false;
                break;
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException2) {
                ++n;
                if (l3 <= System.currentTimeMillis()) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nSessionNotConnectedException2);
                    throw nSessionNotConnectedException2;
                }
                if (l == 0L) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nSessionNotConnectedException2);
                    throw nSessionNotConnectedException2;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (!this.myConnectionManager.isConnected() && l3 > System.currentTimeMillis()) {
                    nTransaction2 = this;
                    synchronized (nTransaction2) {
                        try {
                            this.wait(nConstants.getPushWaitLimit());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (nUnexpectedResponseException nUnexpectedResponseException2) {
                if (l == 0L) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nUnexpectedResponseException2);
                    throw nUnexpectedResponseException2;
                }
                if (nUnexpectedResponseException2.getMessage() != null && nUnexpectedResponseException2.getMessage().contains("Channel is full")) {
                    nTransaction2 = this;
                    synchronized (nTransaction2) {
                        try {
                            this.wait(nConstants.getPushWaitLimit());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nUnexpectedResponseException2);
                throw nUnexpectedResponseException2;
                if (l3 <= System.currentTimeMillis()) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nUnexpectedResponseException2);
                    throw nUnexpectedResponseException2;
                }
            }
            catch (nTransactionAlreadyCommittedException nTransactionAlreadyCommittedException2) {
                if (n == 0) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nTransactionAlreadyCommittedException2);
                    throw nTransactionAlreadyCommittedException2;
                }
                bl2 = false;
            }
            catch (nTransactionAlreadyAbortedException nTransactionAlreadyAbortedException2) {
                if (n == 0) {
                    nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nTransactionAlreadyAbortedException2);
                    throw nTransactionAlreadyAbortedException2;
                }
                bl2 = false;
            }
            catch (nTransactionNotStartedException nTransactionNotStartedException2) {
                nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nTransactionNotStartedException2);
                throw nTransactionNotStartedException2;
            }
            catch (nTransactionNoSuchTXIDException nTransactionNoSuchTXIDException2) {
                nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nTransactionNoSuchTXIDException2);
                throw nTransactionNoSuchTXIDException2;
            }
            catch (nRequestTimedOutException nRequestTimedOutException2) {
                nConstants.logger.trace("Session " + this.myConnectionManager.getClientAllocatedSessionID() + " SessionID " + Long.toHexString(this.myConnectionManager.getServerProvidedSessionID()) + " Tx ID " + this.myTXId + " Commit or abort failed " + nRequestTimedOutException2);
                throw nRequestTimedOutException2;
            }
            ++n;
        }
        if (l != 0L && bl2) {
            try {
                if (bl) {
                    if (this.isCommitted(true)) {
                        return;
                    }
                    throw new nRequestTimedOutException("TX id " + this.getTransactionID() + " failed to commit before timeout " + l);
                }
                if (this.isAborted(true)) {
                    return;
                }
                throw new nRequestTimedOutException("TX id " + this.getTransactionID() + " failed to abort before timeout " + l);
            }
            catch (nRequestTimedOutException nRequestTimedOutException3) {
                throw nRequestTimedOutException3;
            }
            catch (nSessionNotConnectedException nSessionNotConnectedException3) {
                throw nSessionNotConnectedException3;
            }
            catch (Exception exception) {
                throw new nUnexpectedResponseException("TX id " + this.getTransactionID() + " could not commit / abort due to unknown error " + exception.getMessage(), exception);
            }
        }
        if (!this.hasCommitted && !this.hasAborted) {
            throw new nUnexpectedResponseException("TX id " + this.getTransactionID() + " could not commit / abort due to unknown error ");
        }
    }

    private void doAbort() throws nSessionNotConnectedException, nRequestTimedOutException, nChannelNotFoundException, nSecurityException, nUnexpectedResponseException, nTransactionNotStartedException, nTransactionNoSuchTXIDException, nTransactionAlreadyCommittedException, nSessionPausedException, nTransactionAlreadyAbortedException {
        if (this.hasPublished || this.myPublishStorage != null) {
            nEvent nEvent2;
            nTXAbort nTXAbort2 = new nTXAbort(this.myChannel.getBaseAttributes().getUniqueId(), this.getTransactionID(true), this.myAttributes.getTTL());
            if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                this.myChannel.getTraceLogger().info("Aborting transaction. transactionId=" + this.myTXId + ", ttl=" + this.myAttributes.getTTL() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
            }
            if ((nEvent2 = this.myChannel.getBaseChannel().writeEvent(nTXAbort2)) instanceof nTXAbort) {
                this.myPublishStorage = null;
                this.hasCommitted = false;
                this.hasAborted = true;
                if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                    this.myChannel.getTraceLogger().info("Transaction abort succeeded. transactionId=" + this.myTXId + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                return;
            }
            try {
                nExceptionEventProcessor.checkSecurityException(nEvent2);
                nExceptionEventProcessor.checkChannelNotFound(nEvent2);
                nExceptionEventProcessor.checkTransactionNoSuchTXID(nEvent2);
                nExceptionEventProcessor.checkUnexpectedExceptionEvent(nEvent2, "abort");
            }
            catch (Exception exception) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Transaction abort failed. reason=" + exception.getMessage() + ", transactionId=" + this.myTXId + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                throw exception;
            }
        } else {
            if (this.hasAborted) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Transaction abort failed. reason=Transaction has already been aborted, transactionId=" + this.myTXId + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                throw new nTransactionAlreadyAbortedException(" tx id " + this.getTransactionID());
            }
            if (this.hasCommitted) {
                if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                    this.myChannel.getTraceLogger().warn("Transaction abort failed. reason=Transaction has already been committed, transactionId=" + this.myTXId + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
                }
                throw new nTransactionAlreadyCommittedException(" tx id " + this.getTransactionID());
            }
            this.hasCommitted = false;
            this.hasAborted = true;
        }
    }

    private void doCommit(long l) throws nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nSessionPausedException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSecurityException, nTransactionAlreadyAbortedException {
        Cloneable cloneable;
        if (l > 0L) {
            cloneable = new Date();
            l = cloneable.getTime() + l;
        } else {
            l = -1L;
        }
        cloneable = new nTXCommit(this.myChannel.getBaseAttributes().getUniqueId(), this.getTransactionID(false), this.myAttributes.getTTL(), l);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Committing transaction. transactionId=" + this.myTXId + ", ttl=" + this.myAttributes.getTTL() + ", publishTime=" + l + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME);
        }
        try {
            this.writeCommitRequest((nEvent)cloneable);
        }
        catch (Exception exception) {
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Commit request failed. transactionId=" + this.myTXId + ", reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    private void publishCommit(long l) throws nSessionNotConnectedException, nRequestTimedOutException, nUnexpectedResponseException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nSessionPausedException, nSecurityException, nTransactionAlreadyAbortedException {
        Cloneable cloneable;
        Vector<nPublished> vector = new Vector<nPublished>((java.util.Vector<nPublished>)this.myPublishStorage);
        if (l > 0L) {
            cloneable = new Date();
            l = cloneable.getTime() + l;
        } else {
            l = -1L;
        }
        cloneable = new nTXPublishCommit(this.myChannel.getBaseAttributes().getUniqueId(), vector, this.getTransactionID(false), this.myAttributes.getTTL(), l);
        if (this.myChannel.getTraceLogger().isInfoEnabled()) {
            this.myChannel.getTraceLogger().info("Publishing & committing transaction. transactionId=" + this.myTXId + ", ttl=" + this.myAttributes.getTTL() + ", publishTime=" + l + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager) + ", eventsCount=" + vector.size() + ", events={" + ClientEventTraceLoggerContext.addPubEventsInfo(Collections.list(vector.elements())) + "}", CLASS_NAME);
        }
        try {
            this.writeCommitRequest((nEvent)cloneable);
        }
        catch (Exception exception) {
            if (this.myChannel.getTraceLogger().isWarnEnabled()) {
                this.myChannel.getTraceLogger().warn("Publish & Commit request failed. transactionId=" + this.myTXId + ", reason=" + exception.getMessage() + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager), CLASS_NAME, exception);
            }
            throw exception;
        }
    }

    private void writeCommitRequest(nEvent nEvent2) throws nRequestTimedOutException, nSessionPausedException, nSessionNotConnectedException, nSecurityException, nChannelNotFoundException, nTransactionNoSuchTXIDException, nUnexpectedResponseException, nTransactionAlreadyAbortedException {
        this.checkIfStoreIsInvalid();
        nEvent nEvent3 = this.myChannel.getBaseChannel().writeEvent(nEvent2);
        if (nEvent3 instanceof nTXCommit) {
            nTXCommit nTXCommit2 = (nTXCommit)nEvent3;
            this.myStartEID = nTXCommit2.getStartEID();
            this.myEndEID = nTXCommit2.getEndEID();
            this.hasCommitted = true;
            this.hasAborted = false;
            this.myPublishStorage = null;
            if (this.myChannel.getTraceLogger().isInfoEnabled()) {
                this.myChannel.getTraceLogger().info("Transaction request succeeded, cleaning up transaction. transactionId=" + this.myTXId + ", startEID=" + this.myStartEID + ", endEID=" + this.myEndEID + ", requestId=" + nTXCommit2.getRequestId(), CLASS_NAME);
            }
            return;
        }
        nExceptionEventProcessor.checkSecurityException(nEvent3);
        nExceptionEventProcessor.checkChannelNotFound(nEvent3);
        nExceptionEventProcessor.checkTransactionNoSuchTXID(nEvent3);
        nExceptionEventProcessor.checkPublishPausedException(nEvent3);
        nExceptionEventProcessor.checkUnexpectedExceptionEventAppendOrtoString(nEvent3, "Problem : ");
    }

    private void checkIfStoreIsInvalid() throws nTransactionAlreadyAbortedException {
        if (this.myAttributes.getChannel().isStoreObjectInvalid()) {
            this.hasAborted = true;
            this.hasCommitted = false;
            nIllegalArgumentException nIllegalArgumentException2 = this.createIllegalArgument();
            nTransactionAlreadyAbortedException nTransactionAlreadyAbortedException2 = new nTransactionAlreadyAbortedException(nIllegalArgumentException2.getMessage());
            nTransactionAlreadyAbortedException2.initCause(nIllegalArgumentException2);
            throw nTransactionAlreadyAbortedException2;
        }
    }

    private nIllegalArgumentException createIllegalArgument() {
        if (this.myAttributes.getChannel().isQueue()) {
            return new nIllegalArgumentException("This queue object is obsolete please perform a findQueue and discard this object");
        }
        return new nIllegalArgumentException("This channel object is obsolete please perform a findChannel and discard this object");
    }

    public String toString() {
        return "nTransaction { transactionId=" + this.myTXId + ", timeout=" + this.myTimeout + ", ttl=" + this.myAttributes.getTTL() + (this.myPublishStorage != null ? ", eventsCount=" + this.myPublishStorage.size() + ", events={" + ClientEventTraceLoggerContext.addPubEventsInfo(this.myPublishStorage) + "}" : "") + ", isPublished=" + this.hasPublished + ", isCommitted=" + this.hasCommitted + ", isAborted=" + this.hasAborted + ", isXA=" + this.isTransactionXA + ", startEID=" + this.myStartEID + ", endEID=" + this.myEndEID + ClientEventTraceLoggerContext.addClientConnectionInfo(this.myConnectionManager) + '}';
    }
}

