/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.es;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ElasticsearchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient client;
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean deleteIndex(String index) {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            DeleteIndexResponse indexResponse = this.client.indices().delete(request, new Header[0]);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.client.indices().create(request, new Header[0]);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.client.index(indexRequest, new Header[0]);
            return indexResponse.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u63d2\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25");
        }
        return deleteResult;
    }

    public Boolean updateData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest(index, type, id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, new Header[0]);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u66f4\u65b0\u5f02\u5e38");
        }
        return deleteResult;
    }

    public Boolean updateInsertData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            String endPoint = "/" + index + "/" + type + "/" + id;
            Response response = null;
            boolean isExsit = false;
            try {
                response = this.client.getLowLevelClient().performRequest("GET", endPoint, new Header[0]);
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                isExsit = true;
            }
            catch (ResponseException e) {
                isExsit = false;
            }
            if (!isExsit) {
                this.addData(index, type, id, qryJson);
            } else {
                qryJson.remove((Object)"createTime");
                indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
                UpdateRequest updateRequest = new UpdateRequest(index, type, id);
                updateRequest.doc(indexRequest);
                UpdateResponse rspose = this.client.update(updateRequest, new Header[0]);
                LOGGER.info(JSONObject.toJSONString((Object)rspose));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u63d2\u5165\u66f4\u65b0\u5f02\u5e38");
        }
        return deleteResult;
    }

    public String updateByQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_update_by_query";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        try {
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public String doPostSendQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_search";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        try {
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2" + index + "\u5f02\u5e38");
        }
    }

    public String doPostSendCount(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_count";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        try {
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2" + index + "\u5f02\u5e38");
        }
    }

    public void bulkPutIndex(String index, String type, List<Map<String, Object>> list, String id) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        BulkRequest request = new BulkRequest();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                request.add(new IndexRequest(index, type, String.valueOf(map.get(id))).source(map, XContentType.JSON));
                continue;
            }
            if (map.containsKey("id")) {
                request.add(new IndexRequest(index, type, String.valueOf(map.remove("id"))).source(map, XContentType.JSON));
                continue;
            }
            request.add(new IndexRequest(index, type, null).source(map, XContentType.JSON));
        }
        try {
            this.client.bulk(request, new Header[0]);
        }
        catch (IOException e) {
            LOGGER.error("\u6279\u91cf\u63d2\u5165es \u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean checkIndexExist(String index) {
        try {
            Response response = this.client.getLowLevelClient().performRequest("HEAD", index, new Header[0]);
            boolean exist = response.getStatusLine().getReasonPhrase().equals("OK");
            return exist;
        }
        catch (IOException e) {
            LOGGER.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }
}

