/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.http;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String doGet(String url) {
        log.info("\u53d1\u9001http\u8bf7\u6c42get\u5f00\u59cb...");
        log.debug("\u8bf7\u6c42url:" + url);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String result = "";
        try {
            httpClient = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Authorization", "Bearer da3efcbf-0845-4fe3-8aba-ee040be542c0");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.error("\u9519\u8bef\uff1a" + (Object)((Object)e));
            throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u9519\u8bef\uff1a" + e);
            throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error("\u9519\u8bef\uff1a" + e);
                    throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error("\u9519\u8bef\uff1a" + e);
                    throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                }
            }
        }
        log.debug("rsp:" + result);
        log.info("get\u8bf7\u6c42\u7ed3\u675f...");
        return result;
    }

    public static String doPostForm(String url, Map<String, Object> paramMap) {
        log.info("\u53d1\u9001http\u8bf7\u6c42post\u5f00\u59cb...");
        log.debug("post\u8bf7\u6c42url:" + url);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse httpResponse = null;
        String result = "";
        httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        if (null != paramMap && paramMap.size() > 0) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, Object>> entrySet = paramMap.entrySet();
            for (Map.Entry<String, Object> mapEntry : entrySet) {
                nvps.add(new BasicNameValuePair(mapEntry.getKey(), mapEntry.getValue().toString()));
            }
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                log.error("\u9519\u8bef\uff1a" + e);
                throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
            }
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.error("\u9519\u8bef\uff1a" + (Object)((Object)e));
            throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u9519\u8bef\uff1a" + e);
            throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
        }
        finally {
            if (null != httpResponse) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error("\u9519\u8bef\uff1a" + e);
                    throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.error("\u9519\u8bef\uff1a" + e);
                    throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                }
            }
        }
        log.debug("post\u7684rsp:" + result);
        log.info("post\u8bf7\u6c42\u7ed3\u675f...");
        return result;
    }

    public static void main(String[] args) {
        System.out.println(HttpClientUtil.doPostJson("http://11.158.129.80:7001/kg/base/qa/findAnswer", JSONObject.parseObject((String)"{\"sysId\":\"45\",\"query\":\"\u53d8\u538b\u5668\u7528\u98ce\u6247\u7684\u6b63\u5e38\u4f7f\u7528\u6761\u4ef6\u662f\u4ec0\u4e48\",\"version\":\"v2\"}")));
        System.out.println(HttpClientUtil.doPostJson("http://192.168.15.56:8091/search/common/queryDicList", JSONObject.parseObject((String)"{\"paraCode\": \"SO_SEARCH_RANGE \"}")));
    }

    public static String doPostJson(String url, JSONObject jsonObject) {
        String result;
        block17: {
            log.info("\u53d1\u9001http\u8bf7\u6c42post\u5f00\u59cb...");
            log.debug("post\u8bf7\u6c42url:" + url);
            log.debug("post\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonObject.toJSONString());
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse httpResponse = null;
            result = "";
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").setConnectTimeout(350000).setConnectionRequestTimeout(350000).setSocketTimeout(600000).build();
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-Type", "application/json");
            try {
                httpPost.setEntity((HttpEntity)new StringEntity(jsonObject.toJSONString(), "utf-8"));
                httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    log.info(result + "-----------success------------------");
                    HttpEntity entity = httpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)entity);
                    break block17;
                }
                log.error(httpResponse.getStatusLine().getStatusCode() + "------------------fail-----------");
                throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
                log.error("\u9519\u8bef\uff1a" + (Object)((Object)e));
                throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("\u9519\u8bef\uff1a" + e);
                throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
            }
            finally {
                if (null != httpResponse) {
                    try {
                        httpResponse.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        log.error("\u9519\u8bef\uff1a" + e);
                        throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                    }
                }
                if (null != httpClient) {
                    try {
                        httpClient.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        log.error("\u9519\u8bef\uff1a" + e);
                        throw new ZTBusinessException("post\u8bf7\u6c42\u5f02\u5e38");
                    }
                }
            }
        }
        log.debug("post\u7684rsp:" + result);
        log.info("post\u8bf7\u6c42\u7ed3\u675f...");
        return result;
    }
}

