/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.service;

import c.a.b.service.MinioFileClient;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.FileClientFactory;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class FileConstant {
    public static final String OSS = "OSS";
    public static final String FTP = "FTP";
    public static final String MINIO = "MINIO";
    public static final String NEED = "NEED";
    public static final String DEFAULT_TOOL_TYPE = "defaultToolType";
    @Value(value="${minio.AccessKey}")
    public String minioAccessKey;
    @Value(value="${minio.SecretKey}")
    public String minioSecretKey;
    @Value(value="${minio.Endpoint}")
    public String minioEndpoint;
    @Value(value="${minio.Bucket}")
    public String minioBucket;
    @Value(value="${oss.endpoint:}")
    private String endpoint;
    @Value(value="${oss.accesskey:}")
    private String accesskey;
    @Value(value="${oss.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName:}")
    private String bucketName;
    @Value(value="${oss.accessUrl:}")
    private String accessUrl;
    @Value(value="${ftp.host:}")
    private String ftpHost;
    @Value(value="${ftp.user:}")
    private String ftpUser;
    @Value(value="${ftp.pwd:}")
    private String ftpPwd;
    @Value(value="${ftp.port:}")
    private Integer ftpPort;
    @Value(value="${ftp.timeout:}")
    private Integer ftpTimeout;

    @Bean
    public MinioFileClient minioFileClient() {
        return new MinioFileClient(this.minioAccessKey, this.minioSecretKey, this.minioEndpoint, this.minioBucket);
    }

    @Bean(name={"ossFileClient"})
    public FileClient getOSSFileClient() {
        return FileClientFactory.getOssClient((OssConfig)new OssConfig(this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl));
    }

    @Bean(name={"ftpFileClient"})
    public FileClient getFtpFileClient() {
        return FileClientFactory.getFtpClient((FtpConfig)new FtpConfig(this.ftpHost, this.ftpUser, this.ftpPwd, this.ftpPort, this.ftpTimeout));
    }
}

