/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.service;

import c.a.b.api.FileOperService;
import c.a.b.api.bo.FileOperDownloadReqBO;
import c.a.b.api.bo.FileOperDownloadRspBO;
import c.a.b.api.bo.FileOperUploadReqBO;
import c.a.b.api.bo.FileOperUploadRspBO;
import c.a.b.service.FileConstant;
import c.a.b.service.MinioFileClient;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class FileOperServiceImpl
implements FileOperService {
    private static final Logger log = LoggerFactory.getLogger(FileOperServiceImpl.class);
    @Autowired
    private Environment env;
    @Autowired
    FileClient ossFileClient;
    @Autowired
    FileClient ftpFileClient;
    @Autowired
    MinioFileClient minioFileClient;
    @Autowired
    FileConstant fileConstant;

    public FileOperDownloadRspBO download(FileOperDownloadReqBO fileOperDownloadReqBO) {
        String realPath;
        FileOperDownloadRspBO rsp = new FileOperDownloadRspBO();
        String toolType = fileOperDownloadReqBO.getToolType();
        String fileEnvPath = fileOperDownloadReqBO.getFileEnvPath();
        String fileName = fileOperDownloadReqBO.getFileName();
        String newFileName = fileOperDownloadReqBO.getNewFileName();
        if (StringUtils.isEmpty((CharSequence)toolType)) {
            toolType = this.env.getProperty("defaultToolType");
            if (StringUtils.isEmpty((CharSequence)toolType)) {
                throw new ZTBusinessException("toolType\u672a\u914d\u7f6e\uff1adefaultToolType");
            }
            log.info("\u8d70\u9ed8\u8ba4\u5de5\u5177\u7c7b\u578b\u914d\u7f6e\uff1a" + toolType);
        }
        if (StringUtils.isNotEmpty((CharSequence)fileEnvPath)) {
            realPath = this.env.getProperty(fileEnvPath);
            if (null == realPath) {
                throw new ZTBusinessException("\u4e0b\u8f7d\u914d\u7f6e\u672a\u914d\u7f6e\uff1a" + fileEnvPath);
            }
        } else {
            throw new ZTBusinessException("fileEnvPath\u672a\u586b");
        }
        InputStream inputStream = null;
        OutputStream outStream = null;
        File outFile = null;
        try {
            int bytesRead;
            if (StringUtils.equalsIgnoreCase((CharSequence)"OSS", (CharSequence)toolType)) {
                inputStream = this.ossFileClient.downLoadToInputStream(realPath + fileName);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"FTP", (CharSequence)toolType)) {
                inputStream = this.ftpFileClient.downLoadToInputStream(realPath + fileName);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"MINIO", (CharSequence)toolType)) {
                inputStream = this.minioFileClient.downloadFileInputStream(realPath + fileName);
            } else {
                throw new ZTBusinessException("toolType\u672a\u77e5\u7c7b\u578b\uff0c\u4e0b\u8f7d\u5f02\u5e38");
            }
            String dir = System.getProperty("java.io.tmpdir");
            newFileName = dir + File.separator + newFileName;
            outFile = new File(newFileName);
            outStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            rsp.setDownloadFile(outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38");
            throw new ZTBusinessException("\u4e0b\u8f7d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728");
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outStream) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        log.info("\u4e0b\u8f7d\u7ed3\u675f...");
        return rsp;
    }

    public FileOperUploadRspBO upload(FileOperUploadReqBO fileOperUploadReqBO) {
        String fileName;
        String fileRealPath;
        FileOperUploadRspBO rsp = new FileOperUploadRspBO();
        String toolType = fileOperUploadReqBO.getToolType();
        String fileEnvPath = fileOperUploadReqBO.getFileEnvPath();
        boolean needNewFileName = fileOperUploadReqBO.isNeedNewFileName();
        File file = fileOperUploadReqBO.getFile();
        if (StringUtils.isEmpty((CharSequence)toolType)) {
            toolType = this.env.getProperty("defaultToolType");
            if (StringUtils.isEmpty((CharSequence)toolType)) {
                throw new ZTBusinessException("toolType\u672a\u914d\u7f6e\uff1adefaultToolType");
            }
            log.info("\u8d70\u9ed8\u8ba4\u5de5\u5177\u7c7b\u578b\u914d\u7f6e\uff1a" + toolType);
        }
        log.debug("\u4e0a\u4f20\u65b9\u5f0f\uff1a" + toolType);
        if (StringUtils.isNotEmpty((CharSequence)fileEnvPath)) {
            fileRealPath = this.env.getProperty(fileEnvPath);
            if (null == fileRealPath) {
                throw new ZTBusinessException("\u4e0b\u8f7d\u914d\u7f6e\u672a\u914d\u7f6e\uff1a" + fileRealPath);
            }
        } else {
            throw new ZTBusinessException("fileEnvPath\u672a\u586b");
        }
        String newFileName = fileName = file.getName();
        if (needNewFileName) {
            newFileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"OSS", (CharSequence)toolType)) {
            log.info("oss\u4e0a\u4f20\u5f00\u59cb...");
            this.ossFileClient.uploadFileByInputStream(fileRealPath, newFileName, (InputStream)inputStream);
            log.info("oss\u4e0a\u4f20\u7ed3\u675f...");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"FTP", (CharSequence)toolType)) {
            log.info("ftp\u4e0a\u4f20\u5f00\u59cb...");
            this.ftpFileClient.uploadFileByInputStream(fileRealPath, newFileName, (InputStream)inputStream);
            log.info("ftp\u4e0a\u4f20\u7ed3\u675f...");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"MINIO", (CharSequence)toolType)) {
            log.info("minio\u4e0a\u4f20\u5f00\u59cb...");
            this.minioFileClient.upLoadFileWithNewFileName(fileRealPath, newFileName, inputStream);
            log.info("minio\u4e0a\u4f20\u7ed3\u675f...");
        }
        rsp.setToolType(toolType);
        rsp.setFileRealPath(fileRealPath);
        rsp.setNewFileName(newFileName);
        log.debug("\u4e0a\u4f20\u8def\u5f84\uff1a" + fileRealPath);
        return rsp;
    }
}

