/*
 * Decompiled with CFR 0.152.
 */
package c.a.b.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import io.minio.Result;
import io.minio.messages.Item;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioFileClient {
    private static final Logger log = LoggerFactory.getLogger(MinioFileClient.class);
    public MinioClient minioClient;
    public String minioBucket;

    public MinioFileClient(String minioAccessKey, String minioSecretKey, String minioEndpoint, String minioBucket) {
        try {
            this.minioBucket = minioBucket;
            this.minioClient = new MinioClient(minioEndpoint, minioAccessKey, minioSecretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5931\u8d25\uff1a" + e);
        }
    }

    public String upLoadFile(File file, boolean needNewFileName, String path) throws Exception {
        String fileName;
        String newFileName = fileName = file.getName();
        if (needNewFileName) {
            newFileName = UUID.randomUUID().toString() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            newFileName = path + newFileName;
        }
        this.minioClient.putObject(this.minioBucket, newFileName, file.getAbsolutePath(), null);
        System.out.println("\u4e0a\u4f20\u6210\u529f..." + newFileName);
        return newFileName;
    }

    public String upLoadFileWithNewFileName(String path, String newFileName, InputStream inputStream) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                newFileName = path + newFileName;
            }
            this.minioClient.putObject(this.minioBucket, newFileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
            System.out.println("\u4e0a\u4f20\u6210\u529f..." + newFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0a\u4f20\u5931\u8d25\uff1a" + e);
            throw new ZTBusinessException("\u4e0a\u4f20\u5931\u8d25");
        }
        return newFileName;
    }

    public File downloadFile(String filePath) {
        InputStream inputStream = null;
        OutputStream outStream = null;
        File outFile = null;
        try {
            int bytesRead;
            inputStream = this.minioClient.getObject(this.minioBucket, filePath);
            String dir = System.getProperty("java.io.tmpdir");
            String fileName = -1 != filePath.indexOf("/") ? filePath.substring(filePath.lastIndexOf("/"), filePath.length()) : filePath;
            fileName = dir + File.separator + fileName;
            outFile = new File(fileName);
            outStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e);
            throw new ZTBusinessException("\u4e0b\u8f7d\u5f02\u5e38");
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outStream) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e);
                throw new ZTBusinessException("\u4e0b\u8f7d\u5f02\u5e38");
            }
        }
        System.out.println("\u4e0b\u8f7d\u8def\u5f84\uff1a" + outFile.getAbsolutePath());
        return outFile;
    }

    public InputStream downloadFileInputStream(String filePath) {
        InputStream inputStream = null;
        try {
            inputStream = this.minioClient.getObject(this.minioBucket, filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e);
            throw new ZTBusinessException("\u4e0b\u8f7d\u5f02\u5e38");
        }
        return inputStream;
    }

    public File downloadFileWithNewFileName(String filePath, String outFileName) throws Exception {
        InputStream inputStream = null;
        OutputStream outStream = null;
        File outFile = null;
        try {
            int bytesRead;
            inputStream = this.minioClient.getObject(this.minioBucket, filePath);
            String dir = System.getProperty("java.io.tmpdir");
            String fileName = dir + File.separator + outFileName;
            outFile = new File(fileName);
            outStream = new FileOutputStream(outFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e);
            throw e;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outStream) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("\u4e0b\u8f7d\u5f02\u5e38\uff1a" + e);
                throw e;
            }
        }
        System.out.println("\u4e0b\u8f7d\u8def\u5f84\uff1a" + outFile.getAbsolutePath());
        return outFile;
    }

    public List<String> listFiles(String path) throws Exception {
        ArrayList<String> rsp = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)path) && -1 != path.indexOf("/")) {
            throw new Exception("\u6587\u4ef6\u8def\u5f84\u4e0d\u7b26\u5408\u89c4\u8303");
        }
        Iterable list = this.minioClient.listObjects(this.minioBucket, path);
        while (list.iterator().hasNext()) {
            Item it = (Item)((Result)list.iterator().next()).get();
            String fileName = it.objectName();
            String splitFileName = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                splitFileName = fileName.substring(path.length());
                System.out.println(splitFileName);
            }
            if (-1 != splitFileName.indexOf("/")) continue;
            rsp.add(fileName);
        }
        System.out.println("\u603b\u6570\uff1a" + rsp.size());
        return rsp;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("D:/222.jpg".indexOf("/"));
    }
}

