/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.sku.impl;

import com.ohaotian.commodity.atom.sku.InitSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.InitSkuRspBO;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.sku.CreateAttachSkuBusiService;
import com.ohaotian.commodity.busi.sku.bo.AttachSkuRelationBusiBO;
import com.ohaotian.commodity.busi.sku.bo.BaseRspBO;
import com.ohaotian.commodity.busi.sku.bo.CreateAttachSkuRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuBusiBO;
import com.ohaotian.commodity.dao.AttachSkuRelationDAO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.AttachSkuRelationPO;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.base.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="createAttachSkuBusiService")
public class CreateAttachSkuBusiServiceImpl
implements CreateAttachSkuBusiService {
    private static final Logger logger = LoggerFactory.getLogger(CreateAttachSkuBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private InitSkuAtomService initSkuAtomService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private AttachSkuRelationDAO attachSkuRelationDAO;

    public CreateAttachSkuRspBO createAttachSku(SkuBusiBO sku) {
        if (this.isDebugEnabled) {
            logger.debug("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)sku.toString());
        }
        if (null == sku.getCommodityId() || null == sku.getSupplierId() || null == sku.getSkuName() || null == sku.getAttachType() || null == sku.getSkuPrice() || null == sku.getExtSkuId()) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519,\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2");
        }
        CreateAttachSkuRspBO result = new CreateAttachSkuRspBO();
        try {
            SkuBO skuBo = this.skuBusiBOToSkuBO(sku);
            skuBo.setCommodityTypeId(Long.valueOf(0L));
            skuBo.setSkuLocation(Integer.valueOf(0));
            skuBo.setSkuStatus(Constant.SKU_STATUS_BACKED);
            skuBo.setAttachFlag("1");
            Sku oldSku = this.skuMapper.selectByExtSkuIdAndSupplierId(sku.getExtSkuId(), sku.getSupplierId());
            if (null == oldSku) {
                InitSkuRspBO initSkuRspBO = this.initSkuAtomService.initSku(skuBo);
                result.setSkuId(initSkuRspBO.getSkuId());
            } else {
                Sku newSku = new Sku();
                BeanUtils.copyProperties((Object)sku, (Object)newSku);
                newSku.setSkuId(oldSku.getSkuId());
                newSku.setUpdateTime(new Date());
                newSku.setIsDelete(Constant.IS_DELETE);
                this.skuMapper.updateByPrimaryKeySelective(newSku, sku.getSupplierId());
                result.setSkuId(oldSku.getSkuId());
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        logger.info("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2:" + result.toString());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO createAttachRelation(AttachSkuRelationBusiBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        }
        if (null == reqBO.getMainSkuId()) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u51fa\u9519,\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u4e3b\u5546\u54c1Id [mainSKuId]");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u4e3b\u5546\u54c1Id [mainSKuId]");
        }
        if (null == reqBO.getAttachSkuId()) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u51fa\u9519,\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u9644\u5c5e\u5546\u54c1Id [attachSkuId]");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u9644\u5c5e\u5546\u54c1Id [attachSkuId]");
        }
        if (null == reqBO.getSupplierId()) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u51fa\u9519,\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u95e8\u5e97Id [supplieId]");
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u5931\u8d25.\u7f3a\u5c11\u5fc5\u586b\u5165\u53c2\uff1a\u9644\u5c5e\u5546\u54c1Id [supplieId]");
        }
        BaseRspBO result = new BaseRspBO();
        try {
            AttachSkuRelationPO record = new AttachSkuRelationPO();
            record.setAttachSkuId(reqBO.getAttachSkuId());
            record.setMainSkuId(reqBO.getMainSkuId());
            record.setSupplierId(reqBO.getSupplierId());
            record.setRelationStatus("00");
            List<AttachSkuRelationPO> relationList = this.attachSkuRelationDAO.selectByRecord(record);
            if (relationList.size() < 1) {
                this.attachSkuRelationDAO.insertSelective(record);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u51fa\u9519");
        }
        logger.info("\u521b\u5efa\u9644\u52a0\u5546\u54c1\u5173\u7cfb\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2:" + result.toString());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public SkuBO skuBusiBOToSkuBO(SkuBusiBO busi) {
        SkuBO sku = new SkuBO();
        sku.setSkuId(busi.getSkuId());
        sku.setCommodityId(busi.getCommodityId());
        sku.setSupplierId(busi.getSupplierId());
        sku.setMaterialId(busi.getMaterialId());
        sku.setExtSkuId(busi.getExtSkuId());
        sku.setUpcCode(busi.getUpcCode());
        sku.setCommodityTypeId(busi.getCommodityTypeId());
        sku.setSupplierName(busi.getSupplierName());
        sku.setSkuPrice(busi.getSkuPrice());
        sku.setSkuCode(busi.getSkuCode());
        sku.setSkuLocation(busi.getSkuLocation());
        sku.setSkuName(busi.getSkuName());
        sku.setSkuLongName(busi.getSkuLongName());
        sku.setOnShelveTime(busi.getOnShelveTime());
        sku.setOnShelveWay(busi.getOnShelveWay());
        sku.setSkuMainPicUrl(busi.getSkuMainPicUrl());
        sku.setSkuDetail(busi.getSkuDetail());
        sku.setPackParam(busi.getPackParam());
        sku.setSkuDetailUrl(busi.getSkuDetailUrl());
        sku.setStoreNumber(busi.getStoreNumber());
        sku.setPreDeliverDay(busi.getPreDeliverDay());
        sku.setSkuStatus(busi.getSkuStatus());
        sku.setBrandId(busi.getBrandId());
        sku.setBrandName(busi.getBrandName());
        sku.setIsSupplierAgreement(busi.getIsSupplierAgreement());
        sku.setMeasureId(busi.getMeasureId());
        sku.setMeasureName(busi.getMeasureName());
        sku.setCreateLoginId(busi.getCreateLoginId());
        sku.setCreateTime(busi.getCreateTime());
        sku.setUpdateLoginId(busi.getUpdateLoginId());
        sku.setUpdateTime(busi.getUpdateTime());
        sku.setIsDelete(busi.getIsDelete());
        sku.setRemark(busi.getRemark());
        sku.setVendorId(busi.getVendorId());
        sku.setVendorName(busi.getVendorName());
        sku.setMoq(busi.getMoq());
        sku.setMfgSku(busi.getMfgSku());
        sku.setTaskId(busi.getTaskId());
        sku.setPreOnShelveDay(busi.getPreOnShelveDay());
        sku.setAttachFlag(busi.getAttachFlag());
        sku.setAttachType(busi.getAttachType());
        return sku;
    }
}

