/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.commodity.busi.impl;

import com.cgd.commodity.dao.SkuApproveLogMapper;
import com.cgd.commodity.po.SkuApproveLog;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.ohaotian.commodity.busi.SkuAuditCallBackService;
import com.ohaotian.commodity.busi.bo.SkuApproveRspBO;
import com.ohaotian.commodity.busi.constant.Constant;
import com.ohaotian.commodity.busi.vo.SkuHandOffShelfVO;
import com.ohaotian.commodity.common.exception.BusinessException;
import com.ohaotian.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.commodity.dao.SkuApproveDetailLogMapper;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.SkuOffShelveLogMapper;
import com.ohaotian.commodity.dao.SkuOnShelveLogMapper;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.SkuRecoveOnShelveLogMapper;
import com.ohaotian.commodity.dao.po.CommodityGuideCatalog;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.commodity.dao.po.SkuApproveDetailLog;
import com.ohaotian.commodity.dao.po.SkuPrice;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuAuditCallBackServiceImpl
implements SkuAuditCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(SkuAuditCallBackServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private SkuMapper skuMapper;
    private SkuOnShelveLogMapper skuOnShelveLogMapper;
    private SkuOffShelveLogMapper skuOffShelveLogMapper;
    private SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private SkuApproveLogMapper skuApproveLogMapper;
    private SkuApproveDetailLogMapper skuApproveDetailLogMapper;
    private SkuPriceMapper skuPriceMapper;
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public SkuApproveRspBO skuAuditCallBack(Integer approveType, String procInstlId, Integer approveResult, Long supplierId, Long userId, String rejectContent, String suggestContent) {
        SkuApproveRspBO SkuApproveRspBO2;
        block33: {
            if (this.isDebugEnabled) {
                logger.debug("\u5546\u54c1\u5ba1\u6279\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1aapproveType=" + approveType + ",procInstlId=" + procInstlId + ",approveResult=" + approveResult + ",supplierId=" + supplierId);
            }
            SkuApproveRspBO2 = new SkuApproveRspBO();
            if (null == approveType) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[approveType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (approveType > 5) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1approveType\u975e\u6cd5\uff0c\u53ea\u80fd\u4e3a[0:\u4e0a\u67b6\uff0c1:\u4e0b\u67b6\uff0c2\uff1a\u6062\u590d\u4e0a\u67b6\uff0c3\uff1a\u4fe1\u606f\u53d8\u66f4 4\uff1a\u96c6\u56e2\u5ba1\u6279]");
            }
            if ("" == procInstlId || null == procInstlId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[procInstlId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == approveResult) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[approveResult]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == supplierId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == userId) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1[userId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            switch (approveResult) {
                case 0: {
                    approveResult = 1;
                    break;
                }
                case 1: {
                    approveResult = 2;
                    break;
                }
                case 2: {
                    approveResult = 0;
                    break;
                }
            }
            try {
                SelectUserInfoByUserIdReqBO selectUserInfoByUserIdReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoByUserIdReqBO.setUserId(userId);
                String userName = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoByUserIdReqBO).getName();
                List<Map<String, Long>> listMap = this.skuOnShelveLogMapper.selectSkusByProcInstId(approveType, procInstlId, supplierId);
                if (listMap != null && listMap.size() > 0) {
                    ArrayList<Long> skuIds = new ArrayList<Long>();
                    Long skuId = null;
                    for (Map<String, Long> map : listMap) {
                        skuId = map.get("SKU_ID");
                        skuIds.add(skuId);
                    }
                    SkuHandOffShelfVO skuHandOffShelfVO = new SkuHandOffShelfVO();
                    skuHandOffShelfVO.setSupplierId(supplierId);
                    skuHandOffShelfVO.setSkuIds(skuIds);
                    switch (approveType) {
                        case 0: {
                            if (approveResult == 2) {
                                Sku sku = null;
                                Sku record = null;
                                Object onshelvTime = null;
                                for (Long id : skuIds) {
                                    sku = this.skuMapper.selectBySkuIdAndSupplier(id, supplierId);
                                    if (sku == null) continue;
                                    record = new Sku();
                                    record.setSkuId(id);
                                    record.setUpdateLoginId(userId);
                                    record.setUpdateTime(new Date());
                                    record.setSkuStatus(Constant.SKU_STATUS_SHELVED);
                                    this.skuMapper.updateByPrimaryKeySelective(record, supplierId);
                                }
                                this.insertskuApprove(supplierId, userId, userName, skuHandOffShelfVO, skuIds.size(), 0, rejectContent, suggestContent);
                            }
                            if (approveResult == 1) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_BACKED, userId, skuHandOffShelfVO);
                                this.insertskuApprove(supplierId, userId, userName, skuHandOffShelfVO, skuIds.size(), 1, rejectContent, suggestContent);
                            }
                            this.skuOnShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 1: {
                            if (approveResult == 1) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SHELVED, userId, skuHandOffShelfVO);
                            } else if (approveResult == 2) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SUPPLIER_RACK, userId, skuHandOffShelfVO);
                            }
                            this.skuOffShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 2: {
                            if (approveResult == 2) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SHELVED, userId, skuHandOffShelfVO);
                            }
                            this.skuRecoveOnShelveLogMapper.updateSkusApproveStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (approveResult == 1) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(11, userId, skuHandOffShelfVO);
                            } else if (approveResult == 2) {
                                this.skuMapper.updateSkuStateOffShelfBySkuId(Constant.SKU_STATUS_SHELVEING, userId, skuHandOffShelfVO);
                            }
                            this.skuOnShelveLogMapper.updateSkusAuditStsByProcInstId(approveResult, userId, userName, procInstlId, supplierId);
                            break;
                        }
                        default: {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5ba1\u6279\u7c7b\u578b\u9519\u8bef[ 0:\u4e0a\u67b6\uff0c1:\u4e0b\u67b6\uff0c2\uff1a\u6062\u590d\u4e0a\u67b6\uff0c3\uff1a\u4fe1\u606f\u53d8\u66f4]");
                        }
                    }
                    break block33;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f85\u5ba1\u6279\u8bb0\u5f55\u4e0d\u5b58\u5728!");
            }
            catch (Exception e) {
                logger.error("\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519\uff1a" + e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u5ba1\u6279\u4fe1\u606f\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1\u51fa\u9519:" + e);
            }
        }
        return SkuApproveRspBO2;
    }

    private Date plusDay(int num) throws Exception {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        c.add(5, num);
        Date endDate = f.parse(f.format(c.getTime()));
        return endDate;
    }

    private boolean insertskuApprove(Long supplierId, Long userId, String userName, SkuHandOffShelfVO skuHandOffShelfVO, int num, int approveType, String rejectContent, String suggestContent) {
        boolean state = true;
        try {
            Date date = new Date();
            SkuApproveLog approveLog = new SkuApproveLog();
            approveLog.setApprover(userName);
            approveLog.setSupplierId(supplierId);
            approveLog.setApproveType(approveType);
            approveLog.setSkuNumber(num);
            approveLog.setApproveTime(date);
            approveLog.setCreateLoginId(userId);
            approveLog.setCreateTime(date);
            approveLog.setRejectContent(rejectContent);
            approveLog.setSuggestContent(suggestContent);
            approveLog.setIsDelete(0);
            logger.info("===\u5ba1\u6279\u65e5\u5fd7=======>>>>>>>>>>" + approveLog.toString());
            this.skuApproveLogMapper.insertReturnId(approveLog);
            List<Sku> skus = this.skuMapper.selectBySupIdAndSkuId(supplierId, skuHandOffShelfVO.getSkuIds());
            List<SkuPrice> skuPrices = this.skuPriceMapper.selectBySkuIdsAndSupplierId(skuHandOffShelfVO.getSkuIds(), supplierId);
            logger.error("===\u5ba1\u6279\u65e5\u5fd7=======>>>>>>>>>>\u63d2\u5165\u6210\u529f" + approveLog.getApproveId() + "##################################");
            for (Sku sku : skus) {
                for (SkuPrice skuPrice : skuPrices) {
                    if (!sku.getSkuId().equals(skuPrice.getSkuId())) continue;
                    SkuApproveDetailLog skuApproveDetailLog = new SkuApproveDetailLog();
                    skuApproveDetailLog.setSkuName(sku.getSkuName());
                    skuApproveDetailLog.setSkuId(sku.getSkuId());
                    skuApproveDetailLog.setApproveId(approveLog.getApproveId());
                    skuApproveDetailLog.setSupplierId(supplierId);
                    skuApproveDetailLog.setSupplierName(sku.getSupplierName());
                    skuApproveDetailLog.setBrandName(sku.getBrandName());
                    skuApproveDetailLog.setApproveSkuState(approveType + 2);
                    skuApproveDetailLog.setApproveType((byte)approveType);
                    skuApproveDetailLog.setAgreementPrice(skuPrice.getAgreementPrice());
                    skuApproveDetailLog.setMarketPrice(skuPrice.getMarketPrice());
                    CommodityGuideCatalog catalog = this.commodityGuideCatalogMapper.selectByPrimaryKey(sku.getCommodityTypeId());
                    skuApproveDetailLog.setSkuCatalog(catalog.getCatalogName());
                    Long agreementPrice = skuPrice.getAgreementPrice();
                    Long marketPrice = skuPrice.getMarketPrice();
                    float discountRate = (float)agreementPrice.longValue() / (float)marketPrice.longValue();
                    skuApproveDetailLog.setDiscountRate(Float.valueOf(discountRate));
                    skuApproveDetailLog.setUpdateLoginId(userId);
                    skuApproveDetailLog.setUpdateTime(new Date());
                    skuApproveDetailLog.setSuccess((byte)1);
                    skuApproveDetailLog.setPubTime(new Date());
                    skuApproveDetailLog.setIsDelete((byte)0);
                    this.skuApproveDetailLogMapper.insertSelective(skuApproveDetailLog);
                    logger.info("===\u5ba1\u6279\u65e5\u5fd7\u8be6\u60c5=======>>>>>>>>>>" + skuApproveDetailLog.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            state = false;
        }
        return state;
    }

    public static void main(String[] args) throws Exception {
        SkuAuditCallBackServiceImpl skuservice = new SkuAuditCallBackServiceImpl();
        Date d = skuservice.plusDay(5);
        System.out.println(d);
    }

    public void setSkuMapper(SkuMapper skuMapper) {
        this.skuMapper = skuMapper;
    }

    public void setSkuOnShelveLogMapper(SkuOnShelveLogMapper skuOnShelveLogMapper) {
        this.skuOnShelveLogMapper = skuOnShelveLogMapper;
    }

    public void setSkuOffShelveLogMapper(SkuOffShelveLogMapper skuOffShelveLogMapper) {
        this.skuOffShelveLogMapper = skuOffShelveLogMapper;
    }

    public void setSkuRecoveOnShelveLogMapper(SkuRecoveOnShelveLogMapper skuRecoveOnShelveLogMapper) {
        this.skuRecoveOnShelveLogMapper = skuRecoveOnShelveLogMapper;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setSkuApproveLogMapper(SkuApproveLogMapper skuApproveLogMapper) {
        this.skuApproveLogMapper = skuApproveLogMapper;
    }

    public void setSkuApproveDetailLogMapper(SkuApproveDetailLogMapper skuApproveDetailLogMapper) {
        this.skuApproveDetailLogMapper = skuApproveDetailLogMapper;
    }

    public void setSkuPriceMapper(SkuPriceMapper skuPriceMapper) {
        this.skuPriceMapper = skuPriceMapper;
    }

    public void setCommodityGuideCatalogMapper(CommodityGuideCatalogMapper commodityGuideCatalogMapper) {
        this.commodityGuideCatalogMapper = commodityGuideCatalogMapper;
    }
}

